/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.xml;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.XmlLexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.parsing.xml.XmlParser;
import com.intellij.psi.impl.source.xml.XmlFileImpl;
import com.intellij.psi.impl.source.xml.stub.XmlStubBasedElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.UnsupportedNodeElementTypeException;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NotNull;

public class XMLParserDefinition
implements ParserDefinition {
    @NotNull
    public Lexer createLexer(Project project2) {
        return new XmlLexer();
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        IFileElementType iFileElementType = XmlElementType.XML_FILE;
        if (iFileElementType == null) {
            XMLParserDefinition.$$$reportNull$$$0(0);
        }
        return iFileElementType;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = XmlTokenType.WHITESPACES;
        if (tokenSet == null) {
            XMLParserDefinition.$$$reportNull$$$0(1);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = XmlTokenType.COMMENTS;
        if (tokenSet == null) {
            XMLParserDefinition.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            XMLParserDefinition.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @NotNull
    public PsiParser createParser(Project project2) {
        return new XmlParser();
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        if (node.getElementType() instanceof XmlStubBasedElementType) {
            Object PsiT = ((XmlStubBasedElementType)node.getElementType()).createPsi(node);
            if (PsiT == null) {
                XMLParserDefinition.$$$reportNull$$$0(4);
            }
            return PsiT;
        }
        throw new UnsupportedNodeElementTypeException(node);
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            XMLParserDefinition.$$$reportNull$$$0(5);
        }
        return new XmlFileImpl(viewProvider, (IElementType)XmlElementType.XML_FILE);
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        ParserDefinition.SpaceRequirements spaceRequirements = XMLParserDefinition.canStickTokensTogether(left, right);
        if (spaceRequirements == null) {
            XMLParserDefinition.$$$reportNull$$$0(6);
        }
        return spaceRequirements;
    }

    public static ParserDefinition.SpaceRequirements canStickTokensTogether(ASTNode left, ASTNode right) {
        if (left.getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN || right.getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
            return ParserDefinition.SpaceRequirements.MUST_NOT;
        }
        if (left.getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER && right.getElementType() == XmlTokenType.XML_NAME) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        if (left.getElementType() == XmlTokenType.XML_NAME && right.getElementType() == XmlTokenType.XML_NAME) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        if (left.getElementType() == XmlTokenType.XML_TAG_NAME && right.getElementType() == XmlTokenType.XML_NAME) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        return ParserDefinition.SpaceRequirements.MAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/xml/XMLParserDefinition";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNodeType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitespaceTokens";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/xml/XMLParserDefinition";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "spaceExistenceTypeBetweenTokens";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5 -> new IllegalArgumentException(string);
        };
    }
}

