/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.xml;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlTokenizerBase<T extends PsiElement>
extends Tokenizer<T> {
    private final Splitter mySplitter;

    public static <T extends PsiElement> XmlTokenizerBase<T> create(Splitter splitter) {
        return new XmlTokenizerBase<T>(splitter);
    }

    public String toString() {
        return "XmlTokenizerBase(splitter=" + this.mySplitter + ")";
    }

    public XmlTokenizerBase(Splitter splitter) {
        this.mySplitter = splitter;
    }

    public void tokenize(@NotNull T element, @NotNull TokenConsumer consumer) {
        if (element == null) {
            XmlTokenizerBase.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            XmlTokenizerBase.$$$reportNull$$$0(1);
        }
        List<TextRange> excludeRanges = this.getSpellcheckOuterContentRanges(element);
        for (SpellcheckRange spellcheckRange : this.getSpellcheckRanges(element)) {
            consumer.consumeToken(element, spellcheckRange.text, spellcheckRange.useRename, spellcheckRange.offset, spellcheckRange.rangeToCheck, this.createExclusionAwareSplitter(excludeRanges, spellcheckRange.offset));
        }
    }

    @NotNull
    protected @NotNull List<@NotNull SpellcheckRange> getSpellcheckRanges(@NotNull T element) {
        if (element == null) {
            XmlTokenizerBase.$$$reportNull$$$0(2);
        }
        List<SpellcheckRange> list2 = Collections.singletonList(new SpellcheckRange(element.getText()));
        if (list2 == null) {
            XmlTokenizerBase.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    protected @NotNull List<@NotNull TextRange> getSpellcheckOuterContentRanges(@NotNull T element) {
        PsiLanguageInjectionHost injectionHost;
        if (element == null) {
            XmlTokenizerBase.$$$reportNull$$$0(4);
        }
        if ((injectionHost = element instanceof PsiLanguageInjectionHost ? (PsiLanguageInjectionHost)element : null) != null) {
            SmartList ranges = new SmartList();
            String text = element.getText();
            InjectedLanguageManager.getInstance((Project)injectionHost.getProject()).enumerate((PsiElement)injectionHost, (arg_0, arg_1) -> this.lambda$getSpellcheckOuterContentRanges$1((List)ranges, text, arg_0, arg_1));
            SmartList smartList = ranges;
            if (smartList == null) {
                XmlTokenizerBase.$$$reportNull$$$0(5);
            }
            return smartList;
        }
        List<TextRange> list2 = Collections.emptyList();
        if (list2 == null) {
            XmlTokenizerBase.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Nullable
    protected TextRange adjustInjectionRangeForExclusion(@NotNull String text, @NotNull TextRange range) {
        int startOffset;
        if (text == null) {
            XmlTokenizerBase.$$$reportNull$$$0(7);
        }
        if (range == null) {
            XmlTokenizerBase.$$$reportNull$$$0(8);
        }
        if (range.getStartOffset() >= text.length()) {
            return null;
        }
        int endOffset = Math.min(range.getEndOffset(), text.length() - 1);
        for (startOffset = range.getStartOffset(); startOffset > 0 && !XmlTokenizerBase.isLetterDigitOrWhitespace(text.charAt(startOffset - 1)); --startOffset) {
        }
        while (endOffset < text.length() && !XmlTokenizerBase.isLetterDigitOrWhitespace(text.charAt(endOffset))) {
            ++endOffset;
        }
        if (startOffset < endOffset) {
            return TextRange.create((int)startOffset, (int)endOffset);
        }
        return null;
    }

    @NotNull
    private Splitter createExclusionAwareSplitter(final List<TextRange> excludeRanges, final int offset) {
        return new Splitter(){

            public void split(@Nullable String text, @NotNull TextRange range, Consumer<TextRange> consumer) {
                if (range == null) {
                    1.$$$reportNull$$$0(0);
                }
                XmlTokenizerBase.this.mySplitter.split(text, range, tokenRange -> {
                    if (ContainerUtil.all((Collection)excludeRanges, excludeRange -> !excludeRange.intersects(tokenRange.shiftRight(offset)))) {
                        consumer.consume(tokenRange);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/spellchecker/xml/XmlTokenizerBase$1", "split"));
            }
        };
    }

    private static boolean isLetterDigitOrWhitespace(char ch) {
        return Character.isLetterOrDigit(ch) || Character.isWhitespace(ch);
    }

    private /* synthetic */ void lambda$getSpellcheckOuterContentRanges$1(List ranges, String text, PsiFile injectedPsi, List places) {
        ranges.addAll(ContainerUtil.mapNotNull((Collection)places, place -> this.adjustInjectionRangeForExclusion(text, place.getRangeInsideHost())));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/xml/XmlTokenizerBase";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/xml/XmlTokenizerBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpellcheckRanges";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpellcheckOuterContentRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "tokenize";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSpellcheckRanges";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSpellcheckOuterContentRanges";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "adjustInjectionRangeForExclusion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6 -> new IllegalStateException(string);
        };
    }

    public record SpellcheckRange(String text, boolean useRename, int offset, TextRange rangeToCheck) {
        SpellcheckRange(String text) {
            this(text, false);
        }

        SpellcheckRange(String text, boolean useRename) {
            this(text, useRename, 0, TextRange.allOf((String)text));
        }
    }
}

