/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.paths.PathReference;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.ConverterManager;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomResolveConverter;
import com.intellij.util.xml.EnumConverter;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.converters.PathReferenceConverter;
import com.intellij.util.xml.converters.values.NumberValueConverter;
import com.intellij.util.xml.impl.DomImplementationClassEP;
import com.intellij.util.xml.impl.ImplementationClassCache;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConverterManagerImpl
implements ConverterManager {
    private final Map<Class<?>, Converter<?>> mySimpleConverters = new HashMap();

    protected ConverterManagerImpl() {
        this.mySimpleConverters.put(Byte.TYPE, (Converter<?>)new NumberValueConverter(Byte.TYPE, false));
        this.mySimpleConverters.put(Byte.class, (Converter<?>)new NumberValueConverter(Byte.class, true));
        this.mySimpleConverters.put(Short.TYPE, (Converter<?>)new NumberValueConverter(Short.TYPE, false));
        this.mySimpleConverters.put(Short.class, (Converter<?>)new NumberValueConverter(Short.class, true));
        this.mySimpleConverters.put(Integer.TYPE, (Converter<?>)new NumberValueConverter(Integer.TYPE, false));
        this.mySimpleConverters.put(Integer.class, (Converter<?>)new NumberValueConverter(Integer.class, false));
        this.mySimpleConverters.put(Long.TYPE, (Converter<?>)new NumberValueConverter(Long.TYPE, false));
        this.mySimpleConverters.put(Long.class, (Converter<?>)new NumberValueConverter(Long.class, true));
        this.mySimpleConverters.put(Float.TYPE, (Converter<?>)new NumberValueConverter(Float.TYPE, false));
        this.mySimpleConverters.put(Float.class, (Converter<?>)new NumberValueConverter(Float.class, true));
        this.mySimpleConverters.put(Double.TYPE, (Converter<?>)new NumberValueConverter(Double.TYPE, false));
        this.mySimpleConverters.put(Double.class, (Converter<?>)new NumberValueConverter(Double.class, true));
        this.mySimpleConverters.put(BigDecimal.class, (Converter<?>)new NumberValueConverter(BigDecimal.class, true));
        this.mySimpleConverters.put(BigInteger.class, (Converter<?>)new NumberValueConverter(BigInteger.class, true));
        this.mySimpleConverters.put(Boolean.TYPE, ResolvingConverter.BOOLEAN_CONVERTER);
        this.mySimpleConverters.put(Boolean.class, ResolvingConverter.BOOLEAN_CONVERTER);
        this.mySimpleConverters.put(String.class, Converter.EMPTY_CONVERTER);
        this.mySimpleConverters.put(Object.class, Converter.EMPTY_CONVERTER);
        this.mySimpleConverters.put(PathReference.class, PathReferenceConverter.INSTANCE);
    }

    protected void addConverter(Class<?> clazz, Converter<?> converter) {
        this.mySimpleConverters.put(clazz, converter);
    }

    @NotNull
    public final Converter<?> getConverterInstance(Class<? extends Converter> converterClass) {
        Converter converter = ConverterManagerImpl.getOrCreateConverterInstance(converterClass);
        assert (converter != null) : "Converter not found for " + converterClass;
        Converter converter2 = converter;
        if (converter2 == null) {
            ConverterManagerImpl.$$$reportNull$$$0(0);
        }
        return converter2;
    }

    static <T> T getOrCreateConverterInstance(Class<T> clazz) {
        return ((MyClassValue)DomImplementationClassEP.CONVERTER_EP_NAME.computeIfAbsent(ConverterManagerImpl.class, () -> new MyClassValue())).get(clazz);
    }

    @Nullable
    public final Converter<?> getConverterByClass(Class<?> convertingClass) {
        Converter<?> converter = this.mySimpleConverters.get(convertingClass);
        if (converter != null) {
            return converter;
        }
        if (Enum.class.isAssignableFrom(convertingClass)) {
            return EnumConverter.createEnumConverter(convertingClass);
        }
        if (DomElement.class.isAssignableFrom(convertingClass)) {
            return DomResolveConverter.createConverter(convertingClass);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/ConverterManagerImpl", "getConverterInstance"));
    }

    private static final class MyClassValue
    extends ClassValue<Object> {
        private final ImplementationClassCache implementationClassCache = new ImplementationClassCache(DomImplementationClassEP.CONVERTER_EP_NAME);

        private MyClassValue() {
        }

        @Override
        protected Object computeValue(Class<?> key) {
            Class<?> implementation = this.implementationClassCache.get(key);
            Class<?> aClass = implementation == null ? key : implementation;
            try {
                Constructor<?> constructor = aClass.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Couldn't instantiate " + aClass, e);
            }
        }
    }
}

