/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.webTypes.json;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.intellij.webSymbols.webTypes.json.ContextConfig;
import com.intellij.webSymbols.webTypes.json.DisablementRules;
import com.intellij.webSymbols.webTypes.json.EnablementRules;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"kind", "enable-when", "disable-when"})
public class ContextKindConfig {
    @JsonProperty(value="kind")
    @JsonPropertyDescription(value="Context kind. Only a single context of the particular kind will be enabled. An example of context kind is framework, which has dedicated support in Web Types.")
    private String kind;
    @JsonProperty(value="enable-when")
    @JsonPropertyDescription(value="Specify rules for enabling web framework support. Only one framework can be enabled in a particular file. If you need your contributions to be enabled in all files, regardless of the context, do not specify the framework.")
    private EnablementRules enableWhen;
    @JsonProperty(value="disable-when")
    @JsonPropertyDescription(value="Specify rules for disabling web framework support. These rules take precedence over enable-when rules. They allow to turn off framework support in case of some conflicts between frameworks priority.")
    private DisablementRules disableWhen;
    @JsonIgnore
    private Map<String, ContextConfig> additionalProperties = new HashMap<String, ContextConfig>();

    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @JsonProperty(value="enable-when")
    public EnablementRules getEnableWhen() {
        return this.enableWhen;
    }

    @JsonProperty(value="enable-when")
    public void setEnableWhen(EnablementRules enableWhen) {
        this.enableWhen = enableWhen;
    }

    @JsonProperty(value="disable-when")
    public DisablementRules getDisableWhen() {
        return this.disableWhen;
    }

    @JsonProperty(value="disable-when")
    public void setDisableWhen(DisablementRules disableWhen) {
        this.disableWhen = disableWhen;
    }

    @JsonAnyGetter
    public Map<String, ContextConfig> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, ContextConfig value) {
        this.additionalProperties.put(name, value);
    }
}

