/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.codeInsight.require;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.javascript.nodejs.npm.registry.NpmRegistryService;
import com.intellij.javascript.nodejs.packageJson.NodePackageBasicInfo;
import com.intellij.javascript.nodejs.packageJson.codeInsight.popularPackages.PopularNodePackagesProvider;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.nodejs.NodeJSBundle;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class NodeRemotePackagesCompletionContributor
extends CompletionContributor {
    public static final LookupElementRenderer<LookupElement> RENDERER = new LookupElementRenderer<LookupElement>(){

        public void renderElement(LookupElement element, LookupElementPresentation presentation) {
            presentation.setItemText(element.getLookupString());
            presentation.setTypeGrayed(true);
            presentation.setTypeText("remote module");
        }
    };
    private static final Logger LOG = Logger.getInstance(NodeRemotePackagesCompletionContributor.class);

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        JSCallExpression call;
        PsiElement psiElement;
        PsiElement position;
        if (parameters == null) {
            NodeRemotePackagesCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            NodeRemotePackagesCompletionContributor.$$$reportNull$$$0(1);
        }
        if ((position = parameters.getOriginalPosition()) == null) {
            return;
        }
        String text = StringUtil.unquoteString((String)position.getText());
        if (JSFileReferencesUtil.isFileModuleRequired((String)text.trim())) {
            return;
        }
        if (position.getParent() instanceof JSLiteralExpression && position.getParent().getParent() instanceof JSArgumentList && (psiElement = position.getParent().getParent().getParent()) instanceof JSCallExpression && (call = (JSCallExpression)psiElement).isRequireCall()) {
            if (parameters.getInvocationCount() > 1 || CompletionType.SMART.equals((Object)parameters.getCompletionType())) {
                if (text.trim().length() < 3) {
                    NodeRemotePackagesCompletionContributor.advertisement(text, result);
                } else {
                    NodeRemotePackagesCompletionContributor.collectPackages(result);
                }
            } else {
                NodeRemotePackagesCompletionContributor.advertisement(text, result);
            }
        }
    }

    private static void collectPackages(@NotNull CompletionResultSet result) {
        if (result == null) {
            NodeRemotePackagesCompletionContributor.$$$reportNull$$$0(2);
        }
        String prefix = result.getPrefixMatcher().getPrefix();
        List popularPackages = PopularNodePackagesProvider.getInstance().findByPrefix(prefix, 10, info -> true);
        for (NodePackageBasicInfo pkg : popularPackages) {
            result.consume(NodeRemotePackagesCompletionContributor.createElement(pkg.getName()));
        }
        Set popularNames = ContainerUtil.map2Set((Collection)popularPackages, NodePackageBasicInfo::getName);
        try {
            NpmRegistryService.getInstance().findPackages(ProgressManager.getInstance().getProgressIndicator(), NpmRegistryService.namePrefixSearch((String)prefix), Math.max(0, 10 - popularPackages.size()), info -> !popularNames.contains(info.getName()), info -> result.consume(NodeRemotePackagesCompletionContributor.createElement(info.getName())));
        }
        catch (ProcessCanceledException e) {
            LOG.debug("Fetching '" + prefix + "*' packages from registry cancelled");
        }
        catch (IOException e) {
            LOG.info("Cannot fetch '" + prefix + "*' packages from registry", (Throwable)e);
        }
        result.restartCompletionOnAnyPrefixChange();
    }

    private static void advertisement(String text, CompletionResultSet result) {
        if (text.trim().length() < 3) {
            result.addLookupAdvertisement(NodeJSBundle.message("popup.advertisement.type.at.least.symbols.press.twice.for.remote.packages", KeymapUtil.getFirstKeyboardShortcutText((String)"CodeCompletion")));
        } else {
            result.addLookupAdvertisement(NodeJSBundle.message("popup.advertisement.press.again.for.remote.packages", KeymapUtil.getFirstKeyboardShortcutText((String)"CodeCompletion")));
        }
    }

    @NotNull
    private static LookupElement createElement(String repoPackage) {
        LookupElement lookupElement = LookupElementBuilder.create((String)repoPackage).withRenderer(RENDERER).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
        if (lookupElement == null) {
            NodeRemotePackagesCompletionContributor.$$$reportNull$$$0(3);
        }
        return lookupElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/codeInsight/require/NodeRemotePackagesCompletionContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/codeInsight/require/NodeRemotePackagesCompletionContributor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectPackages";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

