/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.doc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.nodejs.doc.ModuleDoc;
import com.jetbrains.nodejs.doc.ModuleMethodDoc;
import com.jetbrains.nodejs.doc.ModuleMethodParamDoc;
import com.jetbrains.nodejs.doc.ModulePropertyDoc;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleDocParser {
    private static final Logger LOG = Logger.getInstance(ModuleDoc.class);
    private static final String TEXT_RAW = "textRaw";
    private static final String NAME = "name";
    private static final String STABILITY = "stability";
    private static final String STABILITY_TEXT = "stabilityText";
    private static final String DESCRIPTION = "desc";
    private static final String SIGNATURES = "signatures";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ModuleDoc parseFrom(@NotNull File jsonFile) {
        ModuleDoc moduleDoc;
        if (jsonFile == null) {
            ModuleDocParser.$$$reportNull$$$0(0);
        }
        if (!jsonFile.isFile()) {
            return null;
        }
        InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(jsonFile), 32768), StandardCharsets.UTF_8);
        try {
            JsonParser parser = new JsonParser();
            JsonElement topElement = parser.parse((Reader)reader);
            moduleDoc = ModuleDocParser.convert(topElement);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException e) {
                    LOG.warn("Can't close", (Throwable)e);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.warn("Can't parse " + jsonFile.getAbsolutePath(), (Throwable)e);
                return null;
            }
        }
        try {
            ((Reader)reader).close();
        }
        catch (IOException e) {
            LOG.warn("Can't close", (Throwable)e);
        }
        return moduleDoc;
    }

    @Nullable
    private static ModuleDoc convert(@NotNull JsonElement topElement) throws IOException {
        JsonObject topObject;
        JsonArray array;
        Iterator iterator;
        if (topElement == null) {
            ModuleDocParser.$$$reportNull$$$0(1);
        }
        if ((iterator = (array = (topObject = topElement.getAsJsonObject()).getAsJsonArray("modules")).iterator()).hasNext()) {
            JsonElement element = (JsonElement)iterator.next();
            return ModuleDocParser.covertModuleObject(element.getAsJsonObject());
        }
        return null;
    }

    @Nullable
    private static ModuleDoc covertModuleObject(@NotNull JsonObject moduleObject) {
        if (moduleObject == null) {
            ModuleDocParser.$$$reportNull$$$0(2);
        }
        String textRaw = ModuleDocParser.getStringProperty(moduleObject, TEXT_RAW);
        String name = ModuleDocParser.getStringProperty(moduleObject, NAME);
        Integer stability = ModuleDocParser.getIntegerProperty(moduleObject, STABILITY);
        String stabilityText = ModuleDocParser.getStringProperty(moduleObject, STABILITY_TEXT);
        String description = ModuleDocParser.getStringProperty(moduleObject, DESCRIPTION);
        List<ModulePropertyDoc> properties = ModuleDocParser.parseProperties(moduleObject);
        List<ModuleMethodDoc> methods = ModuleDocParser.parseMethods(moduleObject);
        return new ModuleDoc(name, textRaw, stability, stabilityText, description, properties, methods);
    }

    @NotNull
    private static List<ModulePropertyDoc> parseProperties(@NotNull JsonObject moduleObject) {
        JsonElement propertiesElement;
        if (moduleObject == null) {
            ModuleDocParser.$$$reportNull$$$0(3);
        }
        if ((propertiesElement = moduleObject.get("properties")) == null) {
            List<ModulePropertyDoc> list = Collections.emptyList();
            if (list == null) {
                ModuleDocParser.$$$reportNull$$$0(4);
            }
            return list;
        }
        JsonArray propertiesArray = propertiesElement.getAsJsonArray();
        ArrayList<ModulePropertyDoc> properties = new ArrayList<ModulePropertyDoc>();
        for (JsonElement propertyElement : propertiesArray) {
            ModulePropertyDoc property = ModuleDocParser.parseProperty(propertyElement.getAsJsonObject());
            if (property == null) continue;
            properties.add(property);
        }
        ArrayList<ModulePropertyDoc> arrayList = properties;
        if (arrayList == null) {
            ModuleDocParser.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Nullable
    private static ModulePropertyDoc parseProperty(@NotNull JsonObject propertyObject) {
        if (propertyObject == null) {
            ModuleDocParser.$$$reportNull$$$0(6);
        }
        String textRaw = ModuleDocParser.getStringProperty(propertyObject, TEXT_RAW);
        String name = ModuleDocParser.getStringProperty(propertyObject, NAME);
        String description = ModuleDocParser.getStringProperty(propertyObject, DESCRIPTION);
        if (name == null) {
            return null;
        }
        return new ModulePropertyDoc(name, textRaw, description);
    }

    @NotNull
    private static List<ModuleMethodDoc> parseMethods(@NotNull JsonObject moduleObject) {
        JsonElement methodsElement;
        if (moduleObject == null) {
            ModuleDocParser.$$$reportNull$$$0(7);
        }
        if ((methodsElement = moduleObject.get("methods")) == null) {
            List<ModuleMethodDoc> list = Collections.emptyList();
            if (list == null) {
                ModuleDocParser.$$$reportNull$$$0(8);
            }
            return list;
        }
        JsonArray methodsArray = methodsElement.getAsJsonArray();
        ArrayList<ModuleMethodDoc> methods = new ArrayList<ModuleMethodDoc>(methodsArray.size());
        for (JsonElement methodElement : methodsArray) {
            ModuleMethodDoc method = ModuleDocParser.parseMethod(methodElement.getAsJsonObject());
            if (method == null) continue;
            methods.add(method);
        }
        ArrayList<ModuleMethodDoc> arrayList = methods;
        if (arrayList == null) {
            ModuleDocParser.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Nullable
    private static ModuleMethodDoc parseMethod(@NotNull JsonObject methodObject) {
        if (methodObject == null) {
            ModuleDocParser.$$$reportNull$$$0(10);
        }
        String textRaw = ModuleDocParser.getStringProperty(methodObject, TEXT_RAW);
        String name = ModuleDocParser.getStringProperty(methodObject, NAME);
        String description = ModuleDocParser.getStringProperty(methodObject, DESCRIPTION);
        List<ModuleMethodParamDoc> params = Collections.emptyList();
        JsonElement signaturesElement = methodObject.get(SIGNATURES);
        if (signaturesElement != null) {
            JsonArray signaturesArray = signaturesElement.getAsJsonArray();
            if (signaturesArray.size() > 1) {
                LOG.warn("Multiple signatures discovered");
            }
            if (signaturesArray.size() > 0) {
                JsonElement signatureElement = (JsonElement)signaturesArray.iterator().next();
                JsonObject signatureObject = signatureElement.getAsJsonObject();
                params = ModuleDocParser.parseSignature(signatureObject);
            }
        }
        if (name != null) {
            return new ModuleMethodDoc(name, textRaw, description, params);
        }
        return null;
    }

    @NotNull
    private static List<ModuleMethodParamDoc> parseSignature(@NotNull JsonObject signatureObject) {
        if (signatureObject == null) {
            ModuleDocParser.$$$reportNull$$$0(11);
        }
        JsonArray paramsArray = signatureObject.getAsJsonArray("params");
        ArrayList<ModuleMethodParamDoc> params = new ArrayList<ModuleMethodParamDoc>(paramsArray.size());
        for (JsonElement paramElement : paramsArray) {
            JsonObject paramObject = paramElement.getAsJsonObject();
            String name = ModuleDocParser.getStringProperty(paramObject, NAME);
            boolean optional = ModuleDocParser.getBooleanProperty(paramObject, "optional", false);
            if (name != null) {
                params.add(new ModuleMethodParamDoc(name, optional));
                continue;
            }
            LOG.warn("method.signature.param.name is null");
        }
        ArrayList<ModuleMethodParamDoc> arrayList = params;
        if (arrayList == null) {
            ModuleDocParser.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @Nullable
    private static String getStringProperty(@NotNull JsonObject obj, @NotNull String key) {
        JsonPrimitive p;
        JsonElement stringElement;
        if (obj == null) {
            ModuleDocParser.$$$reportNull$$$0(13);
        }
        if (key == null) {
            ModuleDocParser.$$$reportNull$$$0(14);
        }
        if ((stringElement = obj.get(key)) != null && stringElement.isJsonPrimitive() && (p = stringElement.getAsJsonPrimitive()).isString()) {
            return p.getAsString();
        }
        return null;
    }

    @Nullable
    private static Integer getIntegerProperty(@NotNull JsonObject obj, @NotNull String key) {
        JsonPrimitive p;
        JsonElement integerElement;
        if (obj == null) {
            ModuleDocParser.$$$reportNull$$$0(15);
        }
        if (key == null) {
            ModuleDocParser.$$$reportNull$$$0(16);
        }
        if ((integerElement = obj.get(key)) != null && integerElement.isJsonPrimitive() && (p = integerElement.getAsJsonPrimitive()).isNumber()) {
            Number n = p.getAsNumber();
            return n.intValue();
        }
        return null;
    }

    private static boolean getBooleanProperty(@NotNull JsonObject obj, @NotNull String key, boolean defaultValue) {
        JsonPrimitive p;
        JsonElement boolElement;
        if (obj == null) {
            ModuleDocParser.$$$reportNull$$$0(17);
        }
        if (key == null) {
            ModuleDocParser.$$$reportNull$$$0(18);
        }
        if ((boolElement = obj.get(key)) != null && boolElement.isJsonPrimitive() && (p = boolElement.getAsJsonPrimitive()).isBoolean()) {
            return p.getAsBoolean();
        }
        return defaultValue;
    }

    public static void main(String[] args) {
        File file = new File("/home/segrey/work/idea-master/system/webstorm/extLibs/nodejs-v0.11.4-src/core-modules-sources/doc/api/http.json");
        ModuleDoc documentation = ModuleDocParser.parseFrom(file);
        System.out.println(documentation);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 8, 9, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topElement";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleObject";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/doc/ModuleDocParser";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyObject";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodObject";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatureObject";
                break;
            }
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/doc/ModuleDocParser";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseProperties";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseMethods";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "covertModuleObject";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseProperties";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseProperty";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseMethods";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseMethod";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseSignature";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getStringProperty";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getIntegerProperty";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getBooleanProperty";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 8, 9, 12 -> new IllegalStateException(string);
        };
    }
}

