/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.nodejs.run.profile.heap.IndexFiles;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8HeapIndexManager;
import com.jetbrains.nodejs.run.profile.heap.io.RawSerializer;
import com.jetbrains.nodejs.util.CloseableProcessor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class V8StringIndex
implements Closeable {
    @Nullable
    private final IndexFiles<V8HeapIndexManager.Category> myIndexFiles;
    private List<OneFileWriter> myWriters;
    private List<OneFileReader> myReaders;
    private long myCnt;

    public V8StringIndex(@NotNull IndexFiles<V8HeapIndexManager.Category> indexFiles) throws IOException {
        if (indexFiles == null) {
            V8StringIndex.$$$reportNull$$$0(0);
        }
        this.myIndexFiles = indexFiles;
        this.myWriters = new ArrayList<OneFileWriter>();
        this.myWriters.add(new OneFileWriter(indexFiles.generate(V8HeapIndexManager.Category.strings, "v8strings")));
        this.myCnt = 0L;
    }

    public V8StringIndex(File ... files) throws IOException {
        this.myReaders = new ArrayList<OneFileReader>(files.length);
        for (File file : files) {
            this.myReaders.add(new OneFileReader(file));
        }
        this.myIndexFiles = null;
    }

    public long addString(@NotNull String s) throws IOException {
        if (s == null) {
            V8StringIndex.$$$reportNull$$$0(1);
        }
        ++this.myCnt;
        if (!this.myWriters.get(this.myWriters.size() - 1).addString(s)) {
            this.myWriters.add(new OneFileWriter(this.myIndexFiles.generate(V8HeapIndexManager.Category.strings, "v8strings")));
        }
        return this.myCnt - 1L;
    }

    public long getCnt() {
        return this.myCnt;
    }

    public void startReading() throws IOException {
        this.myReaders = new ArrayList<OneFileReader>(this.myWriters.size());
        for (OneFileWriter writer : this.myWriters) {
            writer.close();
            this.myReaders.add(writer.createReader());
        }
        this.myWriters = null;
    }

    @Nls
    public String readString(long i) throws IOException {
        int idx = (int)(i / 10000L);
        return this.myReaders.get(idx).readString((int)(i - (long)(idx * 10000)));
    }

    public void deleteFiles() throws IOException {
        if (this.myWriters != null) {
            for (OneFileWriter writer : this.myWriters) {
                writer.close();
            }
        }
        if (this.myReaders != null) {
            for (OneFileReader reader : this.myReaders) {
                reader.close();
            }
        }
    }

    public void iterate(final @NotNull CloseableProcessor<Pair<Long, String>, IOException> processor) throws IOException {
        if (processor == null) {
            V8StringIndex.$$$reportNull$$$0(2);
        }
        for (int i = 0; i < this.myReaders.size(); ++i) {
            OneFileReader reader = this.myReaders.get(i);
            int offset = 10000 * i;
            reader.iterate(offset, new CloseableProcessor<Pair<Long, String>, IOException>(){

                @Override
                public void exceptionThrown(@NotNull IOException e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    processor.exceptionThrown(e);
                }

                @Override
                public void close() throws IOException {
                }

                public boolean process(Pair<Long, String> pair) {
                    processor.process(pair);
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/nodejs/run/profile/heap/calculation/V8StringIndex$1", "exceptionThrown"));
                }
            });
        }
        processor.close();
    }

    public void parallelIterate(final @NotNull CloseableProcessor<Pair<Long, String>, IOException> processor) {
        if (processor == null) {
            V8StringIndex.$$$reportNull$$$0(3);
        }
        final AtomicInteger cnt = new AtomicInteger(this.myReaders.size());
        final AtomicBoolean continueIteration = new AtomicBoolean(true);
        for (int i = 0; i < this.myReaders.size(); ++i) {
            OneFileReader reader = this.myReaders.get(i);
            int offset = 10000 * i;
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    reader.iterate(offset, new CloseableProcessor<Pair<Long, String>, IOException>(){

                        @Override
                        public void exceptionThrown(@NotNull IOException e) {
                            if (e == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            processor.exceptionThrown(e);
                        }

                        @Override
                        public void close() throws IOException {
                            if (cnt.decrementAndGet() <= 0) {
                                processor.close();
                            }
                        }

                        public boolean process(Pair<Long, String> pair) {
                            if (!continueIteration.get()) {
                                return false;
                            }
                            return processor.process(pair);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/nodejs/run/profile/heap/calculation/V8StringIndex$2", "exceptionThrown"));
                        }
                    });
                }
                catch (IOException e) {
                    continueIteration.set(false);
                    processor.exceptionThrown(e);
                    try {
                        processor.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    @Override
    public void close() throws IOException {
        if (this.myWriters != null) {
            for (OneFileWriter writer : this.myWriters) {
                writer.close();
            }
        }
        if (this.myReaders != null) {
            for (OneFileReader reader : this.myReaders) {
                reader.close();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexFiles";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/calculation/V8StringIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "iterate";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "parallelIterate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class OneFileWriter
    implements Closeable {
        public static final int SIZE = 10000;
        private final File myFile;
        private final Map<Integer, Long> myPositionsMap;
        private int myCnt;
        private long myPosition;
        private final BufferedOutputStream myStream;
        private int myMaxSize;

        public OneFileWriter(@NotNull File file) throws IOException {
            if (file == null) {
                OneFileWriter.$$$reportNull$$$0(0);
            }
            this.myFile = file;
            this.myPositionsMap = new HashMap<Integer, Long>();
            this.myStream = new BufferedOutputStream(new FileOutputStream(this.myFile));
            this.myPosition = 0L;
            this.myMaxSize = 0;
        }

        public boolean addString(@NotNull String s) throws IOException {
            if (s == null) {
                OneFileWriter.$$$reportNull$$$0(1);
            }
            byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
            this.myStream.write(bytes);
            this.myMaxSize = Math.max(this.myMaxSize, bytes.length);
            this.myPositionsMap.put(this.myCnt++, this.myPosition);
            this.myPosition += (long)bytes.length;
            return this.myCnt < 10000;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            this.myStream.close();
            this.myPositionsMap.put(this.myCnt, this.myPosition);
            File connected = FileUtil.createTempFile((String)"v8strings", null);
            FileUtil.copy((File)this.myFile, (File)connected);
            FileUtil.delete((File)this.myFile);
            BufferedInputStream stream = new BufferedInputStream(new FileInputStream(connected));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.myFile));
            DataOutputStream dos = new DataOutputStream(out);
            RawSerializer.Helper.serializeInt(this.myPositionsMap.size(), dos);
            RawSerializer.Helper.serializeInt(this.myMaxSize, dos);
            try {
                for (int i = 0; i < this.myPositionsMap.size(); ++i) {
                    RawSerializer.Helper.serializeLong(this.myPositionsMap.get(i), dos);
                }
                FileUtil.copy((InputStream)stream, (OutputStream)out);
            }
            finally {
                stream.close();
                out.close();
                FileUtil.delete((File)connected);
            }
        }

        public OneFileReader createReader() throws FileNotFoundException {
            return new OneFileReader(this.myFile, this.myPositionsMap, this.myMaxSize);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/calculation/V8StringIndex$OneFileWriter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addString";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class OneFileReader
    implements Closeable {
        private final File myFile;
        private final Map<Integer, Long> myPositionsMap;
        private final int myMaxSize;
        private final RandomAccessFile myReader;
        private final int myStartOffset;

        public OneFileReader(File file, Map<Integer, Long> positionsMap, int maxSize) throws FileNotFoundException {
            this.myFile = file;
            this.myPositionsMap = positionsMap;
            this.myMaxSize = maxSize;
            this.myReader = new RandomAccessFile(file, "r");
            this.myStartOffset = 8 + this.myPositionsMap.size() * 8;
        }

        public OneFileReader(@NotNull File file) throws IOException {
            if (file == null) {
                OneFileReader.$$$reportNull$$$0(0);
            }
            this.myFile = file;
            try (FileInputStream fis = new FileInputStream(file);){
                BufferedInputStream stream = new BufferedInputStream(fis);
                DataInputStream din = new DataInputStream(stream);
                int mapSize = RawSerializer.Helper.deserializeInt(din);
                this.myPositionsMap = new HashMap<Integer, Long>(mapSize);
                this.myMaxSize = RawSerializer.Helper.deserializeInt(din);
                for (int i = 0; i < mapSize; ++i) {
                    this.myPositionsMap.put(i, RawSerializer.Helper.deserializeLong(din));
                }
            }
            this.myReader = new RandomAccessFile(file, "r");
            this.myStartOffset = 8 + this.myPositionsMap.size() * 8;
        }

        @NlsSafe
        public String readString(int i) throws IOException {
            Long curPos = this.myPositionsMap.get(i);
            long nextPos = this.myPositionsMap.get(i + 1);
            byte[] buf = new byte[(int)(nextPos - curPos)];
            this.myReader.seek((long)this.myStartOffset + curPos);
            this.myReader.read(buf);
            return new String(buf, StandardCharsets.UTF_8);
        }

        /*
         * WARNING - void declaration
         */
        public void iterate(long offset, @NotNull CloseableProcessor<Pair<Long, String>, IOException> closeableProcessor) throws IOException {
            void processor;
            if (closeableProcessor == null) {
                OneFileReader.$$$reportNull$$$0(1);
            }
            try (void var4_3 = processor;
                 BufferedInputStream stream = new BufferedInputStream(new FileInputStream(this.myFile));){
                stream.skipNBytes(this.myStartOffset);
                byte[] buf = new byte[this.myMaxSize];
                for (int i = 0; i < this.myPositionsMap.size() - 1; ++i) {
                    Long curPos = this.myPositionsMap.get(i);
                    long nextPos = this.myPositionsMap.get(i + 1);
                    int numBytes = stream.read(buf, 0, (int)(nextPos - curPos));
                    if (processor.process((Object)Pair.create((Object)(offset + (long)i), (Object)new String(buf, 0, numBytes, StandardCharsets.UTF_8)))) continue;
                    break;
                }
            }
        }

        @Override
        public void close() throws IOException {
            this.myReader.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/calculation/V8StringIndex$OneFileReader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "iterate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

