/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.domain;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextDomain
extends Domain {
    private final Cardinality.TextCardinality myCardinality;
    private final Length myLengthCaps;
    private final long myLength;

    public TextDomain(@NotNull String name2, @NotNull ConversionPoint descriptor2, long maxLength) {
        if (name2 == null) {
            TextDomain.$$$reportNull$$$0(0);
        }
        if (descriptor2 == null) {
            TextDomain.$$$reportNull$$$0(1);
        }
        this(name2, descriptor2, maxLength, Length.NONE);
    }

    /*
     * WARNING - void declaration
     */
    public TextDomain(@NotNull String name2, @NotNull ConversionPoint descriptor2, long maxLength, long defaultValue, boolean bl, boolean bl2) {
        void variable;
        void narrowable;
        if (name2 == null) {
            TextDomain.$$$reportNull$$$0(2);
        }
        if (descriptor2 == null) {
            TextDomain.$$$reportNull$$$0(3);
        }
        this(name2, descriptor2, maxLength, narrowable != false ? Length.optional(defaultValue == -1L ? maxLength : defaultValue, (boolean)variable) : Length.fixed(defaultValue, (boolean)variable));
    }

    /*
     * WARNING - void declaration
     */
    public TextDomain(@NotNull String name2, @NotNull ConversionPoint descriptor2, long maxLength, Length length) {
        void lengthCaps;
        if (name2 == null) {
            TextDomain.$$$reportNull$$$0(4);
        }
        if (descriptor2 == null) {
            TextDomain.$$$reportNull$$$0(5);
        }
        super(descriptor2, name2);
        this.myLength = maxLength;
        this.myCardinality = new Cardinality.TextCardinality(maxLength);
        this.myLengthCaps = lengthCaps;
    }

    public boolean isVariable() {
        return this.myLengthCaps.isVariable();
    }

    @Override
    @NotNull
    public Compatibility getCompatibility(@NotNull Domain domain) {
        if (domain == null) {
            TextDomain.$$$reportNull$$$0(6);
        }
        Compatibility compatibility = domain instanceof BinaryDomain ? this.compareWithLength((BinaryDomain)domain) : (domain instanceof TextDomain ? (((TextDomain)domain).getEffectiveLength() <= this.getEffectiveLength() ? Compatibility.full(this.cardinality(), domain.getLogicType(), this.getLogicType()) : Compatibility.compatibleLossy(this.cardinality(), domain.getLogicType(), this.getLogicType())) : Compatibility.incompatibleLossless(this.cardinality(), TextDomain.getLogicalType(domain), this.getLogicType()));
        if (compatibility == null) {
            TextDomain.$$$reportNull$$$0(7);
        }
        return compatibility;
    }

    @NotNull
    private static LogicalType getLogicalType(@NotNull Domain domain) {
        if (domain == null) {
            TextDomain.$$$reportNull$$$0(8);
        }
        LogicalType logicalType = domain instanceof TextPreferable ? ((TextPreferable)((Object)domain)).getFakeType() : domain.getLogicType();
        if (logicalType == null) {
            TextDomain.$$$reportNull$$$0(9);
        }
        return logicalType;
    }

    @NotNull
    private Compatibility compareWithLength(@NotNull BinaryDomain domain) {
        if (domain == null) {
            TextDomain.$$$reportNull$$$0(10);
        }
        Compatibility compatibility = domain.getEffectiveUpperBound() <= this.getEffectiveLength() ? Compatibility.incompatibleLossless(this.cardinality(), domain.getLogicType(), this.getLogicType()) : Compatibility.incompatibleLossy(this.cardinality(), domain.getLogicType(), this.getLogicType());
        if (compatibility == null) {
            TextDomain.$$$reportNull$$$0(11);
        }
        return compatibility;
    }

    @Override
    @NotNull
    public Cardinality cardinality() {
        Cardinality.TextCardinality textCardinality = this.myCardinality;
        if (textCardinality == null) {
            TextDomain.$$$reportNull$$$0(12);
        }
        return textCardinality;
    }

    public long getLength() {
        return this.myLength;
    }

    public long getEffectiveLength() {
        return this.myLengthCaps.getEffectiveLength(this.myLength);
    }

    @Override
    @Nullable
    public Object trim(@NotNull Object o) {
        if (o == null) {
            TextDomain.$$$reportNull$$$0(13);
        }
        return this.getLength() != 0L && o instanceof String ? ((String)o).substring(0, (int)Math.min(this.getLength(), (long)((String)o).length())) : o;
    }

    public long getDefaultValue() {
        return this.myLengthCaps.defaultLength;
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull Domain domain) {
        if (domain == null) {
            TextDomain.$$$reportNull$$$0(14);
        }
        if (!this.myLengthCaps.isNarrowable()) {
            TextDomain textDomain = this;
            if (textDomain == null) {
                TextDomain.$$$reportNull$$$0(15);
            }
            return textDomain;
        }
        Domain domain2 = domain instanceof BinaryDomain ? this.create(Math.min(((BinaryDomain)domain).getEffectiveUpperBound(), this.getEffectiveLength())) : (domain instanceof TextDomain ? this.create(Math.min(((TextDomain)domain).getEffectiveLength(), this.getEffectiveLength())) : this);
        if (domain2 == null) {
            TextDomain.$$$reportNull$$$0(16);
        }
        return domain2;
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull SizeProvider provider) {
        if (provider == null) {
            TextDomain.$$$reportNull$$$0(17);
        }
        if (!this.myLengthCaps.isNarrowable()) {
            TextDomain textDomain = this;
            if (textDomain == null) {
                TextDomain.$$$reportNull$$$0(18);
            }
            return textDomain;
        }
        int size = provider.getSize();
        Domain domain = this.create(size > 0 ? Math.min((long)size, this.getEffectiveLength()) : this.myLengthCaps.defaultLength);
        if (domain == null) {
            TextDomain.$$$reportNull$$$0(19);
        }
        return domain;
    }

    protected Domain create(long length) {
        return new TextDomain(this.simpleName(), this.getPoint(), length, this.myLengthCaps);
    }

    @Override
    @NotNull
    public String name() {
        Object object = this.myLengthCaps.shouldAddLength(this.getLength()) ? this.simpleName() + "(" + this.getEffectiveLength() + ")" : super.name();
        if (object == null) {
            TextDomain.$$$reportNull$$$0(20);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 9, 11, 12, 15, 16, 18, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domain";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/data/types/domain/TextDomain";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/data/types/domain/TextDomain";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompatibility";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogicalType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "compareWithLength";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "cardinality";
                break;
            }
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "narrow";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCompatibility";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLogicalType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "compareWithLength";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "trim";
                break;
            }
            case 14: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "narrow";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 9, 11, 12, 15, 16, 18, 19, 20 -> new IllegalStateException(string);
        };
    }

    public static final class Length {
        public final long defaultLength;
        public final Boolean hasCustomLength;
        public final boolean variable;
        public static final Length NONE = new Length(-1L, false, true);
        public static final Length MANDATORY = new Length(-1L, true, false);
        public static final Length MANDATORY_VAR = new Length(-1L, true, true);

        public static Length mandatory(boolean variable) {
            return variable ? MANDATORY_VAR : MANDATORY;
        }

        public static Length fixed(long length, boolean variable) {
            return length == -1L ? NONE : new Length(length, false, variable);
        }

        public static Length mandatory(long fallbackLength, boolean variable) {
            return fallbackLength == -1L ? Length.mandatory(variable) : new Length(fallbackLength, true, variable);
        }

        public static Length optional(long length, boolean variable) {
            return length == -1L ? Length.mandatory(variable) : new Length(length, null, variable);
        }

        private Length(long defaultLength, @Nullable Boolean hasCustomLength, boolean variable) {
            this.defaultLength = defaultLength;
            this.hasCustomLength = hasCustomLength;
            this.variable = variable;
        }

        public boolean isNarrowable() {
            return !this.isFixed();
        }

        public boolean isOptional() {
            return this.hasCustomLength == null;
        }

        public boolean isFixed() {
            return Boolean.FALSE.equals(this.hasCustomLength);
        }

        public boolean shouldAddLength(long length) {
            if (this.isFixed()) {
                return false;
            }
            if (this.isOptional()) {
                return length != this.defaultLength && length > 0L;
            }
            return true;
        }

        public long getEffectiveLength(long length) {
            return length > 0L ? length : this.defaultLength;
        }

        public boolean isVariable() {
            return this.variable;
        }
    }

    public static interface TextPreferable {
        @NotNull
        public LogicalType getFakeType();
    }
}

