/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.clickhouse;

import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.data.types.domain.UnknownDomain;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public final class CHouseDomains
extends BaseDomainRegistry {
    public CHouseDomains() {
        this.add(new SimpleDomain("Date", ConversionPoint.DATE));
        this.add(new SimpleDomain("DateTime", ConversionPoint.TIMESTAMP){

            @Override
            @NotNull
            public Compatibility getCompatibility(@NotNull Domain domain) {
                if (domain == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (domain.getLogicType() != LogicalType.TIME && domain.getLogicType() != LogicalType.TIME_WITH_TIMEZONE) {
                    Compatibility compatibility = super.getCompatibility(domain);
                    if (compatibility == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return compatibility;
                }
                Compatibility compatibility = Compatibility.full(this.cardinality(), domain.getLogicType(), this.getLogicType());
                if (compatibility == null) {
                    1.$$$reportNull$$$0(2);
                }
                return compatibility;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "domain";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dialects/clickhouse/CHouseDomains$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dialects/clickhouse/CHouseDomains$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCompatibility";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getCompatibility";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        });
        this.add(new TextDomain("FixedString", ConversionPoint.BLOB_TEXT, 0xFFFFFFL, TextDomain.Length.mandatory(0xFFFFFFL, false)){

            @Override
            public boolean isSuitable(@NotNull ColumnDescriptor descriptor2) {
                String typeName;
                if (descriptor2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return (typeName = descriptor2.getTypeName()) != null && StringUtil.startsWithIgnoreCase((String)typeName, (String)"FixedString");
            }

            @Override
            @NotNull
            public Compatibility getCompatibility(@NotNull Domain domain) {
                if (domain == null) {
                    2.$$$reportNull$$$0(1);
                }
                boolean fixed = domain instanceof BinaryDomain && !((BinaryDomain)domain).isVariable() || domain instanceof TextDomain && !((TextDomain)domain).isVariable();
                Compatibility compatibility = fixed ? super.getCompatibility(domain) : Compatibility.incompatible();
                if (compatibility == null) {
                    2.$$$reportNull$$$0(2);
                }
                return compatibility;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "domain";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dialects/clickhouse/CHouseDomains$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dialects/clickhouse/CHouseDomains$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCompatibility";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isSuitable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getCompatibility";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        }.withOperationSupport(OperationSupport.SUPPORTS_EQUALS));
        this.add(new FloatDomain("Float32", ConversionPoint.SINGLE_PRECISION, -3.4028234663852886E38, 3.4028234663852886E38));
        this.add(new FloatDomain("Float64", ConversionPoint.SINGLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add(new IntegerDomain("Int8", ConversionPoint.NUMBER, -128.0, 127.0));
        this.add(new IntegerDomain("Int16", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add(new IntegerDomain("Int32", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add(new IntegerDomain("Int64", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new IntegerDomain("UInt8", ConversionPoint.UNSIGNED_NUMBER, 0.0, 255.0));
        this.add(new IntegerDomain("UInt16", ConversionPoint.UNSIGNED_NUMBER, 0.0, 65535.0));
        this.add(new IntegerDomain("UInt32", ConversionPoint.UNSIGNED_NUMBER, 0.0, 4.294967295E9));
        this.add(new IntegerDomain("UInt64", ConversionPoint.UNSIGNED_NUMBER, 0.0, 1.8446744073709552E19));
        this.add(new TextDomain("String", ConversionPoint.TEXT, Long.MAX_VALUE, -1L, false, true));
        this.add(new SimpleDomain("UUID", ConversionPoint.UUID_TEXT));
        this.add(new UnknownDomain("Decimal").withOperationSupport(OperationSupport.SUPPORTS_NUMERIC_EQUALS));
        this.add(new UnknownDomain("Decimal32").withOperationSupport(OperationSupport.SUPPORTS_NUMERIC_EQUALS));
        this.add(new UnknownDomain("Decimal64").withOperationSupport(OperationSupport.SUPPORTS_NUMERIC_EQUALS));
        this.add(new UnknownDomain("Decimal128").withOperationSupport(OperationSupport.SUPPORTS_NUMERIC_EQUALS));
        this.add(new UnknownDomain("AggregateFunction"));
    }
}

