/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.clickhouse.types;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.types.DasTypeSystemImpl;
import com.intellij.database.dialects.clickhouse.types.CHouseArrayType;
import com.intellij.database.dialects.clickhouse.types.CHouseDateTime64Type;
import com.intellij.database.dialects.clickhouse.types.CHouseDateTimeType;
import com.intellij.database.dialects.clickhouse.types.CHouseEnumType;
import com.intellij.database.dialects.clickhouse.types.CHouseTypeSystem;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasArrayType;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasBuiltinTypeWithLength;
import com.intellij.database.types.DasBuiltinTypeWithLengthImpl;
import com.intellij.database.types.DasBuiltinTypeWithPrecision;
import com.intellij.database.types.DasBuiltinTypeWithPrecisionImpl;
import com.intellij.database.types.DasSimpleBuiltinType;
import com.intellij.database.types.DasSimpleBuiltinTypeClass;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeSystem;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.types.DasTypeWithScaleImpl;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.clickhouse.CHouseDialect;
import com.intellij.sql.dialects.clickhouse.CHouseElementTypes;
import com.intellij.sql.dialects.clickhouse.psi.CHouseJoinExpression;
import com.intellij.sql.dialects.clickhouse.psi.CHouseLambdaLiteral;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 @2\u00020\u0001:\u0001@B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\f\u001a\u00020\u0007H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\u0010\u001a\u00020\u0007H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0012H\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0012\u0010 \u001a\b\u0012\u0002\b\u0003\u0018\u00010\n*\u00020\u001fH\u0002J\u001c\u0010!\u001a\u0006\u0012\u0002\b\u00030\n*\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J$\u0010#\u001a\u00020\u001a2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0%2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0017\u0010&\u001a\t\u0018\u00010\u001a\u00a2\u0006\u0002\b'2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J&\u0010)\u001a\u00020\u001a2\b\u0010*\u001a\u0004\u0018\u00010+2\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010.\u001a\u0004\u0018\u00010/H\u0016J\u0012\u00100\u001a\u0004\u0018\u00010\u001a2\u0006\u00101\u001a\u00020-H\u0016J'\u00102\u001a\u0014 4*\t\u0018\u000103\u00a2\u0006\u0002\b'03\u00a2\u0006\u0002\b'2\u0006\u00105\u001a\u000206H\u0002\u00a2\u0006\u0002\u00107J\u0015\u00108\u001a\u000703\u00a2\u0006\u0002\b'2\u0006\u00105\u001a\u000206H\u0002J.\u00109\u001a\u0004\u0018\u00010\u001a2\u0006\u0010:\u001a\u00020;2\b\u0010<\u001a\u0004\u0018\u00010=2\b\u0010>\u001a\u0004\u0018\u00010-2\u0006\u0010?\u001a\u00020-H\u0016\u00a8\u0006A"}, d2={"Lcom/intellij/database/dialects/clickhouse/types/CHouseTypeSystem;", "Lcom/intellij/database/dialects/base/types/DasTypeSystemImpl;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "getIntType", "Lcom/intellij/database/types/DasSimpleBuiltinType;", "getRealType", "getBooleanType", "Lcom/intellij/database/types/DasBuiltinType;", "Lcom/intellij/database/types/DasSimpleBuiltinTypeClass;", "getDateType", "getDateTimeType", "Lcom/intellij/database/dialects/clickhouse/types/CHouseDateTimeType;", "getTimestampType", "getStringType", "getNormalizedTypeName", "", "name", "getDefaultTypeName", "cat", "Lcom/intellij/database/types/DasTypeCategory;", "doCreateArrayType", "Lcom/intellij/database/dialects/clickhouse/types/CHouseArrayType;", "componentType", "Lcom/intellij/database/types/DasType;", "getTableTypeSpecification", "args", "createDasType", "dataType", "Lcom/intellij/database/model/DataType;", "createBuiltinTypeBase", "adjust", "createCompositeType", "createSimpleConstructedType", "constructor", "Lkotlin/Function1;", "parseAsType", "Lorg/jetbrains/annotations/NotNull;", "createEnumType", "getDasType", "ref", "Lcom/intellij/sql/psi/SqlReference;", "resolved", "Lcom/intellij/psi/PsiElement;", "symbol", "Lcom/intellij/database/symbols/DasSymbol;", "getUnqualifiedAsteriskType", "element", "getDummyType", "Lcom/intellij/sql/psi/SqlTableType;", "kotlin.jvm.PlatformType", "tableExpression", "Lcom/intellij/sql/psi/SqlTableExpression;", "(Lcom/intellij/sql/psi/SqlTableExpression;)Lcom/intellij/sql/psi/SqlTableType;", "calcDummyType", "getBuiltinFunctionReturnType", "prototype", "Lcom/intellij/sql/dialects/BuiltinFunction$Prototype;", "nameElement", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "params", "routineElement", "Companion", "intellij.database.dialects.clickhouse"})
@SourceDebugExtension(value={"SMAP\nCHouseTypeSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CHouseTypeSystem.kt\ncom/intellij/database/dialects/clickhouse/types/CHouseTypeSystem\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,418:1\n1#2:419\n1187#3,2:420\n1261#3,4:422\n1230#3,4:426\n1230#3,4:430\n*S KotlinDebug\n*F\n+ 1 CHouseTypeSystem.kt\ncom/intellij/database/dialects/clickhouse/types/CHouseTypeSystem\n*L\n339#1:420,2\n339#1:422,4\n179#1:426,4\n223#1:430,4\n*E\n"})
public final class CHouseTypeSystem
extends DasTypeSystemImpl {
    @NotNull
    public static final Companion Companion;
    @JvmField
    @NotNull
    public static final DasSimpleBuiltinType UINT8;
    @JvmField
    @NotNull
    public static final DasSimpleBuiltinType UINT16;
    @JvmField
    @NotNull
    public static final DasSimpleBuiltinType UINT32;
    @JvmField
    @NotNull
    public static final DasSimpleBuiltinType UINT64;
    @JvmField
    @NotNull
    public static final DasSimpleBuiltinType INT8;
    @JvmField
    @NotNull
    public static final DasBuiltinType<DasSimpleBuiltinTypeClass> BOOLEAN;
    @JvmField
    @NotNull
    public static final DasSimpleBuiltinType INT16;
    @JvmField
    @NotNull
    public static final DasSimpleBuiltinType INT32;
    @JvmField
    @NotNull
    public static final DasSimpleBuiltinType INT64;
    @JvmField
    @NotNull
    public static final DasBuiltinTypeWithPrecisionImpl DECIMAL;
    @JvmField
    @NotNull
    public static final DasSimpleBuiltinType FLOAT32;
    @JvmField
    @NotNull
    public static final DasSimpleBuiltinType FLOAT64;
    @JvmField
    @NotNull
    public static final DasSimpleBuiltinType DATE;
    @JvmField
    @NotNull
    public static final CHouseDateTimeType DATETIME;
    @JvmField
    @NotNull
    public static final DasBuiltinType<DasSimpleBuiltinTypeClass> TIMESTAMP;
    @JvmField
    @NotNull
    public static final DasBuiltinTypeWithLengthImpl FIXED_STRING;
    @JvmField
    @NotNull
    public static final DasSimpleBuiltinType STRING;
    @JvmField
    @NotNull
    public static final DasSimpleBuiltinType IPv4;
    @JvmField
    @NotNull
    public static final DasSimpleBuiltinType IPv6;
    @JvmField
    @NotNull
    public static final Map<String, DasBuiltinType<?>> caseInsensitiveTypes;
    @JvmField
    @NotNull
    public static final Map<String, DasBuiltinType<?>> caseSensitiveTypes;

    public CHouseTypeSystem(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }

    @Override
    @NotNull
    public DasSimpleBuiltinType getIntType() {
        return INT32;
    }

    @Override
    @NotNull
    public DasSimpleBuiltinType getRealType() {
        return FLOAT64;
    }

    @Override
    @NotNull
    public DasBuiltinType<DasSimpleBuiltinTypeClass> getBooleanType() {
        return BOOLEAN;
    }

    @Override
    @NotNull
    public DasSimpleBuiltinType getDateType() {
        return DATE;
    }

    @Override
    @NotNull
    public CHouseDateTimeType getDateTimeType() {
        return DATETIME;
    }

    @Override
    @NotNull
    public DasBuiltinType<DasSimpleBuiltinTypeClass> getTimestampType() {
        return TIMESTAMP;
    }

    @Override
    @NotNull
    public DasSimpleBuiltinType getStringType() {
        return STRING;
    }

    @Override
    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return StringsKt.equals((String)name2, (String)"int", (boolean)true) ? "Int32" : (StringsKt.equals((String)name2, (String)"integer", (boolean)true) ? "Int32" : name2);
    }

    @Override
    @Nullable
    public String getDefaultTypeName(@NotNull DasTypeCategory cat) {
        Intrinsics.checkNotNullParameter((Object)((Object)cat), (String)"cat");
        return switch (WhenMappings.$EnumSwitchMapping$0[cat.ordinal()]) {
            case 1 -> "Int64";
            case 2 -> "Float64";
            case 3 -> "String";
            case 4 -> "UInt8";
            case 5 -> "DateTime";
            case 6 -> "Date";
            case 7 -> "DateTime";
            case 8 -> "DateTime";
            case 9 -> "Interval";
            case 10 -> "FixedString";
            default -> null;
        };
    }

    @Override
    @NotNull
    protected CHouseArrayType doCreateArrayType(@NotNull DasType componentType) {
        Intrinsics.checkNotNullParameter((Object)componentType, (String)"componentType");
        return new CHouseArrayType(componentType);
    }

    @Override
    @NotNull
    public String getTableTypeSpecification(@NotNull String args2) {
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        return "Nested(" + args2 + ")";
    }

    @Override
    @NotNull
    public DasType createDasType(@NotNull DataType dataType) {
        DasType dasType;
        Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
        DasBuiltinType<?> dasBuiltinType = this.createBuiltinTypeBase(dataType);
        if (dasBuiltinType != null && (dasBuiltinType = this.adjust(dasBuiltinType, dataType)) != null) {
            dasType = dasBuiltinType;
        } else {
            dasType = this.createEnumType(dataType);
            if (dasType == null && (dasType = this.createCompositeType(dataType)) == null) {
                dasType = DasTypeSystemBase.UNKNOWN;
            }
        }
        return dasType;
    }

    private final DasBuiltinType<?> createBuiltinTypeBase(DataType $this$createBuiltinTypeBase) {
        String string = $this$createBuiltinTypeBase.typeName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"typeName");
        String typeName = string;
        DasBuiltinType<?> dasBuiltinType = caseSensitiveTypes.get(typeName);
        if (dasBuiltinType != null) {
            DasBuiltinType<?> it = dasBuiltinType;
            boolean bl = false;
            return it;
        }
        DasBuiltinType<?> dasBuiltinType2 = caseInsensitiveTypes.get(StringUtil.toUpperCase((String)typeName));
        if (dasBuiltinType2 == null) {
            return null;
        }
        DasBuiltinType<?> dasType = dasBuiltinType2;
        if (!Intrinsics.areEqual((Object)dasType.getTypeClass().getName(), (Object)typeName)) {
            return DasTypeUtilsKt.withName(dasType, typeName);
        }
        return dasType;
    }

    private final DasBuiltinType<?> adjust(DasBuiltinType<?> $this$adjust, DataType dataType) {
        int size = dataType.size;
        int scale = dataType.scale;
        String arg = dataType.vagueArg;
        if ($this$adjust instanceof DasBuiltinTypeWithPrecision && (size != -1 || scale != 0)) {
            DasBuiltinTypeWithPrecision dasBuiltinTypeWithPrecision = ((DasBuiltinTypeWithPrecision)$this$adjust).copy(size, scale);
            Intrinsics.checkNotNullExpressionValue(dasBuiltinTypeWithPrecision, (String)"copy(...)");
            return dasBuiltinTypeWithPrecision;
        }
        if ($this$adjust instanceof DasBuiltinTypeWithLength && size != -1) {
            DasBuiltinTypeWithLength dasBuiltinTypeWithLength = ((DasBuiltinTypeWithLength)$this$adjust).copy(size);
            Intrinsics.checkNotNullExpressionValue(dasBuiltinTypeWithLength, (String)"copy(...)");
            return dasBuiltinTypeWithLength;
        }
        if ($this$adjust instanceof CHouseDateTimeType && arg != null) {
            return ((CHouseDateTimeType)$this$adjust).copy(StringUtil.unquoteString((String)arg));
        }
        if ($this$adjust instanceof CHouseDateTime64Type) {
            if (arg != null) {
                int p2 = StringsKt.indexOf$default((CharSequence)arg, (char)',', (int)0, (boolean)false, (int)6, null);
                if (p2 < 0) {
                    Integer n = StringsKt.toIntOrNull((String)arg);
                    if (n == null) {
                        return $this$adjust;
                    }
                    int sizeFromArg = n;
                    return CHouseDateTime64Type.copy$default((CHouseDateTime64Type)$this$adjust, sizeFromArg, null, 2, null);
                }
                String string = arg.substring(0, p2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                int precision = StringUtil.parseInt((String)((Object)StringsKt.trim((CharSequence)string)).toString(), (int)-1);
                String string2 = arg.substring(p2 + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                String string3 = StringUtil.unquoteString((String)((Object)StringsKt.trim((CharSequence)string2)).toString());
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"unquoteString(...)");
                String timeZone = string3;
                return ((CHouseDateTime64Type)$this$adjust).copy(precision, timeZone);
            }
            return CHouseDateTime64Type.copy$default((CHouseDateTime64Type)$this$adjust, size, null, 2, null);
        }
        return $this$adjust;
    }

    private final DasType createCompositeType(DataType dataType) {
        return switch (dataType.typeName) {
            case "Nullable" -> this.createSimpleConstructedType((Function1<? super DasType, ? extends DasType>)((Function1)createCompositeType.1.INSTANCE), dataType);
            case "Array" -> this.createSimpleConstructedType((Function1<? super DasType, ? extends DasType>)((Function1)createCompositeType.2.INSTANCE), dataType);
            case "LowCardinality" -> this.createSimpleConstructedType((Function1<? super DasType, ? extends DasType>)((Function1)createCompositeType.3.INSTANCE), dataType);
            case "AggregateFunction", "SimpleAggregateFunction", "Tuple" -> this.parseAsType(dataType);
            default -> null;
        };
    }

    private final DasType createSimpleConstructedType(Function1<? super DasType, ? extends DasType> constructor, DataType dataType) {
        String string = dataType.vagueArg;
        if (string == null) {
            string = "";
        }
        DataType dataType2 = DataTypeFactory.of(string);
        Intrinsics.checkNotNullExpressionValue((Object)dataType2, (String)"of(...)");
        return (DasType)constructor.invoke((Object)this.createDasType(dataType2));
    }

    private final DasType parseAsType(DataType dataType) {
        SqlTypeElement sqlTypeElement = SqlPsiElementFactory.createDataTypeFromText(dataType.getSpecification(), CHouseDialect.INSTANCE, ProjectManager.getInstance().getDefaultProject(), null, false);
        return sqlTypeElement != null ? sqlTypeElement.getDasType() : null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final DasType createEnumType(DataType dataType) {
        Map map2;
        DasSimpleBuiltinTypeClass dasSimpleBuiltinTypeClass;
        block12: {
            block11: {
                String string = dataType.typeName;
                switch (string.hashCode()) {
                    case 2165025: {
                        if (!string.equals("Enum")) {
                            return null;
                        }
                        break block11;
                    }
                    case 2080590598: {
                        if (string.equals("Enum16")) break;
                        return null;
                    }
                    case 67115831: {
                        if (!string.equals("Enum8")) return null;
                        dasSimpleBuiltinTypeClass = CHouseEnumType.ENUM8_CLASS;
                        break block12;
                    }
                }
                dasSimpleBuiltinTypeClass = CHouseEnumType.ENUM16_CLASS;
                break block12;
            }
            dasSimpleBuiltinTypeClass = CHouseEnumType.ENUM_CLASS;
            break block12;
            return null;
        }
        DasSimpleBuiltinTypeClass typeClass = dasSimpleBuiltinTypeClass;
        List<String> list = dataType.enumValues;
        if (list != null) {
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv = list;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Pair pair;
                Map map3 = destination$iv$iv;
                String it = (String)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                int p2 = StringsKt.lastIndexOf$default((CharSequence)it, (char)'=', (int)0, (boolean)false, (int)6, null);
                if (p2 < 0) {
                    pair = TuplesKt.to((Object)it, (Object)0);
                } else {
                    String key2;
                    String string = it.substring(0, p2);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)StringUtil.unquoteString((String)((Object)StringsKt.trim((CharSequence)string)).toString()), (String)"unquoteString(...)");
                    String string2 = it.substring(p2 + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    int value = StringUtil.parseInt((String)((Object)StringsKt.trim((CharSequence)string2)).toString(), (int)0);
                    pair = TuplesKt.to((Object)key2, (Object)value);
                }
                Pair pair2 = pair;
                map3.put(pair2.getFirst(), pair2.getSecond());
            }
            map2 = destination$iv$iv;
        } else {
            map2 = MapsKt.emptyMap();
        }
        Map labels = map2;
        return CHouseEnumType.Companion.of(typeClass, labels);
    }

    @Override
    @NotNull
    public DasType getDasType(@Nullable SqlReference ref2, @Nullable PsiElement resolved, @Nullable DasSymbol symbol) {
        DasObject dasObject;
        if (symbol != null && Intrinsics.areEqual((Object)symbol.getKind(), (Object)ObjectKind.OBJECT_TYPE)) {
            DasBuiltinType<?> dasBuiltinType = caseSensitiveTypes.get(symbol.getName());
            return dasBuiltinType != null ? (DasType)dasBuiltinType : (DasType)DasTypeSystemBase.UNKNOWN;
        }
        DasSymbol dasSymbol = symbol;
        DasObject dasObject2 = dasObject = dasSymbol != null ? dasSymbol.getDasObject() : null;
        if (ref2 != null && dasObject != null && Intrinsics.areEqual((Object)dasObject.getKind(), (Object)CHouseElementTypes.Kinds.DICTIONARY)) {
            TableBasedSqlTableTypeImpl<DasColumn> tableBasedSqlTableTypeImpl = TableBasedSqlTableTypeImpl.createTypeWithColumns(dasObject, resolved, ref2.getElement(), DasColumn.class, ObjectKind.COLUMN);
            Intrinsics.checkNotNullExpressionValue(tableBasedSqlTableTypeImpl, (String)"createTypeWithColumns(...)");
            return (DasType)((Object)tableBasedSqlTableTypeImpl);
        }
        DasType type = super.getDasType(ref2, resolved, symbol);
        if (ref2 == null) {
            return type;
        }
        PsiElement psiElement = ref2.getQualifier();
        SqlExpression sqlExpression = psiElement instanceof SqlExpression ? (SqlExpression)psiElement : null;
        if (sqlExpression == null) {
            return type;
        }
        SqlExpression qualifier = sqlExpression;
        DasType dasType = qualifier.getDasType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
        DasType qualifierType = dasType;
        if (qualifierType instanceof DasArrayType) {
            DasArrayType dasArrayType = (DasArrayType)qualifierType;
            DasTypeSystem dasTypeSystem = SqlImplUtil.getTypeSystem((PsiElement)qualifier);
            Intrinsics.checkNotNullExpressionValue((Object)dasTypeSystem, (String)"getTypeSystem(...)");
            return DasTypeUtilsKt.mapDeepestComponent(dasArrayType, type, dasTypeSystem);
        }
        return type;
    }

    @Override
    @Nullable
    public DasType getUnqualifiedAsteriskType(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        SqlQueryExpression queryExpression = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, SqlQueryExpression.class, (boolean)true);
        SqlQueryExpression sqlQueryExpression = queryExpression;
        if (sqlQueryExpression == null || (sqlQueryExpression = sqlQueryExpression.getTableExpression()) == null) {
            return null;
        }
        SqlQueryExpression tableExpression = sqlQueryExpression;
        SqlFromClause sqlFromClause = tableExpression.getFromClause();
        if (sqlFromClause == null) {
            return (DasType)this.getDummyType((SqlTableExpression)tableExpression);
        }
        SqlFromClause fromClause = sqlFromClause;
        SqlExpression sqlExpression = fromClause.getFromExpression();
        if (sqlExpression == null) {
            return null;
        }
        SqlExpression expr = sqlExpression;
        DasType dasType = expr instanceof CHouseJoinExpression ? (DasType)((CHouseJoinExpression)expr).calcJoinType(null, true) : expr.getDasType();
        Intrinsics.checkNotNull((Object)dasType);
        DasType type = dasType;
        return type instanceof SqlTableType ? (DasType)CHouseDialect.filterComputedColumns((SqlTableType)type) : type;
    }

    private final SqlTableType getDummyType(SqlTableExpression tableExpression) {
        return (SqlTableType)CachedValuesManager.getCachedValue((PsiElement)((PsiElement)tableExpression), () -> CHouseTypeSystem.getDummyType$lambda$2(this, tableExpression));
    }

    private final SqlTableType calcDummyType(SqlTableExpression tableExpression) {
        SqlTableType sqlTableType = SqlImplUtil.createType(CollectionsKt.listOf((Object)SqlDialectImplUtilCore.col((PsiElement)tableExpression, null, "dummy", this.getBooleanType())), tableExpression.getParent());
        Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"createType(...)");
        return sqlTableType;
    }

    @Override
    @Nullable
    public DasType getBuiltinFunctionReturnType(@NotNull BuiltinFunction.Prototype prototype, @Nullable SqlReferenceExpression nameElement, @Nullable PsiElement params, @NotNull PsiElement routineElement) {
        Intrinsics.checkNotNullParameter((Object)prototype, (String)"prototype");
        Intrinsics.checkNotNullParameter((Object)routineElement, (String)"routineElement");
        if (!(params instanceof SqlExpressionList) || nameElement == null) {
            return null;
        }
        List list = ((SqlExpressionList)params).getExpressionList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExpressionList(...)");
        List expressions = list;
        return switch (nameElement.getName()) {
            case "sumMap" -> SqlImplUtil.getTupleType((SqlExpressionList)params, false);
            case "arrayFirst" -> {
                if (expressions.isEmpty()) {
                    yield null;
                }
                DasType var8_7 = ((SqlExpression)expressions.get(0)).getDasType();
                DasArrayType v2 = var8_7 instanceof DasArrayType ? (DasArrayType)var8_7 : null;
                if (v2 != null) {
                    yield v2.getComponentType();
                }
                yield null;
            }
            case "arrayMap" -> {
                CHouseLambdaLiteral lambda = (CHouseLambdaLiteral)PsiTreeUtil.getChildOfType((PsiElement)params, CHouseLambdaLiteral.class);
                Object v3 = lambda;
                if (v3 == null || (v3 = ((CHouseLambdaLiteral)v3).getReturnType()) == null) {
                    v3 = DasTypeSystemBase.UNKNOWN;
                }
                Object lambdaBodyType = v3;
                yield this.getArrayType((DasType)lambdaBodyType);
            }
            case "groupArray" -> {
                DasArrayType v4;
                if (expressions.isEmpty()) {
                    v4 = null;
                } else {
                    DasType v5 = ((SqlExpression)expressions.get(0)).getDasType();
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getDasType(...)");
                    v4 = this.getArrayType(v5);
                }
                yield v4;
            }
            case "arraySplit" -> {
                DasType v6 = ((SqlExpression)expressions.get(0)).getDasType();
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getDasType(...)");
                yield this.getArrayType(v6);
            }
            case "arrayJoin" -> {
                DasType var8_9 = ((SqlExpression)expressions.get(0)).getDasType();
                DasArrayType v7 = var8_9 instanceof DasArrayType ? (DasArrayType)var8_9 : null;
                if (v7 != null) {
                    yield v7.getComponentType();
                }
                yield null;
            }
            default -> null;
        };
    }

    private static final CachedValueProvider.Result getDummyType$lambda$2(CHouseTypeSystem this$0, SqlTableExpression $tableExpression) {
        Object[] objectArray = new Object[]{$tableExpression};
        return CachedValueProvider.Result.create((Object)this$0.calcDummyType($tableExpression), (Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_1;
        DasBuiltinType it;
        Map map2;
        Object element$iv;
        Object $this$associateByTo$iv;
        Companion = new Companion(null);
        UINT8 = DasSimpleBuiltinType.Companion.of("UInt8", DasTypeCategory.INTEGER);
        UINT16 = DasSimpleBuiltinType.Companion.of("UInt16", DasTypeCategory.INTEGER);
        UINT32 = DasSimpleBuiltinType.Companion.of("UInt32", DasTypeCategory.INTEGER);
        UINT64 = DasSimpleBuiltinType.Companion.of("UInt64", DasTypeCategory.INTEGER);
        INT8 = DasSimpleBuiltinType.Companion.of("Int8", DasTypeCategory.INTEGER);
        BOOLEAN = DasTypeUtilsKt.withName(INT8, "BOOLEAN");
        INT16 = DasSimpleBuiltinType.Companion.of("Int16", DasTypeCategory.INTEGER);
        INT32 = DasSimpleBuiltinType.Companion.of("Int32", DasTypeCategory.INTEGER);
        INT64 = DasSimpleBuiltinType.Companion.of("Int64", DasTypeCategory.INTEGER);
        DECIMAL = DasBuiltinTypeWithPrecisionImpl.Companion.of$default(DasBuiltinTypeWithPrecisionImpl.Companion, DasSimpleBuiltinTypeClass.Companion.of("Decimal", DasTypeCategory.REAL), 0, 0, 6, null);
        FLOAT32 = DasSimpleBuiltinType.Companion.of("Float32", DasTypeCategory.REAL);
        FLOAT64 = DasSimpleBuiltinType.Companion.of("Float64", DasTypeCategory.REAL);
        DATE = DasSimpleBuiltinType.Companion.of("Date", DasTypeCategory.DATE);
        DATETIME = CHouseDateTimeType.Companion.of$default(CHouseDateTimeType.Companion, null, 1, null);
        TIMESTAMP = DasTypeUtilsKt.withName(DATETIME, "TIMESTAMP");
        FIXED_STRING = DasBuiltinTypeWithLengthImpl.Companion.of$default(DasBuiltinTypeWithLengthImpl.Companion, DasSimpleBuiltinTypeClass.Companion.of("FixedString", DasTypeCategory.STRING), 0, 2, null);
        STRING = DasSimpleBuiltinType.Companion.of("String", DasTypeCategory.STRING);
        IPv4 = DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "IPv4", null, 2, null);
        IPv6 = DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "IPv6", null, 2, null);
        Object object = new DasBuiltinType[]{DasTypeUtilsKt.withName(UINT8, "INT1 UNSIGNED"), DasTypeUtilsKt.withName(UINT8, "TINYINT UNSIGNED"), DasTypeUtilsKt.withName(UINT16, "SMALLINT UNSIGNED"), DasTypeUtilsKt.withName(UINT32, "INTEGER UNSIGNED"), DasTypeUtilsKt.withName(UINT32, "INT UNSIGNED"), DasTypeUtilsKt.withName(UINT32, "MEDIUMINT UNSIGNED"), DasTypeUtilsKt.withName(UINT64, "BIGINT UNSIGNED"), DasTypeUtilsKt.withName(INT8, "BOOL"), BOOLEAN, DasTypeUtilsKt.withName(INT8, "INT1 SIGNED"), DasTypeUtilsKt.withName(INT8, "TINYINT SIGNED"), DasTypeUtilsKt.withName(INT8, "INT1"), DasTypeUtilsKt.withName(INT8, "TINYINT"), DasTypeUtilsKt.withName(INT8, "BYTE"), DasTypeUtilsKt.withName(INT16, "SMALLINT"), DasTypeUtilsKt.withName(INT16, "SMALLINT SIGNED"), DasTypeUtilsKt.withName(INT32, "INTEGER SIGNED"), DasTypeUtilsKt.withName(INT32, "INT SIGNED"), DasTypeUtilsKt.withName(INT32, "MEDIUMINT"), DasTypeUtilsKt.withName(INT32, "MEDIUMINT SIGNED"), DasTypeUtilsKt.withName(INT32, "INTEGER"), DasTypeUtilsKt.withName(INT32, "INT"), DasTypeUtilsKt.withName(INT64, "BIGINT SIGNED"), DasTypeUtilsKt.withName(INT64, "BIGINT"), DECIMAL, DasTypeUtilsKt.withName(DECIMAL, "FIXED"), DasTypeUtilsKt.withName(DECIMAL, "NUMERIC"), DasTypeUtilsKt.withName(DECIMAL, "DEC"), DasTypeWithScaleImpl.Companion.of$default(DasTypeWithScaleImpl.Companion, DasSimpleBuiltinTypeClass.Companion.of("DECIMAL32", DasTypeCategory.REAL), 0, 2, null), DasTypeWithScaleImpl.Companion.of$default(DasTypeWithScaleImpl.Companion, DasSimpleBuiltinTypeClass.Companion.of("DECIMAL64", DasTypeCategory.REAL), 0, 2, null), DasTypeWithScaleImpl.Companion.of$default(DasTypeWithScaleImpl.Companion, DasSimpleBuiltinTypeClass.Companion.of("DECIMAL128", DasTypeCategory.REAL), 0, 2, null), DasTypeWithScaleImpl.Companion.of$default(DasTypeWithScaleImpl.Companion, DasSimpleBuiltinTypeClass.Companion.of("DECIMAL256", DasTypeCategory.REAL), 0, 2, null), DasTypeUtilsKt.withName(FLOAT32, "SINGLE"), DasTypeUtilsKt.withName(FLOAT32, "FLOAT"), DasTypeUtilsKt.withName(FLOAT32, "REAL"), DasTypeUtilsKt.withName(FLOAT64, "DOUBLE"), DATE, DasSimpleBuiltinType.Companion.of("Date32", DasTypeCategory.DATE), DATETIME, DasTypeUtilsKt.withName(DATETIME, "DATETIME32"), TIMESTAMP, CHouseDateTime64Type.Companion.of$default(CHouseDateTime64Type.Companion, 0, null, 3, null), DasTypeUtilsKt.withName(FIXED_STRING, "BINARY"), DasTypeUtilsKt.withName(STRING, "BINARY VARYING"), DasTypeUtilsKt.withName(STRING, "BYTEA"), DasTypeUtilsKt.withName(STRING, "CHAR"), DasTypeUtilsKt.withName(STRING, "CHARACTER"), DasTypeUtilsKt.withName(STRING, "VARCHAR"), DasTypeUtilsKt.withName(STRING, "VARCHAR2"), DasTypeUtilsKt.withName(STRING, "CHAR VARYING"), DasTypeUtilsKt.withName(STRING, "CHARACTER VARYING"), DasTypeUtilsKt.withName(STRING, "NCHAR"), DasTypeUtilsKt.withName(STRING, "NATIONAL CHAR"), DasTypeUtilsKt.withName(STRING, "NATIONAL CHARACTER"), DasTypeUtilsKt.withName(STRING, "NVARCHAR"), DasTypeUtilsKt.withName(STRING, "NCHAR VARYING"), DasTypeUtilsKt.withName(STRING, "NATIONAL CHAR VARYING"), DasTypeUtilsKt.withName(STRING, "NATIONAL CHARACTER VARYING"), DasTypeUtilsKt.withName(STRING, "CLOB"), DasTypeUtilsKt.withName(STRING, "CHAR LARGE OBJECT"), DasTypeUtilsKt.withName(STRING, "CHARACTER LARGE OBJECT"), DasTypeUtilsKt.withName(STRING, "NCHAR LARGE OBJECT"), DasTypeUtilsKt.withName(STRING, "NATIONAL CHARACTER LARGE OBJECT"), DasTypeUtilsKt.withName(STRING, "TINYTEXT"), DasTypeUtilsKt.withName(STRING, "MEDIUMTEXT"), DasTypeUtilsKt.withName(STRING, "TEXT"), DasTypeUtilsKt.withName(STRING, "LONGTEXT"), DasTypeUtilsKt.withName(STRING, "TINYBLOB"), DasTypeUtilsKt.withName(STRING, "MEDIUMBLOB"), DasTypeUtilsKt.withName(STRING, "LONGBLOB"), DasTypeUtilsKt.withName(STRING, "BLOB"), DasTypeUtilsKt.withName(STRING, "BINARY LARGE OBJECT"), DasTypeUtilsKt.withName(IPv4, "INET4"), DasTypeUtilsKt.withName(IPv6, "INET6")};
        object = CollectionsKt.listOf((Object[])object);
        Map destination$iv = new HashMap();
        boolean $i$f$associateByTo = false;
        Iterator iterator = $this$associateByTo$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            DasBuiltinType dasBuiltinType = (DasBuiltinType)element$iv;
            map2 = destination$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.database.types.DasType");
            map2.put(StringUtil.toUpperCase((String)((DasType)it).getTypeClass().getName()), element$iv);
        }
        caseInsensitiveTypes = destination$iv;
        $this$associateByTo$iv = new DasBuiltinType[]{UINT8, UINT16, UINT32, UINT64, DasSimpleBuiltinType.Companion.of("UInt128", DasTypeCategory.INTEGER), DasSimpleBuiltinType.Companion.of("UInt256", DasTypeCategory.INTEGER), INT8, INT16, INT32, INT64, DasSimpleBuiltinType.Companion.of("Int128", DasTypeCategory.INTEGER), DasSimpleBuiltinType.Companion.of("Int256", DasTypeCategory.INTEGER), FLOAT32, FLOAT64, DasSimpleBuiltinType.Companion.of("IntervalSecond", DasTypeCategory.INTERVAL), DasSimpleBuiltinType.Companion.of("IntervalMinute", DasTypeCategory.INTERVAL), DasSimpleBuiltinType.Companion.of("IntervalHour", DasTypeCategory.INTERVAL), DasSimpleBuiltinType.Companion.of("IntervalDay", DasTypeCategory.INTERVAL), DasSimpleBuiltinType.Companion.of("IntervalWeek", DasTypeCategory.INTERVAL), DasSimpleBuiltinType.Companion.of("IntervalMonth", DasTypeCategory.INTERVAL), DasSimpleBuiltinType.Companion.of("IntervalQuarter", DasTypeCategory.INTERVAL), DasSimpleBuiltinType.Companion.of("IntervalYear", DasTypeCategory.INTERVAL), STRING, FIXED_STRING, DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "Point", null, 2, null), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "Ring", null, 2, null), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "Polygon", null, 2, null), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "MultiPolygon", null, 2, null), IPv4, IPv6, DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "UUID", null, 2, null), DasSimpleBuiltinType.Companion.of$default(DasSimpleBuiltinType.Companion, "Nothing", null, 2, null)};
        $this$associateByTo$iv = CollectionsKt.listOf((Object[])$this$associateByTo$iv);
        destination$iv = new HashMap();
        $i$f$associateByTo = false;
        iterator = $this$associateByTo$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            it = (DasBuiltinType)element$iv;
            map2 = destination$iv;
            boolean bl = false;
            map2.put(((DasSimpleBuiltinTypeClass)it.getTypeClass()).getName(), element$iv);
        }
        caseSensitiveTypes = var1_1;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u00168\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u00198\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u001f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R \u0010 \u001a\u0012\u0012\u0004\u0012\u00020\u001f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/database/dialects/clickhouse/types/CHouseTypeSystem$Companion;", "", "<init>", "()V", "UINT8", "Lcom/intellij/database/types/DasSimpleBuiltinType;", "UINT16", "UINT32", "UINT64", "INT8", "BOOLEAN", "Lcom/intellij/database/types/DasBuiltinType;", "Lcom/intellij/database/types/DasSimpleBuiltinTypeClass;", "INT16", "INT32", "INT64", "DECIMAL", "Lcom/intellij/database/types/DasBuiltinTypeWithPrecisionImpl;", "FLOAT32", "FLOAT64", "DATE", "DATETIME", "Lcom/intellij/database/dialects/clickhouse/types/CHouseDateTimeType;", "TIMESTAMP", "FIXED_STRING", "Lcom/intellij/database/types/DasBuiltinTypeWithLengthImpl;", "STRING", "IPv4", "IPv6", "caseInsensitiveTypes", "", "", "caseSensitiveTypes", "intellij.database.dialects.clickhouse"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DasTypeCategory.values().length];
            try {
                nArray[DasTypeCategory.INTEGER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.REAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.BOOLEAN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.DATE_TIME.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.DATE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.TIME.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.TIMESTAMP.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.INTERVAL.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.BYTES.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

