/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.generator.producers;

import com.intellij.database.dialects.base.generator.BaseProducer;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.mssql.model.MsDataSpace;
import com.intellij.database.dialects.mssql.model.MsFileGroup;
import com.intellij.database.dialects.mssql.model.MsLikeColumn;
import com.intellij.database.dialects.mssql.model.MsPartition;
import com.intellij.database.dialects.mssql.model.MsPartitionOwner;
import com.intellij.database.dialects.mssql.model.MsPartitionScheme;
import com.intellij.database.dialects.mssql.model.properties.MsDataCompressionKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a$\u0010\u0005\u001a\u00020\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0000\u001al\u0010\u0005\u001a\u00020\u0001\"\u0004\b\u0000\u0010\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\r\u001a\u0002H\f2\u0017\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\f0\u000f\u00a2\u0006\u0002\b\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\u0012\u001a\u00020\u000b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"produceOnDataSpaceClause", "", "Lcom/intellij/database/dialects/base/generator/BaseProducer;", "element", "Lcom/intellij/database/dialects/mssql/model/MsPartitionOwner;", "appendPartitionRangeOptions", "partitions", "", "Lcom/intellij/database/dialects/mssql/model/MsPartition;", "options", "", "", "K", "defaultKind", "kindGetter", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "kindPrinter", "clausePrefix", "(Ljava/util/List;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Ljava/lang/String;Ljava/util/List;)V", "intellij.database.dialects.mssql"})
@SourceDebugExtension(value={"SMAP\nMsTableProducers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MsTableProducers.kt\ncom/intellij/database/dialects/mssql/generator/producers/MsTableProducersKt\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 ScriptingContext.kt\ncom/intellij/database/dialects/base/generator/ScriptingContext$NewCodingAdapter\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,243:1\n381#2,7:244\n250#3:251\n254#3:253\n241#3,8:254\n250#3:262\n254#3:264\n241#3,8:265\n1#4:252\n1#4:263\n*S KotlinDebug\n*F\n+ 1 MsTableProducers.kt\ncom/intellij/database/dialects/mssql/generator/producers/MsTableProducersKt\n*L\n203#1:244,7\n159#1:251\n159#1:253\n159#1:254,8\n161#1:262\n161#1:264\n161#1:265,8\n159#1:252\n161#1:263\n*E\n"})
public final class MsTableProducersKt {
    public static final void produceOnDataSpaceClause(@NotNull BaseProducer $this$produceOnDataSpaceClause, @NotNull MsPartitionOwner element) {
        Intrinsics.checkNotNullParameter((Object)$this$produceOnDataSpaceClause, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        MsDataSpace msDataSpace = element.getPartitionDataSpace();
        if (msDataSpace == null) {
            return;
        }
        MsDataSpace dataSpace = msDataSpace;
        if (dataSpace instanceof MsFileGroup && ((MsFileGroup)dataSpace).isDefaultGroup()) {
            return;
        }
        MsLikeColumn partitionColumn = element.getPartitionColumn();
        $this$produceOnDataSpaceClause.sqlClause((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)arg_0 -> MsTableProducersKt.produceOnDataSpaceClause$lambda$0(dataSpace, partitionColumn, arg_0)));
    }

    public static final void appendPartitionRangeOptions(@NotNull List<? extends MsPartition> partitions, @NotNull List<String> options) {
        Intrinsics.checkNotNullParameter(partitions, (String)"partitions");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        MsTableProducersKt.appendPartitionRangeOptions(partitions, MsDataCompressionKind.NONE, MsTableProducersKt::appendPartitionRangeOptions$lambda$1, MsTableProducersKt::appendPartitionRangeOptions$lambda$2, "data_compression", options);
        MsTableProducersKt.appendPartitionRangeOptions(partitions, false, MsTableProducersKt::appendPartitionRangeOptions$lambda$3, MsTableProducersKt::appendPartitionRangeOptions$lambda$4, "xml_compression", options);
    }

    private static final <K> void appendPartitionRangeOptions(List<? extends MsPartition> partitions, K defaultKind, Function1<? super MsPartition, ? extends K> kindGetter, Function1<? super K, String> kindPrinter, String clausePrefix, List<String> options) {
        Object kind;
        LinkedHashMap rangesByKind = new LinkedHashMap();
        int start2 = 0;
        int numPartitions = partitions.size();
        while (start2 < numPartitions) {
            Object object;
            int end;
            Object kind2 = kindGetter.invoke((Object)partitions.get(start2));
            for (end = start2; end < numPartitions && Intrinsics.areEqual((Object)kindGetter.invoke((Object)partitions.get(end)), (Object)kind2); ++end) {
            }
            Map $this$getOrPut$iv = rangesByKind;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(kind2);
            if (value$iv == null) {
                boolean bl = false;
                SmartList answer$iv = new SmartList();
                $this$getOrPut$iv.put(kind2, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((SmartList)object).add((Object)new IntRange(start2 + 1, end));
            start2 = end;
        }
        for (Map.Entry entry : ((Map)rangesByKind).entrySet()) {
            IntRange range;
            kind = entry.getKey();
            SmartList ranges = (SmartList)entry.getValue();
            if ((IntRange)CollectionsKt.singleOrNull((List)((List)ranges)) == null || range.getFirst() != 1 || range.getLast() != numPartitions) continue;
            if (!Intrinsics.areEqual(kind, defaultKind)) {
                ((Collection)options).add(clausePrefix + " = " + kindPrinter.invoke(kind));
            }
            return;
        }
        for (Map.Entry entry : ((Map)rangesByKind).entrySet()) {
            kind = entry.getKey();
            SmartList ranges = (SmartList)entry.getValue();
            ((Collection)options).add(CollectionsKt.joinToString$default((Iterable)((Iterable)ranges), null, (CharSequence)(clausePrefix + " = " + kindPrinter.invoke(kind) + " on partitions ("), (CharSequence)")", (int)0, null, MsTableProducersKt::appendPartitionRangeOptions$lambda$6, (int)25, null));
        }
    }

    private static final Unit produceOnDataSpaceClause$lambda$0(MsDataSpace $dataSpace, MsLikeColumn $partitionColumn, ScriptingContext.NewCodingAdapter $this$sqlClause) {
        ScriptingContext.NewCodingAdapter this_$iv$iv;
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$sqlClause, (String)"$this$sqlClause");
        ScriptingContext.NewCodingAdapter newCodingAdapter = $this$sqlClause.unaryPlus("on");
        ScriptingContext.NewCodingAdapter this_$iv = $this$sqlClause;
        boolean $i$f$scr = false;
        ScriptingContext.NewCodingAdapter newCodingAdapter2 = this_$iv;
        BasicElement basicElement = $dataSpace;
        if (basicElement != null) {
            BasicElement it$iv = basicElement;
            boolean bl = false;
            string = ScriptingContext.NewCodingAdapter.quote$default(this_$iv, it$iv, null, 2, null);
        } else {
            string = null;
        }
        String quotedName$iv$iv = string;
        boolean $i$f$name = false;
        void this_$iv$iv$iv = this_$iv$iv;
        boolean $i$f$orError = false;
        $this$sqlClause.plus(newCodingAdapter, (Function0<? extends Object>)((Function0)new Function0<Unit>(quotedName$iv$iv, (ScriptingContext.NewCodingAdapter)this_$iv$iv$iv){
            final /* synthetic */ String $text;
            final /* synthetic */ ScriptingContext.NewCodingAdapter this$0;
            {
                this.$text = $text;
                this.this$0 = $receiver;
            }

            public final void invoke() {
                if (this.$text != null) {
                    ScriptingContext.NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                } else {
                    CompositeText.Kind kind = null;
                    CharSequence charSequence = "???";
                    ScriptingContext.NewCodingAdapter newCodingAdapter = this.this$0;
                    boolean bl = false;
                    String string = "unknown name";
                    ScriptingContext.NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                }
            }
        }));
        if ($dataSpace instanceof MsPartitionScheme) {
            String string2;
            ScriptingContext.NewCodingAdapter newCodingAdapter3 = $this$sqlClause.unaryPlus("(");
            this_$iv = $this$sqlClause;
            $i$f$scr = false;
            this_$iv$iv = this_$iv;
            BasicElement basicElement2 = $partitionColumn;
            if (basicElement2 != null) {
                BasicElement it$iv = basicElement2;
                boolean bl = false;
                string2 = ScriptingContext.NewCodingAdapter.quote$default(this_$iv, it$iv, null, 2, null);
            } else {
                string2 = null;
            }
            quotedName$iv$iv = string2;
            $i$f$name = false;
            ScriptingContext.NewCodingAdapter this_$iv$iv$iv2 = this_$iv$iv;
            $i$f$orError = false;
            $this$sqlClause.minus($this$sqlClause.minus(newCodingAdapter3, (Function0<? extends Object>)((Function0)new Function0<Unit>(quotedName$iv$iv, this_$iv$iv$iv2){
                final /* synthetic */ String $text;
                final /* synthetic */ ScriptingContext.NewCodingAdapter this$0;
                {
                    this.$text = $text;
                    this.this$0 = $receiver;
                }

                public final void invoke() {
                    if (this.$text != null) {
                        ScriptingContext.NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                    } else {
                        CompositeText.Kind kind = null;
                        CharSequence charSequence = "???";
                        ScriptingContext.NewCodingAdapter newCodingAdapter = this.this$0;
                        boolean bl = false;
                        String string = "unknown name";
                        ScriptingContext.NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                    }
                }
            })), ")");
        }
        return Unit.INSTANCE;
    }

    private static final MsDataCompressionKind appendPartitionRangeOptions$lambda$1(MsPartition $this$appendPartitionRangeOptions) {
        Intrinsics.checkNotNullParameter((Object)$this$appendPartitionRangeOptions, (String)"$this$appendPartitionRangeOptions");
        MsDataCompressionKind msDataCompressionKind = $this$appendPartitionRangeOptions.getCompression();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)msDataCompressionKind), (String)"getCompression(...)");
        return msDataCompressionKind;
    }

    private static final String appendPartitionRangeOptions$lambda$2(MsDataCompressionKind it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return it.getSql();
    }

    private static final boolean appendPartitionRangeOptions$lambda$3(MsPartition $this$appendPartitionRangeOptions) {
        Intrinsics.checkNotNullParameter((Object)$this$appendPartitionRangeOptions, (String)"$this$appendPartitionRangeOptions");
        return $this$appendPartitionRangeOptions.isXmlCompression();
    }

    private static final String appendPartitionRangeOptions$lambda$4(boolean it) {
        return it ? "on" : "off";
    }

    private static final CharSequence appendPartitionRangeOptions$lambda$6(IntRange it) {
        int last;
        int first2 = it.getFirst();
        return first2 == (last = it.getLast()) ? (CharSequence)String.valueOf(first2) : (CharSequence)(first2 + " to " + last);
    }
}

