/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysqlbase.model.properties;

import com.intellij.database.dialects.mysqlbase.model.properties.MysqlObjectGrantController;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.properties.Grants;
import com.intellij.database.util.DbUtil;
import java.util.BitSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJN\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/dialects/mysqlbase/model/properties/MysqlObjectGrant;", "Lcom/intellij/database/model/properties/Grants$Grant;", "name", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "subs", "Ljava/util/BitSet;", "grantee", "host", "permission", "state", "Lcom/intellij/database/model/properties/Grants$State;", "<init>", "(Ljava/lang/String;Lcom/intellij/database/model/ObjectKind;Ljava/util/BitSet;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/database/model/properties/Grants$State;)V", "getKind", "()Lcom/intellij/database/model/ObjectKind;", "getName", "()Ljava/lang/String;", "getGrantee", "getHost", "copy", "equals", "", "other", "", "hashCode", "", "intellij.database.dialects.mysqlbase"})
public final class MysqlObjectGrant
extends Grants.Grant {
    @NotNull
    private final ObjectKind kind;
    @NotNull
    private final String name;
    @NotNull
    private final String grantee;
    @NotNull
    private final String host;

    public MysqlObjectGrant(@NotNull String name2, @NotNull ObjectKind kind, @Nullable BitSet subs, @NotNull String grantee, @NotNull String host, @NotNull String permission, @NotNull Grants.State state) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)grantee, (String)"grantee");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        super(subs, permission, state);
        this.kind = kind;
        String string = DbUtil.intern(name2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"intern(...)");
        this.name = string;
        String string2 = DbUtil.intern(grantee);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"intern(...)");
        this.grantee = string2;
        String string3 = DbUtil.intern(MysqlObjectGrantController.INSTANCE.normalizeHost(host));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"intern(...)");
        this.host = string3;
    }

    @NotNull
    public final ObjectKind getKind() {
        return this.kind;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getGrantee() {
        return this.grantee;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    @NotNull
    public final MysqlObjectGrant copy(@NotNull String name2, @NotNull ObjectKind kind, @Nullable BitSet subs, @NotNull String grantee, @NotNull String host, @NotNull String permission, @NotNull Grants.State state) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)grantee, (String)"grantee");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        return new MysqlObjectGrant(name2, kind, subs, grantee, host, permission, state);
    }

    public static /* synthetic */ MysqlObjectGrant copy$default(MysqlObjectGrant mysqlObjectGrant, String string, ObjectKind objectKind, BitSet bitSet, String string2, String string3, String string4, Grants.State state, int n, Object object) {
        if ((n & 1) != 0) {
            string = mysqlObjectGrant.name;
        }
        if ((n & 2) != 0) {
            objectKind = mysqlObjectGrant.kind;
        }
        if ((n & 4) != 0) {
            bitSet = mysqlObjectGrant.getSubs();
        }
        if ((n & 8) != 0) {
            string2 = mysqlObjectGrant.grantee;
        }
        if ((n & 0x10) != 0) {
            string3 = mysqlObjectGrant.host;
        }
        if ((n & 0x20) != 0) {
            string4 = mysqlObjectGrant.getPermission();
        }
        if ((n & 0x40) != 0) {
            state = mysqlObjectGrant.getState();
        }
        return mysqlObjectGrant.copy(string, objectKind, bitSet, string2, string3, string4, state);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof MysqlObjectGrant && super.equals(other) && Intrinsics.areEqual((Object)this.name, (Object)((MysqlObjectGrant)other).name) && Intrinsics.areEqual((Object)this.kind, (Object)((MysqlObjectGrant)other).kind) && Intrinsics.areEqual((Object)this.grantee, (Object)((MysqlObjectGrant)other).grantee) && Intrinsics.areEqual((Object)this.host, (Object)((MysqlObjectGrant)other).host);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.name.hashCode();
        result2 = 31 * result2 + this.kind.hashCode();
        result2 = 31 * result2 + this.grantee.hashCode();
        result2 = 31 * result2 + this.host.hashCode();
        return result2;
    }
}

