/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceBriefConfig;
import com.intellij.database.diagnostic.DataSourceDiagnosticRecorder;
import com.intellij.database.diagnostic.DiagnosticSectionReference;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.base.introspector.IntrospectionQueryContext;
import com.intellij.database.dialects.postgresbase.PgNoDatabaseXminOption;
import com.intellij.database.dialects.postgresbase.PgSystemSchemasOption;
import com.intellij.database.dialects.postgresbase.PgTemplateDatabaseOption;
import com.intellij.database.dialects.postgresbase.introspector.IntroStep;
import com.intellij.database.dialects.postgresbase.introspector.PgAclItem;
import com.intellij.database.dialects.postgresbase.introspector.PgBaseIntroQueries;
import com.intellij.database.dialects.postgresbase.introspector.PgBaseIntrospector$SchemaRetriever$retrieveConstraints$lambda$94$;
import com.intellij.database.dialects.postgresbase.introspector.PgBaseIntrospectorKt;
import com.intellij.database.dialects.postgresbase.model.PgBaseAggregate;
import com.intellij.database.dialects.postgresbase.model.PgBaseArgument;
import com.intellij.database.dialects.postgresbase.model.PgBaseCast;
import com.intellij.database.dialects.postgresbase.model.PgBaseCatalogObject;
import com.intellij.database.dialects.postgresbase.model.PgBaseDatabase;
import com.intellij.database.dialects.postgresbase.model.PgBaseDefType;
import com.intellij.database.dialects.postgresbase.model.PgBaseDefTypeAttribute;
import com.intellij.database.dialects.postgresbase.model.PgBaseForeignKey;
import com.intellij.database.dialects.postgresbase.model.PgBaseGrantsHolder;
import com.intellij.database.dialects.postgresbase.model.PgBaseKey;
import com.intellij.database.dialects.postgresbase.model.PgBaseLanguage;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeColumn;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeDatabase;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeSchema;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeStoredTable;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeTable;
import com.intellij.database.dialects.postgresbase.model.PgBaseMatView;
import com.intellij.database.dialects.postgresbase.model.PgBaseModelHelper;
import com.intellij.database.dialects.postgresbase.model.PgBaseObjectWithOwner;
import com.intellij.database.dialects.postgresbase.model.PgBaseOperator;
import com.intellij.database.dialects.postgresbase.model.PgBaseRegularTable;
import com.intellij.database.dialects.postgresbase.model.PgBaseRoot;
import com.intellij.database.dialects.postgresbase.model.PgBaseRoutine;
import com.intellij.database.dialects.postgresbase.model.PgBaseSchema;
import com.intellij.database.dialects.postgresbase.model.PgBaseSourceAware;
import com.intellij.database.dialects.postgresbase.model.PgBaseTable;
import com.intellij.database.dialects.postgresbase.model.PgBaseTableColumn;
import com.intellij.database.dialects.postgresbase.model.PgBaseView;
import com.intellij.database.dialects.postgresbase.model.properties.PgCastContext;
import com.intellij.database.dialects.postgresbase.model.properties.PgCastMethod;
import com.intellij.database.dialects.postgresbase.model.properties.PgDataTypeSubKind;
import com.intellij.database.dialects.postgresbase.model.properties.PgDateInputStyle;
import com.intellij.database.dialects.postgresbase.model.properties.PgObjectGrant;
import com.intellij.database.dialects.postgresbase.model.properties.PgObjectGrantController;
import com.intellij.database.dialects.postgresbase.model.properties.PgOperatorKind;
import com.intellij.database.dialects.postgresbase.model.properties.PgPrivilege;
import com.intellij.database.dialects.postgresbase.model.properties.PgRoutineKind;
import com.intellij.database.dialects.postgresbase.model.properties.PgTimeZone;
import com.intellij.database.dialects.postgresbase.model.properties.PgVolatilityKind;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.IntrospectionMode;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicMixinElement;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModArrangedElement;
import com.intellij.database.model.basic.BasicModColumniation;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModKey;
import com.intellij.database.model.basic.BasicModLikeTable;
import com.intellij.database.model.basic.BasicModMateDatabase;
import com.intellij.database.model.basic.BasicModMixinElement;
import com.intellij.database.model.basic.BasicModMixinNamedElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModMultiDatabaseRoot;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModTypedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.PositioningFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.meta.BasicResolveAssistant;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.Grants;
import com.intellij.database.model.properties.references.BasicByColumnPositionsReference;
import com.intellij.database.model.properties.references.BasicIdOrNameReference;
import com.intellij.database.model.properties.references.BasicIdReference;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.model.properties.references.BasicParentReference;
import com.intellij.database.remote.jdba.exceptions.DBException;
import com.intellij.database.remote.jdba.sql.Rewriters;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.common.StringFun;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ArrayListSet;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.StringKt;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0090\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u0000 \u008a\u0001*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u00062\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00050\u0007:\b\u008a\u0001\u008b\u0001\u008c\u0001\u008d\u0001B'\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J$\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u0001002\u0006\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u000105H\u0016J\b\u00106\u001a\u000207H\u0014J\n\u00108\u001a\u0004\u0018\u000109H\u0002J\u0010\u0010:\u001a\u0002072\u0006\u0010;\u001a\u00020<H\u0014J\u001d\u0010=\u001a\u0002072\u0006\u0010;\u001a\u00020<2\u0006\u0010>\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010?J\u0010\u0010@\u001a\u0002072\u0006\u0010;\u001a\u00020<H\u0014J\b\u0010A\u001a\u00020BH\u0002J\b\u0010C\u001a\u00020$H\u0014J$\u0010D\u001a\u000207*\u00020E2\u0006\u0010F\u001a\u00020\u00142\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020HH\u0002J\u0010\u0010J\u001a\u00020H2\u0006\u0010K\u001a\u00020HH\u0002J\u0010\u0010L\u001a\u00020H2\u0006\u0010G\u001a\u00020HH&J \u0010M\u001a\u0002072\u0006\u0010N\u001a\u00020<2\u0006\u0010O\u001a\u00020$2\u0006\u0010P\u001a\u00020$H\u0002J\u0016\u0010Q\u001a\b\u0012\u0004\u0012\u00020S0R2\u0006\u0010N\u001a\u00020<H\u0014J \u0010T\u001a\u0002072\u0006\u0010;\u001a\u00020<2\u0006\u0010O\u001a\u00020$2\u0006\u0010P\u001a\u00020$H\u0002J \u0010U\u001a\u0002072\u0006\u0010N\u001a\u00020<2\u0006\u0010O\u001a\u00020$2\u0006\u0010P\u001a\u00020$H\u0014J\u0010\u0010V\u001a\u0002072\u0006\u0010W\u001a\u00020<H\u0014J\u0010\u0010X\u001a\u0002072\u0006\u0010W\u001a\u00020<H\u0014J\u0014\u0010Y\u001a\u0004\u0018\u00010Z2\b\u0010[\u001a\u0004\u0018\u00010HH\u0002J!\u0010\\\u001a\u0002072\u0012\u0010]\u001a\n\u0012\u0006\b\u0001\u0012\u0002090^\"\u000209H\u0016\u00a2\u0006\u0002\u0010_J&\u0010`\u001a\b\u0012\u0004\u0012\u00028\u00010a2\u0006\u0010;\u001a\u00020<2\u000e\u0010b\u001a\n\u0012\u0004\u0012\u00020d\u0018\u00010cH\u0014J\"\u0010e\u001a\u000e\u0012\u0004\u0012\u00020g\u0012\u0004\u0012\u00020$0f2\f\u0010h\u001a\b\u0012\u0004\u0012\u00020g0aH\u0014J,\u0010i\u001a\u0002072\u0006\u0010j\u001a\u00020H2\f\u0010k\u001a\b\u0012\u0004\u0012\u00020H0l2\f\u0010m\u001a\b\u0012\u0004\u0012\u00020o0nH\u0004J\u0017\u0010p\u001a\u0004\u0018\u00010\u00142\u0006\u0010;\u001a\u00020<H\u0002\u00a2\u0006\u0002\u0010qJ\b\u0010r\u001a\u00020$H\u0014J\"\u0010s\u001a\u0004\u0018\u00010t2\u0006\u0010u\u001a\u00020v2\u0006\u0010w\u001a\u00020x2\u0006\u0010y\u001a\u00020HH\u0014J\u0010\u0010z\u001a\u00020$2\u0006\u0010{\u001a\u00020|H\u0014J*\u0010}\u001a\u00020H2\b\u0010~\u001a\u0004\u0018\u00010H2\u0006\u0010\u007f\u001a\u00020$2\u000e\u0010\u0080\u0001\u001a\t\u0012\u0004\u0012\u00020H0\u0081\u0001H\u0004J\u0014\u0010\u0082\u0001\u001a\u00020$2\t\u0010\u0083\u0001\u001a\u0004\u0018\u00010HH\u0004J)\u0010\u0084\u0001\u001a\u0005\u0018\u00010\u0085\u00012\u0007\u0010\u0086\u0001\u001a\u00020\u00142\t\u0010\u0087\u0001\u001a\u0004\u0018\u00010H2\t\u0010\u0088\u0001\u001a\u0004\u0018\u00010HJ\u001b\u0010\u0089\u0001\u001a\u0005\u0018\u00010\u0085\u0001*\u00020H2\t\u0010\u0088\u0001\u001a\u0004\u0018\u00010HH\u0002R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00020\u0016X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0012\u0010\u0019\u001a\u00020\u001aX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001d\u001a\u0004\u0018\u00010\u0014X\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\"\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010#\u001a\u00020$X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020$X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010&\"\u0004\b+\u0010(R\u001a\u0010,\u001a\u00020$X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010&\"\u0004\b.\u0010(\u00a8\u0006\u008e\u0001"}, d2={"Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector;", "MR", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseRoot;", "D", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeDatabase;", "S", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "nature", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$Nature;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "<init>", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$Nature;Lcom/intellij/database/Dbms;Lcom/intellij/database/model/ModelFactory;)V", "affectedKeySchemaIds", "Lcom/intellij/util/containers/ArrayListSet;", "", "helper", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseModelHelper;", "getHelper", "()Lcom/intellij/database/dialects/postgresbase/model/PgBaseModelHelper;", "queries", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries;", "getQueries", "()Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries;", "introspectionXid", "getIntrospectionXid", "()Ljava/lang/Long;", "setIntrospectionXid", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "showTemplateDbs", "", "getShowTemplateDbs", "()Z", "setShowTemplateDbs", "(Z)V", "showSystemScs", "getShowSystemScs", "setShowSystemScs", "noDbXmin", "getNoDbXmin", "setNoDbXmin", "init", "Lcom/intellij/database/model/basic/BasicModModel;", "model", "dsConfig", "Lcom/intellij/database/dataSource/DataSourceBriefConfig;", "introspectionScope", "Lcom/intellij/database/util/TreePattern;", "introspectSpecificSessionInfo", "", "connectionDatabase", "Lcom/intellij/database/model/basic/BasicDatabase;", "introspectPreDatabaseObjects", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "postProcessDatabase", "database", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeDatabase;)V", "introspectAllServerObjects", "getServerIntrospectionMode", "Lcom/intellij/database/introspection/IntrospectionMode;", "loadNewServerObjects", "setTx", "Lcom/intellij/database/dialects/base/introspector/IntrospectionQueryContext;", "stateNumber", "tx", "", "txage", "mapNegativeAgeToMax", "age", "generateDbAge", "introspectServerObjects", "trans", "detectDropped", "loadNew", "steps", "", "Lcom/intellij/database/dialects/postgresbase/introspector/IntroStep;", "retrieveAcls", "retrieveComments", "retrieveSettings", "transaction", "retrieveTimeZones", "parseDateStyle", "Lcom/intellij/database/dialects/postgresbase/model/properties/PgDateInputStyle;", "s", "introspectDatabaseSchemas", "databases", "", "([Lcom/intellij/database/model/basic/BasicDatabase;)V", "getDatabasesToIntrospect", "", "namespaces", "", "Lcom/intellij/database/model/basic/BasicNamespace;", "checkElementsUptodate", "", "Lcom/intellij/database/model/basic/BasicElement;", "elements", "freezeOnWrapAround", "param", "memory", "", "ageComputable", "Lkotlin/Function0;", "", "getCurrentXid", "(Lcom/intellij/database/layoutedQueries/DBTransaction;)Ljava/lang/Long;", "isItPossibleToRetrieveCurrentXid", "parseAclItem", "Lcom/intellij/database/dialects/postgresbase/introspector/PgAclItem;", "lex", "Lcom/intellij/lexer/Lexer;", "ns", "Lcom/intellij/database/script/generator/NamingService;", "item", "isNameSurrogate", "columniation", "Lcom/intellij/database/model/basic/BasicModColumniation;", "surrogateKeyName", "tableName", "primary", "colNames", "", "isColumnNameSurrogate", "it", "createIdOrQNameRef", "Lcom/intellij/database/model/properties/BasicReference;", "id", "name", "pDefault", "parseNameRef", "Companion", "DatabaseRetriever", "NativeRetriever", "SchemaRetriever", "intellij.database.dialects.postgresbase"})
@SourceDebugExtension(value={"SMAP\nPgBaseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PgBaseIntrospector.kt\ncom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector\n+ 2 DataSourceBriefConfig.kt\ncom/intellij/database/dataSource/DataSourceBriefConfigs\n+ 3 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 8 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1636:1\n41#2,2:1637\n39#2:1639\n41#2,2:1640\n39#2:1642\n41#2,2:1643\n39#2:1645\n466#3,7:1646\n466#3,7:1653\n466#3,2:1660\n469#3,4:1667\n466#3,7:1716\n1628#4,3:1662\n1010#4,2:1665\n1755#4,3:1673\n1734#4,3:1676\n1863#4,2:1679\n1863#4,2:1681\n1216#4,2:1727\n1246#4,4:1729\n1863#4,2:1733\n37#5,2:1671\n37#5,2:1723\n1#6:1683\n1#6:1697\n1#6:1713\n995#7,11:1684\n1188#7,2:1695\n1190#7:1698\n1006#7:1699\n995#7,11:1700\n1188#7,2:1711\n1190#7:1714\n1006#7:1715\n13409#8,2:1725\n*S KotlinDebug\n*F\n+ 1 PgBaseIntrospector.kt\ncom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector\n*L\n80#1:1637,2\n80#1:1639\n81#1:1640,2\n81#1:1642\n82#1:1643,2\n82#1:1645\n181#1:1646,7\n207#1:1653,7\n214#1:1660,2\n214#1:1667,4\n90#1:1716,7\n216#1:1662,3\n219#1:1665,2\n254#1:1673,3\n257#1:1676,3\n266#1:1679,2\n277#1:1681,2\n228#1:1727,2\n228#1:1729,4\n282#1:1733,2\n249#1:1671,2\n114#1:1723,2\n512#1:1697\n515#1:1713\n512#1:1684,11\n512#1:1695,2\n512#1:1698\n512#1:1699\n515#1:1700,11\n515#1:1711,2\n515#1:1714\n515#1:1715\n193#1:1725,2\n*E\n"})
public abstract class PgBaseIntrospector<MR extends PgBaseRoot, D extends PgBaseLikeDatabase, S extends PgBaseLikeSchema>
extends BaseMultiDatabaseIntrospector<MR, D, S> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ArrayListSet<Long> affectedKeySchemaIds;
    @Nullable
    private Long introspectionXid;
    private boolean showTemplateDbs;
    private boolean showSystemScs;
    private boolean noDbXmin;
    @Deprecated
    public static final int FROZEN_TXID = 2;

    public PgBaseIntrospector(@NotNull DBIntrospectionContext context, @NotNull BaseIntrospector.Nature nature, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)nature, (String)"nature");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        super(context, nature, dbms, modelFactory);
        this.affectedKeySchemaIds = new ArrayListSet();
    }

    @NotNull
    protected abstract PgBaseModelHelper getHelper();

    @NotNull
    protected abstract PgBaseIntroQueries getQueries();

    @Nullable
    protected final Long getIntrospectionXid() {
        return this.introspectionXid;
    }

    protected final void setIntrospectionXid(@Nullable Long l) {
        this.introspectionXid = l;
    }

    protected final boolean getShowTemplateDbs() {
        return this.showTemplateDbs;
    }

    protected final void setShowTemplateDbs(boolean bl) {
        this.showTemplateDbs = bl;
    }

    protected final boolean getShowSystemScs() {
        return this.showSystemScs;
    }

    protected final void setShowSystemScs(boolean bl) {
        this.showSystemScs = bl;
    }

    protected final boolean getNoDbXmin() {
        return this.noDbXmin;
    }

    protected final void setNoDbXmin(boolean bl) {
        this.noDbXmin = bl;
    }

    @Override
    @NotNull
    public BasicModModel init(@Nullable BasicModModel model, @NotNull DataSourceBriefConfig dsConfig, @Nullable TreePattern introspectionScope) {
        Intrinsics.checkNotNullParameter((Object)dsConfig, (String)"dsConfig");
        DataSourceBriefConfig $this$getBooleanOptionValue_u24default$iv = dsConfig;
        boolean default$iv = false;
        boolean $i$f$getBooleanOptionValue = false;
        DataSourceBriefConfig $this$getOptionValue$iv$iv = $this$getBooleanOptionValue_u24default$iv;
        boolean $i$f$getOptionValue = false;
        Boolean bl = (Boolean)$this$getOptionValue$iv$iv.getProvidedOptionValue(PgTemplateDatabaseOption.class);
        this.showTemplateDbs = bl != null ? bl : default$iv;
        $this$getBooleanOptionValue_u24default$iv = dsConfig;
        default$iv = false;
        $i$f$getBooleanOptionValue = false;
        $this$getOptionValue$iv$iv = $this$getBooleanOptionValue_u24default$iv;
        $i$f$getOptionValue = false;
        Boolean bl2 = (Boolean)$this$getOptionValue$iv$iv.getProvidedOptionValue(PgSystemSchemasOption.class);
        this.showSystemScs = bl2 != null ? bl2 : default$iv;
        $this$getBooleanOptionValue_u24default$iv = dsConfig;
        default$iv = false;
        $i$f$getBooleanOptionValue = false;
        $this$getOptionValue$iv$iv = $this$getBooleanOptionValue_u24default$iv;
        $i$f$getOptionValue = false;
        Boolean bl3 = (Boolean)$this$getOptionValue$iv$iv.getProvidedOptionValue(PgNoDatabaseXminOption.class);
        this.noDbXmin = bl3 != null ? bl3 : default$iv;
        return super.init(model, dsConfig, introspectionScope);
    }

    @Override
    protected void introspectSpecificSessionInfo() {
        super.introspectSpecificSessionInfo();
        this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)arg_0 -> PgBaseIntrospector.introspectSpecificSessionInfo$lambda$1(this, arg_0)));
    }

    private final BasicDatabase connectionDatabase() {
        String databaseName = this.getDbConnectionInfo().databaseName;
        return databaseName == null ? null : (BasicDatabase)((BasicModMultiDatabaseRoot)this.getRoot()).findDatabaseByName(databaseName);
    }

    @Override
    protected void introspectPreDatabaseObjects(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        super.introspectPreDatabaseObjects(tran);
        this.introspectServerObjectsInTran(tran);
    }

    @Override
    protected void postProcessDatabase(@NotNull DBTransaction tran, @NotNull D database) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        Intrinsics.checkNotNullParameter(database, (String)"database");
        this.handleErrors("Detect and handle cross-schema foreign keys", (Function0<Unit>)((Function0)() -> PgBaseIntrospector.postProcessDatabase$lambda$2(this, tran, database)));
    }

    @Override
    protected void introspectAllServerObjects(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        IntrospectionMode mode = this.getServerIntrospectionMode();
        long stateNumber = mode.increment ? ((PgBaseRoot)this.getRoot()).getIntrospectionStateNumber() : 0L;
        boolean detectDropped = mode.increment;
        boolean loadNew = mode.full || this.loadNewServerObjects();
        this.setTx(this, stateNumber, "tx", "TXAGE");
        String string = IntrospectionMode.INCREMENT.code;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"code");
        this.setQueryParameter(string, mode.increment);
        this.introspectServerObjects(tran, detectDropped, loadNew);
    }

    private final IntrospectionMode getServerIntrospectionMode() {
        return ((PgBaseRoot)this.getRoot()).getIntrospectionStateNumber() != 0L && !this.getForbidIncremental() ? IntrospectionMode.INCREMENT : IntrospectionMode.FULL;
    }

    protected boolean loadNewServerObjects() {
        Long l = this.introspectionXid;
        long l2 = ((PgBaseRoot)this.getRoot()).getIntrospectionStateNumber();
        return l == null || l != l2;
    }

    private final void setTx(IntrospectionQueryContext $this$setTx, long stateNumber, String tx, String txage) {
        $this$setTx.setQueryParameter(tx, stateNumber);
        $this$setTx.setQueryParameter(txage, this.mapNegativeAgeToMax(this.generateDbAge(":" + tx)));
    }

    private final String mapNegativeAgeToMax(String age) {
        return "coalesce(nullif(greatest(" + age + ", -1), -1), 2147483647)";
    }

    @NotNull
    public abstract String generateDbAge(@NotNull String var1);

    private final void introspectServerObjects(DBTransaction trans, boolean detectDropped, boolean loadNew) {
        block1: {
            List<IntroStep> steps = this.steps(trans);
            CollectionsKt.sort(steps);
            for (IntroStep step2 : steps) {
                step2.getPerform().invoke((Object)detectDropped, (Object)loadNew);
            }
            Long l = this.introspectionXid;
            if (l == null) break block1;
            long xid = ((Number)l).longValue();
            boolean bl = false;
            this.inModel(arg_0 -> PgBaseIntrospector.introspectServerObjects$lambda$4$lambda$3(xid, arg_0));
        }
    }

    @NotNull
    protected List<IntroStep> steps(@NotNull DBTransaction trans) {
        Intrinsics.checkNotNullParameter((Object)trans, (String)"trans");
        return PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(new ArrayList(), 20, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)(arg_0, arg_1) -> PgBaseIntrospector.steps$lambda$5(this, trans, arg_0, arg_1))), 30, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)(arg_0, arg_1) -> PgBaseIntrospector.steps$lambda$6(this, trans, arg_0, arg_1))), 40, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)(arg_0, arg_1) -> PgBaseIntrospector.steps$lambda$7(this, trans, arg_0, arg_1))), 100, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)(arg_0, arg_1) -> PgBaseIntrospector.steps$lambda$8(this, trans, arg_0, arg_1)));
    }

    private final void retrieveAcls(DBTransaction tran, boolean detectDropped, boolean loadNew) {
        this.reportRetrieving("ACL", "introspection.retrieve.ACL");
        BaseNativeIntrospector this_$iv = this;
        boolean $i$f$continueOnDbError = false;
        try {
            boolean bl = false;
            this.inModel(arg_0 -> PgBaseIntrospector.retrieveAcls$lambda$15$lambda$14(detectDropped, loadNew, this, tran, arg_0));
        }
        catch (DBException e$iv) {
            this_$iv.getErrorSink().accept(null, e$iv);
        }
    }

    protected void retrieveComments(@NotNull DBTransaction trans, boolean detectDropped, boolean loadNew) {
        Intrinsics.checkNotNullParameter((Object)trans, (String)"trans");
    }

    protected void retrieveSettings(@NotNull DBTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        BaseNativeIntrospector this_$iv = this;
        boolean $i$f$continueOnDbError = false;
        try {
            boolean bl = false;
            String dateStyle = this.performQuery(transaction, this.getQueries().getRetrieveDateStyle());
            this.inModel(arg_0 -> PgBaseIntrospector.retrieveSettings$lambda$17$lambda$16(this, dateStyle, arg_0));
        }
        catch (DBException e$iv) {
            this_$iv.getErrorSink().accept(null, e$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void retrieveTimeZones(@NotNull DBTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        BaseNativeIntrospector this_$iv = this;
        boolean $i$f$continueOnDbError = false;
        try {
            Iterable iterable;
            boolean bl = false;
            try {
                void $this$mapTo$iv;
                List<PgBaseIntroQueries.OneTimeZone> list = this.performQuery(transaction, this.getQueries().getRetrieveTimeZones());
                Intrinsics.checkNotNullExpressionValue(list, (String)"performQuery(...)");
                iterable = list;
                Collection destination$iv = new ArrayList();
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    PgBaseIntroQueries.OneTimeZone oneTimeZone = (PgBaseIntroQueries.OneTimeZone)item$iv;
                    Collection collection = destination$iv;
                    boolean bl2 = false;
                    collection.add(new PgTimeZone(it.name, it.is_dst));
                }
                iterable = destination$iv;
                ArrayList $this$retrieveTimeZones_u24lambda_u2424_u24lambda_u2420 = (ArrayList)iterable;
                boolean bl3 = false;
                List $this$sortBy$iv = $this$retrieveTimeZones_u24lambda_u2424_u24lambda_u2420;
                boolean $i$f$sortBy = false;
                if ($this$sortBy$iv.size() > 1) {
                    CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            PgTimeZone it = (PgTimeZone)a;
                            boolean bl = false;
                            Comparable comparable = (Comparable)((Object)it.getName());
                            it = (PgTimeZone)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                        }
                    });
                }
                iterable = (List)iterable;
            }
            catch (Exception e) {
                int[] nArray = new int[]{10};
                if (this.getServerVersion().isOrGreater(nArray)) {
                    throw e;
                }
                this.log.warn((Throwable)e);
                iterable = CollectionsKt.emptyList();
            }
            Iterable zones = iterable;
            this.inModel(arg_0 -> PgBaseIntrospector.retrieveTimeZones$lambda$24$lambda$23((List)zones, arg_0));
        }
        catch (DBException e$iv) {
            this_$iv.getErrorSink().accept(null, e$iv);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final PgDateInputStyle parseDateStyle(String s) {
        if (s == null) {
            return null;
        }
        int i2 = StringsKt.indexOf$default((CharSequence)s, (String)",", (int)0, (boolean)false, (int)6, null);
        if (i2 < 0) {
            return null;
        }
        String string = s.substring(i2 + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String string2 = StringUtil.toUpperCase((String)((Object)StringsKt.trim((CharSequence)string)).toString());
        if (string2 == null) return null;
        int n = -1;
        switch (string2.hashCode()) {
            case 67824: {
                if (string2.equals("DMY")) {
                    n = 1;
                }
                break;
            }
            case 87984: {
                if (string2.equals("YMD")) {
                    n = 2;
                }
                break;
            }
            case 76194: {
                if (string2.equals("MDY")) {
                    n = 3;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                PgDateInputStyle pgDateInputStyle = PgDateInputStyle.DMY;
                return pgDateInputStyle;
            }
            case 3: {
                PgDateInputStyle pgDateInputStyle = PgDateInputStyle.MDY;
                return pgDateInputStyle;
            }
            case 2: {
                PgDateInputStyle pgDateInputStyle = PgDateInputStyle.YMD;
                return pgDateInputStyle;
            }
            default: {
                return null;
            }
        }
    }

    @Override
    public void introspectDatabaseSchemas(BasicDatabase ... databases) {
        Intrinsics.checkNotNullParameter((Object)databases, (String)"databases");
        Iterable dbs2 = (Iterable)this.inTransaction(arg_0 -> PgBaseIntrospector.introspectDatabaseSchemas$lambda$25(this, databases, arg_0));
        Collection $this$toTypedArray$iv = CollectionsKt.toList((Iterable)dbs2);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        BasicDatabase[] basicDatabaseArray = thisCollection$iv.toArray(new BasicDatabase[0]);
        super.introspectDatabaseSchemas(Arrays.copyOf(basicDatabaseArray, basicDatabaseArray.length));
    }

    @Override
    @NotNull
    protected Iterable<D> getDatabasesToIntrospect(@NotNull DBTransaction tran, @Nullable Collection<? extends BasicNamespace> namespaces2) {
        BasicDatabase connectionDatabase;
        block20: {
            block19: {
                boolean bl;
                block16: {
                    List databases;
                    List list;
                    block18: {
                        block17: {
                            boolean bl2;
                            block15: {
                                Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
                                List list2 = namespaces2;
                                if (list2 == null || list2.isEmpty()) break block17;
                                Iterable $this$any$iv = namespaces2;
                                boolean $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl2 = false;
                                } else {
                                    for (Object element$iv : $this$any$iv) {
                                        BasicNamespace it = (BasicNamespace)element$iv;
                                        boolean bl3 = false;
                                        if (!(it instanceof PgBaseDatabase)) continue;
                                        bl2 = true;
                                        break block15;
                                    }
                                    bl2 = false;
                                }
                            }
                            if (!bl2) break block18;
                        }
                        this.introspectNamespacesInTran(tran);
                    }
                    if ((list = namespaces2) == null || (list = CollectionsKt.filterIsInstance((Iterable)list, PgBaseDatabase.class)) == null) {
                        list = databases = CollectionsKt.emptyList();
                    }
                    if ((connectionDatabase = this.connectionDatabase()) == null) break block19;
                    if (!(!((Collection)databases).isEmpty())) break block20;
                    Iterable $this$all$iv = databases;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            PgBaseDatabase it = (PgBaseDatabase)element$iv;
                            boolean bl4 = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)connectionDatabase.getName())) continue;
                            bl = false;
                            break block16;
                        }
                        bl = true;
                    }
                }
                if (!bl) break block20;
            }
            JBIterable jBIterable = JBIterable.empty();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
            return (Iterable)jBIterable;
        }
        JBIterable jBIterable = JBIterable.of((Object)((PgBaseLikeDatabase)connectionDatabase));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"of(...)");
        return (Iterable)jBIterable;
    }

    @Override
    @NotNull
    protected Map<BasicElement, Boolean> checkElementsUptodate(@NotNull Iterable<? extends BasicElement> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        BasicElement basicElement = (BasicElement)CollectionsKt.firstOrNull(elements);
        if (basicElement == null || (basicElement = basicElement.getDatabase()) == null) {
            return MapsKt.emptyMap();
        }
        BasicElement database = basicElement;
        LinkedHashMap<Object, Object> ids = new LinkedHashMap<Object, Object>();
        Iterable<? extends BasicElement> $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        Iterator<? extends BasicElement> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            BasicElement element$iv;
            BasicElement it = element$iv = iterator.next();
            boolean bl = false;
            if (!PgBaseIntrospectorKt.canCheckOutdated(it)) continue;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.database.dialects.postgresbase.model.PgBaseCatalogObject");
            PgBaseCatalogObject cfr_ignored_0 = (PgBaseCatalogObject)it;
            if (!Intrinsics.areEqual((Object)database, (Object)((PgBaseCatalogObject)it).getDatabase())) {
                this.log.error("Element from different database");
            }
            ((Map)ids).put(((PgBaseCatalogObject)it).getObjectId(), it);
        }
        if (ids.isEmpty()) {
            return MapsKt.emptyMap();
        }
        BaseNativeIntrospector baseNativeIntrospector = this;
        SqlQuery sqlQuery = this.getQueries().getRetrieveStates().rewrite(arg_0 -> PgBaseIntrospector.checkElementsUptodate$lambda$30(ids, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)sqlQuery, (String)"rewrite(...)");
        List states = (List)BaseNativeIntrospector.performQuery$default(baseNativeIntrospector, sqlQuery, null, 2, null);
        LinkedHashMap res2 = new LinkedHashMap();
        ids.forEach((arg_0, arg_1) -> PgBaseIntrospector.checkElementsUptodate$lambda$32((arg_0, arg_1) -> PgBaseIntrospector.checkElementsUptodate$lambda$31(res2, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNull((Object)states);
        Iterable $this$forEach$iv2 = states;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            PgBaseCatalogObject obj2;
            PgBaseIntroQueries.OneState s = (PgBaseIntroQueries.OneState)element$iv;
            boolean bl = false;
            if ((PgBaseCatalogObject)ids.get(s.oid) == null) continue;
            ((Map)res2).put(obj2, obj2.getStateNumber() == s.xmin);
        }
        this.inModel(arg_0 -> PgBaseIntrospector.checkElementsUptodate$lambda$35(res2, arg_0));
        return res2;
    }

    protected final void freezeOnWrapAround(@NotNull String param, @NotNull Set<String> memory, @NotNull Function0<Integer> ageComputable) {
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        Intrinsics.checkNotNullParameter(memory, (String)"memory");
        Intrinsics.checkNotNullParameter(ageComputable, (String)"ageComputable");
        if (memory.contains(param)) {
            return;
        }
        int age = ((Number)ageComputable.invoke()).intValue();
        if (age >= 0 && age != Integer.MAX_VALUE) {
            return;
        }
        this.setQueryParameter(param, 2);
        ((Collection)memory).add(param);
    }

    private final Long getCurrentXid(DBTransaction tran) {
        return this.isItPossibleToRetrieveCurrentXid() ? this.performQuery(tran, this.getQueries().currentXid) : null;
    }

    protected boolean isItPossibleToRetrieveCurrentXid() {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    protected PgAclItem parseAclItem(@NotNull Lexer lex, @NotNull NamingService ns, @NotNull String item) {
        Intrinsics.checkNotNullParameter((Object)lex, (String)"lex");
        Intrinsics.checkNotNullParameter((Object)ns, (String)"ns");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        gp = "group ";
        isGroup = StringsKt.startsWith$default((String)item, (String)gp, (boolean)false, (int)2, null);
        v0 = so = isGroup != false ? gp.length() : 0;
        if (StringsKt.startsWith$default((CharSequence)item, (char)'=', (boolean)false, (int)2, null)) {
            v1 = 0;
        } else {
            lex.start((CharSequence)item, so, item.length());
            var9_7 = lex.getTokenEnd();
            it = ((Number)var9_7).intValue();
            $i$a$-takeIf-PgBaseIntrospector$parseAclItem$eq$1 = false;
            v1 = item.charAt(it) == '=' != false ? var9_7 : null;
            if (v1 == null) {
                var9_7 = StringsKt.indexOf$default((CharSequence)item, (char)'=', (int)0, (boolean)false, (int)6, null);
                it = ((Number)var9_7).intValue();
                $i$a$-takeIf-PgBaseIntrospector$parseAclItem$eq$2 = false;
                v1 = eq = it != -1 != false ? var9_7 : null;
            }
        }
        if (eq == null) {
            return null;
        }
        it = StringsKt.indexOf$default((CharSequence)item, (char)'/', (int)eq, (boolean)false, (int)4, null);
        it = ((Number)it).intValue();
        $i$a$-takeIf-PgBaseIntrospector$parseAclItem$sl$1 = 0;
        v2 = it != -1 != false ? it : null;
        sl = v2 != null ? v2.intValue() : item.length();
        $i$a$-takeIf-PgBaseIntrospector$parseAclItem$sl$1 = eq;
        v3 = item.substring(so, $i$a$-takeIf-PgBaseIntrospector$parseAclItem$sl$1);
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"substring(...)");
        it = v3;
        $i$a$-let-PgBaseIntrospector$parseAclItem$grantee$1 = false;
        it = StringsKt.startsWith$default((CharSequence)it, (char)'\\', (boolean)false, (int)2, null) ? StringUtil.unescapeStringCharacters((String)it) : it;
        $i$a$-let-PgBaseIntrospector$parseAclItem$grantee$2 = false;
        Intrinsics.checkNotNull((Object)it);
        v4 = StringKt.nullize$default((String)ns.unquoteIdentifier(it), (boolean)false, (int)1, null);
        if (v4 == null) {
            v4 = "public";
        }
        grantee = v4;
        v5 = this.getModel().getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getRoot(...)");
        v6 = PgObjectGrantController.INSTANCE.findGranteeId(v5, grantee);
        granteeId = v6 != null ? v6 : -9223372036854775807L;
        v7 = item.substring(eq + 1, sl);
        Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"substring(...)");
        privilegesText = v7;
        $this$mapIndexedNotNull$iv = privilegesText;
        $i$f$mapIndexedNotNull = false;
        var16_21 = $this$mapIndexedNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapIndexedNotNullTo = false;
        $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        $i$f$forEachIndexed = false;
        index$iv$iv$iv = 0;
        for (var22_31 = 0; var22_31 < $this$forEachIndexed$iv$iv$iv.length(); ++var22_31) {
            block13: {
                item$iv$iv$iv = $this$forEachIndexed$iv$iv$iv.charAt(var22_31);
                v8 = index$iv$iv$iv++;
                var24_33 = item$iv$iv$iv;
                index$iv$iv = v8;
                $i$a$-forEachIndexed-StringsKt___StringsKt$mapIndexedNotNullTo$1$iv$iv = false;
                var27_36 = element$iv$iv;
                i = index$iv$iv;
                $i$a$-mapIndexedNotNull-PgBaseIntrospector$parseAclItem$privileges$1 = false;
                if (c == 42) ** GOTO lbl-1000
                v9 = StringsKt.getOrNull((CharSequence)privilegesText, (int)(i + 1));
                var30_39 = '*';
                if (v9 != null && v9.charValue() == var30_39) lbl-1000:
                // 2 sources

                {
                    v10 = null;
                } else {
                    var31_40 = PgPrivilege.values();
                    var33_45 = var31_40.length;
                    for (var32_42 = 0; var32_42 < var33_45; ++var32_42) {
                        it = var34_46 = var31_40[var32_42];
                        $i$a$-find-PgBaseIntrospector$parseAclItem$privileges$1$1 = false;
                        if (!(it.getCode() == c)) continue;
                        v10 = var34_46;
                        break block13;
                    }
                    v10 = null;
                }
            }
            if (v10 == null) continue;
            it$iv$iv = v10;
            $i$a$-let-StringsKt___StringsKt$mapIndexedNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        privileges = (List)destination$iv$iv;
        $this$mapIndexedNotNull$iv = privilegesText;
        $i$f$mapIndexedNotNull = false;
        destination$iv$iv = $this$mapIndexedNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapIndexedNotNullTo = false;
        $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        $i$f$forEachIndexed = false;
        index$iv$iv$iv = 0;
        for (var23_32 = 0; var23_32 < $this$forEachIndexed$iv$iv$iv.length(); ++var23_32) {
            block14: {
                item$iv$iv$iv = $this$forEachIndexed$iv$iv$iv.charAt(var23_32);
                v11 = index$iv$iv$iv++;
                index$iv$iv = item$iv$iv$iv;
                index$iv$iv = v11;
                $i$a$-forEachIndexed-StringsKt___StringsKt$mapIndexedNotNullTo$1$iv$iv = false;
                i = element$iv$iv;
                i = index$iv$iv;
                $i$a$-mapIndexedNotNull-PgBaseIntrospector$parseAclItem$grantablePrivileges$1 = false;
                if (c == 42) ** GOTO lbl-1000
                v12 = StringsKt.getOrNull((CharSequence)privilegesText, (int)(i + 1));
                var31_41 = '*';
                if (v12 == null || v12.charValue() != var31_41) lbl-1000:
                // 2 sources

                {
                    v13 = null;
                } else {
                    var32_44 = PgPrivilege.values();
                    var34_47 = var32_44.length;
                    for (var33_45 = 0; var33_45 < var34_47; ++var33_45) {
                        it = var35_48 = var32_44[var33_45];
                        $i$a$-find-PgBaseIntrospector$parseAclItem$grantablePrivileges$1$1 = false;
                        if (!(it.getCode() == c)) continue;
                        v13 = var35_48;
                        break block14;
                    }
                    v13 = null;
                }
            }
            if (v13 == null) continue;
            it$iv$iv = v13;
            $i$a$-let-StringsKt___StringsKt$mapIndexedNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        grantablePrivileges = (List)destination$iv$iv;
        return new PgAclItem(granteeId, privileges, grantablePrivileges);
    }

    protected boolean isNameSurrogate(@NotNull BasicModColumniation columniation) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)columniation, (String)"columniation");
        BasicModColumniation basicModColumniation = columniation;
        if (basicModColumniation instanceof PgBaseKey) {
            String string = ((PgBaseKey)columniation).getName();
            DasTable dasTable = ((PgBaseKey)columniation).getTable();
            String string2 = dasTable != null ? dasTable.getName() : null;
            boolean bl2 = ((PgBaseKey)columniation).isPrimary();
            List<String> list = ((PgBaseKey)columniation).getColNames();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getColNames(...)");
            bl = Intrinsics.areEqual((Object)string, (Object)this.surrogateKeyName(string2, bl2, list));
        } else if (basicModColumniation instanceof PgBaseForeignKey) {
            String string = ((PgBaseForeignKey)columniation).getName();
            DasTable dasTable = ((PgBaseForeignKey)columniation).getTable();
            String string3 = dasTable != null ? dasTable.getName() : null;
            List<String> list = ((PgBaseForeignKey)columniation).getColNames();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getColNames(...)");
            bl = Intrinsics.areEqual((Object)string, (Object)(string3 + "_" + CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"_", null, null, (int)0, null, null, (int)62, null) + "_fkey"));
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    protected final String surrogateKeyName(@Nullable String tableName, boolean primary, @NotNull List<String> colNames) {
        Intrinsics.checkNotNullParameter(colNames, (String)"colNames");
        return tableName + "_" + (String)(primary ? "pkey" : CollectionsKt.joinToString$default((Iterable)colNames, (CharSequence)"_", null, null, (int)0, null, null, (int)62, null) + "_key");
    }

    protected final boolean isColumnNameSurrogate(@Nullable String it) {
        return it != null && StringsKt.startsWith$default((String)it, (String)"?", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)it, (String)"?", (boolean)false, (int)2, null);
    }

    @Nullable
    public final BasicReference createIdOrQNameRef(long id, @Nullable String name2, @Nullable String pDefault) {
        String string = name2;
        return BasicIdOrNameReference.create(BasicIdReference.create(PgBaseIntrospectorKt.nullizeOid(id)), string != null ? this.parseNameRef(string, pDefault) : null);
    }

    private final BasicReference parseNameRef(String $this$parseNameRef, String pDefault) {
        NamingService ns = NamingServices.getNamingService$default(this.dbms, null, null, 6, null);
        Lexer lexer = this.getSqlHelper().createLexer();
        Pair<String, String> pair = BasicParentReference.parseNameRef($this$parseNameRef, ns, lexer);
        Intrinsics.checkNotNullExpressionValue(pair, (String)"parseNameRef(...)");
        Pair<String, String> p2 = pair;
        String string = (String)p2.first;
        if (string == null) {
            string = pDefault;
        }
        Object object = p2.second;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second");
        return BasicParentReference.create(string, BasicNameReference.create(ns.unquoteIdentifier((String)object)));
    }

    private static final Unit introspectSpecificSessionInfo$lambda$1(PgBaseIntrospector this$0, DBTransaction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.introspectionXid = null;
        BaseNativeIntrospector this_$iv = this$0;
        boolean $i$f$continueOnDbError = false;
        try {
            boolean bl = false;
            Long stateNumber = (Long)BaseNativeIntrospector.performQuery$default(this$0, this$0.getQueries().stateNumber, null, 2, null);
            Long l = stateNumber;
            if (l == null) {
                l = this$0.getCurrentXid(it);
            }
            this$0.introspectionXid = l;
        }
        catch (DBException e$iv) {
            this_$iv.getErrorSink().accept(null, e$iv);
        }
        return Unit.INSTANCE;
    }

    private static final Unit postProcessDatabase$lambda$2(PgBaseIntrospector this$0, DBTransaction $tran, PgBaseLikeDatabase $database) {
        if (!((Collection)this$0.affectedKeySchemaIds).isEmpty()) {
            String signs = StringFun.replicate("?", this$0.affectedKeySchemaIds.size(), ",", "null");
            SqlQuery sqlQuery = this$0.getQueries().getListReferencingSchemas().rewrite(Rewriters.replace((String)"SCHEMAIDS", (String)signs));
            Intrinsics.checkNotNullExpressionValue((Object)sqlQuery, (String)"rewrite(...)");
            SqlQuery query = sqlQuery;
            Collection $this$toTypedArray$iv = (Collection)this$0.affectedKeySchemaIds;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Long[] longArray = thisCollection$iv.toArray(new Long[0]);
            long[] referencingSchemaIds = (long[])$tran.query(query).withParams(Arrays.copyOf(longArray, longArray.length)).runOnce();
            Intrinsics.checkNotNull((Object)referencingSchemaIds);
            if (referencingSchemaIds.length == 0) {
                return Unit.INSTANCE;
            }
            this$0.getModel().modify((BasicElement)$database, PgBaseDatabase.class, new ModelModifier(referencingSchemaIds, this$0){
                final /* synthetic */ long[] $referencingSchemaIds;
                final /* synthetic */ PgBaseIntrospector<MR, D, S> this$0;
                {
                    this.$referencingSchemaIds = $referencingSchemaIds;
                    this.this$0 = $receiver;
                }

                public final void perform(PgBaseDatabase database) {
                    for (PgBaseSchema schema : database.getSchemas()) {
                        Object object = this.$referencingSchemaIds;
                        Intrinsics.checkNotNull((Object)object);
                        if (!ArraysKt.contains((long[])object, (long)schema.getObjectId())) continue;
                        object = schema.getTables().iterator();
                        while (object.hasNext()) {
                            PgBaseForeignKey fk;
                            PgBaseRegularTable table = (PgBaseRegularTable)object.next();
                            Iterator<T> iterator = table.getForeignKeys().iterator();
                            while (iterator.hasNext() && (fk = (PgBaseForeignKey)iterator.next()).getRefTable() != null) {
                                BasicTable refTable;
                                if (Intrinsics.areEqual((Object)schema, (Object)refTable.getSchema())) continue;
                                PgBaseModelHelper pgBaseModelHelper = this.this$0.getHelper();
                                Intrinsics.checkNotNull((Object)fk);
                                pgBaseModelHelper.resolveReference(fk, refTable);
                            }
                        }
                    }
                }
            });
        }
        return Unit.INSTANCE;
    }

    private static final Unit introspectServerObjects$lambda$4$lambda$3(long $xid, PgBaseRoot it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setIntrospectionStateNumber($xid);
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$5(PgBaseIntrospector this$0, DBTransaction $trans, boolean detectDropped, boolean loadNew) {
        this$0.retrieveSettings($trans);
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$6(PgBaseIntrospector this$0, DBTransaction $trans, boolean detectDropped, boolean loadNew) {
        this$0.retrieveTimeZones($trans);
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$7(PgBaseIntrospector this$0, DBTransaction $trans, boolean detectDropped, boolean loadNew) {
        this$0.retrieveComments($trans, detectDropped, loadNew);
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$8(PgBaseIntrospector this$0, DBTransaction $trans, boolean detectDropped, boolean loadNew) {
        this$0.retrieveAcls($trans, detectDropped, loadNew);
        return Unit.INSTANCE;
    }

    private static final boolean retrieveAcls$lambda$15$lambda$14$lambda$9(Grants.Controller $ctl, PgBaseRoot $r, PgObjectGrant it) {
        Grants.Grant grant = it;
        BasicElement basicElement = $r;
        BasicResolveAssistant basicResolveAssistant = BasicResolveAssistant.DEFAULT;
        Intrinsics.checkNotNullExpressionValue((Object)basicResolveAssistant, (String)"DEFAULT");
        return $ctl.findTarget(grant, basicElement, basicResolveAssistant) == null;
    }

    private static final boolean retrieveAcls$lambda$15$lambda$14$lambda$10(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit retrieveAcls$lambda$15$lambda$14$lambda$13(PgBaseIntrospector this$0, Lexer $lexer, NamingService $ns, List $newGrants, PgBaseIntroQueries.OneAcl acl) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)acl, (String)"acl");
            if (acl.acl == null) break block1;
            String[] $this$forEach$iv = acl.acl;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                String element$iv;
                String it = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                PgAclItem pgAclItem = this$0.parseAclItem($lexer, $ns, it);
                if (pgAclItem == null) continue;
                pgAclItem.toGrants(acl.object_id, $newGrants);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit retrieveAcls$lambda$15$lambda$14(boolean $detectDropped, boolean $loadNew, PgBaseIntrospector this$0, DBTransaction $tran, PgBaseRoot r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Grants.Controller<PgObjectGrant, ?> ctl = ((PgBaseGrantsHolder)r).getGrants().getController();
        List<PgObjectGrant> newGrants = ((PgBaseGrantsHolder)r).getGrants().toMutableList();
        if ($detectDropped) {
            newGrants.removeIf(arg_0 -> PgBaseIntrospector.retrieveAcls$lambda$15$lambda$14$lambda$10(arg_0 -> PgBaseIntrospector.retrieveAcls$lambda$15$lambda$14$lambda$9(ctl, r, arg_0), arg_0));
        }
        if ($loadNew) {
            Long l = r.getIntrospectionStateNumber();
            long it = ((Number)l).longValue();
            boolean bl = false;
            Long tx = $detectDropped ? l : null;
            Lexer lexer = this$0.getSqlHelper().createLexer();
            NamingService ns = NamingServices.getNamingService$default(this$0.dbms, this$0.getModel(), null, 4, null);
            this$0.getQueries().processObjectAcls($tran, r, tx, this$0.noDbXmin, (Function1<? super PgBaseIntroQueries.OneAcl, Unit>)((Function1)arg_0 -> PgBaseIntrospector.retrieveAcls$lambda$15$lambda$14$lambda$13(this$0, lexer, ns, newGrants, arg_0)));
        }
        ((PgBaseGrantsHolder)r).setGrants(((PgBaseGrantsHolder)r).getGrants().with((Iterable<PgObjectGrant>)newGrants));
        return Unit.INSTANCE;
    }

    private static final Unit retrieveSettings$lambda$17$lambda$16(PgBaseIntrospector this$0, String $dateStyle, PgBaseRoot root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        root.setDateStyle(this$0.parseDateStyle($dateStyle));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit retrieveTimeZones$lambda$24$lambda$23(List $zones, PgBaseRoot root) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Iterable iterable = $zones;
        PgBaseRoot pgBaseRoot = root;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var5_6 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            PgTimeZone pgTimeZone = (PgTimeZone)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            PgTimeZone it = (PgTimeZone)element$iv$iv;
            String string = StringUtil.toLowerCase((String)it.getName());
            boolean bl2 = false;
            PgTimeZone pgTimeZone2 = new PgTimeZone(it.getName(), it.isDST());
            map2.put(string, pgTimeZone2);
        }
        pgBaseRoot.setTimeZones(destination$iv$iv);
        return Unit.INSTANCE;
    }

    private static final Iterable introspectDatabaseSchemas$lambda$25(PgBaseIntrospector this$0, BasicDatabase[] $databases, DBTransaction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.getDatabasesToIntrospect(it, ArraysKt.toList((Object[])$databases));
    }

    private static final CharSequence checkElementsUptodate$lambda$30$lambda$29(Long it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return String.valueOf(it);
    }

    private static final String checkElementsUptodate$lambda$30(LinkedHashMap $ids, String s) {
        Intrinsics.checkNotNull((Object)s);
        Set set = $ids.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        return StringsKt.replace$default((String)s, (String)"OIDS", (String)CollectionsKt.joinToString$default((Iterable)set, null, null, null, (int)0, null, PgBaseIntrospector::checkElementsUptodate$lambda$30$lambda$29, (int)31, null), (boolean)false, (int)4, null);
    }

    private static final Unit checkElementsUptodate$lambda$31(LinkedHashMap $res, Long l, PgBaseCatalogObject v) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        ((Map)$res).put(v, false);
        return Unit.INSTANCE;
    }

    private static final void checkElementsUptodate$lambda$32(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit checkElementsUptodate$lambda$35(LinkedHashMap $res, PgBaseRoot it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Set set = $res.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)entry);
            Object k = entry.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
            BasicElement obj2 = (BasicElement)k;
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
            Boolean ok2 = (Boolean)v;
            Intrinsics.checkNotNull((Object)obj2, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicModElement");
            ((BasicModElement)obj2).setOutdated(ok2 == false);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector$Companion;", "", "<init>", "()V", "FROZEN_TXID", "", "intellij.database.dialects.postgresbase"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\b\u0094\u0004\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u00022\u001e\u0012\u0004\u0012\u0002H\u00010\u0003R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u0006\u0010\u0012\u001a\u00020\u000eJ\b\u0010\u0013\u001a\u00020\u000eH\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u000eH\u0002J\b\u0010\u001a\u001a\u00020\u0010H\u0014J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0014J\u0018\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0014J\u0018\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0014J)\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00028\u00032\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&H\u0014\u00a2\u0006\u0002\u0010'J\u0018\u0010(\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0014J\u0018\u0010)\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0014J\b\u0010*\u001a\u00020\u000eH\u0016J\u0012\u0010+\u001a\u00020\u00102\b\u0010,\u001a\u0004\u0018\u00010\fH\u0002R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector$DatabaseRetriever;", "D", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseDatabase;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "<init>", "(Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/postgresbase/model/PgBaseDatabase;)V", "myFrozen", "", "", "retrieveAcls", "", "detectDropped", "", "loadNew", "retrieveServerAndDatabaseObjects", "beforeServerAndDatabaseObjectsRetrieval", "getDatabaseIntrospectionMode", "Lcom/intellij/database/introspection/IntrospectionMode;", "removeDroppedDatabaseComments", "ids", "Lit/unimi/dsi/fastutil/longs/LongSet;", "introspectDatabase", "loadNewIntrospectDatabase", "steps", "", "Lcom/intellij/database/dialects/postgresbase/introspector/IntroStep;", "introspectDatabaseObjects", "introspectComments", "findObjectById", "Lcom/intellij/database/model/basic/BasicModNamedElement;", "db", "kind", "", "id", "", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseDatabase;Ljava/lang/Character;J)Lcom/intellij/database/model/basic/BasicModNamedElement;", "retrieveLanguages", "retrieveCasts", "retrieveSchemas", "isSystem", "name", "intellij.database.dialects.postgresbase"})
    @SourceDebugExtension(value={"SMAP\nPgBaseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PgBaseIntrospector.kt\ncom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector$DatabaseRetriever\n+ 2 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 7 ModelFun.kt\ncom/intellij/database/model/ModelFun\n*L\n1#1,1636:1\n466#2,2:1637\n469#2,4:1640\n466#2,7:1644\n466#2,2:1660\n469#2,4:1664\n466#2,2:1676\n469#2,4:1680\n1#3:1639\n13409#4,2:1651\n13437#4,2:1662\n13437#4,2:1678\n1863#5,2:1653\n1863#5:1689\n1864#5:1692\n178#6,5:1655\n183#6,3:1668\n178#6,5:1671\n183#6,3:1684\n421#7,2:1687\n423#7,2:1690\n425#7,3:1693\n*S KotlinDebug\n*F\n+ 1 PgBaseIntrospector.kt\ncom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector$DatabaseRetriever\n*L\n312#1:1637,2\n312#1:1640,4\n378#1:1644,7\n407#1:1660,2\n407#1:1664,4\n437#1:1676,2\n437#1:1680,4\n324#1:1651,2\n409#1:1662,2\n439#1:1678,2\n349#1:1653,2\n474#1:1689\n474#1:1692\n406#1:1655,5\n406#1:1668,3\n436#1:1671,5\n436#1:1684,3\n474#1:1687,2\n474#1:1690,2\n474#1:1693,3\n*E\n"})
    protected static class DatabaseRetriever<D extends PgBaseDatabase>
    extends BaseMultiDatabaseIntrospector.BaseDatabaseRetriever<D> {
        @NotNull
        private final Set<String> myFrozen;
        final /* synthetic */ PgBaseIntrospector<MR, D, S> this$0;

        public DatabaseRetriever(@NotNull DBTransaction tran, D database) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter(database, (String)"database");
            this.this$0 = this$0;
            super((BaseMultiDatabaseIntrospector)this$0, tran, (BasicModMateDatabase)database);
            this.myFrozen = new HashSet();
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveAcls(boolean detectDropped, boolean loadNew) {
            this.this$0.reportRetrieving("ACL", "introspection.retrieve.ACL");
            BaseNativeIntrospector baseNativeIntrospector = this.this$0;
            PgBaseIntrospector pgBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl = false;
                Grants.Controller<PgObjectGrant, ?> ctl = ((PgBaseGrantsHolder)this.getDatabase()).getGrants().getController();
                List<PgObjectGrant> newGrants = ((PgBaseGrantsHolder)this.getDatabase()).getGrants().toMutableList();
                if (detectDropped) {
                    newGrants.removeIf(arg_0 -> DatabaseRetriever.retrieveAcls$lambda$7$lambda$1(arg_0 -> DatabaseRetriever.retrieveAcls$lambda$7$lambda$0(ctl, this, arg_0), arg_0));
                }
                if (loadNew) {
                    Long l = ((PgBaseDatabase)this.getDatabase()).getIntrospectionStateNumber();
                    long it = ((Number)l).longValue();
                    boolean bl2 = false;
                    Long tx = detectDropped ? l : null;
                    Lexer lexer = pgBaseIntrospector.getSqlHelper().createLexer();
                    NamingService ns = NamingServices.getNamingService(pgBaseIntrospector.dbms, this.getModel(), (BasicDatabase)this.getDatabase());
                    pgBaseIntrospector.getQueries().processObjectAcls(this.getTransaction(), (PgBaseDatabase)this.getDatabase(), tx, (Function1<? super PgBaseIntroQueries.OneAcl, Unit>)((Function1)arg_0 -> DatabaseRetriever.retrieveAcls$lambda$7$lambda$6(newGrants, pgBaseIntrospector, lexer, ns, arg_0)));
                }
                ((PgBaseGrantsHolder)this.getDatabase()).setGrants(((PgBaseGrantsHolder)this.getDatabase()).getGrants().with((Iterable<PgObjectGrant>)newGrants));
            }
            catch (DBException e$iv) {
                void this_$iv;
                this_$iv.getErrorSink().accept(null, e$iv);
            }
        }

        @Override
        public final void retrieveServerAndDatabaseObjects() {
            block0: {
                super.retrieveServerAndDatabaseObjects();
                this.introspectDatabase();
                Long l = this.this$0.getIntrospectionXid();
                if (l == null) break block0;
                long xid = ((Number)l).longValue();
                boolean bl = false;
                this.inDatabase(arg_0 -> DatabaseRetriever.retrieveServerAndDatabaseObjects$lambda$9$lambda$8(xid, arg_0));
            }
        }

        @Override
        protected void beforeServerAndDatabaseObjectsRetrieval() {
            IntrospectionMode mode = this.getDatabaseIntrospectionMode();
            this.this$0.setTx(this, ((PgBaseDatabase)this.getDatabase()).getIntrospectionStateNumber(), "tx", "TXAGE");
            String string = IntrospectionMode.INCREMENT.code;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"code");
            this.setQueryParameter(string, mode.increment);
        }

        private final IntrospectionMode getDatabaseIntrospectionMode() {
            return ((PgBaseDatabase)this.getDatabase()).getIntrospectionStateNumber() != 0L && !this.this$0.getForbidIncremental() ? IntrospectionMode.INCREMENT : IntrospectionMode.FULL;
        }

        protected void removeDroppedDatabaseComments(@NotNull LongSet ids) {
            Intrinsics.checkNotNullParameter((Object)ids, (String)"ids");
            this.inDatabase(arg_0 -> DatabaseRetriever.removeDroppedDatabaseComments$lambda$11(ids, arg_0));
        }

        private final void introspectDatabase() {
            IntrospectionMode mode = this.getDatabaseIntrospectionMode();
            boolean detectDropped = mode.increment;
            boolean loadNew = mode.full || this.loadNewIntrospectDatabase();
            this.introspectDatabaseObjects(detectDropped, loadNew);
        }

        protected boolean loadNewIntrospectDatabase() {
            Long l = this.this$0.getIntrospectionXid();
            long l2 = ((PgBaseDatabase)this.getDatabase()).getIntrospectionStateNumber();
            return l == null || l != l2;
        }

        @NotNull
        protected List<IntroStep> steps() {
            return PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(new ArrayList(), 10, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)(arg_0, arg_1) -> DatabaseRetriever.steps$lambda$12(this, arg_0, arg_1))), 20, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)(arg_0, arg_1) -> DatabaseRetriever.steps$lambda$13(this, arg_0, arg_1))), 30, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)(arg_0, arg_1) -> DatabaseRetriever.steps$lambda$14(this, arg_0, arg_1))), 40, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)(arg_0, arg_1) -> DatabaseRetriever.steps$lambda$15(this, arg_0, arg_1)));
        }

        protected void introspectDatabaseObjects(boolean detectDropped, boolean loadNew) {
            List<IntroStep> steps = this.steps();
            CollectionsKt.sort(steps);
            for (IntroStep step2 : steps) {
                step2.getPerform().invoke((Object)detectDropped, (Object)loadNew);
            }
        }

        /*
         * WARNING - void declaration
         */
        protected void introspectComments(boolean detectDropped, boolean loadNew) {
            this.this$0.reportRetrieving("comments", "introspection.retrieve.comments");
            BaseNativeIntrospector baseNativeIntrospector = this.this$0;
            PgBaseIntrospector pgBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl = false;
                LongOpenHashSet commentsIds = detectDropped ? new LongOpenHashSet(this.performQuery(pgBaseIntrospector.getQueries().getListExistentDatabaseComments())) : new LongOpenHashSet();
                this.removeDroppedDatabaseComments((LongSet)commentsIds);
                if (loadNew) {
                    this.inDatabase(arg_0 -> DatabaseRetriever.introspectComments$lambda$18$lambda$17(this, pgBaseIntrospector, arg_0));
                }
            }
            catch (DBException e$iv) {
                void this_$iv;
                this_$iv.getErrorSink().accept(null, e$iv);
            }
        }

        @Nullable
        protected BasicModNamedElement findObjectById(@NotNull D db, @Nullable Character kind, long id) {
            BasicModNamedElement basicModNamedElement;
            Character c2;
            Intrinsics.checkNotNullParameter(db, (String)"db");
            Character c3 = c2 = kind;
            char c4 = 'L';
            if (c3 != null && c3.charValue() == c4) {
                basicModNamedElement = (BasicModNamedElement)db.getLanguages().getByObjectId(id);
            } else {
                Character c5 = c2;
                c4 = 'C';
                basicModNamedElement = c5 != null && c5.charValue() == c4 ? (BasicModNamedElement)db.getCasts().getByObjectId(id) : null;
            }
            return basicModNamedElement;
        }

        protected void retrieveLanguages(boolean detectDropped, boolean loadNew) {
            this.inDatabase(arg_0 -> DatabaseRetriever.retrieveLanguages$lambda$24(this.this$0, detectDropped, this, loadNew, arg_0));
        }

        protected void retrieveCasts(boolean detectDropped, boolean loadNew) {
            ObjectKind objectKind = ObjectKind.CAST;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"CAST");
            this.this$0.reportRetrieving(objectKind);
            this.inDatabase(arg_0 -> DatabaseRetriever.retrieveCasts$lambda$29(this.this$0, detectDropped, this, loadNew, arg_0));
        }

        @Override
        public void retrieveSchemas() {
            super.retrieveSchemas();
            if (!Intrinsics.areEqual((Object)((PgBaseLikeDatabase)this.getDatabase()).getName(), (Object)((PgBaseIntrospector)this.this$0).getDbConnectionInfo().databaseName)) {
                return;
            }
            List<PgBaseIntroQueries.IdNameCommentOwner> scs = this.performQuery(this.this$0.getQueries().getListSchemas());
            this.inDatabase(arg_0 -> DatabaseRetriever.retrieveSchemas$lambda$32(scs, this.this$0, this, arg_0));
        }

        private final boolean isSystem(String name2) {
            return name2 != null && (StringsKt.startsWith$default((String)name2, (String)"pg_temp", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name2, (String)"pg_toast", (boolean)false, (int)2, null));
        }

        private static final boolean retrieveAcls$lambda$7$lambda$0(Grants.Controller $ctl, DatabaseRetriever this$0, PgObjectGrant it) {
            Grants.Grant grant = it;
            BasicElement basicElement = (BasicElement)this$0.getDatabase();
            BasicResolveAssistant basicResolveAssistant = BasicResolveAssistant.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)basicResolveAssistant, (String)"DEFAULT");
            return $ctl.findTarget(grant, basicElement, basicResolveAssistant) == null;
        }

        private static final boolean retrieveAcls$lambda$7$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean retrieveAcls$lambda$7$lambda$6$lambda$3(PgBaseIntroQueries.OneAcl $acl, PgObjectGrant it) {
            return it.getObjectId() == $acl.object_id;
        }

        private static final boolean retrieveAcls$lambda$7$lambda$6$lambda$4(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final Unit retrieveAcls$lambda$7$lambda$6(List $newGrants, PgBaseIntrospector this$0, Lexer $lexer, NamingService $ns, PgBaseIntroQueries.OneAcl acl) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)acl, (String)"acl");
                $newGrants.removeIf(arg_0 -> DatabaseRetriever.retrieveAcls$lambda$7$lambda$6$lambda$4(arg_0 -> DatabaseRetriever.retrieveAcls$lambda$7$lambda$6$lambda$3(acl, arg_0), arg_0));
                if (acl.acl == null) break block1;
                String[] $this$forEach$iv = acl.acl;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int j = 0; j < n; ++j) {
                    String element$iv;
                    String it = element$iv = $this$forEach$iv[j];
                    boolean bl = false;
                    PgAclItem pgAclItem = this$0.parseAclItem($lexer, $ns, it);
                    if (pgAclItem == null) continue;
                    pgAclItem.toGrants(acl.object_id, $newGrants);
                }
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveServerAndDatabaseObjects$lambda$9$lambda$8(long $xid, PgBaseDatabase it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            it.setIntrospectionStateNumber($xid);
            return Unit.INSTANCE;
        }

        private static final Unit removeDroppedDatabaseComments$lambda$11(LongSet $ids, PgBaseDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            ModNamingIdentifyingFamily<? extends PgBaseLanguage> modNamingIdentifyingFamily = db.getLanguages();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getLanguages(...)");
            Iterable $this$forEach$iv = modNamingIdentifyingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PgBaseLanguage it = (PgBaseLanguage)element$iv;
                boolean bl = false;
                if ($ids.contains(it.getObjectId())) continue;
                it.setComment(null);
            }
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$12(DatabaseRetriever this$0, boolean detectDropped, boolean loadNew) {
            this$0.retrieveLanguages(detectDropped, loadNew);
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$13(DatabaseRetriever this$0, boolean detectDropped, boolean loadNew) {
            this$0.introspectComments(detectDropped, loadNew);
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$14(DatabaseRetriever this$0, boolean detectDropped, boolean loadNew) {
            this$0.retrieveAcls(detectDropped, loadNew);
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$15(DatabaseRetriever this$0, boolean detectDropped, boolean loadNew) {
            this$0.retrieveCasts(detectDropped, loadNew);
            return Unit.INSTANCE;
        }

        private static final Unit introspectComments$lambda$18$lambda$17$lambda$16(DatabaseRetriever this$0, PgBaseDatabase $db, PgBaseIntroQueries.OneComment it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            BasicModNamedElement basicModNamedElement = this$0.findObjectById($db, it.kind, it.id);
            if (basicModNamedElement == null) {
                return Unit.INSTANCE;
            }
            BasicModNamedElement obj2 = basicModNamedElement;
            obj2.setComment(it.description);
            return Unit.INSTANCE;
        }

        private static final Unit introspectComments$lambda$18$lambda$17(DatabaseRetriever this$0, PgBaseIntrospector this$1, PgBaseDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this$0, this$1.getQueries().getRetrieveDatabaseComments(), 0, arg_0 -> DatabaseRetriever.introspectComments$lambda$18$lambda$17$lambda$16(this$0, db, arg_0), 2, null);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveLanguages$lambda$24$lambda$23$lambda$22$lambda$21(ModNamingIdentifyingFamily $languages, PgBaseIntroQueries.OneLanguage it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Object e = $languages.renew(it.id, it.name);
            Intrinsics.checkNotNullExpressionValue(e, (String)"renew(...)");
            Object e2 = e;
            PgBaseLanguage $this$retrieveLanguages_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420 = (PgBaseLanguage)e2;
            boolean bl = false;
            $this$retrieveLanguages_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420.setStateNumber(it.state_number);
            $this$retrieveLanguages_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420.setTrusted(it.trusted);
            $this$retrieveLanguages_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420.setHandlerName(it.handler);
            $this$retrieveLanguages_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420.setHandlerSchema(it.handlerSchema);
            $this$retrieveLanguages_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420.setInlineHandlerName(it.inline);
            $this$retrieveLanguages_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420.setInlineHandlerSchema(it.inlineSchema);
            $this$retrieveLanguages_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420.setValidatorName(it.validator);
            $this$retrieveLanguages_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420.setValidatorSchema(it.validatorSchema);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveLanguages$lambda$24(PgBaseIntrospector this$0, boolean $detectDropped, DatabaseRetriever this$1, boolean $loadNew, PgBaseDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            ModFamily $this$modifyAndCleanup_u24default$iv = db.getLanguages();
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingIdentifyingFamily languages = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector this_$iv = this$0;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl2 = false;
                if ($detectDropped) {
                    long[] $this$forEach$iv = this$1.performQuery(this$0.getQueries().getListExistentLanguages());
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int j = 0; j < n; ++j) {
                        long element$iv;
                        long it = element$iv = $this$forEach$iv[j];
                        boolean bl3 = false;
                        PgBaseLanguage pgBaseLanguage = (PgBaseLanguage)languages.getByObjectId(it);
                        if (pgBaseLanguage != null) {
                            ((BasicModMixinElement)pgBaseLanguage).resetSyncPending();
                        }
                    }
                }
                if ($loadNew) {
                    BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this$1, this$0.getQueries().getListLanguages(), 0, arg_0 -> DatabaseRetriever.retrieveLanguages$lambda$24$lambda$23$lambda$22$lambda$21(languages, arg_0), 2, null);
                }
            }
            catch (DBException e$iv) {
                this_$iv.getErrorSink().accept(null, e$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
            return Unit.INSTANCE;
        }

        private static final Unit retrieveCasts$lambda$29$lambda$28$lambda$27$lambda$26(ModNamingIdentifyingFamily $casts, PgBaseIntrospector this$0, PgBaseIntroQueries.OneCast m) {
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            Object e = $casts.createOrGet(m.oid);
            Intrinsics.checkNotNullExpressionValue(e, (String)"createOrGet(...)");
            PgBaseCast cast = (PgBaseCast)e;
            cast.setStateNumber(m.state_number);
            cast.setSourceTypeRef(this$0.createIdOrQNameRef(m.castsource_id, m.castsource_name, ((PgBaseIntrospector)this$0).getDbConnectionInfo().schemaName));
            cast.setTargetTypeRef(this$0.createIdOrQNameRef(m.casttarget_id, m.casttarget_name, ((PgBaseIntrospector)this$0).getDbConnectionInfo().schemaName));
            cast.setCastFunctionRef(this$0.createIdOrQNameRef(m.castfunc_id, m.castfunc_name, ((PgBaseIntrospector)this$0).getDbConnectionInfo().schemaName));
            cast.setMethod(switch (m.castmethod) {
                case 'f' -> PgCastMethod.FUNCTION;
                case 'i' -> PgCastMethod.IO;
                case 'b' -> PgCastMethod.BINARY;
                default -> null;
            });
            cast.setContext(switch (m.castcontext) {
                case 'e' -> PgCastContext.EXPLICIT;
                case 'a' -> PgCastContext.ASSIGNMENT;
                case 'i' -> PgCastContext.IMPLICIT;
                default -> null;
            });
            return Unit.INSTANCE;
        }

        private static final Unit retrieveCasts$lambda$29(PgBaseIntrospector this$0, boolean $detectDropped, DatabaseRetriever this$1, boolean $loadNew, PgBaseDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            ModFamily $this$modifyAndCleanup_u24default$iv = db.getCasts();
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingIdentifyingFamily casts = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector this_$iv = this$0;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl2 = false;
                if ($detectDropped) {
                    long[] $this$forEach$iv = this$1.performQuery(this$0.getQueries().getListExistentCasts());
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int j = 0; j < n; ++j) {
                        long element$iv;
                        long it = element$iv = $this$forEach$iv[j];
                        boolean bl3 = false;
                        PgBaseCast pgBaseCast = (PgBaseCast)casts.getByObjectId(it);
                        if (pgBaseCast != null) {
                            ((BasicModMixinElement)pgBaseCast).resetSyncPending();
                        }
                    }
                }
                if ($loadNew) {
                    BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this$1, this$0.getQueries().getListCasts(), 0, arg_0 -> DatabaseRetriever.retrieveCasts$lambda$29$lambda$28$lambda$27$lambda$26(casts, this$0, arg_0), 2, null);
                }
            }
            catch (DBException e$iv) {
                this_$iv.getErrorSink().accept(null, e$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveSchemas$lambda$32(List $scs, PgBaseIntrospector this$0, DatabaseRetriever this$1, PgBaseDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            ModNamingFamily modNamingFamily = db.getSchemas();
            Intrinsics.checkNotNullExpressionValue((Object)modNamingFamily, (String)"getSchemas(...)");
            ModNamingFamily $this$applySchemasImpl$iv = modNamingFamily;
            boolean $i$f$applySchemasImpl = false;
            $this$applySchemasImpl$iv.markChildrenAsSyncPending();
            Iterable $this$forEach$iv$iv = $scs;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object e;
                void sc;
                Object element$iv$iv;
                Object sc$iv = element$iv$iv = iterator.next();
                boolean bl = false;
                PgBaseIntroQueries.IdNameCommentOwner idNameCommentOwner = (PgBaseIntroQueries.IdNameCommentOwner)sc$iv;
                ModNamingFamily $this$retrieveSchemas_u24lambda_u2432_u24lambda_u2431 = $this$applySchemasImpl$iv;
                boolean bl2 = false;
                if (!this$0.getShowSystemScs() && this$1.isSystem(sc.name)) continue;
                Intrinsics.checkNotNullExpressionValue(db.getSchemas().renew(sc.id, sc.name), (String)"renew(...)");
                PgBaseSchema $this$retrieveSchemas_u24lambda_u2432_u24lambda_u2431_u24lambda_u2430 = (PgBaseSchema)e;
                boolean bl3 = false;
                $this$retrieveSchemas_u24lambda_u2432_u24lambda_u2431_u24lambda_u2430.setStateNumber(sc.state_number);
                $this$retrieveSchemas_u24lambda_u2432_u24lambda_u2431_u24lambda_u2430.setComment(sc.description);
                $this$retrieveSchemas_u24lambda_u2432_u24lambda_u2431_u24lambda_u2430.setOwnerRef(BasicNameReference.create(sc.getOwnerName()));
                PgBaseIntroQueries.IdNameCommentOwner idNameCommentOwner2 = (PgBaseIntroQueries.IdNameCommentOwner)CollectionsKt.firstOrNull((List)$scs);
                $this$retrieveSchemas_u24lambda_u2432_u24lambda_u2431_u24lambda_u2430.setCurrent(idNameCommentOwner2 != null ? idNameCommentOwner2.id == $this$retrieveSchemas_u24lambda_u2432_u24lambda_u2431_u24lambda_u2430.getObjectId() : false);
            }
            $this$applySchemasImpl$iv.removeSyncPendingChildren();
            $this$applySchemasImpl$iv.sort();
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0094\u0004\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u00022\u001e\u0012\u0004\u0012\u0002H\u00010\u0003R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0003\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector$NativeRetriever;", "D", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeDatabase;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseNativeRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "<init>", "(Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeDatabase;)V", "intellij.database.dialects.postgresbase"})
    protected static class NativeRetriever<D extends PgBaseLikeDatabase>
    extends BaseMultiDatabaseIntrospector.BaseNativeRetriever<D> {
        final /* synthetic */ PgBaseIntrospector<MR, D, S> this$0;

        public NativeRetriever(@NotNull DBTransaction tran, D database) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter(database, (String)"database");
            this.this$0 = this$0;
            super((BaseMultiDatabaseIntrospector)this$0, tran, (BasicModMateDatabase)database);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00da\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\f\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00a4\u0004\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u00022\u001e\u0012\u0004\u0012\u0002H\u00010\u0003R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004B\u0019\b\u0014\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u0003H\u0016\u00a2\u0006\u0002\u0010\"J\u0006\u0010#\u001a\u00020$J\b\u0010%\u001a\u00020$H\u0016J\b\u0010&\u001a\u00020$H\u0014J\u001c\u0010'\u001a\u00020$2\u0012\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0*0)H\u0002J\u0014\u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0*0)H$J$\u0010-\u001a\u00020$2\u0012\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0*0)2\u0006\u0010.\u001a\u00020/H\u0014J#\u00100\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020/010*2\u0006\u0010\u0007\u001a\u00028\u0003H\u0014\u00a2\u0006\u0002\u00102J\b\u00103\u001a\u00020$H\u0014J\b\u00104\u001a\u00020$H\u0014J\b\u00105\u001a\u00020\u000bH\u0014J\b\u00106\u001a\u00020\u000bH\u0014J\b\u00107\u001a\u00020\u000eH\u0014J\b\u00108\u001a\u00020$H\u0014J\u000e\u00109\u001a\b\u0012\u0004\u0012\u00020;0:H\u0014J\u0018\u0010<\u001a\u00020$2\u0006\u0010=\u001a\u00020\u000b2\u0006\u0010>\u001a\u00020\u000bH\u0002J\u0016\u0010?\u001a\u00020$2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020A0:H\u0002J \u0010B\u001a\u00020$*\b\u0012\u0004\u0012\u00020D0C2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020A0:H\u0002J<\u0010B\u001a\u00020$*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u00020G0E0C2\u0006\u0010H\u001a\u00020\u000e2\u0006\u0010I\u001a\u00020\u000e2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020A0:H\u0002J\u0018\u0010J\u001a\u00020$2\u0006\u0010=\u001a\u00020\u000b2\u0006\u0010>\u001a\u00020\u000bH\u0014J%\u0010K\u001a\u00020$2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020O2\u0006\u0010\u0007\u001a\u00028\u0003H\u0014\u00a2\u0006\u0002\u0010PJ\u0018\u0010Q\u001a\u00020$2\u0006\u0010=\u001a\u00020\u000b2\u0006\u0010>\u001a\u00020\u000bH\u0002J#\u0010R\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020T0S0*2\u0006\u0010U\u001a\u00028\u0003H\u0014\u00a2\u0006\u0002\u0010VJ\u0015\u0010W\u001a\u00020$2\u0006\u0010\u0007\u001a\u00028\u0003H\u0014\u00a2\u0006\u0002\u0010XJ\u001d\u0010Y\u001a\u00020$2\u0006\u0010\u0007\u001a\u00028\u00032\u0006\u0010Z\u001a\u00020[H\u0004\u00a2\u0006\u0002\u0010\\J%\u0010Y\u001a\u00020$2\u0006\u0010]\u001a\u00020T2\u0006\u0010\u0007\u001a\u00028\u00032\u0006\u0010^\u001a\u00020[H\u0014\u00a2\u0006\u0002\u0010_J/\u0010`\u001a\u0004\u0018\u00010T2\u0006\u0010\u0007\u001a\u00028\u00032\u0006\u0010a\u001a\u00020b2\u0006\u0010H\u001a\u00020\u000e2\u0006\u0010c\u001a\u00020\u001fH\u0002\u00a2\u0006\u0002\u0010dJ/\u0010e\u001a\u0004\u0018\u00010T2\u0006\u0010\u0007\u001a\u00028\u00032\u0006\u0010a\u001a\u00020b2\u0006\u0010H\u001a\u00020\u000e2\u0006\u0010c\u001a\u00020\u001fH\u0014\u00a2\u0006\u0002\u0010dJ\u001e\u0010f\u001a\u0004\u0018\u00010T2\b\u0010g\u001a\u0004\u0018\u00010T2\b\u0010h\u001a\u0004\u0018\u00010TH\u0014J\u0010\u0010i\u001a\u00020\u000b2\u0006\u0010j\u001a\u00020bH\u0014J\b\u0010k\u001a\u00020$H\u0014J\b\u0010l\u001a\u00020$H\u0014J\u0018\u0010m\u001a\u00020$2\u0006\u0010=\u001a\u00020\u000b2\u0006\u0010>\u001a\u00020\u000bH\u0014J)\u0010n\u001a\u00020$\"\b\b\u0004\u0010o*\u00020p2\u0006\u0010q\u001a\u0002Ho2\b\u0010r\u001a\u0004\u0018\u00010bH\u0016\u00a2\u0006\u0002\u0010sJ0\u0010t\u001a\u00020$\"\b\b\u0004\u0010o*\u00020p2\u0006\u0010u\u001a\u00020v2\f\u0010w\u001a\b\u0012\u0004\u0012\u0002Ho0x2\u0006\u0010y\u001a\u00020zH\u0002J\u001d\u0010{\u001a\u00020|2\u0006\u0010\u0007\u001a\u00028\u00032\u0006\u0010u\u001a\u00020}H\u0014\u00a2\u0006\u0002\u0010~J\u0018\u0010\u007f\u001a\u00020$2\u0006\u0010=\u001a\u00020\u000b2\u0006\u0010>\u001a\u00020\u000bH\u0014J\u001d\u0010\u0080\u0001\u001a\u00020$2\b\u0010\u0081\u0001\u001a\u00030\u0082\u00012\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001H\u0014J\u0019\u0010\u0085\u0001\u001a\u00020$2\u0006\u0010=\u001a\u00020\u000b2\u0006\u0010>\u001a\u00020\u000bH\u0014J\u001d\u0010\u0086\u0001\u001a\u00020$2\b\u0010\u0087\u0001\u001a\u00030\u0088\u00012\b\u0010\u0089\u0001\u001a\u00030\u008a\u0001H\u0014J\t\u0010\u008b\u0001\u001a\u00020$H\u0002J'\u0010\u008c\u0001\u001a\u00020$2\u000e\u0010\u008d\u0001\u001a\t\u0012\u0005\u0012\u00030\u008e\u00010:2\u0006\u0010\u0007\u001a\u00028\u0003H\u0014\u00a2\u0006\u0003\u0010\u008f\u0001J7\u0010\u0090\u0001\u001a\u00020$2\b\u0010\u0091\u0001\u001a\u00030\u008e\u00012\b\u0010\u0092\u0001\u001a\u00030\u0093\u00012\u0010\u0010\u0094\u0001\u001a\u000b\u0012\u0007\b\u0001\u0012\u00030\u0093\u00010x2\u0006\u0010]\u001a\u00020TH\u0014J\u001c\u0010\u0095\u0001\u001a\u00020b2\u0006\u0010j\u001a\u00020b2\t\u0010\u0096\u0001\u001a\u0004\u0018\u00010\u001fH\u0014J*\u0010\u0097\u0001\u001a\u0004\u0018\u00010T2\u0006\u0010\u0007\u001a\u00028\u00032\u0006\u0010a\u001a\u00020b2\u0007\u0010\u0098\u0001\u001a\u00020\u000eH\u0014\u00a2\u0006\u0003\u0010\u0099\u0001J#\u0010\u009a\u0001\u001a\u00020$2\u0006\u0010]\u001a\u00020T2\u0007\u0010\u009b\u0001\u001a\u00020\u001f2\u0007\u0010\u009c\u0001\u001a\u00020\u001fH\u0014J-\u0010\u009a\u0001\u001a\u00020$2\u0006\u0010]\u001a\u00020T2\b\u0010\u009d\u0001\u001a\u00030\u009e\u00012\u0007\u0010\u009b\u0001\u001a\u00020\u001f2\u0007\u0010\u009f\u0001\u001a\u00020\u001fH\u0014J\u0019\u0010\u00a0\u0001\u001a\u00020$2\u0006\u0010=\u001a\u00020\u000b2\u0006\u0010>\u001a\u00020\u000bH\u0002J\"\u0010\u00a1\u0001\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030S0*2\u0007\u0010]\u001a\u00030\u00a2\u0001H\u0014\u00a2\u0006\u0003\u0010\u00a3\u0001J&\u0010\u00a4\u0001\u001a\u00020$2\b\u0010\u00a5\u0001\u001a\u00030\u00a6\u00012\u0007\u0010]\u001a\u00030\u00a2\u00012\b\u0010\u00a7\u0001\u001a\u00030\u00a8\u0001H\u0014J\u001c\u0010\u00a9\u0001\u001a\u00020$2\u0007\u0010]\u001a\u00030\u00a2\u00012\b\u0010\u00a7\u0001\u001a\u00030\u00a8\u0001H\u0014J4\u0010\u00aa\u0001\u001a\u00020$2\b\u0010\u00ab\u0001\u001a\u00030\u00ac\u00012\u0007\u0010]\u001a\u00030\u00a2\u00012\b\u0010\u00a7\u0001\u001a\u00030\u00a8\u00012\u0006\u0010\u0007\u001a\u00028\u0003H\u0014\u00a2\u0006\u0003\u0010\u00ad\u0001J\u0013\u0010\u00ae\u0001\u001a\u00020\u000b2\b\u0010\u00a7\u0001\u001a\u00030\u00a8\u0001H\u0014J6\u0010\u00af\u0001\u001a\b\u0012\u0004\u0012\u00020\u001f0C2\t\u0010\u00b0\u0001\u001a\u0004\u0018\u00010\u001f2\u0007\u0010\u00b1\u0001\u001a\u00020\u001f2\u0011\u0010\u0094\u0001\u001a\f\u0012\u0007\b\u0001\u0012\u00030\u00b3\u00010\u00b2\u0001H\u0004J\"\u0010\u00b4\u0001\u001a\u0004\u0018\u00010\u001f*\f\u0012\u0007\b\u0001\u0012\u00030\u00b3\u00010\u00b2\u00012\u0007\u0010\u00b5\u0001\u001a\u00020+H\u0004J\u0019\u0010\u00b6\u0001\u001a\u00020$2\u0006\u0010=\u001a\u00020\u000b2\u0006\u0010>\u001a\u00020\u000bH\u0014J-\u0010\u00b7\u0001\u001a\u0005\u0018\u00010\u00b8\u00012\u0006\u0010\u0007\u001a\u00028\u00032\b\u0010j\u001a\u0004\u0018\u00010b2\u0007\u0010\u00b9\u0001\u001a\u00020\u000eH\u0014\u00a2\u0006\u0003\u0010\u00ba\u0001J\t\u0010\u00bb\u0001\u001a\u00020$H\u0002J\u001f\u0010\u00bc\u0001\u001a\u00020$2\t\u0010\u00bd\u0001\u001a\u0004\u0018\u00010T2\t\u0010\u00be\u0001\u001a\u0004\u0018\u00010\u001fH\u0014J\t\u0010\u00bf\u0001\u001a\u00020$H\u0014J\u001c\u0010\u00c0\u0001\u001a\u00020$2\u0007\u0010\u00c1\u0001\u001a\u00020|2\b\u0010\u00c2\u0001\u001a\u00030\u00c3\u0001H\u0002J\u001c\u0010\u00c4\u0001\u001a\u00020$2\u0007\u0010\u00c1\u0001\u001a\u00020|2\b\u0010\u00c2\u0001\u001a\u00030\u00c3\u0001H\u0014J\u0016\u0010\u00c5\u0001\u001a\u0005\u0018\u00010\u00c6\u00012\b\u0010\u00c2\u0001\u001a\u00030\u00c3\u0001H\u0014J\u0019\u0010\u00c7\u0001\u001a\u00020$*\u00030\u00c8\u00012\t\u0010\u00be\u0001\u001a\u0004\u0018\u00010\u001fH\u0002J\t\u0010\u00c9\u0001\u001a\u00020\u000bH\u0004J\t\u0010\u00ca\u0001\u001a\u00020\u000bH\u0014J\t\u0010\u00cb\u0001\u001a\u00020\u000bH\u0014J\u0019\u0010\u00cc\u0001\u001a\u00020$2\u0006\u0010]\u001a\u00020T2\u0006\u0010Z\u001a\u00020[H$J\u001a\u0010\u00cd\u0001\u001a\u00020$2\u0007\u0010]\u001a\u00030\u00a2\u00012\u0006\u0010Z\u001a\u00020[H$R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00ce\u0001"}, d2={"Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector$SchemaRetriever;", "S", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "<init>", "(Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;)V", "myHasChanges", "", "myTypes", "", "", "Lcom/intellij/database/types/DasType;", "getMyTypes", "()Ljava/util/Map;", "setMyTypes", "(Ljava/util/Map;)V", "wasStructures", "wasTables", "wasViews", "wasMatViews", "getWasMatViews", "()Z", "setWasMatViews", "(Z)V", "srcFromTx", "myFrozen", "", "", "isPossibleToIntrospectSchemaIncrementally", "tran", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;)Z", "prepareParameters", "", "processPreliminaryPhase", "analyzeBriefInfo", "removeDroppedComments", "existentComments", "Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", "", "", "listExistentComments", "removeComments", "e", "Lcom/intellij/database/model/basic/BasicModIdentifiedElement;", "getSchemaChildrenToDrop", "Lcom/intellij/database/model/families/ModIdentifyingFamily;", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;)[Lcom/intellij/database/model/families/ModIdentifyingFamily;", "retrieveMainContent", "performNonIncrementalPart", "incrementalViewSources", "incrementalColAcl", "getSchemaStateNumber", "finishSchema", "steps", "", "Lcom/intellij/database/dialects/postgresbase/introspector/IntroStep;", "retrieveAcls", "detectDropped", "loadNew", "retrieveColumnAcl", "newGrants", "Lcom/intellij/database/dialects/postgresbase/model/properties/PgObjectGrant;", "toGrants", "", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$AttrAcl;", "Lkotlin/Pair;", "", "Lcom/intellij/database/dialects/postgresbase/introspector/PgAclItem;", "objectId", "granteeId", "retrieveDataTypes", "processDataType", "dataType", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseDefType;", "oneType", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneDataType;", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseDefType;Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneDataType;Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;)V", "retrieveTables", "tableFamilies", "Lcom/intellij/database/model/families/ModNamingIdentifyingFamily;", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeStoredTable;", "sc", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;)[Lcom/intellij/database/model/families/ModNamingIdentifyingFamily;", "loadTables", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;)V", "processTable", "t", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneTable;", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneTable;)V", "table", "oneTable", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeStoredTable;Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneTable;)V", "renewTableOrView", "relKind", "", "objectName", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;CJLjava/lang/String;)Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeStoredTable;", "renewTableOrViewImpl", "preventDuplicates", "newRelation", "existing", "isTableKind", "kind", "retrieveStructAttributes", "obtainUsedTypes", "retrieveRoutines", "processArgExtra", "T", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseArgument;", "argument", "argMode", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseArgument;Ljava/lang/Character;)V", "processArgs", "r", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$ArgumentHolder;", "family", "Lcom/intellij/database/model/families/ModPositioningNamingFamily;", "routine", "Lcom/intellij/database/model/basic/BasicModRoutine;", "createRoutine", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseRoutine;", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneRoutine;", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneRoutine;)Lcom/intellij/database/dialects/postgresbase/model/PgBaseRoutine;", "retrieveAggregates", "processAggregate", "agg", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneAggregate;", "aggregate", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseAggregate;", "retrieveOperators", "processOperator", "o", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneOperator;", "operator", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseOperator;", "retrieveTableColumns", "processColumns", "cols", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneColumn;", "(Ljava/util/List;Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;)V", "processColumn", "col", "column", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeColumn;", "columns", "adjustRelKind", "name", "getTableOrView", "tableId", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;CJ)Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeStoredTable;", "handleColumnRenaming", "oldName", "tableName", "childrenKind", "Lcom/intellij/database/model/ObjectKind;", "newName", "retrieveConstraints", "constraintFamilies", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseTable;", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseTable;)[Lcom/intellij/database/model/families/ModNamingIdentifyingFamily;", "processKey", "key", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseKey;", "con", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneConstraint;", "processCheck", "processForeignKey", "fkey", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseForeignKey;", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseForeignKey;Lcom/intellij/database/dialects/postgresbase/model/PgBaseTable;Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneConstraint;Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;)V", "hasReference", "peekColNames", "columnPositions", "what", "Lcom/intellij/database/model/families/PositioningFamily;", "Lcom/intellij/database/model/basic/BasicTableOrViewColumn;", "getColumnName", "position", "retrieveDescriptions", "findObjectById", "Lcom/intellij/database/model/basic/BasicElement;", "id", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;Ljava/lang/Character;J)Lcom/intellij/database/model/basic/BasicElement;", "retrieveViewSources", "processViewSource", "view", "sourceText", "retrieveFunSources", "processFunSource", "function", "fs", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneFunctionSource;", "processFunSourceAttributes", "getFunSourceText", "Lcom/intellij/database/model/properties/CompositeText;", "applyViewSourceText", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseSourceAware;", "shouldIntrospectTableRelatedData", "shouldIntrospectTableRelatedDataIncremental", "wasDataTables", "processModView", "processModTable", "intellij.database.dialects.postgresbase"})
    @SourceDebugExtension(value={"SMAP\nPgBaseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PgBaseIntrospector.kt\ncom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector$SchemaRetriever\n+ 2 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 8 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 9 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 10 ModelFun.kt\ncom/intellij/database/model/ModelFun\n+ 11 BaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospector\n+ 12 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 13 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,1636:1\n466#2,2:1637\n469#2,4:1640\n466#2,7:1644\n466#2,7:1672\n466#2,7:1679\n466#2,7:1687\n466#2,7:1718\n466#2,2:1727\n367#2:1729\n368#2,2:1735\n469#2,4:1742\n466#2,2:1746\n367#2:1748\n368#2,2:1754\n469#2,4:1761\n466#2,2:1772\n469#2,4:1776\n466#2,2:1791\n469#2,4:1795\n466#2,2:1844\n469#2,4:1848\n466#2,2:1860\n469#2,4:1864\n466#2,2:1876\n469#2,4:1880\n466#2,2:1910\n469#2,4:1920\n1#3:1639\n1#3:1901\n992#4:1651\n1021#4,3:1652\n1024#4,3:1662\n381#5,7:1655\n381#5,7:1698\n381#5,7:1808\n381#5,7:1933\n216#6,2:1665\n216#6:1708\n217#6:1717\n216#6:1818\n217#6:1827\n216#6:1943\n217#6:1946\n1863#7:1667\n1863#7,2:1668\n1864#7:1670\n1485#7:1694\n1510#7,3:1695\n1513#7,3:1705\n1485#7:1804\n1510#7,3:1805\n1513#7,3:1815\n739#7,9:1828\n1863#7:1905\n1864#7:1908\n1863#7:1912\n1863#7:1913\n1863#7,2:1915\n1864#7:1918\n1864#7:1919\n1864#7:1927\n1485#7:1929\n1510#7,3:1930\n1513#7,3:1940\n1863#7,2:1944\n19#8:1671\n19#8:1686\n178#9,8:1709\n178#9,5:1767\n183#9,3:1780\n195#9,8:1783\n204#9,5:1799\n178#9,8:1819\n178#9,5:1839\n183#9,3:1852\n178#9,5:1855\n183#9,3:1868\n178#9,5:1871\n183#9,3:1884\n265#9:1904\n268#9:1909\n269#9:1924\n273#9:1928\n209#10:1725\n202#10:1726\n199#10,4:1887\n1057#11:1730\n1151#11,2:1731\n1058#11,2:1733\n1062#11:1737\n1156#11,2:1738\n1063#11,2:1740\n1057#11:1749\n1151#11,2:1750\n1058#11,2:1752\n1062#11:1756\n1156#11,2:1757\n1063#11,2:1759\n13409#12,2:1765\n13437#12,2:1774\n13437#12,2:1793\n13437#12,2:1846\n13437#12,2:1862\n13437#12,2:1878\n11483#12,9:1891\n13409#12:1900\n13410#12:1902\n11492#12:1903\n13409#12,2:1906\n13409#12:1914\n13410#12:1917\n13409#12,2:1925\n37#13,2:1837\n*S KotlinDebug\n*F\n+ 1 PgBaseIntrospector.kt\ncom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector$SchemaRetriever\n*L\n675#1:1637,2\n675#1:1640,4\n698#1:1644,7\n851#1:1672,7\n874#1:1679,7\n1123#1:1687,7\n1317#1:1718,7\n1353#1:1727,2\n1354#1:1729\n1354#1:1735,2\n1353#1:1742,4\n1375#1:1746,2\n1376#1:1748\n1376#1:1754,2\n1375#1:1761,4\n745#1:1772,2\n745#1:1776,4\n779#1:1791,2\n779#1:1795,4\n893#1:1844,2\n893#1:1848,4\n1055#1:1860,2\n1055#1:1864,4\n1088#1:1876,2\n1088#1:1880,4\n1229#1:1910,2\n1229#1:1920,4\n1227#1:1901\n717#1:1651\n717#1:1652,3\n717#1:1662,3\n717#1:1655,7\n1132#1:1698,7\n856#1:1808,7\n1327#1:1933,7\n717#1:1665,2\n1133#1:1708\n1133#1:1717\n857#1:1818\n857#1:1827\n1327#1:1943\n1327#1:1946\n726#1:1667\n728#1:1668,2\n726#1:1670\n1132#1:1694\n1132#1:1695,3\n1132#1:1705,3\n856#1:1804\n856#1:1805,3\n856#1:1815,3\n910#1:1828,9\n1228#1:1905\n1228#1:1908\n1232#1:1912\n1233#1:1913\n1235#1:1915,2\n1233#1:1918\n1232#1:1919\n1228#1:1927\n1327#1:1929\n1327#1:1930,3\n1327#1:1940,3\n1329#1:1944,2\n824#1:1671\n1017#1:1686\n1135#1:1709,8\n744#1:1767,5\n744#1:1780,3\n778#1:1783,8\n778#1:1799,5\n859#1:1819,8\n892#1:1839,5\n892#1:1852,3\n1054#1:1855,5\n1054#1:1868,3\n1087#1:1871,5\n1087#1:1884,3\n1228#1:1904\n1228#1:1909\n1228#1:1924\n1228#1:1928\n1344#1:1725\n1344#1:1726\n1244#1:1887,4\n1354#1:1730\n1354#1:1731,2\n1354#1:1733,2\n1354#1:1737\n1354#1:1738,2\n1354#1:1740,2\n1376#1:1749\n1376#1:1750,2\n1376#1:1752,2\n1376#1:1756\n1376#1:1757,2\n1376#1:1759,2\n687#1:1765,2\n747#1:1774,2\n781#1:1793,2\n895#1:1846,2\n1057#1:1862,2\n1090#1:1878,2\n1227#1:1891,9\n1227#1:1900\n1227#1:1902\n1227#1:1903\n1228#1:1906,2\n1234#1:1914\n1234#1:1917\n1228#1:1925,2\n910#1:1837,2\n*E\n"})
    protected static abstract class SchemaRetriever<S extends PgBaseSchema>
    extends BaseNativeIntrospector.AbstractSchemaRetriever<S> {
        private boolean myHasChanges;
        protected Map<Long, DasType> myTypes;
        private boolean wasStructures;
        private boolean wasTables;
        private boolean wasViews;
        private boolean wasMatViews;
        private final long srcFromTx;
        @NotNull
        private final Set<String> myFrozen;
        final /* synthetic */ PgBaseIntrospector<MR, D, S> this$0;

        @NotNull
        protected final Map<Long, DasType> getMyTypes() {
            Map<Long, DasType> map2 = this.myTypes;
            if (map2 != null) {
                return map2;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTypes");
            return null;
        }

        protected final void setMyTypes(@NotNull Map<Long, DasType> map2) {
            Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
            this.myTypes = map2;
        }

        protected final boolean getWasMatViews() {
            return this.wasMatViews;
        }

        protected final void setWasMatViews(boolean bl) {
            this.wasMatViews = bl;
        }

        protected SchemaRetriever(@NotNull DBTransaction transaction, S schema) {
            long l;
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            this.this$0 = this$0;
            super((BaseNativeIntrospector)this$0, transaction, (BasicModSchema)schema);
            this.myHasChanges = true;
            this.myFrozen = new HashSet();
            Long existentSourcesTx = this.getModel().getSchemaSourcesVersion((BasicSchema)schema);
            if (this.getMode().increment) {
                Long l2 = existentSourcesTx;
                l = l2 != null ? l2 : 0L;
            } else {
                l = 0L;
            }
            this.srcFromTx = l;
            this.prepareParameters();
        }

        @Override
        public boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull S schema) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            return true;
        }

        @Override
        public final void prepareParameters() {
            super.prepareParameters();
            long stateNumber = this.getMode().increment ? ((PgBaseSchema)this.getSchema()).getIntrospectionStateNumber() : 0L;
            this.this$0.setTx(this, stateNumber, "tx", "TXAGE");
            this.this$0.setTx(this, this.getWithSources() ? this.srcFromTx : stateNumber, "src_tx", "SRCTXAGE");
        }

        @Override
        public void processPreliminaryPhase() {
            if (this.getMode().fragment) {
                return;
            }
            this.analyzeBriefInfo();
            this.analyzeCurrentContent();
        }

        @Override
        protected void analyzeBriefInfo() {
            long stateNumber;
            long l = stateNumber = this.getMode().increment ? ((PgBaseSchema)this.getSchema()).getIntrospectionStateNumber() : 0L;
            this.myHasChanges = this.getMode().full || this.this$0.getQueries().checkSchemaChanges(this.getTransaction(), stateNumber, this.getWithSources() ? this.srcFromTx : stateNumber, (PgBaseSchema)this.getSchema());
        }

        private final void removeDroppedComments(Long2ObjectMap<Short[]> existentComments) {
            this.inSchema(arg_0 -> SchemaRetriever.removeDroppedComments$lambda$0(this, existentComments, arg_0));
        }

        @NotNull
        protected abstract Long2ObjectMap<Short[]> listExistentComments();

        protected void removeComments(@NotNull Long2ObjectMap<Short[]> existentComments, @NotNull BasicModIdentifiedElement e) {
            Object[] commented;
            Intrinsics.checkNotNullParameter(existentComments, (String)"existentComments");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            BasicModNamedElement cfr_ignored_0 = (BasicModNamedElement)((Object)e);
            Object[] objectArray = (Short[])existentComments.get(((BasicIdentifiedElement)e).getObjectId());
            if (objectArray == null) {
                objectArray = new Short[]{};
            }
            if (!ArraysKt.contains((Object[])(commented = objectArray), (Object)0)) {
                ((BasicModNamedElement)((Object)e)).setComment(null);
            }
            if (e instanceof PgBaseDefType) {
                for (PgBaseDefTypeAttribute pgBaseDefTypeAttribute : ((PgBaseDefType)e).getAttributes()) {
                    if (ArraysKt.contains((Object[])commented, (Object)pgBaseDefTypeAttribute.getPosition())) continue;
                    pgBaseDefTypeAttribute.setComment(null);
                }
            }
            if (e instanceof PgBaseLikeTable) {
                for (PgBaseLikeColumn pgBaseLikeColumn : ((PgBaseLikeTable)e).getColumns()) {
                    if (ArraysKt.contains((Object[])commented, (Object)pgBaseLikeColumn.getPosition())) continue;
                    pgBaseLikeColumn.setComment(null);
                }
                for (BasicModKey basicModKey : ((PgBaseLikeTable)e).getKeys()) {
                    Intrinsics.checkNotNull((Object)basicModKey, (String)"null cannot be cast to non-null type com.intellij.database.dialects.postgresbase.model.PgBaseKey");
                    this.removeComments(existentComments, (PgBaseKey)basicModKey);
                }
                for (BasicModForeignKey basicModForeignKey : ((PgBaseLikeTable)e).getForeignKeys()) {
                    Intrinsics.checkNotNull((Object)basicModForeignKey, (String)"null cannot be cast to non-null type com.intellij.database.dialects.postgresbase.model.PgBaseForeignKey");
                    this.removeComments(existentComments, (PgBaseForeignKey)basicModForeignKey);
                }
            }
        }

        @NotNull
        protected ModIdentifyingFamily<? extends BasicModIdentifiedElement>[] getSchemaChildrenToDrop(@NotNull S schema) {
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            ModIdentifyingFamily[] modIdentifyingFamilyArray = new ModIdentifyingFamily[]{schema.getDefTypes(), schema.getTables(), schema.getViews(), schema.getMatViews(), schema.getRoutines(), schema.getOperators(), schema.getAggregates()};
            return modIdentifyingFamilyArray;
        }

        @Override
        protected void retrieveMainContent() {
            List<IntroStep> steps = this.steps();
            CollectionsKt.sort(steps);
            boolean loadNew = !this.getMode().increment || this.myHasChanges;
            for (IntroStep step2 : steps) {
                step2.getPerform().invoke((Object)this.getMode().increment, (Object)loadNew);
            }
            if (!loadNew) {
                this.performNonIncrementalPart();
            }
        }

        protected void performNonIncrementalPart() {
            if (!this.incrementalColAcl()) {
                List<PgObjectGrant> newGrants = ((PgBaseGrantsHolder)this.getSchema()).getGrants().toMutableList();
                this.retrieveColumnAcl(newGrants);
                ((PgBaseGrantsHolder)this.getSchema()).setGrants(((PgBaseGrantsHolder)this.getSchema()).getGrants().with((Iterable<PgObjectGrant>)newGrants));
            }
        }

        protected boolean incrementalViewSources() {
            return false;
        }

        protected boolean incrementalColAcl() {
            return true;
        }

        @Override
        protected long getSchemaStateNumber() {
            Long l = this.this$0.getIntrospectionXid();
            return l != null ? l.longValue() : ((PgBaseSchema)this.getSchema()).getIntrospectionStateNumber();
        }

        @Override
        protected void finishSchema() {
            super.finishSchema();
            this.inSchema(arg_0 -> SchemaRetriever.finishSchema$lambda$1(this.this$0, arg_0));
        }

        @NotNull
        protected List<IntroStep> steps() {
            return PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(new ArrayList(), 10, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)(arg_0, arg_1) -> SchemaRetriever.steps$lambda$2(this, arg_0, arg_1))), 20, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)(arg_0, arg_1) -> SchemaRetriever.steps$lambda$3(this, arg_0, arg_1))), 30, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)(arg_0, arg_1) -> SchemaRetriever.steps$lambda$4(this, arg_0, arg_1))), 40, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)(arg_0, arg_1) -> SchemaRetriever.steps$lambda$5(this, arg_0, arg_1))), 45, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)(arg_0, arg_1) -> SchemaRetriever.steps$lambda$6(this, arg_0, arg_1))), 50, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)(arg_0, arg_1) -> SchemaRetriever.steps$lambda$7(this, arg_0, arg_1))), 60, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)(arg_0, arg_1) -> SchemaRetriever.steps$lambda$8(this, arg_0, arg_1))), 70, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)(arg_0, arg_1) -> SchemaRetriever.steps$lambda$9(this, arg_0, arg_1))), 80, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)(arg_0, arg_1) -> SchemaRetriever.steps$lambda$10(this, arg_0, arg_1))), 90, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)(arg_0, arg_1) -> SchemaRetriever.steps$lambda$11(this, arg_0, arg_1))), 99, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)(arg_0, arg_1) -> SchemaRetriever.steps$lambda$12(this, arg_0, arg_1))), 100, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)(arg_0, arg_1) -> SchemaRetriever.steps$lambda$13(this, arg_0, arg_1))), 110, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)(arg_0, arg_1) -> SchemaRetriever.steps$lambda$14(this, arg_0, arg_1)));
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveAcls(boolean detectDropped, boolean loadNew) {
            this.this$0.reportRetrieving("ACL", "introspection.retrieve.ACL");
            BaseNativeIntrospector baseNativeIntrospector = this.this$0;
            PgBaseIntrospector pgBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl = false;
                Grants.Controller<PgObjectGrant, ?> ctl = ((PgBaseGrantsHolder)this.getSchema()).getGrants().getController();
                List<PgObjectGrant> newGrants = ((PgBaseGrantsHolder)this.getSchema()).getGrants().toMutableList();
                if (detectDropped) {
                    newGrants.removeIf(arg_0 -> SchemaRetriever.retrieveAcls$lambda$22$lambda$16(arg_0 -> SchemaRetriever.retrieveAcls$lambda$22$lambda$15(ctl, this, arg_0), arg_0));
                }
                if (loadNew) {
                    Long l = ((PgBaseSchema)this.getSchema()).getIntrospectionStateNumber();
                    long it = ((Number)l).longValue();
                    boolean bl2 = false;
                    Long tx = detectDropped ? l : null;
                    Lexer lexer = pgBaseIntrospector.getSqlHelper().createLexer();
                    NamingService ns = NamingServices.getNamingService(pgBaseIntrospector.dbms, this.getModel(), ((PgBaseSchema)this.getSchema()).getDatabase());
                    pgBaseIntrospector.getQueries().processObjectAcls(this.getTransaction(), (PgBaseSchema)this.getSchema(), tx, (Function1<? super PgBaseIntroQueries.OneAcl, Unit>)((Function1)arg_0 -> SchemaRetriever.retrieveAcls$lambda$22$lambda$21(newGrants, pgBaseIntrospector, lexer, ns, arg_0)));
                    this.retrieveColumnAcl(newGrants);
                }
                ((PgBaseGrantsHolder)this.getSchema()).setGrants(((PgBaseGrantsHolder)this.getSchema()).getGrants().with((Iterable<PgObjectGrant>)newGrants));
            }
            catch (DBException e$iv) {
                void this_$iv;
                this_$iv.getErrorSink().accept(null, e$iv);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveColumnAcl(List<PgObjectGrant> newGrants) {
            Long l = ((PgBaseSchema)this.getSchema()).getIntrospectionStateNumber();
            long it22 = ((Number)l).longValue();
            boolean bl = false;
            Long tx = this.getMode().increment ? l : null;
            ArrayList columns = new ArrayList();
            BaseNativeIntrospector it22 = this.this$0;
            PgBaseIntrospector pgBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl2 = false;
                pgBaseIntrospector.getQueries().processColumnAcls(this.getTransaction(), (PgBaseSchema)this.getSchema(), tx, (Function1<? super PgBaseIntroQueries.AttrAcl, Unit>)((Function1)arg_0 -> SchemaRetriever.retrieveColumnAcl$lambda$28$lambda$27(newGrants, columns, this, arg_0)));
            }
            catch (DBException e$iv) {
                void this_$iv;
                this_$iv.getErrorSink().accept(null, e$iv);
            }
            this.toGrants(columns, newGrants);
        }

        /*
         * WARNING - void declaration
         */
        private final void toGrants(List<PgBaseIntroQueries.AttrAcl> $this$toGrants, List<PgObjectGrant> newGrants) {
            void $this$forEach$iv;
            void $this$groupByTo$iv$iv;
            Map $this$groupBy$iv;
            if ($this$toGrants.isEmpty()) {
                return;
            }
            long objectId = ((PgBaseIntroQueries.AttrAcl)CollectionsKt.first($this$toGrants)).object_id;
            Lexer lexer = this.this$0.getSqlHelper().createLexer();
            NamingService ns = NamingServices.getNamingService(this.this$0.dbms, this.getModel(), ((PgBaseSchema)this.getSchema()).getDatabase());
            Sequence sequence = SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)$this$toGrants), arg_0 -> SchemaRetriever.toGrants$lambda$31(this.this$0, lexer, ns, arg_0));
            boolean $i$f$groupBy = false;
            Iterator iterator = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                kotlin.Pair it = (kotlin.Pair)element$iv$iv;
                boolean bl = false;
                Long key$iv$iv = ((PgAclItem)it.getSecond()).getGrantee();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv;
            boolean $i$f$forEach = false;
            iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                long granteeId = ((Number)entry.getKey()).longValue();
                List grants = (List)entry.getValue();
                this.toGrants(grants, objectId, granteeId, newGrants);
            }
        }

        private final void toGrants(List<kotlin.Pair<Integer, PgAclItem>> $this$toGrants, long objectId, long granteeId, List<PgObjectGrant> newGrants) {
            if (newGrants.isEmpty()) {
                return;
            }
            BitSet columns = new BitSet();
            for (PgPrivilege privilege : PgPrivilege.values()) {
                Iterable $this$forEach$iv = (Iterable)new IntRange(0, 1);
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int g = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl = false;
                    for (kotlin.Pair<Integer, PgAclItem> acl : $this$toGrants) {
                        Iterable $this$forEach$iv2 = g == 1 ? ((PgAclItem)acl.getSecond()).getGrantablePrivileges() : ((PgAclItem)acl.getSecond()).getPrivileges();
                        boolean $i$f$forEach2 = false;
                        for (Object element$iv2 : $this$forEach$iv2) {
                            PgPrivilege p2 = (PgPrivilege)((Object)element$iv2);
                            boolean bl2 = false;
                            if (p2 != privilege) continue;
                            columns.set(((Number)acl.getFirst()).intValue());
                        }
                    }
                    if (columns.isEmpty()) continue;
                    newGrants.add(new PgObjectGrant(objectId, columns, granteeId, privilege.name(), g == 1 ? Grants.State.GRANT_WITH_GRANT_OPTION : Grants.State.GRANT));
                    columns.clear();
                }
            }
        }

        protected void retrieveDataTypes(boolean detectDropped, boolean loadNew) {
            this.this$0.reportRetrieving("data types", "introspection.retrieve.types");
            this.inSchema(arg_0 -> SchemaRetriever.retrieveDataTypes$lambda$40(this.this$0, detectDropped, this, loadNew, arg_0));
        }

        protected void processDataType(@NotNull PgBaseDefType dataType, @NotNull PgBaseIntroQueries.OneDataType oneType, @NotNull S schema) {
            Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
            Intrinsics.checkNotNullParameter((Object)oneType, (String)"oneType");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            PgDataTypeSubKind subKind = PgDataTypeSubKind.of(oneType.type_sub_kind);
            dataType.setStateNumber(oneType.type_state_number);
            dataType.setSubKind(subKind);
            String string = PgBaseIntrospectorKt.access$adjustedTypeSpec(oneType);
            dataType.setDefinition(string != null ? PgBaseIntrospectorKt.normalizeDataTypeSpec(string) : null);
            dataType.setDefaultExpression(oneType.default_expression);
            dataType.setNotNull(oneType.mandatory);
            this.wasStructures = this.wasStructures || subKind == PgDataTypeSubKind.COMPOSITE;
        }

        private final void retrieveTables(boolean detectDropped, boolean loadNew) {
            this.this$0.reportRetrieving("tables and views", "introspection.retrieve.tablesViews");
            this.inSchema(arg_0 -> SchemaRetriever.retrieveTables$lambda$44(this, this.this$0, detectDropped, loadNew, arg_0));
        }

        @NotNull
        protected ModNamingIdentifyingFamily<? extends PgBaseLikeStoredTable>[] tableFamilies(@NotNull S sc) {
            Intrinsics.checkNotNullParameter(sc, (String)"sc");
            ModNamingIdentifyingFamily[] modNamingIdentifyingFamilyArray = new ModNamingIdentifyingFamily[]{sc.getTables(), sc.getViews(), sc.getMatViews()};
            return modNamingIdentifyingFamilyArray;
        }

        protected void loadTables(@NotNull S schema) {
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this, this.this$0.getQueries().getRetrieveTables(), 0, arg_0 -> SchemaRetriever.loadTables$lambda$45(this, schema, arg_0), 2, null);
        }

        protected final void processTable(@NotNull S schema, @NotNull PgBaseIntroQueries.OneTable t) {
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            char c2 = t.table_kind;
            long l = t.table_id;
            String string = t.table_name;
            Intrinsics.checkNotNull((Object)string);
            PgBaseLikeStoredTable pgBaseLikeStoredTable = this.renewTableOrView(schema, c2, l, string);
            if (pgBaseLikeStoredTable == null) {
                return;
            }
            PgBaseLikeStoredTable table = pgBaseLikeStoredTable;
            this.processTable(table, schema, t);
        }

        protected void processTable(@NotNull PgBaseLikeStoredTable table, @NotNull S schema, @NotNull PgBaseIntroQueries.OneTable oneTable) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)oneTable, (String)"oneTable");
            table.setStateNumber(oneTable.table_state_number);
            table.setOwnerRef(BasicNameReference.create(oneTable.getOwnerName()));
            PgBaseLikeStoredTable pgBaseLikeStoredTable = table;
            if (pgBaseLikeStoredTable instanceof PgBaseTable) {
                this.processModTable((PgBaseTable)table, oneTable);
            } else if (pgBaseLikeStoredTable instanceof PgBaseView) {
                this.processModView(table, oneTable);
            }
            this.wasTables = this.wasTables || this.isTableKind(oneTable.table_kind);
            this.wasViews = this.wasViews || oneTable.table_kind == 'v';
            this.wasMatViews = this.wasMatViews || oneTable.table_kind == 'm';
        }

        private final PgBaseLikeStoredTable renewTableOrView(S schema, char relKind, long objectId, String objectName) {
            BasicIdentifiedElement basicIdentifiedElement;
            PgBaseLikeStoredTable pgBaseLikeStoredTable;
            PgBaseDatabase pgBaseDatabase = schema.getDatabase();
            Intrinsics.checkNotNull((Object)pgBaseDatabase);
            BasicIdentifiedElement existing2 = pgBaseDatabase.findIdentifiedElement(objectId);
            PgBaseLikeStoredTable newRelation = this.renewTableOrViewImpl(schema, relKind, objectId, objectName);
            BasicIdentifiedElement $this$asSafely$iv = existing2;
            boolean $i$f$asSafely = false;
            BasicIdentifiedElement basicIdentifiedElement2 = $this$asSafely$iv;
            if (!(basicIdentifiedElement2 instanceof PgBaseLikeStoredTable)) {
                basicIdentifiedElement2 = null;
            }
            if ((pgBaseLikeStoredTable = (PgBaseLikeStoredTable)basicIdentifiedElement2) != null) {
                BasicIdentifiedElement it = $this$asSafely$iv = pgBaseLikeStoredTable;
                boolean bl = false;
                basicIdentifiedElement = newRelation != null && !Intrinsics.areEqual((Object)it, (Object)newRelation) && Intrinsics.areEqual((Object)it.getSchema(), schema) ? $this$asSafely$iv : null;
            } else {
                basicIdentifiedElement = null;
            }
            BasicIdentifiedElement it = basicIdentifiedElement;
            boolean bl = false;
            return this.preventDuplicates(newRelation, (PgBaseLikeStoredTable)it);
        }

        @Nullable
        protected PgBaseLikeStoredTable renewTableOrViewImpl(@NotNull S schema, char relKind, long objectId, @NotNull String objectName) {
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)objectName, (String)"objectName");
            return this.isTableKind(relKind) ? (PgBaseLikeStoredTable)schema.getTables().renew(objectId, objectName) : (relKind == 'v' ? (PgBaseLikeStoredTable)schema.getViews().renew(objectId, objectName) : (relKind == 'm' ? (PgBaseLikeStoredTable)schema.getMatViews().renew(objectId, objectName) : null));
        }

        @Nullable
        protected PgBaseLikeStoredTable preventDuplicates(@Nullable PgBaseLikeStoredTable newRelation, @Nullable PgBaseLikeStoredTable existing2) {
            block0: {
                PgBaseLikeStoredTable pgBaseLikeStoredTable = existing2;
                if (pgBaseLikeStoredTable == null) break block0;
                pgBaseLikeStoredTable.drop();
            }
            return newRelation;
        }

        protected boolean isTableKind(char kind) {
            return kind == 'r';
        }

        /*
         * WARNING - void declaration
         */
        protected void retrieveStructAttributes() {
            if (!(this.wasStructures || this.getMode().increment && ((PgBaseSchema)this.getSchema()).getDefTypes().hasChildren())) {
                return;
            }
            ObjectKind objectKind = ObjectKind.OBJECT_ATTRIBUTE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"OBJECT_ATTRIBUTE");
            this.this$0.reportRetrieving(objectKind);
            BaseNativeIntrospector baseNativeIntrospector = this.this$0;
            PgBaseIntrospector pgBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl = false;
                List<PgBaseIntroQueries.OneStructAttribute> ats = this.performQuery(pgBaseIntrospector.getQueries().getRetrieveStructAttributes());
                if (ats.isEmpty()) {
                    return;
                }
                this.inSchema(arg_0 -> SchemaRetriever.retrieveStructAttributes$lambda$52$lambda$51(ats, arg_0));
            }
            catch (DBException e$iv) {
                void this_$iv;
                this_$iv.getErrorSink().accept(null, e$iv);
            }
        }

        /*
         * WARNING - void declaration
         */
        protected void obtainUsedTypes() {
            BaseNativeIntrospector baseNativeIntrospector = this.this$0;
            PgBaseIntrospector pgBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl = false;
                Map<Long, String> typeSpecs = this.performQuery(pgBaseIntrospector.getQueries().getRetrieveUsedArgumentTypes());
                this.setMyTypes(new HashMap(typeSpecs.size()));
                for (Map.Entry<Long, String> entry : typeSpecs.entrySet()) {
                    DataType type;
                    long typeId = ((Number)entry.getKey()).longValue();
                    String typeSpec = entry.getValue();
                    typeSpec = PgBaseIntrospectorKt.normalizeDataTypeSpec(typeSpec);
                    Intrinsics.checkNotNullExpressionValue((Object)DataTypeFactory.of(typeSpec), (String)"of(...)");
                    Long l = typeId;
                    this.getMyTypes().put(l, DasUnresolvedTypeReference.Companion.of(type));
                }
            }
            catch (DBException e$iv) {
                void this_$iv;
                this_$iv.getErrorSink().accept(null, e$iv);
            }
        }

        protected void retrieveRoutines(boolean detectDropped, boolean loadNew) {
            ObjectKind objectKind = ObjectKind.ROUTINE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ROUTINE");
            this.this$0.reportRetrieving(objectKind);
            this.inSchema(arg_0 -> SchemaRetriever.retrieveRoutines$lambda$59(this.this$0, detectDropped, this, loadNew, arg_0));
        }

        public <T extends PgBaseArgument> void processArgExtra(@NotNull T argument, @Nullable Character argMode) {
            Intrinsics.checkNotNullParameter(argument, (String)"argument");
        }

        private final <T extends PgBaseArgument> void processArgs(PgBaseIntroQueries.ArgumentHolder r, ModPositioningNamingFamily<T> family, BasicModRoutine routine2) {
            NamingService namingService = NamingServices.getNamingService$default(this.this$0.dbms, null, null, 6, null);
            String[] argNames = r.getArgNames();
            char[] argModes = PgBaseIntrospectorKt.stringsToChars(r.getArgModes());
            long[] argTypeIds = r.getArgTypes();
            int argNamesCount = argNames != null ? argNames.length : 0;
            int n = Math.max(argNamesCount, argModes.length);
            int n2 = argTypeIds != null ? argTypeIds.length : 0;
            int n3 = Math.max(n, n2);
            String resultType = null;
            StringBuilder resultArguments = null;
            int i2 = 0;
            int n4 = n3 - 1;
            if (i2 <= n4) {
                while (true) {
                    DasType dt;
                    String string;
                    ArgumentDirection direction;
                    Character argMode;
                    Character c2;
                    Character c3 = c2 = (argMode = ArraysKt.getOrNull((char[])argModes, (int)i2));
                    char c4 = 'b';
                    if (c3 != null && c3.charValue() == c4) {
                        v1 = ArgumentDirection.INOUT;
                    } else {
                        Character c5 = c2;
                        c4 = 'o';
                        if (c5 != null && c5.charValue() == c4) {
                            v1 = ArgumentDirection.OUT;
                        } else {
                            Character c6 = c2;
                            c4 = 't';
                            v1 = direction = c6 != null && c6.charValue() == c4 ? ArgumentDirection.RESULT : ArgumentDirection.IN;
                        }
                    }
                    if (i2 < argNamesCount) {
                        Intrinsics.checkNotNull((Object)argNames);
                        string = argNames[i2];
                    } else {
                        string = null;
                    }
                    String argName = string;
                    DasType dasType = DasTypeSystemBase.UNKNOWN;
                    Intrinsics.checkNotNull((Object)argTypeIds);
                    if (i2 < argTypeIds.length && (dt = this.getMyTypes().get(argTypeIds[i2])) != null) {
                        dasType = dt;
                    }
                    if (r instanceof PgBaseIntroQueries.OneRoutine && ((PgBaseIntroQueries.OneRoutine)r).ret_set && direction == ArgumentDirection.RESULT) {
                        if (resultType == null || resultArguments == null) {
                            resultType = "table";
                            resultArguments = new StringBuilder();
                        } else {
                            resultArguments.append(", ");
                        }
                        if (argName != null) {
                            resultArguments.append(namingService.enquote(argName, ObjectKind.ARGUMENT)).append(' ');
                        }
                        resultArguments.append(dasType.getSpecification());
                    } else {
                        short position = (short)(i2 + 1);
                        PgBaseArgument argument = (PgBaseArgument)family.getByNaturalPosition(position);
                        if (argument == null) {
                            argument = (PgBaseArgument)family.createNewOne();
                            ((BasicModArrangedElement)argument).setPosition(position);
                        } else {
                            ((BasicModMixinElement)argument).resetSyncPending();
                        }
                        ((BasicModMixinNamedElement)argument).setRealName(argName);
                        ((BasicModArgument)argument).setArgumentDirection(direction);
                        ((BasicModTypedElement)argument).setStoredType(dasType);
                        this.processArgExtra(argument, argMode);
                    }
                    if (i2 == n4) break;
                    ++i2;
                }
            }
            Object $this$asSafely$iv = r;
            boolean $i$f$asSafely = false;
            Object object = $this$asSafely$iv;
            if (!(object instanceof PgBaseIntroQueries.OneRoutine)) {
                object = null;
            }
            PgBaseIntroQueries.OneRoutine oneRoutine = (PgBaseIntroQueries.OneRoutine)object;
            boolean bl = oneRoutine != null ? oneRoutine.kind == 'p' : false;
            if (bl) {
                $this$asSafely$iv = routine2.getReturnArgument();
                BasicModArgument basicModArgument = $this$asSafely$iv instanceof BasicModArgument ? (BasicModArgument)$this$asSafely$iv : null;
                if (basicModArgument != null) {
                    basicModArgument.drop();
                }
            } else {
                BasicModArgument basicModArgument = routine2.createOrGetReturnArgument();
                Intrinsics.checkNotNullExpressionValue((Object)basicModArgument, (String)"createOrGetReturnArgument(...)");
                BasicModArgument returns = basicModArgument;
                if (resultType != null) {
                    StringBuilder stringBuilder = resultArguments;
                    Intrinsics.checkNotNull(stringBuilder);
                    DataType dataType = DataTypeFactory.ofArgs(null, resultType, stringBuilder.toString(), false);
                    Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"ofArgs(...)");
                    DataType resultDataType = dataType;
                    returns.setArgumentDirection(ArgumentDirection.RESULT);
                    returns.setStoredType(DasUnresolvedTypeReference.Companion.of(resultDataType));
                } else if (r.getReturnType() != 0L) {
                    DasType retType;
                    returns.setArgumentDirection(ArgumentDirection.RETURN);
                    DasType dasType = this.getMyTypes().get(r.getReturnType());
                    if (dasType == null) {
                        dasType = retType = (DasType)DasTypeSystemBase.UNKNOWN;
                    }
                    if (r.getReturnsSet()) {
                        DataType dataType = DataTypeFactory.of("setof " + retType.getSpecification());
                        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                        retType = DasUnresolvedTypeReference.Companion.of(dataType);
                    }
                    returns.setStoredType(retType);
                }
                returns.setRealName(null);
                returns.setPosition((short)0);
                returns.setDefaultExpression(null);
            }
        }

        @NotNull
        protected PgBaseRoutine createRoutine(@NotNull S schema, @NotNull PgBaseIntroQueries.OneRoutine r) {
            PgBaseRoutine pgBaseRoutine;
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            PgBaseRoutine pgBaseRoutine2 = schema.getRoutines().renew(r.r_id, r.r_name);
            Intrinsics.checkNotNullExpressionValue((Object)pgBaseRoutine2, (String)"renew(...)");
            PgBaseRoutine $this$createRoutine_u24lambda_u2460 = pgBaseRoutine = pgBaseRoutine2;
            boolean bl = false;
            $this$createRoutine_u24lambda_u2460.setSecurityDefiner(r.is_security_definer);
            if (r.configuration_parameters != null) {
                Intrinsics.checkNotNull((Object)r.configuration_parameters);
                $this$createRoutine_u24lambda_u2460.setConfigurationParameters(ArraysKt.toMutableList((Object[])r.configuration_parameters));
            }
            return pgBaseRoutine;
        }

        protected void retrieveAggregates(boolean detectDropped, boolean loadNew) {
            ObjectKind objectKind = ObjectKind.AGGREGATE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"AGGREGATE");
            this.this$0.reportRetrieving(objectKind);
            this.inSchema(arg_0 -> SchemaRetriever.retrieveAggregates$lambda$65(this.this$0, detectDropped, this, loadNew, arg_0));
        }

        protected void processAggregate(@NotNull PgBaseIntroQueries.OneAggregate agg, @NotNull PgBaseAggregate aggregate) {
            Intrinsics.checkNotNullParameter((Object)agg, (String)"agg");
            Intrinsics.checkNotNullParameter((Object)aggregate, (String)"aggregate");
            aggregate.setTransitionRef(this.this$0.createIdOrQNameRef(agg.transition_function_id, agg.transition_function_name, ((PgBaseIntrospector)this.this$0).getDbConnectionInfo().schemaName));
            aggregate.setFinalRef(this.this$0.createIdOrQNameRef(agg.final_function_id, agg.final_function_name, ((PgBaseIntrospector)this.this$0).getDbConnectionInfo().schemaName));
            aggregate.setInitialValue(agg.initial_value);
            DasType dasType = this.getMyTypes().get(agg.transition_type);
            if (dasType == null) {
                dasType = DasTypeSystemBase.UNKNOWN;
            }
            aggregate.setTransitionStoredType(dasType);
        }

        protected void retrieveOperators(boolean detectDropped, boolean loadNew) {
            ObjectKind objectKind = ObjectKind.OPERATOR;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"OPERATOR");
            this.this$0.reportRetrieving(objectKind);
            this.inSchema(arg_0 -> SchemaRetriever.retrieveOperators$lambda$70(this.this$0, detectDropped, this, loadNew, arg_0));
        }

        protected void processOperator(@NotNull PgBaseIntroQueries.OneOperator o, @NotNull PgBaseOperator operator) {
            String string;
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
            operator.setStateNumber(o.state_number);
            operator.setOperatorKind(PgOperatorKind.of(o.op_kind));
            DasType dasType = o.arg_left_type_id > 0L ? this.getMyTypes().get(o.arg_left_type_id) : null;
            if (dasType == null) {
                dasType = DasTypeSystemBase.UNKNOWN;
            }
            operator.setLeftStoredType(dasType);
            DasType dasType2 = o.arg_right_type_id > 0L ? this.getMyTypes().get(o.arg_right_type_id) : null;
            if (dasType2 == null) {
                dasType2 = DasTypeSystemBase.UNKNOWN;
            }
            operator.setRightStoredType(dasType2);
            DasType dasType3 = o.arg_result_type_id > 0L ? this.getMyTypes().get(o.arg_result_type_id) : null;
            if (dasType3 == null) {
                dasType3 = DasTypeSystemBase.UNKNOWN;
            }
            operator.setResultStoredType(dasType3);
            operator.setCallRoutineRef(this.this$0.createIdOrQNameRef(o.main_id, o.main_name, ((PgBaseIntrospector)this.this$0).getDbConnectionInfo().schemaName));
            String string2 = string = o.join_name;
            long l = o.join_id;
            PgBaseIntrospector pgBaseIntrospector = this.this$0;
            PgBaseOperator pgBaseOperator = operator;
            boolean bl = false;
            boolean bl2 = o.join_id != 0L;
            pgBaseOperator.setJoinRoutineRef(pgBaseIntrospector.createIdOrQNameRef(l, bl2 ? string : null, ((PgBaseIntrospector)this.this$0).getDbConnectionInfo().schemaName));
            String it = string = o.restrict_name;
            l = o.restrict_id;
            pgBaseIntrospector = this.this$0;
            pgBaseOperator = operator;
            boolean bl3 = false;
            bl2 = o.restrict_id != 0L;
            pgBaseOperator.setRestrictRoutineRef(pgBaseIntrospector.createIdOrQNameRef(l, bl2 ? string : null, ((PgBaseIntrospector)this.this$0).getDbConnectionInfo().schemaName));
            it = string = o.neg_name;
            l = o.neg_id;
            pgBaseIntrospector = this.this$0;
            pgBaseOperator = operator;
            boolean bl4 = false;
            bl2 = o.neg_id != 0L;
            pgBaseOperator.setNegateOperatorRef(pgBaseIntrospector.createIdOrQNameRef(l, bl2 ? string : null, ((PgBaseIntrospector)this.this$0).getDbConnectionInfo().schemaName));
            it = string = o.com_name;
            l = o.com_id;
            pgBaseIntrospector = this.this$0;
            pgBaseOperator = operator;
            boolean bl5 = false;
            bl2 = o.com_id != 0L;
            pgBaseOperator.setCommuteOperatorRef(pgBaseIntrospector.createIdOrQNameRef(l, bl2 ? string : null, ((PgBaseIntrospector)this.this$0).getDbConnectionInfo().schemaName));
            operator.setHashes(o.hashes);
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveTableColumns() {
            if (!this.shouldIntrospectTableRelatedData()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.COLUMN;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN");
            this.this$0.reportRetrieving(objectKind);
            BaseNativeIntrospector baseNativeIntrospector = this.this$0;
            PgBaseIntrospector pgBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl = false;
                List<PgBaseIntroQueries.OneColumn> cols = this.performQuery(pgBaseIntrospector.getQueries().getRetrieveColumns());
                if (cols.isEmpty()) {
                    return;
                }
                this.inSchema(arg_0 -> SchemaRetriever.retrieveTableColumns$lambda$76$lambda$75(this, cols, arg_0));
            }
            catch (DBException e$iv) {
                void this_$iv;
                this_$iv.getErrorSink().accept(null, e$iv);
            }
        }

        /*
         * WARNING - void declaration
         */
        protected void processColumns(@NotNull List<PgBaseIntroQueries.OneColumn> cols, @NotNull S schema) {
            void $this$groupByTo$iv$iv;
            Intrinsics.checkNotNullParameter(cols, (String)"cols");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            Iterable $this$groupBy$iv = cols;
            boolean $i$f$groupBy = false;
            Object object = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object2;
                PgBaseIntroQueries.OneColumn it = (PgBaseIntroQueries.OneColumn)element$iv$iv;
                boolean bl = false;
                Long key$iv$iv = it.table_id;
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            Map $this$forEach$iv = destination$iv$iv;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv.entrySet().iterator();
            while (object.hasNext()) {
                PgBaseLikeStoredTable table;
                Map.Entry element$iv;
                Map.Entry entry = element$iv = (Map.Entry)object.next();
                boolean bl = false;
                if (this.getTableOrView(schema, '\u0000', ((Number)entry.getKey()).longValue()) == null) continue;
                ModFamily $this$modifyAndCleanup_u24default$iv = (ModFamily)((Object)table.getColumns());
                boolean removeUnaffected$iv = true;
                boolean $i$f$modifyAndCleanup = false;
                $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                ModPositioningNamingFamily columns = (ModPositioningNamingFamily)$this$modifyAndCleanup_u24default$iv;
                boolean bl3 = false;
                for (PgBaseIntroQueries.OneColumn col : (List)entry.getValue()) {
                    PgBaseLikeColumn pgBaseLikeColumn;
                    if (col.column_is_dropped) continue;
                    if (col.column_position >= 1) {
                        Object e = columns.createOrGetAt(col.column_position);
                        Intrinsics.checkNotNullExpressionValue(e, (String)"createOrGetAt(...)");
                        pgBaseLikeColumn = (PgBaseLikeColumn)e;
                    } else {
                        String string = col.column_name;
                        Intrinsics.checkNotNull((Object)string);
                        Object e = columns.createOrGet(string);
                        Intrinsics.checkNotNullExpressionValue(e, (String)"createOrGet(...)");
                        pgBaseLikeColumn = (PgBaseLikeColumn)e;
                    }
                    PgBaseLikeColumn column2 = pgBaseLikeColumn;
                    Intrinsics.checkNotNull((Object)columns);
                    this.processColumn(col, column2, columns, table);
                }
                $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                $this$modifyAndCleanup_u24default$iv.sort();
            }
        }

        protected void processColumn(@NotNull PgBaseIntroQueries.OneColumn col, @NotNull PgBaseLikeColumn column2, @NotNull ModPositioningNamingFamily<? extends PgBaseLikeColumn> columns, @NotNull PgBaseLikeStoredTable table) {
            String newName;
            Intrinsics.checkNotNullParameter((Object)col, (String)"col");
            Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            column2.setPosition(col.column_position);
            String string = column2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String oldName = string;
            String string2 = col.column_name;
            if (string2 == null) {
                String string3 = ModelConsts.NO_NAME;
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"NO_NAME");
            }
            if (!Intrinsics.areEqual((Object)oldName, (Object)(newName = string2))) {
                column2.setName(newName);
                if (!Intrinsics.areEqual((Object)oldName, (Object)ModelConsts.NO_NAME)) {
                    this.handleColumnRenaming(table, oldName, newName);
                }
            }
            column2.resetSyncPending();
            column2.setStateNumber(col.column_state_number);
            column2.setStoredType(PgBaseIntrospectorKt.dasTypeOf(col));
            column2.setNotNull(col.mandatory);
            if (column2 instanceof PgBaseTableColumn) {
                ((PgBaseTableColumn)column2).setDefaultExpression(StringKt.nullize$default((String)col.column_default_expression, (boolean)false, (int)1, null));
            }
            column2.setNameSurrogate(this.this$0.isColumnNameSurrogate(col.column_name));
        }

        protected char adjustRelKind(char kind, @Nullable String name2) {
            return kind;
        }

        @Nullable
        protected PgBaseLikeStoredTable getTableOrView(@NotNull S schema, char relKind, long tableId) {
            PgBaseLikeStoredTable pgBaseLikeStoredTable;
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            char lowerCaseKind = Character.toLowerCase(relKind);
            if (this.isTableKind(lowerCaseKind)) {
                pgBaseLikeStoredTable = (PgBaseLikeStoredTable)schema.getTables().getByObjectId(tableId);
            } else {
                switch (lowerCaseKind) {
                    case 'v': {
                        pgBaseLikeStoredTable = (PgBaseLikeStoredTable)schema.getViews().getByObjectId(tableId);
                        break;
                    }
                    case 'm': {
                        pgBaseLikeStoredTable = (PgBaseLikeStoredTable)schema.getMatViews().getByObjectId(tableId);
                        break;
                    }
                    case '\u0000': {
                        PgBaseRegularTable pgBaseRegularTable = (PgBaseRegularTable)schema.getTables().getByObjectId(tableId);
                        if (pgBaseRegularTable != null) {
                            pgBaseLikeStoredTable = pgBaseRegularTable;
                            break;
                        }
                        PgBaseView pgBaseView = (PgBaseView)schema.getViews().getByObjectId(tableId);
                        if (pgBaseView != null) {
                            pgBaseLikeStoredTable = pgBaseView;
                            break;
                        }
                        pgBaseLikeStoredTable = (PgBaseLikeStoredTable)schema.getMatViews().getByObjectId(tableId);
                        break;
                    }
                    default: {
                        pgBaseLikeStoredTable = null;
                    }
                }
            }
            return pgBaseLikeStoredTable;
        }

        protected void handleColumnRenaming(@NotNull PgBaseLikeStoredTable table, @NotNull String oldName, @NotNull String tableName) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
            Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
            ObjectKind objectKind = ObjectKind.KEY;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"KEY");
            this.handleColumnRenaming(table, objectKind, oldName, tableName);
            ObjectKind objectKind2 = ObjectKind.FOREIGN_KEY;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind2, (String)"FOREIGN_KEY");
            this.handleColumnRenaming(table, objectKind2, oldName, tableName);
        }

        protected void handleColumnRenaming(@NotNull PgBaseLikeStoredTable table, @NotNull ObjectKind childrenKind, @NotNull String oldName, @NotNull String newName) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)childrenKind, (String)"childrenKind");
            Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
            Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
            ModFamily f = (ModFamily)table.familyOf(childrenKind);
            if (f != null && f.hasChildren()) {
                for (BasicModElement child : f) {
                    if (!(child instanceof BasicModColumniation)) continue;
                    boolean changed = false;
                    ArrayList<String> names = new ArrayList<String>((Collection)((BasicModColumniation)child).getColNames());
                    int n = names.size();
                    for (int i2 = 0; i2 < n; ++i2) {
                        if (!Intrinsics.areEqual(names.get(i2), (Object)oldName)) continue;
                        names.set(i2, newName);
                        changed = true;
                    }
                    if (!changed) continue;
                    ((BasicModColumniation)child).setColNames((List<String>)names);
                    if (child instanceof BasicModNamedElement) {
                        ((BasicModNamedElement)child).setNameSurrogate(this.this$0.isNameSurrogate((BasicModColumniation)child));
                    }
                    if (!Intrinsics.areEqual((Object)childrenKind, (Object)ObjectKind.KEY)) continue;
                    if (table.getSchema() != null) {
                        PgBaseSchema pgBaseSchema;
                        PgBaseIntrospector pgBaseIntrospector = this.this$0;
                        PgBaseSchema it = pgBaseSchema;
                        boolean bl = false;
                        pgBaseIntrospector.affectedKeySchemaIds.add((Object)it.getObjectId());
                    }
                }
            }
        }

        private final void retrieveConstraints(boolean detectDropped, boolean loadNew) {
            this.this$0.reportRetrieving("constraints", "introspection.retrieve.constraints");
            Ref.BooleanRef wasKeys = new Ref.BooleanRef();
            this.inSchema(arg_0 -> SchemaRetriever.retrieveConstraints$lambda$94(this, this.this$0, detectDropped, loadNew, wasKeys, arg_0));
            if (wasKeys.element) {
                ((Collection)this.this$0.affectedKeySchemaIds).add(((BasicIdentifiedElement)this.getSchema()).getObjectId());
            }
        }

        @NotNull
        protected ModNamingIdentifyingFamily<?>[] constraintFamilies(@NotNull PgBaseTable table) {
            ModNamingIdentifyingFamily[] modNamingIdentifyingFamilyArray;
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            PgBaseRegularTable pgBaseRegularTable = table instanceof PgBaseRegularTable ? (PgBaseRegularTable)table : null;
            if (pgBaseRegularTable != null) {
                PgBaseRegularTable $this$constraintFamilies_u24lambda_u2495 = pgBaseRegularTable;
                boolean bl = false;
                ModNamingIdentifyingFamily[] modNamingIdentifyingFamilyArray2 = new ModNamingIdentifyingFamily[]{$this$constraintFamilies_u24lambda_u2495.getKeys(), $this$constraintFamilies_u24lambda_u2495.getForeignKeys()};
                modNamingIdentifyingFamilyArray = modNamingIdentifyingFamilyArray2;
            } else {
                modNamingIdentifyingFamilyArray = new ModNamingIdentifyingFamily[]{};
            }
            return modNamingIdentifyingFamilyArray;
        }

        protected void processKey(@NotNull PgBaseKey key2, @NotNull PgBaseTable table, @NotNull PgBaseIntroQueries.OneConstraint con) {
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)con, (String)"con");
            key2.setPrimary(con.con_kind == 'p');
            key2.setStateNumber(con.con_state_id);
            String string = con.con_columns;
            String string2 = "Key " + con.con_name + " column positions";
            PositioningNamingFamily positioningNamingFamily = table.getColumns();
            Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
            key2.setColNames(this.peekColNames(string, string2, positioningNamingFamily));
            key2.setNameSurrogate(this.this$0.isNameSurrogate(key2));
        }

        protected void processCheck(@NotNull PgBaseTable table, @NotNull PgBaseIntroQueries.OneConstraint con) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)con, (String)"con");
        }

        protected void processForeignKey(@NotNull PgBaseForeignKey fkey, @NotNull PgBaseTable table, @NotNull PgBaseIntroQueries.OneConstraint con, @NotNull S schema) {
            Intrinsics.checkNotNullParameter((Object)fkey, (String)"fkey");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)con, (String)"con");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            fkey.setStateNumber(con.con_state_id);
            fkey.setRefTableRef(BasicIdReference.create(con.ref_table_id));
            String string = con.con_columns;
            String string2 = "Foreign key " + con.con_name + " domestic column positions";
            PositioningNamingFamily positioningNamingFamily = table.getColumns();
            Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
            fkey.setColNames(this.peekColNames(string, string2, positioningNamingFamily));
            fkey.setNameSurrogate(this.this$0.isNameSurrogate(fkey));
            List<Short> refColPositions = PgBaseIntrospectorKt.parseArrayOfPositions(con.ref_columns, "Foreign Key " + fkey.getName() + " ref columns");
            fkey.setRefKeyRef(BasicByColumnPositionsReference.create(refColPositions));
        }

        protected boolean hasReference(@NotNull PgBaseIntroQueries.OneConstraint con) {
            Intrinsics.checkNotNullParameter((Object)con, (String)"con");
            return con.ref_table_id > 0L && con.ref_columns != null;
        }

        @NotNull
        protected final List<String> peekColNames(@Nullable String columnPositions, @NotNull String what, @NotNull PositioningFamily<? extends BasicTableOrViewColumn> columns) {
            Intrinsics.checkNotNullParameter((Object)what, (String)"what");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            List<Short> positions = PgBaseIntrospectorKt.parseArrayOfPositions(columnPositions, what);
            int n = positions.size();
            ArrayList<String> names = new ArrayList<String>(n);
            Iterator<Short> iterator = positions.iterator();
            while (iterator.hasNext()) {
                String it;
                short position = ((Number)iterator.next()).shortValue();
                if (this.getColumnName(columns, position) == null) continue;
                boolean bl = false;
                names.add(it);
            }
            return names;
        }

        @Nullable
        protected final String getColumnName(@NotNull PositioningFamily<? extends BasicTableOrViewColumn> $this$getColumnName, short position) {
            Intrinsics.checkNotNullParameter($this$getColumnName, (String)"<this>");
            return this.this$0.getHelper().getColumnName($this$getColumnName, position);
        }

        /*
         * WARNING - void declaration
         */
        protected void retrieveDescriptions(boolean detectDropped, boolean loadNew) {
            this.this$0.reportRetrieving("comments", "introspection.retrieve.comments");
            BaseNativeIntrospector baseNativeIntrospector = this.this$0;
            PgBaseIntrospector pgBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl = false;
                this.inSchema(arg_0 -> SchemaRetriever.retrieveDescriptions$lambda$101$lambda$100(detectDropped, this, loadNew, pgBaseIntrospector, arg_0));
            }
            catch (DBException e$iv) {
                void this_$iv;
                this_$iv.getErrorSink().accept(null, e$iv);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Nullable
        protected BasicElement findObjectById(@NotNull S schema, @Nullable Character kind, long id) {
            BasicIdentifiedElement basicIdentifiedElement;
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            BasicSchema $this$findById$iv = (BasicSchema)schema;
            boolean $i$f$findById = false;
            BasicDatabase basicDatabase = $this$findById$iv.getDatabase();
            if (basicDatabase != null) {
                Function1 function1;
                BasicDatabase $this$findAllById$iv$iv = basicDatabase;
                boolean $i$f$findAllById = false;
                JBIterable jBIterable = JBIterable.from((Iterable)$this$findAllById$iv$iv.findIdentifiedElements(id)).filter(BasicIdentifiedElement.class);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
                basicDatabase = jBIterable;
                if (jBIterable != null && (basicDatabase = basicDatabase.filter(new Condition(function1 = (Function1)new Function1<BasicIdentifiedElement, Boolean>($this$findById$iv){
                    final /* synthetic */ BasicSchema $this_findById;
                    {
                        this.$this_findById = $receiver;
                    }

                    public final Boolean invoke(BasicIdentifiedElement it) {
                        return Intrinsics.areEqual((Object)((BasicMixinElement)it).getSchema(), (Object)this.$this_findById);
                    }
                }){
                    private final /* synthetic */ Function1 function;
                    {
                        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                        this.function = function;
                    }

                    public final /* synthetic */ boolean value(Object p0) {
                        return (Boolean)this.function.invoke(p0);
                    }
                })) != null) {
                    basicIdentifiedElement = (BasicIdentifiedElement)basicDatabase.first();
                    return basicIdentifiedElement;
                }
            }
            basicIdentifiedElement = null;
            return basicIdentifiedElement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void retrieveViewSources() {
            if (!this.getWithSources()) {
                return;
            }
            this.setQueryParameter("INCSRC", this.getMode().increment && this.incrementalViewSources());
            this.this$0.reportRetrieving("view sources", "introspection.retrieve.view.sources");
            BaseNativeIntrospector baseNativeIntrospector = this.this$0;
            PgBaseIntrospector pgBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            try {
                void this_$iv$iv;
                boolean bl = false;
                BaseNativeIntrospector this_$iv = pgBaseIntrospector;
                boolean $i$f$writeSources = false;
                BaseIntrospector baseIntrospector = this_$iv;
                String name$iv$iv = "WriteSources";
                boolean $i$f$doSection = false;
                CharSequence message$iv$iv$iv = null;
                boolean $i$f$logSectionBegin = false;
                DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv);
                DiagnosticSectionReference ref$iv$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin(name$iv$iv, message$iv$iv$iv) : null;
                try {
                    boolean bl2 = false;
                    this_$iv.getModel().writeSources(new Runnable(this, pgBaseIntrospector){
                        final /* synthetic */ SchemaRetriever this$0;
                        final /* synthetic */ PgBaseIntrospector this$1$inlined;
                        {
                            this.this$0 = schemaRetriever;
                            this.this$1$inlined = pgBaseIntrospector;
                        }

                        public final void run() {
                            boolean bl = false;
                            SchemaRetriever.access$inSchema(this.this$0, (Function1)new Function1<S, Unit>(this.this$0, this.this$1$inlined){
                                final /* synthetic */ SchemaRetriever<S> this$0;
                                final /* synthetic */ PgBaseIntrospector<MR, D, S> this$1;
                                {
                                    this.this$0 = $receiver;
                                    this.this$1 = $receiver2;
                                }

                                public final void invoke(S schema) {
                                    Intrinsics.checkNotNullParameter(schema, (String)"schema");
                                    BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this.this$0, this.this$1.getQueries().getRetrieveViewSources(), 0, (Function1)new Function1<PgBaseIntroQueries.OneViewSource, Unit>(this.this$0, schema){
                                        final /* synthetic */ SchemaRetriever<S> this$0;
                                        final /* synthetic */ S $schema;
                                        {
                                            this.this$0 = $receiver;
                                            this.$schema = $schema;
                                        }

                                        public final void invoke(PgBaseIntroQueries.OneViewSource vs) {
                                            Intrinsics.checkNotNullParameter((Object)vs, (String)"vs");
                                            PgBaseLikeStoredTable view = this.this$0.getTableOrView(this.$schema, this.this$0.adjustRelKind(vs.view_kind, vs.view_name), vs.view_id);
                                            String sourceText = vs.source_text;
                                            this.this$0.processViewSource(view, sourceText);
                                        }
                                    }, 2, null);
                                }
                            });
                        }
                    });
                }
                finally {
                    void this_$iv$iv$iv = this_$iv$iv;
                    boolean $i$f$logSectionEnd = false;
                    if (ref$iv$iv != null) {
                        DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv);
                        if (dataSourceDiagnosticRecorder2 != null) {
                            DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder2, ref$iv$iv, null, 2, null);
                        }
                    }
                }
            }
            catch (DBException e$iv) {
                void this_$iv;
                this_$iv.getErrorSink().accept(null, e$iv);
            }
        }

        protected void processViewSource(@Nullable PgBaseLikeStoredTable view, @Nullable String sourceText) {
            if (view instanceof PgBaseView) {
                this.applyViewSourceText((PgBaseSourceAware)((Object)view), sourceText);
            }
            if (view instanceof PgBaseMatView) {
                this.applyViewSourceText((PgBaseSourceAware)((Object)view), sourceText);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        protected void retrieveFunSources() {
            if (!this.getWithSources()) {
                return;
            }
            this.this$0.reportRetrieving("functions' sources", "introspection.retrieve.routine.sources");
            BaseNativeIntrospector baseNativeIntrospector = this.this$0;
            PgBaseIntrospector pgBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            try {
                void this_$iv$iv;
                boolean bl = false;
                BaseNativeIntrospector this_$iv = pgBaseIntrospector;
                boolean $i$f$writeSources = false;
                BaseIntrospector baseIntrospector = this_$iv;
                String name$iv$iv = "WriteSources";
                boolean $i$f$doSection = false;
                CharSequence message$iv$iv$iv = null;
                boolean $i$f$logSectionBegin = false;
                DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv);
                DiagnosticSectionReference ref$iv$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin(name$iv$iv, message$iv$iv$iv) : null;
                try {
                    boolean bl2 = false;
                    this_$iv.getModel().writeSources(new Runnable(this, pgBaseIntrospector){
                        final /* synthetic */ SchemaRetriever this$0;
                        final /* synthetic */ PgBaseIntrospector this$1$inlined;
                        {
                            this.this$0 = schemaRetriever;
                            this.this$1$inlined = pgBaseIntrospector;
                        }

                        public final void run() {
                            boolean bl = false;
                            SchemaRetriever.access$inSchema(this.this$0, (Function1)new Function1<S, Unit>(this.this$0, this.this$1$inlined){
                                final /* synthetic */ SchemaRetriever<S> this$0;
                                final /* synthetic */ PgBaseIntrospector<MR, D, S> this$1;
                                {
                                    this.this$0 = $receiver;
                                    this.this$1 = $receiver2;
                                }

                                public final void invoke(S schema) {
                                    Intrinsics.checkNotNullParameter(schema, (String)"schema");
                                    BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this.this$0, this.this$1.getQueries().getRetrieveFunctionSources(), 0, (Function1)new Function1<PgBaseIntroQueries.OneFunctionSource, Unit>(schema, this.this$0){
                                        final /* synthetic */ S $schema;
                                        final /* synthetic */ SchemaRetriever<S> this$0;
                                        {
                                            this.$schema = $schema;
                                            this.this$0 = $receiver;
                                        }

                                        public final void invoke(PgBaseIntroQueries.OneFunctionSource fs) {
                                            Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
                                            PgBaseRoutine pgBaseRoutine = (PgBaseRoutine)this.$schema.getRoutines().getByObjectId(fs.id);
                                            if (pgBaseRoutine == null) {
                                                return;
                                            }
                                            PgBaseRoutine function = pgBaseRoutine;
                                            SchemaRetriever.access$processFunSource(this.this$0, function, fs);
                                        }
                                    }, 2, null);
                                }
                            });
                        }
                    });
                }
                finally {
                    void this_$iv$iv$iv = this_$iv$iv;
                    boolean $i$f$logSectionEnd = false;
                    if (ref$iv$iv != null) {
                        DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv);
                        if (dataSourceDiagnosticRecorder2 != null) {
                            DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder2, ref$iv$iv, null, 2, null);
                        }
                    }
                }
            }
            catch (DBException e$iv) {
                void this_$iv;
                this_$iv.getErrorSink().accept(null, e$iv);
            }
        }

        private final void processFunSource(PgBaseRoutine function, PgBaseIntroQueries.OneFunctionSource fs) {
            this.processFunSourceAttributes(function, fs);
            function.setSourceText(this.getFunSourceText(fs));
        }

        protected void processFunSourceAttributes(@NotNull PgBaseRoutine function, @NotNull PgBaseIntroQueries.OneFunctionSource fs) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
            function.setArgumentsDefinition(StringKt.nullize((String)fs.arguments_def, (boolean)true));
            function.setResultsDefinition(StringKt.nullize((String)fs.result_def, (boolean)true));
        }

        @Nullable
        protected CompositeText getFunSourceText(@NotNull PgBaseIntroQueries.OneFunctionSource fs) {
            Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
            String string = fs.source_text;
            return string != null ? BaseIntrospectionFunctions.toCompositeText(string, CompositeText.Kind.ORIGINAL_TEXT) : null;
        }

        private final void applyViewSourceText(PgBaseSourceAware $this$applyViewSourceText, String sourceText) {
            CharSequence charSequence = sourceText;
            if (charSequence == null || charSequence.length() == 0) {
                $this$applyViewSourceText.setSourceText(null);
                return;
            }
            String body2 = PgBaseIntrospectorKt.removeSuffix(((Object)StringsKt.trim((CharSequence)sourceText)).toString(), ';');
            $this$applyViewSourceText.setSourceText(BaseIntrospectionFunctions.toCompositeText(body2, CompositeText.Kind.DECOMPILED_TEXT));
        }

        protected final boolean shouldIntrospectTableRelatedData() {
            return this.wasDataTables() || this.getMode().increment && this.shouldIntrospectTableRelatedDataIncremental();
        }

        protected boolean shouldIntrospectTableRelatedDataIncremental() {
            return ((PgBaseSchema)this.getSchema()).getTables().hasChildren();
        }

        protected boolean wasDataTables() {
            return this.wasTables || this.wasViews || this.wasMatViews;
        }

        protected abstract void processModView(@NotNull PgBaseLikeStoredTable var1, @NotNull PgBaseIntroQueries.OneTable var2);

        protected abstract void processModTable(@NotNull PgBaseTable var1, @NotNull PgBaseIntroQueries.OneTable var2);

        private static final Unit removeDroppedComments$lambda$0(SchemaRetriever this$0, Long2ObjectMap $existentComments, PgBaseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            for (ModFamily modFamily : schema.getFamilies()) {
                if (!modFamily.getMetaObject().kindOf(BasicModIdentifiedElement.class)) continue;
                for (BasicModElement c2 : modFamily) {
                    Intrinsics.checkNotNull((Object)c2, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicModIdentifiedElement");
                    this$0.removeComments((Long2ObjectMap<Short[]>)$existentComments, (BasicModIdentifiedElement)c2);
                }
            }
            return Unit.INSTANCE;
        }

        private static final Unit finishSchema$lambda$1(PgBaseIntrospector this$0, PgBaseSchema it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Long xid = this$0.getIntrospectionXid();
            if (xid != null) {
                it.setIntrospectionStateNumber(xid);
            }
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$2(SchemaRetriever this$0, boolean detectDropped, boolean loadNew) {
            this$0.retrieveDataTypes(detectDropped, loadNew);
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$3(SchemaRetriever this$0, boolean detectDropped, boolean loadNew) {
            this$0.retrieveTables(detectDropped, loadNew);
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$4(SchemaRetriever this$0, boolean detectDropped, boolean loadNew) {
            if (loadNew) {
                this$0.obtainUsedTypes();
            }
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$5(SchemaRetriever this$0, boolean detectDropped, boolean loadNew) {
            this$0.retrieveRoutines(detectDropped, loadNew);
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$6(SchemaRetriever this$0, boolean detectDropped, boolean loadNew) {
            this$0.retrieveAggregates(detectDropped, loadNew);
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$7(SchemaRetriever this$0, boolean detectDropped, boolean loadNew) {
            this$0.retrieveOperators(detectDropped, loadNew);
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$8(SchemaRetriever this$0, boolean detectDropped, boolean loadNew) {
            if (loadNew) {
                this$0.retrieveStructAttributes();
            }
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$9(SchemaRetriever this$0, boolean detectDropped, boolean loadNew) {
            if (loadNew) {
                this$0.retrieveTableColumns();
            }
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$10(SchemaRetriever this$0, boolean detectDropped, boolean loadNew) {
            this$0.retrieveConstraints(detectDropped, loadNew);
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$11(SchemaRetriever this$0, boolean detectDropped, boolean loadNew) {
            this$0.retrieveDescriptions(detectDropped, loadNew);
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$12(SchemaRetriever this$0, boolean detectDropped, boolean loadNew) {
            this$0.retrieveAcls(detectDropped, loadNew);
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$13(SchemaRetriever this$0, boolean detectDropped, boolean loadNew) {
            if (loadNew || !this$0.incrementalViewSources()) {
                this$0.retrieveViewSources();
            }
            return Unit.INSTANCE;
        }

        private static final Unit steps$lambda$14(SchemaRetriever this$0, boolean detectDropped, boolean loadNew) {
            if (loadNew) {
                this$0.retrieveFunSources();
            }
            return Unit.INSTANCE;
        }

        private static final boolean retrieveAcls$lambda$22$lambda$15(Grants.Controller $ctl, SchemaRetriever this$0, PgObjectGrant it) {
            Grants.Grant grant = it;
            BasicElement basicElement = (BasicElement)this$0.getSchema();
            BasicResolveAssistant basicResolveAssistant = BasicResolveAssistant.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)basicResolveAssistant, (String)"DEFAULT");
            return $ctl.findTarget(grant, basicElement, basicResolveAssistant) == null;
        }

        private static final boolean retrieveAcls$lambda$22$lambda$16(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean retrieveAcls$lambda$22$lambda$21$lambda$18(PgBaseIntroQueries.OneAcl $acl, PgObjectGrant it) {
            return it.getObjectId() == $acl.object_id && !it.isSub();
        }

        private static final boolean retrieveAcls$lambda$22$lambda$21$lambda$19(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final Unit retrieveAcls$lambda$22$lambda$21(List $newGrants, PgBaseIntrospector this$0, Lexer $lexer, NamingService $ns, PgBaseIntroQueries.OneAcl acl) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)acl, (String)"acl");
                $newGrants.removeIf(arg_0 -> SchemaRetriever.retrieveAcls$lambda$22$lambda$21$lambda$19(arg_0 -> SchemaRetriever.retrieveAcls$lambda$22$lambda$21$lambda$18(acl, arg_0), arg_0));
                if (acl.acl == null) break block1;
                String[] $this$forEach$iv = acl.acl;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int j = 0; j < n; ++j) {
                    String element$iv;
                    String it = element$iv = $this$forEach$iv[j];
                    boolean bl = false;
                    PgAclItem pgAclItem = this$0.parseAclItem($lexer, $ns, it);
                    if (pgAclItem == null) continue;
                    pgAclItem.toGrants(acl.object_id, $newGrants);
                }
            }
            return Unit.INSTANCE;
        }

        private static final boolean retrieveColumnAcl$lambda$28$lambda$27$lambda$25$lambda$24(PgBaseIntroQueries.AttrAcl $acl, int n) {
            return n == $acl.attr_position;
        }

        private static final boolean retrieveColumnAcl$lambda$28$lambda$27$lambda$25(PgBaseIntroQueries.AttrAcl $acl, PgObjectGrant it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getObjectId() == $acl.object_id && it.isSub() && it.getSubsStream().allMatch(arg_0 -> SchemaRetriever.retrieveColumnAcl$lambda$28$lambda$27$lambda$25$lambda$24($acl, arg_0));
        }

        private static final boolean retrieveColumnAcl$lambda$28$lambda$27$lambda$26(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final Unit retrieveColumnAcl$lambda$28$lambda$27(List $newGrants, ArrayList $columns, SchemaRetriever this$0, PgBaseIntroQueries.AttrAcl acl) {
            Intrinsics.checkNotNullParameter((Object)acl, (String)"acl");
            $newGrants.removeIf(arg_0 -> SchemaRetriever.retrieveColumnAcl$lambda$28$lambda$27$lambda$26(arg_0 -> SchemaRetriever.retrieveColumnAcl$lambda$28$lambda$27$lambda$25(acl, arg_0), arg_0));
            PgBaseIntroQueries.AttrAcl attrAcl = (PgBaseIntroQueries.AttrAcl)CollectionsKt.firstOrNull((List)$columns);
            if (!(attrAcl != null ? attrAcl.object_id == acl.object_id : false)) {
                this$0.toGrants($columns, $newGrants);
                $columns.clear();
            }
            ((Collection)$columns).add(acl);
            return Unit.INSTANCE;
        }

        private static final PgAclItem toGrants$lambda$31$lambda$29(PgBaseIntrospector this$0, Lexer $lexer, NamingService $ns, String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return this$0.parseAclItem($lexer, $ns, it);
        }

        private static final kotlin.Pair toGrants$lambda$31$lambda$30(PgBaseIntroQueries.AttrAcl $a, PgAclItem it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new kotlin.Pair((Object)$a.attr_position, (Object)it);
        }

        private static final Sequence toGrants$lambda$31(PgBaseIntrospector this$0, Lexer $lexer, NamingService $ns, PgBaseIntroQueries.AttrAcl a) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            String[] stringArray = a.acl;
            if (stringArray == null || (stringArray = ArraysKt.asSequence((Object[])stringArray)) == null || (stringArray = SequencesKt.mapNotNull((Sequence)stringArray, arg_0 -> SchemaRetriever.toGrants$lambda$31$lambda$29(this$0, $lexer, $ns, arg_0))) == null || (stringArray = SequencesKt.map((Sequence)stringArray, arg_0 -> SchemaRetriever.toGrants$lambda$31$lambda$30(a, arg_0))) == null) {
                stringArray = SequencesKt.emptySequence();
            }
            return stringArray;
        }

        private static final Unit retrieveDataTypes$lambda$40$lambda$39$lambda$38$lambda$37(ModNamingIdentifyingFamily $defTypes, SchemaRetriever this$0, PgBaseSchema $sc, PgBaseIntroQueries.OneDataType dt) {
            Intrinsics.checkNotNullParameter((Object)dt, (String)"dt");
            Object e = $defTypes.renew(dt.type_id, dt.type_name);
            Intrinsics.checkNotNullExpressionValue(e, (String)"renew(...)");
            PgBaseDefType dataType = (PgBaseDefType)e;
            this$0.processDataType(dataType, dt, $sc);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveDataTypes$lambda$40(PgBaseIntrospector this$0, boolean $detectDropped, SchemaRetriever this$1, boolean $loadNew, PgBaseSchema sc) {
            Intrinsics.checkNotNullParameter((Object)sc, (String)"sc");
            ModFamily $this$modifyAndCleanup_u24default$iv = sc.getDefTypes();
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingIdentifyingFamily defTypes = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector this_$iv = this$0;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl2 = false;
                if ($detectDropped) {
                    long[] $this$forEach$iv = this$1.performQuery(this$0.getQueries().getRetrieveExistentDataTypes());
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int j = 0; j < n; ++j) {
                        long element$iv;
                        long it = element$iv = $this$forEach$iv[j];
                        boolean bl3 = false;
                        PgBaseDefType pgBaseDefType = (PgBaseDefType)defTypes.getByObjectId(it);
                        if (pgBaseDefType != null) {
                            ((BasicModMixinElement)pgBaseDefType).resetSyncPending();
                        }
                    }
                }
                if ($loadNew) {
                    BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this$1, this$0.getQueries().getRetrieveDataTypes(), 0, arg_0 -> SchemaRetriever.retrieveDataTypes$lambda$40$lambda$39$lambda$38$lambda$37(defTypes, this$1, sc, arg_0), 2, null);
                }
            }
            catch (DBException e$iv) {
                this_$iv.getErrorSink().accept(null, e$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
            return Unit.INSTANCE;
        }

        private static final Unit retrieveTables$lambda$44(SchemaRetriever this$0, PgBaseIntrospector this$1, boolean $detectDropped, boolean $loadNew, PgBaseSchema sc) {
            Intrinsics.checkNotNullParameter((Object)sc, (String)"sc");
            ModNamingIdentifyingFamily<PgBaseLikeStoredTable>[] fTables = this$0.tableFamilies(sc);
            ModFamily[] families$iv = Arrays.copyOf(fTables, fTables.length);
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            for (ModFamily f$iv : families$iv) {
                f$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            BaseNativeIntrospector this_$iv = this$1;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl2 = false;
                if ($detectDropped) {
                    long[] $this$forEach$iv = this$0.performQuery(this$1.getQueries().getRetrieveExistentTables());
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int j = 0; j < n; ++j) {
                        long element$iv;
                        long it = element$iv = $this$forEach$iv[j];
                        boolean bl3 = false;
                        for (ModNamingIdentifyingFamily<PgBaseLikeStoredTable> tables : fTables) {
                            PgBaseLikeStoredTable pgBaseLikeStoredTable = (PgBaseLikeStoredTable)tables.getByObjectId(it);
                            if (pgBaseLikeStoredTable == null) continue;
                            ((BasicModMixinElement)pgBaseLikeStoredTable).resetSyncPending();
                        }
                    }
                }
                if ($loadNew) {
                    this$0.loadTables(sc);
                }
            }
            catch (DBException e$iv) {
                this_$iv.getErrorSink().accept(null, e$iv);
            }
            for (ModFamily f$iv : families$iv) {
                f$iv.removeSyncPendingChildren();
                f$iv.sort();
            }
            return Unit.INSTANCE;
        }

        private static final Unit loadTables$lambda$45(SchemaRetriever this$0, PgBaseSchema $schema, PgBaseIntroQueries.OneTable it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.processTable($schema, it);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveStructAttributes$lambda$52$lambda$51(List $ats, PgBaseSchema schema) {
            void $this$groupByTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Iterable $this$groupBy$iv = $ats;
            boolean $i$f$groupBy = false;
            Object object = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object2;
                PgBaseIntroQueries.OneStructAttribute it = (PgBaseIntroQueries.OneStructAttribute)element$iv$iv;
                boolean bl = false;
                Long key$iv$iv = it.type_id;
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            Map $this$forEach$iv = destination$iv$iv;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry element$iv;
                Object element$iv$iv;
                Map.Entry entry = element$iv = (Map.Entry)object.next();
                boolean bl = false;
                if ((PgBaseDefType)schema.getDefTypes().getByObjectId(((Number)entry.getKey()).longValue()) == null) continue;
                Intrinsics.checkNotNull(element$iv$iv);
                Object dataType = element$iv$iv;
                ModFamily $this$modifyAndCleanup_u24default$iv = dataType.getAttributes();
                boolean removeUnaffected$iv = true;
                boolean $i$f$modifyAndCleanup = false;
                $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                ModPositioningNamingFamily attributes = (ModPositioningNamingFamily)$this$modifyAndCleanup_u24default$iv;
                boolean bl3 = false;
                for (PgBaseIntroQueries.OneStructAttribute at : (List)entry.getValue()) {
                    if (at.att_dropped) continue;
                    PgBaseDefTypeAttribute attribute = (PgBaseDefTypeAttribute)attributes.createOrGetAt(at.att_position);
                    String string = at.att_name;
                    Intrinsics.checkNotNull((Object)string);
                    attribute.setName(string);
                    attribute.setStoredType(PgBaseIntrospectorKt.dasTypeOf(at));
                }
                $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                $this$modifyAndCleanup_u24default$iv.sort();
            }
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveRoutines$lambda$59$lambda$58$lambda$57$lambda$56(SchemaRetriever this$0, PgBaseSchema $schema, PgBaseIntroQueries.OneRoutine r) {
            PgRoutineKind pgRoutineKind;
            Iterator iterator;
            BasicNameReference basicNameReference;
            Regex it;
            int n;
            PgBaseRoutine routine2;
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            PgBaseRoutine pgBaseRoutine = routine2 = this$0.createRoutine($schema, r);
            String string = r.lang;
            if (string != null) {
                String string2 = string;
                PgBaseRoutine pgBaseRoutine2 = pgBaseRoutine;
                n = 0;
                basicNameReference = BasicNameReference.create((String)it);
                pgBaseRoutine = pgBaseRoutine2;
            } else {
                basicNameReference = null;
            }
            pgBaseRoutine.setLanguageRef(basicNameReference);
            routine2.setStateNumber(r.r_state_number);
            routine2.setReturnsSet(r.ret_set);
            PgVolatilityKind pgVolatilityKind = PgVolatilityKind.of(r.volatile_kind);
            if (pgVolatilityKind == null) {
                pgVolatilityKind = PgVolatilityKind.VOLATILE;
            }
            routine2.setVolatilityKind(pgVolatilityKind);
            PgBaseIntroQueries.ArgumentHolder argumentHolder = r;
            PositioningNamingFamily positioningNamingFamily = routine2.getArguments();
            Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getArguments(...)");
            this$0.processArgs(argumentHolder, (ModPositioningNamingFamily)positioningNamingFamily, routine2);
            if (r.arg_defaults != null) {
                void $this$toTypedArray$iv;
                List list;
                Collection $this$dropLastWhile$iv;
                String string3 = r.arg_defaults;
                Intrinsics.checkNotNull((Object)string3);
                Object object = string3;
                it = new Regex(",\\s+");
                n = 0;
                object = it.split((CharSequence)object, n);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String p0 = (String)iterator$iv.previous();
                        boolean bl = false;
                        boolean $i$f$retrieveRoutines$lambda$59$lambda$58$lambda$57$lambda$56$stub_for_inlining = false;
                        if (((CharSequence)p0).length() == 0) continue;
                        list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                $this$dropLastWhile$iv = list;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                String[] defaults = thisCollection$iv.toArray(new String[0]);
                PositioningNamingFamily positioningNamingFamily2 = routine2.getArguments();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily2, (String)"getArguments(...)");
                List arguments = BaseIntrospectionFunctions.toList(positioningNamingFamily2);
                int an = arguments.size();
                int k = defaults.length;
                for (int i2 = an - 1; -1 < i2; --i2) {
                    PgBaseArgument a = (PgBaseArgument)arguments.get(i2);
                    if (a.getArgumentDirection().isIn()) {
                        if (--k >= 0) {
                            String theDefaultExpression = PgBaseIntrospectorKt.normalizeDefaultExpression(defaults[k]);
                            a.setDefaultExpression(theDefaultExpression);
                            continue;
                        }
                        a.setDefaultExpression(null);
                        continue;
                    }
                    a.setDefaultExpression(null);
                }
            } else {
                iterator = routine2.getArguments().iterator();
                while (iterator.hasNext()) {
                    PgBaseArgument a = (PgBaseArgument)iterator.next();
                    a.setDefaultExpression(null);
                }
            }
            if (r.kind == 'p') {
                pgRoutineKind = PgRoutineKind.PG_PROCEDURE;
            } else {
                Object object = routine2.getReturnArgument();
                if (object != null && (object = object.getDasType()) != null && (object = DasTypeUtilsKt.getTypeName((DasType)object)) != null) {
                    String string4 = ((String)object).toLowerCase();
                    v12 = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                } else {
                    v12 = iterator = null;
                }
                pgRoutineKind = Intrinsics.areEqual(iterator, (Object)"trigger") ? PgRoutineKind.PG_TRIGGER : (Intrinsics.areEqual(iterator, (Object)"event_trigger") ? PgRoutineKind.PG_EVENT_TRIGGER : PgRoutineKind.PG_FUNCTION);
            }
            routine2.setPgRoutineKind(pgRoutineKind);
            routine2.getArguments().sort();
            routine2.getArguments().removeSyncPendingChildren();
            return Unit.INSTANCE;
        }

        private static final Unit retrieveRoutines$lambda$59(PgBaseIntrospector this$0, boolean $detectDropped, SchemaRetriever this$1, boolean $loadNew, PgBaseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModFamily $this$modifyAndCleanup_u24default$iv = schema.getRoutines();
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingIdentifyingFamily routines = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector this_$iv = this$0;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl2 = false;
                if ($detectDropped) {
                    long[] $this$forEach$iv = this$1.performQuery(this$0.getQueries().getRetrieveExistentRoutines());
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int j = 0; j < n; ++j) {
                        long element$iv;
                        long it = element$iv = $this$forEach$iv[j];
                        boolean bl3 = false;
                        PgBaseRoutine pgBaseRoutine = (PgBaseRoutine)routines.getByObjectId(it);
                        if (pgBaseRoutine != null) {
                            ((BasicModMixinElement)pgBaseRoutine).resetSyncPending();
                        }
                    }
                }
                if ($loadNew) {
                    BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this$1, this$0.getQueries().getRetrieveRoutines(), 0, arg_0 -> SchemaRetriever.retrieveRoutines$lambda$59$lambda$58$lambda$57$lambda$56(this$1, schema, arg_0), 2, null);
                }
            }
            catch (DBException e$iv) {
                this_$iv.getErrorSink().accept(null, e$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
            return Unit.INSTANCE;
        }

        private static final Unit retrieveAggregates$lambda$65$lambda$64$lambda$63$lambda$62(ModNamingIdentifyingFamily $aggregates, SchemaRetriever this$0, PgBaseIntroQueries.OneAggregate agg) {
            Intrinsics.checkNotNullParameter((Object)agg, (String)"agg");
            Object e = $aggregates.renew(agg.aggregate_id, agg.aggregate_name);
            Intrinsics.checkNotNullExpressionValue(e, (String)"renew(...)");
            PgBaseAggregate aggregate = (PgBaseAggregate)e;
            aggregate.setStateNumber(agg.state_number);
            PgBaseIntroQueries.ArgumentHolder argumentHolder = agg;
            PositioningNamingFamily positioningNamingFamily = aggregate.getArguments();
            Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getArguments(...)");
            this$0.processArgs(argumentHolder, (ModPositioningNamingFamily)positioningNamingFamily, aggregate);
            this$0.processAggregate(agg, aggregate);
            aggregate.getArguments().sort();
            aggregate.getArguments().removeSyncPendingChildren();
            return Unit.INSTANCE;
        }

        private static final Unit retrieveAggregates$lambda$65(PgBaseIntrospector this$0, boolean $detectDropped, SchemaRetriever this$1, boolean $loadNew, PgBaseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModFamily $this$modifyAndCleanup_u24default$iv = schema.getAggregates();
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingIdentifyingFamily aggregates = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector this_$iv = this$0;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl2 = false;
                if ($detectDropped) {
                    long[] $this$forEach$iv = this$1.performQuery(this$0.getQueries().getRetrieveExistentAggregates());
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int j = 0; j < n; ++j) {
                        long element$iv;
                        long it = element$iv = $this$forEach$iv[j];
                        boolean bl3 = false;
                        PgBaseAggregate pgBaseAggregate = (PgBaseAggregate)aggregates.getByObjectId(it);
                        if (pgBaseAggregate != null) {
                            ((BasicModMixinElement)pgBaseAggregate).resetSyncPending();
                        }
                    }
                }
                if ($loadNew) {
                    BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this$1, this$0.getQueries().getRetrieveAggregates(), 0, arg_0 -> SchemaRetriever.retrieveAggregates$lambda$65$lambda$64$lambda$63$lambda$62(aggregates, this$1, arg_0), 2, null);
                }
            }
            catch (DBException e$iv) {
                this_$iv.getErrorSink().accept(null, e$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
            return Unit.INSTANCE;
        }

        private static final Unit retrieveOperators$lambda$70$lambda$69$lambda$68$lambda$67(ModNamingIdentifyingFamily $operators, SchemaRetriever this$0, PgBaseIntroQueries.OneOperator op) {
            Intrinsics.checkNotNullParameter((Object)op, (String)"op");
            Object e = $operators.renew(op.op_id, op.op_name);
            Intrinsics.checkNotNullExpressionValue(e, (String)"renew(...)");
            PgBaseOperator operator = (PgBaseOperator)e;
            this$0.processOperator(op, operator);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveOperators$lambda$70(PgBaseIntrospector this$0, boolean $detectDropped, SchemaRetriever this$1, boolean $loadNew, PgBaseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModFamily $this$modifyAndCleanup_u24default$iv = schema.getOperators();
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingIdentifyingFamily operators = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector this_$iv = this$0;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl2 = false;
                if ($detectDropped) {
                    long[] $this$forEach$iv = this$1.performQuery(this$0.getQueries().getRetrieveExistentOperators());
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int j = 0; j < n; ++j) {
                        long element$iv;
                        long it = element$iv = $this$forEach$iv[j];
                        boolean bl3 = false;
                        PgBaseOperator pgBaseOperator = (PgBaseOperator)operators.getByObjectId(it);
                        if (pgBaseOperator != null) {
                            ((BasicModMixinElement)pgBaseOperator).resetSyncPending();
                        }
                    }
                }
                if ($loadNew) {
                    BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this$1, this$0.getQueries().getRetrieveOperators(), 0, arg_0 -> SchemaRetriever.retrieveOperators$lambda$70$lambda$69$lambda$68$lambda$67(operators, this$1, arg_0), 2, null);
                }
            }
            catch (DBException e$iv) {
                this_$iv.getErrorSink().accept(null, e$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
            return Unit.INSTANCE;
        }

        private static final Unit retrieveTableColumns$lambda$76$lambda$75(SchemaRetriever this$0, List $cols, PgBaseSchema it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.processColumns($cols, it);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveConstraints$lambda$94$lambda$93$lambda$92$lambda$91(PgBaseSchema $schema, SchemaRetriever this$0, Ref.BooleanRef $wasKeys, PgBaseIntroQueries.OneConstraint con) {
            PgBaseObjectWithOwner pgBaseObjectWithOwner;
            block12: {
                block11: {
                    void $this$findById$iv;
                    Intrinsics.checkNotNullParameter((Object)con, (String)"con");
                    pgBaseObjectWithOwner = $schema.getDatabase();
                    if (pgBaseObjectWithOwner == null) break block11;
                    BasicDatabase basicDatabase = pgBaseObjectWithOwner;
                    long objectId$iv = con.table_id;
                    boolean $i$f$findById = false;
                    void $this$findAllById$iv$iv = $this$findById$iv;
                    boolean $i$f$findAllById = false;
                    JBIterable jBIterable = JBIterable.from((Iterable)$this$findAllById$iv$iv.findIdentifiedElements(objectId$iv)).filter(PgBaseTable.class);
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
                    pgBaseObjectWithOwner = (PgBaseTable)((BasicIdentifiedElement)jBIterable.first());
                    if (pgBaseObjectWithOwner != null) break block12;
                }
                return Unit.INSTANCE;
            }
            PgBaseObjectWithOwner table = pgBaseObjectWithOwner;
            switch (con.con_kind) {
                case 'p': 
                case 'u': 
                case 'x': {
                    PgBaseRegularTable pgBaseRegularTable = table instanceof PgBaseRegularTable ? (PgBaseRegularTable)table : null;
                    if (pgBaseRegularTable != null) {
                        PgBaseRegularTable it = pgBaseRegularTable;
                        boolean bl = false;
                        Object e = it.getKeys().renew(con.con_id, con.con_name);
                        Intrinsics.checkNotNullExpressionValue(e, (String)"renew(...)");
                        PgBaseKey key2 = (PgBaseKey)e;
                        this$0.processKey(key2, it, con);
                        $wasKeys.element = true;
                    }
                    break;
                }
                case 'f': {
                    PgBaseRegularTable pgBaseRegularTable = table instanceof PgBaseRegularTable ? (PgBaseRegularTable)table : null;
                    if (pgBaseRegularTable != null) {
                        PgBaseRegularTable it = pgBaseRegularTable;
                        boolean bl = false;
                        Object e = it.getForeignKeys().renew(con.con_id, con.con_name);
                        Intrinsics.checkNotNullExpressionValue(e, (String)"renew(...)");
                        PgBaseForeignKey fkey = (PgBaseForeignKey)e;
                        this$0.processForeignKey(fkey, it, con, $schema);
                    }
                    break;
                }
                case 'c': {
                    this$0.processCheck((PgBaseTable)table, con);
                }
            }
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveConstraints$lambda$94(SchemaRetriever this$0, PgBaseIntrospector this$1, boolean $detectDropped, boolean $loadNew, Ref.BooleanRef $wasKeys, PgBaseSchema schema) {
            Iterable $this$forEach$iv;
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModNamingIdentifyingFamily<PgBaseLikeStoredTable>[] $this$mapNotNull$iv = this$0.tableFamilies(schema);
            boolean $i$f$mapNotNull = false;
            ModNamingIdentifyingFamily<PgBaseLikeStoredTable>[] modNamingIdentifyingFamilyArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                ModFamily<PgBaseTable> it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                if (ModelFun.tryCast((ModFamily)it, PgBaseTable.class) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List tables = (List)destination$iv$iv;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            Function1 it = SchemaRetriever$retrieveConstraints$lambda$94$$inlined$modifyFamiliesAndCleanup$1.INSTANCE;
            boolean bl = false;
            Iterable $this$forEach$iv2 = tables;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                ModFamily tf = (ModFamily)element$iv;
                boolean bl4 = false;
                $this$forEach$iv = tf;
                boolean $i$f$forEach3 = false;
                for (Object element$iv2 : $this$forEach$iv) {
                    PgBaseTable t = (PgBaseTable)element$iv2;
                    boolean bl5 = false;
                    Intrinsics.checkNotNull((Object)t);
                    ModNamingIdentifyingFamily<?>[] $this$forEach$iv3 = this$0.constraintFamilies(t);
                    boolean $i$f$forEach4 = false;
                    int n2 = $this$forEach$iv3.length;
                    for (int j = 0; j < n2; ++j) {
                        ModNamingIdentifyingFamily<?> element$iv3 = $this$forEach$iv3[j];
                        it.invoke(element$iv3);
                    }
                }
            }
            boolean bl6 = false;
            BaseNativeIntrospector this_$iv = this$1;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl7 = false;
                if ($detectDropped) {
                    LongOpenHashSet ids = new LongOpenHashSet(this$0.performQuery(this$1.getQueries().getRetrieveExistentConstraints()));
                    Iterable $this$forEach$iv4 = tables;
                    boolean $i$f$forEach5 = false;
                    for (Object element$iv : $this$forEach$iv4) {
                        ModFamily tf = (ModFamily)element$iv;
                        boolean bl8 = false;
                        Iterable $this$forEach$iv5 = tf;
                        boolean $i$f$forEach6 = false;
                        for (Object element$iv4 : $this$forEach$iv5) {
                            PgBaseTable t = (PgBaseTable)element$iv4;
                            boolean bl9 = false;
                            Intrinsics.checkNotNull((Object)t);
                            ModNamingIdentifyingFamily<?>[] $this$forEach$iv6 = this$0.constraintFamilies(t);
                            boolean $i$f$forEach7 = false;
                            int n3 = $this$forEach$iv6.length;
                            for (int j = 0; j < n3; ++j) {
                                ModNamingIdentifyingFamily<?> element$iv5;
                                ModNamingIdentifyingFamily<?> f = element$iv5 = $this$forEach$iv6[j];
                                boolean bl10 = false;
                                Iterable $this$forEach$iv7 = f;
                                boolean $i$f$forEach8 = false;
                                for (Object element$iv6 : $this$forEach$iv7) {
                                    BasicModElement it2 = (BasicModElement)element$iv6;
                                    boolean bl11 = false;
                                    if (!ids.contains(((BasicIdentifiedElement)((Object)it2)).getObjectId())) continue;
                                    ((BasicModMixinElement)it2).resetSyncPending();
                                }
                            }
                        }
                    }
                }
                if ($loadNew) {
                    BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this$0, this$1.getQueries().getRetrieveConstraints(), 0, arg_0 -> SchemaRetriever.retrieveConstraints$lambda$94$lambda$93$lambda$92$lambda$91(schema, this$0, $wasKeys, arg_0), 2, null);
                }
            }
            catch (DBException e$iv) {
                this_$iv.getErrorSink().accept(null, e$iv);
            }
            it = SchemaRetriever$retrieveConstraints$lambda$94$$inlined$modifyFamiliesAndCleanup$2.INSTANCE;
            $i$a$-modifyFamiliesAndCleanup-PgBaseIntrospector$SchemaRetriever$retrieveConstraints$1$1 = false;
            $this$forEach$iv = tables;
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                ModFamily tf = (ModFamily)element$iv;
                boolean bl12 = false;
                $this$forEach$iv = tf;
                boolean $i$f$forEach9 = false;
                for (Object element$iv2 : $this$forEach$iv) {
                    PgBaseTable t = (PgBaseTable)element$iv2;
                    boolean bl13 = false;
                    Intrinsics.checkNotNull((Object)t);
                    ModNamingIdentifyingFamily<?>[] $this$forEach$iv8 = this$0.constraintFamilies(t);
                    boolean $i$f$forEach10 = false;
                    for (ModNamingIdentifyingFamily<?> element$iv7 : $this$forEach$iv8) {
                        it.invoke(element$iv7);
                    }
                }
            }
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveDescriptions$lambda$101$lambda$100(boolean $detectDropped, SchemaRetriever this$0, boolean $loadNew, PgBaseIntrospector this$1, PgBaseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Long2ObjectMap existentComments = $detectDropped ? this$0.listExistentComments() : (Long2ObjectMap)new Long2ObjectOpenHashMap();
            this$0.removeDroppedComments((Long2ObjectMap<Short[]>)existentComments);
            if ($loadNew) {
                void $this$forEach$iv;
                void $this$groupByTo$iv$iv;
                Object $this$groupBy$iv = this$0.performQuery(this$1.getQueries().getRetrieveSchemaComments());
                boolean $i$f$groupBy = false;
                Object object = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object2;
                    PgBaseIntroQueries.OneComment it = (PgBaseIntroQueries.OneComment)element$iv$iv;
                    boolean bl = false;
                    Long key$iv$iv = it.id;
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl2 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object2 = answer$iv$iv$iv;
                    } else {
                        object2 = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object2;
                    list$iv$iv.add(element$iv$iv);
                }
                $this$groupBy$iv = destination$iv$iv;
                boolean $i$f$forEach = false;
                object = $this$forEach$iv.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = (Map.Entry)object.next();
                    boolean bl = false;
                    if (this$0.findObjectById(schema, ((PgBaseIntroQueries.OneComment)CollectionsKt.first((List)((List)it.getValue()))).kind, ((Number)it.getKey()).longValue()) == null) continue;
                    Iterable $this$forEach$iv2 = (Iterable)it.getValue();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        BasicElement obj2;
                        BasicModNamedElement target2;
                        PgBaseIntroQueries.OneComment it2 = (PgBaseIntroQueries.OneComment)element$iv2;
                        boolean bl3 = false;
                        BasicModNamedElement basicModNamedElement = target2 = it2.sub_id == 0 ? (obj2 instanceof BasicModNamedElement ? (BasicModNamedElement)obj2 : null) : (obj2 instanceof BasicModLikeTable ? (BasicModNamedElement)((BasicModLikeTable)obj2).getColumns().getByNaturalPosition(it2.sub_id) : (obj2 instanceof PgBaseDefType ? (BasicModNamedElement)((PgBaseDefType)obj2).getAttributes().getByNaturalPosition(it2.sub_id) : null));
                        if (basicModNamedElement == null) continue;
                        basicModNamedElement.setComment(it2.description);
                    }
                }
            }
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ void access$inSchema(SchemaRetriever $this, Function1 modifier) {
            $this.inSchema(modifier);
        }

        public static final /* synthetic */ void access$processFunSource(SchemaRetriever $this, PgBaseRoutine function, PgBaseIntroQueries.OneFunctionSource fs) {
            $this.processFunSource(function, fs);
        }
    }
}

