/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sybase;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.statements.ClosableResultsProducer;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementDecoration;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactoryService;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.mssql.TsqlDefinitionProviderBase;
import com.intellij.database.dialects.sybase.model.AseProcedure;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PairConsumer;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AseDefinitionProvider
extends TsqlDefinitionProviderBase {
    @Override
    public boolean isSupported(@NotNull DasObject object) {
        ObjectKind kind;
        if (object == null) {
            AseDefinitionProvider.$$$reportNull$$$0(0);
        }
        return (kind = object.getKind()) == ObjectKind.VIEW || kind == ObjectKind.ROUTINE || kind == ObjectKind.TRIGGER;
    }

    @Override
    protected void fetchSources(@NotNull Iterable<? extends DasObject> objects, @NotNull DatabaseConnectionCore connection2, @NotNull PairConsumer<DasObject, Object> consumer) {
        if (objects == null) {
            AseDefinitionProvider.$$$reportNull$$$0(1);
        }
        if (connection2 == null) {
            AseDefinitionProvider.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            AseDefinitionProvider.$$$reportNull$$$0(3);
        }
        NamingService namingService = NamingServices.getNamingService(Dbms.SYBASE);
        StringBuilder builder = new StringBuilder();
        try (ReusableSmartStatement<ParameterizedStatementDecoration> statement2 = SmartStatementFactoryService.getInstance().poweredBy(connection2).parameterized().reuse("exec sp_helptext ?, ?");){
            for (DasObject dasObject : objects) {
                DasObject parent = dasObject.getDasParent();
                boolean procGroup = DasUtil.getKind(parent) == ObjectKind.PACKAGE;
                String objName = procGroup ? DasUtil.getName(parent) : dasObject.getName();
                String name2 = namingService.enquote(DasUtil.getSchema(dasObject), ObjectKind.SCHEMA, "\"") + "." + namingService.enquote(objName, dasObject.getKind(), "\"");
                Integer procNum = procGroup ? AseDefinitionProvider.getProcNum(dasObject) : null;
                StatementParameters parameters = new StatementParameters().text(name2);
                parameters = procNum == null ? parameters.integer(null) : parameters.integer(procNum);
                ParameterizedStatementDecoration data = parameters.asDecoration();
                try {
                    ClosableResultsProducer producer = statement2.noisy().execute(data, StandardExecutionMode.QUERY);
                    try {
                        boolean ok2;
                        RemoteResultSet rs = null;
                        boolean bl = ok2 = producer.advance() && (rs = producer.processCurrent(StandardResultsProcessors.RESULT_SET)) != null;
                        if (rs != null && !"text".equalsIgnoreCase(rs.getMetaData().getColumnLabel(1))) {
                            boolean advanced = producer.advance();
                            boolean bl2 = ok2 = advanced && (rs = producer.processCurrent(StandardResultsProcessors.RESULT_SET)) != null;
                            if (!ok2 && advanced && producer.processCurrent(StandardResultsProcessors.updateCount(-1)) != -1) {
                                ok2 = producer.advance() && (rs = producer.processCurrent(StandardResultsProcessors.RESULT_SET)) != null;
                            }
                        }
                        builder.setLength(0);
                        if (ok2) {
                            while (rs.next()) {
                                builder.append(rs.getString(1));
                            }
                        }
                        consumer.consume((Object)dasObject, (Object)StringUtil.nullize((String)builder.toString()));
                    }
                    finally {
                        if (producer == null) continue;
                        producer.close();
                    }
                }
                catch (Exception e) {
                    consumer.consume((Object)dasObject, (Object)e);
                }
            }
        }
    }

    @Override
    @Nullable
    protected String getCurrentDb(@NotNull DatabaseConnectionCore connection2) throws SQLException {
        DatabaseDialectEx dialect;
        SearchPath searchPath;
        ObjectPath current;
        if (connection2 == null) {
            AseDefinitionProvider.$$$reportNull$$$0(4);
        }
        return (current = SearchPath.getCurrent(searchPath = (dialect = DbImplUtilCore.getDatabaseDialect(Dbms.SYBASE)).tryToLoadSearchPath(connection2))) == null ? null : current.getName();
    }

    private static Integer getProcNum(DasObject obj2) {
        int res2;
        int n = res2 = obj2 instanceof AseProcedure ? ((AseProcedure)obj2).getPosition() : StringUtil.parseInt((String)obj2.getName(), (int)-1);
        return res2 == -1 ? null : Integer.valueOf(res2 == 0 ? 1 : res2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/sybase/AseDefinitionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchSources";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getCurrentDb";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

