/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.common.CollectionFun;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\nJ\b\u0010\u0013\u001a\u00020\u0006H\u0016J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/introspection/FamilyFragment;", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "names", "", "", "<init>", "(Lcom/intellij/database/model/ObjectKind;Ljava/util/Set;)V", "name", "(Lcom/intellij/database/model/ObjectKind;Ljava/lang/String;)V", "getKind", "()Lcom/intellij/database/model/ObjectKind;", "getNames", "()Ljava/util/Set;", "size", "", "getSize", "()I", "toString", "component1", "component2", "copy", "equals", "", "other", "hashCode", "intellij.database.core.impl"})
public final class FamilyFragment {
    @NotNull
    private final ObjectKind kind;
    @NotNull
    private final Set<String> names;

    public FamilyFragment(@NotNull ObjectKind kind, @NotNull Set<String> names) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter(names, (String)"names");
        this.kind = kind;
        this.names = names;
    }

    @NotNull
    public final ObjectKind getKind() {
        return this.kind;
    }

    @NotNull
    public final Set<String> getNames() {
        return this.names;
    }

    public FamilyFragment(@NotNull ObjectKind kind, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this(kind, CollectionFun.asSingleSet(name2));
    }

    public final int getSize() {
        return this.names.size();
    }

    @NotNull
    public String toString() {
        Object object;
        int n = this.names.size();
        switch (n) {
            case 0: {
                object = "Empty fragment of " + this.kind.code();
                break;
            }
            case 1: {
                object = "Fragment of 1 " + this.kind.code() + ": " + CollectionsKt.first((Iterable)this.names);
                break;
            }
            default: {
                StringBuilder stringBuilder;
                StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$toString_u24lambda_u240.append("Fragment of ");
                $this$toString_u24lambda_u240.append(n);
                $this$toString_u24lambda_u240.append(' ');
                $this$toString_u24lambda_u240.append(StringUtil.pluralize((String)this.kind.code()));
                $this$toString_u24lambda_u240.append(": ");
                CollectionsKt.joinTo$default((Iterable)this.names, (Appendable)$this$toString_u24lambda_u240, null, null, null, (int)0, null, null, (int)126, null);
                String string = stringBuilder.toString();
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            }
        }
        return object;
    }

    @NotNull
    public final ObjectKind component1() {
        return this.kind;
    }

    @NotNull
    public final Set<String> component2() {
        return this.names;
    }

    @NotNull
    public final FamilyFragment copy(@NotNull ObjectKind kind, @NotNull Set<String> names) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter(names, (String)"names");
        return new FamilyFragment(kind, names);
    }

    public static /* synthetic */ FamilyFragment copy$default(FamilyFragment familyFragment, ObjectKind objectKind, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            objectKind = familyFragment.kind;
        }
        if ((n & 2) != 0) {
            set = familyFragment.names;
        }
        return familyFragment.copy(objectKind, set);
    }

    public int hashCode() {
        int result2 = this.kind.hashCode();
        result2 = result2 * 31 + ((Object)this.names).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FamilyFragment)) {
            return false;
        }
        FamilyFragment familyFragment = (FamilyFragment)other;
        if (!Intrinsics.areEqual((Object)this.kind, (Object)familyFragment.kind)) {
            return false;
        }
        return Intrinsics.areEqual(this.names, familyFragment.names);
    }
}

