/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NlsSafe;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u001a\u0010\u000b\u001a\u00020\u00052\b\b\u0001\u0010\f\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\"\u000e\u0010\b\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u000ej\b\u0012\u0004\u0012\u00020\u0003`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"isPermissionForProtocolGiven", "", "protocol", "", "showNotificationToAllowUrlProtocolOpening", "", "project", "Lcom/intellij/openapi/project/Project;", "HTTP", "HTTPS", "FILE", "showNotification", "message", "POPULAR_TLDS", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "intellij.database.impl"})
public final class NavigateUrlActionKt {
    @NotNull
    private static final String HTTP = "http";
    @NotNull
    private static final String HTTPS = "https";
    @NotNull
    private static final String FILE = "file";
    @NotNull
    private static final HashSet<String> POPULAR_TLDS;

    private static final boolean isPermissionForProtocolGiven(String protocol) {
        DatabaseSettings settings = DatabaseSettings.getSettings();
        return Intrinsics.areEqual((Object)protocol, (Object)HTTPS) && settings.isOpeningOfHttpsLinksAllowed() ? true : (Intrinsics.areEqual((Object)protocol, (Object)HTTP) && settings.isOpeningOfHttpLinksAllowed() ? true : Intrinsics.areEqual((Object)protocol, (Object)FILE) && settings.isOpeningOfLocalFileUrlsAllowed());
    }

    private static final void showNotificationToAllowUrlProtocolOpening(String protocol, Project project) {
        Object object = new Object[]{protocol};
        String string = DatabaseBundle.message("notification.content.enable.opening.url", object);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        MessageType messageType = MessageType.INFO;
        Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"INFO");
        Notification notification = DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(string, messageType);
        object = switch (protocol) {
            case HTTP -> DatabaseBundle.message("settings.data.urls.allow.click.on.http.url", new Object[0]);
            case HTTPS -> DatabaseBundle.message("settings.data.urls.allow.click.on.https.url", new Object[0]);
            case FILE -> DatabaseBundle.message("settings.data.urls.allow.click.on.local.file.url", new Object[0]);
            default -> "";
        };
        Intrinsics.checkNotNull((Object)object);
        Object settingsFilterString = object;
        notification.addAction((AnAction)NotificationAction.createSimple((String)DatabaseBundle.message("action.DataViews.Settings.text", new Object[0]), () -> NavigateUrlActionKt.showNotificationToAllowUrlProtocolOpening$lambda$0(notification, project, (String)settingsFilterString)));
        notification.notify(project);
    }

    private static final void showNotification(@NlsSafe String message, Project project) {
        MessageType messageType = MessageType.INFO;
        Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"INFO");
        Notification notification = DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(message, messageType);
        notification.notify(project);
    }

    private static final void showNotificationToAllowUrlProtocolOpening$lambda$0(Notification $notification, Project $project, String $settingsFilterString) {
        $notification.expire();
        ShowSettingsUtilImpl.Companion.showSettingsDialog($project, "database.data.views", $settingsFilterString);
    }

    public static final /* synthetic */ boolean access$isPermissionForProtocolGiven(String protocol) {
        return NavigateUrlActionKt.isPermissionForProtocolGiven(protocol);
    }

    public static final /* synthetic */ void access$showNotificationToAllowUrlProtocolOpening(String protocol, Project project) {
        NavigateUrlActionKt.showNotificationToAllowUrlProtocolOpening(protocol, project);
    }

    public static final /* synthetic */ HashSet access$getPOPULAR_TLDS$p() {
        return POPULAR_TLDS;
    }

    public static final /* synthetic */ void access$showNotification(String message, Project project) {
        NavigateUrlActionKt.showNotification(message, project);
    }

    static {
        Object[] objectArray = new String[]{"com", "org", "ru", "net", "de", "com.br", "ir", "co.uk", "pl", "it", "com.au", "fr", "info", "in", "cz", "es", "io", "jp", "ro", "nl", "gr", "co", "ca", "eu", "ch", "com.tw", "se", "sk", "hu", "me", "co.za", "no", "tv", "dk", "at", "co.jp", "edu", "be", "cn", "co.kr", "com.ar", "com.ua", "cl", "biz", "xyz", "com.mx", "fi", "us", "vn", "pt", "com.tr", "club", "ie", "pro", "online", "co.in", "ua", "org.uk", "cc", "az", "by", "mx", "tw", "co.il", "gov.in", "com.cn", "kz", "bg", "lt", "site", "su", "hr", "org.br", "gov", "com.pl", "co.nz", "si", "top", "ac.in", "com.hk", "com.sg", "rs", "com.co", "kr", "co.id", "pw", "uz", "com.my", "ae", "nic.in", "com.vn", "hk", "org.au", "tk", "lv", "live", "to", "mobi", "gov.cn", "ac.uk", "id", "org.tw", "ee", "or.jp", "go.id", "cat", "or.kr", "pk", "sg", "ws", "edu.cn", "ac.ir", "co.th", "uk", "com.ng", "gob.mx", "gov.uk", "news", "ma", "ac.id", "is", "go.th", "edu.mx", "fm", "in.ua", "lk", "edu.br", "ge", "xxx", "am", "ai", "my", "life", "edu.vn", "shop", "space", "nu", "edu.in", "asia", "com.pk", "org.ua", "cf", "br", "website", "lu", "ml", "guru", "pe", "go.kr", "today", "ba", "icu", "blog", "ac.jp", "ga", "gov.tr", "ac.th", "store", "ph", "gov.tw", "tech", "edu.co", "gov.co", "gov.it", "com.ph", "com.pe", "gov.br", "gov.bd", "net.br", "fun", "edu.hk", "ng", "cloud", "net.au", "app", "gov.my", "edu.pl", "org.in", "host", "edu.au", "org.ar", "gg", "win", "edu.pk", "com.sa", "gov.au", "link", "md", "one", "ne.jp", "com.ve", "gob.pe", "media", "sp.gov.br", "edu.tr", "gov.ua", "gob.ar", "edu.tw", "org.tr", "tn", "dz", "kiev.ua", "edu.ar", "ac.kr", "ly", "travel", "mk", "work", "nhs.uk", "world", "la", "org.cn", "gov.ar", "edu.ng", "org.hk", "co.ke", "al", "edu.pe", "com.do", "com.uy", "in.th", "video", "name", "org.za", "org.pl", "gov.pk", "sa", "gov.sa", "mn", "aero", "network", "org.mx", "vip", "download", "net.ua", "bz", "mg.gov.br", "kg", "global", "im", "rocks", "pr.gov.br", "edu.my", "coop", "gov.vn", "gov.az", "gov.hk", "stream", "net.pl"};
        POPULAR_TLDS = SetsKt.hashSetOf((Object[])objectArray);
    }
}

