/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model;

import com.intellij.database.Dbms;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.MultiElementIdentity;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbEditorModelListener;
import com.intellij.database.schemaEditor.model.DbModelIdentity;
import com.intellij.database.schemaEditor.model.applier.DbModelApplier;
import com.intellij.database.schemaEditor.model.applier.DbModelMultiApplier;
import com.intellij.database.schemaEditor.model.state.DbModelState;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.lang.ref.WeakReference;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbEditorModelBase<E extends BasicElement, S extends DbModelState>
implements DbEditorModel<E, S> {
    private final DbEditorModelController myController;
    private final @NlsContexts.Label String myTitle;
    private final S myState;
    private final DbModelApplier<E, S> myApplier;
    private final DbModelMultiApplier<E, S> myMultiApplier;
    private final DbEditorModelListener myListener;
    private final WeakListener myWeakListener;
    private final DbModelIdentity<E, S> myModelIdentity;

    public DbEditorModelBase(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> identity, @NlsContexts.Label @Nullable String title, @NotNull S state, @NotNull DbModelApplier<E, S> applier, @Nullable DbModelMultiApplier<E, S> multiApplier) {
        if (controller == null) {
            DbEditorModelBase.$$$reportNull$$$0(0);
        }
        if (identity == null) {
            DbEditorModelBase.$$$reportNull$$$0(1);
        }
        if (state == null) {
            DbEditorModelBase.$$$reportNull$$$0(2);
        }
        if (applier == null) {
            DbEditorModelBase.$$$reportNull$$$0(3);
        }
        this.myController = controller;
        this.myTitle = title;
        this.myState = state;
        this.myApplier = applier;
        ((StateBase)this.myState).subscribe(this::fireModified);
        this.myMultiApplier = multiApplier;
        this.myModelIdentity = new DbModelIdentity(identity, this.myApplier.getModelInternalKey());
        this.myListener = ((ApplierBase)applier).createListener(this);
        this.myWeakListener = this.myListener == null ? null : new WeakListener(this.myListener);
        this.myController.track(this);
    }

    private void fireModified() {
        ((ApplierBase)this.myApplier).modified(this);
    }

    @Override
    @NotNull
    public DbModelIdentity<E, S> getModelIdentity() {
        DbModelIdentity<E, S> dbModelIdentity = this.myModelIdentity;
        if (dbModelIdentity == null) {
            DbEditorModelBase.$$$reportNull$$$0(4);
        }
        return dbModelIdentity;
    }

    @Override
    @NotNull
    public S getState() {
        S s = this.myState;
        if (s == null) {
            DbEditorModelBase.$$$reportNull$$$0(5);
        }
        return s;
    }

    @Override
    @NotNull
    public DbModelApplier<E, S> getApplier() {
        DbModelApplier<E, S> dbModelApplier = this.myApplier;
        if (dbModelApplier == null) {
            DbEditorModelBase.$$$reportNull$$$0(6);
        }
        return dbModelApplier;
    }

    @Override
    @Nullable
    public DbModelMultiApplier<E, S> getMultiApplier() {
        return this.myMultiApplier;
    }

    @Override
    @NotNull
    public final ElementIdentity<E> getIdentity() {
        ElementIdentity<E> elementIdentity = this.myModelIdentity.getIdentity();
        if (elementIdentity == null) {
            DbEditorModelBase.$$$reportNull$$$0(7);
        }
        return elementIdentity;
    }

    @Override
    @NotNull
    public BasicMetaId getModelInternalKey() {
        BasicMetaId basicMetaId = this.myModelIdentity.getInternalKey();
        if (basicMetaId == null) {
            DbEditorModelBase.$$$reportNull$$$0(8);
        }
        return basicMetaId;
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.getController().getDbms(this.getIdentity());
        if (dbms == null) {
            DbEditorModelBase.$$$reportNull$$$0(9);
        }
        return dbms;
    }

    @Override
    @NotNull
    public final DbEditorModelController getController() {
        DbEditorModelController dbEditorModelController = this.myController;
        if (dbEditorModelController == null) {
            DbEditorModelBase.$$$reportNull$$$0(10);
        }
        return dbEditorModelController;
    }

    @Override
    @Nullable
    public final String getTitle() {
        return this.myTitle;
    }

    @Override
    public boolean register() {
        return ((StateBase)this.getState()).register(this);
    }

    @Override
    public boolean unregister() {
        return ((StateBase)this.getState()).unregister(this);
    }

    @Override
    public boolean isRegistered() {
        return ((StateBase)this.getState()).isRegistered();
    }

    protected void modified() {
        ((StateBase)this.getState()).modified();
    }

    private static void modifiedImpl(@NotNull DbEditorModel<?, ?> model) {
        if (model == null) {
            DbEditorModelBase.$$$reportNull$$$0(11);
        }
        DbEditorModelController controller = model.getController();
        ((DbEditorModelListener)controller.getEventDispatcher().getMulticaster()).modified(model);
    }

    private static void appliedImpl(@NotNull DbEditorModel<?, ?> model) {
        if (model == null) {
            DbEditorModelBase.$$$reportNull$$$0(12);
        }
        DbEditorModelController controller = model.getController();
        ((DbEditorModelListener)controller.getEventDispatcher().getMulticaster()).applied(model);
    }

    protected String getDebugString() {
        String title = this.getTitle();
        return title == null ? this.getModelInternalKey().name : title;
    }

    public String toString() {
        return this.getIdentity() + " " + this.getDebugString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identity";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applier";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/model/DbEditorModelBase";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/model/DbEditorModelBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelIdentity";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplier";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentity";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelInternalKey";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getController";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "modifiedImpl";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "appliedImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9, 10 -> new IllegalStateException(string);
        };
    }

    public static class StateBase
    implements DbModelState {
        private boolean myRegistered;
        protected Runnable myListener;
        private boolean myEnabled = true;
        private boolean myInconsistent;
        private int myForceModifiedCounter;

        protected void subscribe(@NotNull Runnable listener2) {
            if (listener2 == null) {
                StateBase.$$$reportNull$$$0(0);
            }
            if (this.myListener != null) {
                throw new AssertionError((Object)"Already bound");
            }
            this.myListener = listener2;
        }

        public final void modified() {
            if (this.myListener != null) {
                this.myListener.run();
            }
        }

        @Override
        public boolean isEnabled() {
            return this.myEnabled;
        }

        @Override
        public void setEnabled(boolean enabled) {
            if (this.myEnabled == enabled) {
                return;
            }
            this.myEnabled = enabled;
            this.modified();
        }

        @Override
        public boolean isInconsistent() {
            return this.myInconsistent;
        }

        @Override
        public void setInconsistent(boolean inconsistent) {
            if (this.myInconsistent == inconsistent) {
                return;
            }
            this.myInconsistent = inconsistent;
            this.modified();
        }

        public void forceModified() {
            ++this.myForceModifiedCounter;
            this.modified();
        }

        public void transferForceModifiedFrom(@NotNull DbModelState o) {
            if (o == null) {
                StateBase.$$$reportNull$$$0(1);
            }
            if (o instanceof StateBase) {
                StateBase os = (StateBase)o;
                if (os.myForceModifiedCounter != this.myForceModifiedCounter) {
                    this.myForceModifiedCounter = os.myForceModifiedCounter;
                    this.modified();
                }
            }
        }

        public boolean register(@NotNull DbEditorModel<?, ?> model) {
            WeakListener applierListener;
            if (model == null) {
                StateBase.$$$reportNull$$$0(2);
            }
            if (this.myRegistered) {
                return false;
            }
            this.myRegistered = true;
            EventDispatcher<DbEditorModelListener> dispatcher = model.getController().getEventDispatcher();
            if (model instanceof DbEditorModelBase) {
                DbEditorModelBase mb = (DbEditorModelBase)model;
                v0 = mb.myWeakListener;
            } else {
                v0 = applierListener = null;
            }
            if (applierListener != null) {
                dispatcher.addListener((EventListener)applierListener);
            }
            ((DbEditorModelListener)dispatcher.getMulticaster()).created(model);
            return true;
        }

        public boolean unregister(@NotNull DbEditorModel<?, ?> model) {
            WeakListener applierListener;
            if (model == null) {
                StateBase.$$$reportNull$$$0(3);
            }
            if (!this.myRegistered) {
                return false;
            }
            this.myRegistered = false;
            EventDispatcher<DbEditorModelListener> dispatcher = model.getController().getEventDispatcher();
            ((DbEditorModelListener)dispatcher.getMulticaster()).removed(model);
            if (model instanceof DbEditorModelBase) {
                DbEditorModelBase mb = (DbEditorModelBase)model;
                v0 = mb.myWeakListener;
            } else {
                v0 = applierListener = null;
            }
            if (applierListener != null) {
                dispatcher.removeListener((EventListener)applierListener);
            }
            return true;
        }

        boolean isRegistered() {
            return this.myRegistered;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/schemaEditor/model/DbEditorModelBase$StateBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "subscribe";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "transferForceModifiedFrom";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "register";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "unregister";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class ApplierBase<E extends BasicElement, S extends DbModelState>
    implements DbModelApplier<E, S> {
        private final BasicMetaId myModelInternalKey;

        protected ApplierBase(@NotNull BasicMetaId modelInternalKey) {
            if (modelInternalKey == null) {
                ApplierBase.$$$reportNull$$$0(0);
            }
            this.myModelInternalKey = modelInternalKey;
        }

        @Override
        @NotNull
        public final BasicMetaId getModelInternalKey() {
            BasicMetaId basicMetaId = this.myModelInternalKey;
            if (basicMetaId == null) {
                ApplierBase.$$$reportNull$$$0(1);
            }
            return basicMetaId;
        }

        @Override
        public final void resolve(@NotNull DbEditorModel<E, S> model, @NotNull ElementOwner owner) {
            E e;
            if (model == null) {
                ApplierBase.$$$reportNull$$$0(2);
            }
            if (owner == null) {
                ApplierBase.$$$reportNull$$$0(3);
            }
            if ((e = owner.find(model.getIdentity())) != null) {
                this.resolveImpl(model, owner, e);
                this.enable(model, owner, e);
            }
        }

        @Override
        public final void enable(@NotNull DbEditorModel<E, S> model, @NotNull ElementOwner owner) {
            if (model == null) {
                ApplierBase.$$$reportNull$$$0(4);
            }
            if (owner == null) {
                ApplierBase.$$$reportNull$$$0(5);
            }
            E e = owner.find(model.getIdentity());
            this.enable(model, owner, e);
        }

        @Override
        public Iterable<DbEditorModel<?, ?>> getDependencies(@NotNull DbEditorModel<E, S> model) {
            if (model == null) {
                ApplierBase.$$$reportNull$$$0(6);
            }
            return JBIterable.empty();
        }

        @Override
        public final void apply(@NotNull DbEditorModel<E, S> model, @NotNull ElementOwner owner) {
            E e;
            if (model == null) {
                ApplierBase.$$$reportNull$$$0(7);
            }
            if (owner == null) {
                ApplierBase.$$$reportNull$$$0(8);
            }
            if ((e = owner.find(model.getIdentity())) != null) {
                this.applyImpl(model, owner, e);
            }
            DbEditorModelBase.appliedImpl(model);
        }

        @Override
        public final void reset(@NotNull DbEditorModel<E, S> model, @NotNull ElementOwner owner) {
            E e;
            if (model == null) {
                ApplierBase.$$$reportNull$$$0(9);
            }
            if (owner == null) {
                ApplierBase.$$$reportNull$$$0(10);
            }
            if ((e = owner.find(model.getIdentity())) != null) {
                this.resetImpl(model, owner, e);
            }
            this.enable(model, owner, e);
            DbEditorModelBase.appliedImpl(model);
        }

        @Override
        public final boolean differsFrom(@NotNull DbEditorModel<E, S> model, @NotNull ElementOwner owner) {
            E e;
            if (model == null) {
                ApplierBase.$$$reportNull$$$0(11);
            }
            if (owner == null) {
                ApplierBase.$$$reportNull$$$0(12);
            }
            if ((e = owner.find(model.getIdentity())) == null) {
                return false;
            }
            return this.differsFromImpl(model, owner, e);
        }

        @Override
        public void copyState(@NotNull DbEditorModel<E, S> from, @NotNull DbEditorModel<E, S> to) {
            if (from == null) {
                ApplierBase.$$$reportNull$$$0(13);
            }
            if (to == null) {
                ApplierBase.$$$reportNull$$$0(14);
            }
            to.getState().setEnabled(from.getState().isEnabled());
            to.getState().setInconsistent(from.getState().isInconsistent());
            S s = to.getState();
            if (s instanceof StateBase) {
                StateBase sb = (StateBase)s;
                sb.transferForceModifiedFrom((DbModelState)from.getState());
            }
        }

        protected abstract void applyImpl(@NotNull DbEditorModel<E, S> var1, @NotNull ElementOwner var2, @NotNull E var3);

        protected abstract void resetImpl(@NotNull DbEditorModel<E, S> var1, @NotNull ElementOwner var2, @NotNull E var3);

        protected void resolveImpl(@NotNull DbEditorModel<E, S> model, @NotNull ElementOwner owner, @NotNull E e) {
            if (model == null) {
                ApplierBase.$$$reportNull$$$0(15);
            }
            if (owner == null) {
                ApplierBase.$$$reportNull$$$0(16);
            }
            if (e == null) {
                ApplierBase.$$$reportNull$$$0(17);
            }
        }

        public abstract boolean isEnabled(@NotNull DbEditorModel<E, S> var1, @NotNull ElementOwner var2, @Nullable E var3);

        protected void enable(@NotNull DbEditorModel<E, S> model, @NotNull ElementOwner owner, @Nullable E e) {
            if (model == null) {
                ApplierBase.$$$reportNull$$$0(18);
            }
            if (owner == null) {
                ApplierBase.$$$reportNull$$$0(19);
            }
            model.getState().setEnabled(this.isEnabled(model, owner, e));
        }

        protected static <E extends BasicElement, S extends DbModelState> boolean isEnabledImpl(@NotNull DbEditorModel<E, S> model) {
            ElementIdentity<E> identity;
            List<ElementIdentity<E>> multi;
            if (model == null) {
                ApplierBase.$$$reportNull$$$0(20);
            }
            return (multi = MultiElementIdentity.getIdentities(identity = model.getIdentity())) == null || model.getMultiApplier() != null;
        }

        protected static <E extends BasicElement, S extends DbModelState> boolean isEnabledImpl(@NotNull DbEditorModel<E, S> model, @NotNull ElementOwner owner, @Nullable E e, @NotNull BasicMetaId propId) {
            if (model == null) {
                ApplierBase.$$$reportNull$$$0(21);
            }
            if (owner == null) {
                ApplierBase.$$$reportNull$$$0(22);
            }
            if (propId == null) {
                ApplierBase.$$$reportNull$$$0(23);
            }
            if (!ApplierBase.isEnabledImpl(model)) {
                return false;
            }
            ElementIdentity<E> identity = model.getIdentity();
            List<ElementIdentity<E>> multi = MultiElementIdentity.getIdentities(identity);
            DbEditorModelController controller = model.getController();
            if (multi != null) {
                return ContainerUtil.all(multi, id -> controller.getBuilder().isEnabled(controller, (ElementIdentity<?>)id, (BasicElement)owner.find(id), propId));
            }
            return controller.getBuilder().isEnabled(controller, identity, e, propId);
        }

        protected abstract boolean differsFromImpl(@NotNull DbEditorModel<E, S> var1, @NotNull ElementOwner var2, @NotNull E var3);

        @Override
        @Nullable
        public BasicMetaType<?> getValueType() {
            return null;
        }

        protected void modified(@NotNull DbEditorModel<E, S> model) {
            if (model == null) {
                ApplierBase.$$$reportNull$$$0(24);
            }
            DbEditorModelBase.modifiedImpl(model);
        }

        @Nullable
        protected DbEditorModelListener createListener(@NotNull DbEditorModel<E, S> model) {
            if (model == null) {
                ApplierBase.$$$reportNull$$$0(25);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelInternalKey";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/model/DbEditorModelBase$ApplierBase";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 7: 
                case 9: 
                case 11: 
                case 15: 
                case 18: 
                case 20: 
                case 21: 
                case 24: 
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 3: 
                case 5: 
                case 8: 
                case 10: 
                case 12: 
                case 16: 
                case 19: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/model/DbEditorModelBase$ApplierBase";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModelInternalKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
                case 4: 
                case 5: 
                case 18: 
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "enable";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getDependencies";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "differsFrom";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "copyState";
                    break;
                }
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "resolveImpl";
                    break;
                }
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "isEnabledImpl";
                    break;
                }
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "modified";
                    break;
                }
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "createListener";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class WeakListener
    implements DbEditorModelListener {
        private static final DbEditorModelListener DUMMY = new DbEditorModelListener(){};
        private final WeakReference<DbEditorModelListener> myListener;

        private WeakListener(DbEditorModelListener listener2) {
            this.myListener = new WeakReference<DbEditorModelListener>(listener2);
        }

        @NotNull
        private DbEditorModelListener get(@NotNull DbEditorModel<?, ?> model) {
            DbEditorModelListener listener2;
            if (model == null) {
                WeakListener.$$$reportNull$$$0(0);
            }
            if ((listener2 = (DbEditorModelListener)this.myListener.get()) != null) {
                DbEditorModelListener dbEditorModelListener = listener2;
                if (dbEditorModelListener == null) {
                    WeakListener.$$$reportNull$$$0(1);
                }
                return dbEditorModelListener;
            }
            model.getController().getEventDispatcher().removeListener((EventListener)this);
            DbEditorModelListener dbEditorModelListener = DUMMY;
            if (dbEditorModelListener == null) {
                WeakListener.$$$reportNull$$$0(2);
            }
            return dbEditorModelListener;
        }

        @Override
        public void created(@NotNull DbEditorModel<?, ?> model) {
            if (model == null) {
                WeakListener.$$$reportNull$$$0(3);
            }
            this.get(model).created(model);
        }

        @Override
        public void modified(@NotNull DbEditorModel<?, ?> model) {
            if (model == null) {
                WeakListener.$$$reportNull$$$0(4);
            }
            this.get(model).modified(model);
        }

        @Override
        public void removed(@NotNull DbEditorModel<?, ?> model) {
            if (model == null) {
                WeakListener.$$$reportNull$$$0(5);
            }
            this.get(model).removed(model);
        }

        @Override
        public void applied(@NotNull DbEditorModel<?, ?> model) {
            if (model == null) {
                WeakListener.$$$reportNull$$$0(6);
            }
            this.get(model).applied(model);
        }

        @Override
        public void forgotten(@NotNull DbModelIdentity<?, ?> modelId) {
            if (modelId == null) {
                WeakListener.$$$reportNull$$$0(7);
            }
            DbEditorModelListener.super.forgotten(modelId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/model/DbEditorModelBase$WeakListener";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/model/DbEditorModelBase$WeakListener";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "created";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "modified";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "removed";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "applied";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "forgotten";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    public static abstract class MultiApplierBase<E extends BasicElement, S extends DbModelState>
    implements DbModelMultiApplier<E, S> {
        @Nullable
        private MultiElementIdentity<E> getMultiIdentity(@NotNull DbEditorModel<E, S> model) {
            if (model == null) {
                MultiApplierBase.$$$reportNull$$$0(0);
            }
            return (MultiElementIdentity)ObjectUtils.tryCast(model.getIdentity(), MultiElementIdentity.class);
        }

        @Override
        public final void apply(@NotNull DbEditorModel<E, S> model, @NotNull ElementOwner owner) {
            if (model == null) {
                MultiApplierBase.$$$reportNull$$$0(1);
            }
            if (owner == null) {
                MultiApplierBase.$$$reportNull$$$0(2);
            }
            this.applyImpl(model, owner, this.resolveModels(model));
            DbEditorModelBase.appliedImpl(model);
        }

        @Override
        public final void reset(@NotNull DbEditorModel<E, S> model, @NotNull ElementOwner owner) {
            if (model == null) {
                MultiApplierBase.$$$reportNull$$$0(3);
            }
            if (owner == null) {
                MultiApplierBase.$$$reportNull$$$0(4);
            }
            this.resetImpl(model, owner, this.resolveModels(model));
            DbEditorModelBase.appliedImpl(model);
        }

        @Override
        public void resolve(@NotNull DbEditorModel<E, S> model, @NotNull ElementOwner owner) {
            if (model == null) {
                MultiApplierBase.$$$reportNull$$$0(5);
            }
            if (owner == null) {
                MultiApplierBase.$$$reportNull$$$0(6);
            }
            this.resolveImpl(model, owner, this.resolveModels(model));
            DbEditorModelBase.appliedImpl(model);
        }

        protected List<DbEditorModel<E, S>> resolveModels(@NotNull DbEditorModel<E, S> model) {
            MultiElementIdentity<E> identity;
            if (model == null) {
                MultiApplierBase.$$$reportNull$$$0(7);
            }
            if ((identity = this.getMultiIdentity(model)) == null) {
                return null;
            }
            DbModelIdentity modelId = model.getModelIdentity();
            return ContainerUtil.mapNotNull(identity.getIdentities(), id -> id == null ? null : model.getController().resolveModel(modelId.switchTo((ElementIdentity)id)));
        }

        protected abstract void applyImpl(@NotNull DbEditorModel<E, S> var1, @NotNull ElementOwner var2, @NotNull List<DbEditorModel<E, S>> var3);

        protected abstract void resetImpl(@NotNull DbEditorModel<E, S> var1, @NotNull ElementOwner var2, @NotNull List<DbEditorModel<E, S>> var3);

        protected void resolveImpl(@NotNull DbEditorModel<E, S> model, @NotNull ElementOwner owner, @NotNull List<DbEditorModel<E, S>> models2) {
            if (model == null) {
                MultiApplierBase.$$$reportNull$$$0(8);
            }
            if (owner == null) {
                MultiApplierBase.$$$reportNull$$$0(9);
            }
            if (models2 == null) {
                MultiApplierBase.$$$reportNull$$$0(10);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "models";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/schemaEditor/model/DbEditorModelBase$MultiApplierBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getMultiIdentity";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "apply";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reset";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolve";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveModels";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveImpl";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

