/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbModelIdentity;
import com.intellij.database.schemaEditor.model.DbModelLiteRef;
import com.intellij.database.schemaEditor.model.applier.DbModelApplier;
import com.intellij.database.schemaEditor.model.state.DbModelState;
import com.intellij.util.containers.JBIterable;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbModelRef<E extends BasicElement, S extends DbModelState>
implements DbModelLiteRef<E, S> {
    private final DbEditorModel<E, S> myModel;

    public DbModelRef(@NotNull DbEditorModel<E, S> model) {
        if (model == null) {
            DbModelRef.$$$reportNull$$$0(0);
        }
        this.myModel = model;
    }

    @NotNull
    public DbEditorModel<E, S> resolve(@NotNull DbEditorModelController controller) {
        if (controller == null) {
            DbModelRef.$$$reportNull$$$0(1);
        }
        if (controller != this.myModel.getController()) {
            throw new IllegalArgumentException("Not supported for now");
        }
        DbEditorModel<E, S> dbEditorModel = this.myModel;
        if (dbEditorModel == null) {
            DbModelRef.$$$reportNull$$$0(2);
        }
        return dbEditorModel;
    }

    @Override
    @Nullable
    public DbEditorModel<E, S> resolveOpt(@NotNull DbEditorModelController controller) {
        if (controller == null) {
            DbModelRef.$$$reportNull$$$0(3);
        }
        if (controller == this.myModel.getController()) {
            return this.myModel;
        }
        return controller.resolveRegisteredOrCachedModel(this.getModelIdentity());
    }

    public boolean isRefTo(@Nullable DbEditorModel<?, ?> m) {
        return m == this.myModel;
    }

    @Override
    @NotNull
    public DbModelIdentity<E, S> getModelIdentity() {
        DbModelIdentity<E, S> dbModelIdentity = this.myModel.getModelIdentity();
        if (dbModelIdentity == null) {
            DbModelRef.$$$reportNull$$$0(4);
        }
        return dbModelIdentity;
    }

    @NotNull
    public S getState() {
        S s = this.myModel.getState();
        if (s == null) {
            DbModelRef.$$$reportNull$$$0(5);
        }
        return s;
    }

    @NotNull
    public DbModelApplier<E, S> getApplier() {
        DbModelApplier<E, S> dbModelApplier = this.myModel.getApplier();
        if (dbModelApplier == null) {
            DbModelRef.$$$reportNull$$$0(6);
        }
        return dbModelApplier;
    }

    @Contract(value="!null,!null->!null")
    public <E2 extends BasicElement, S2 extends DbModelState> DbModelRef<E2, S2> cast(@Nullable ElementIdentity<E2> castedId, @Nullable S2 castedState) {
        if (castedId == null || castedState == null) {
            return null;
        }
        assert (this.getState() == castedState && castedId == this.getIdentity());
        return this;
    }

    @Contract(value="!null->!null;null->null")
    public <S2 extends DbModelState> DbModelRef<E, S2> castState(@Nullable S2 casted) {
        return this.cast(this.getIdentity(), casted);
    }

    @Contract(value="!null->!null;null->null")
    public <E2 extends BasicElement> DbModelRef<E2, S> castIdentity(@Nullable ElementIdentity<E2> casted) {
        return this.cast(casted, (DbModelState)this.getState());
    }

    public boolean isBoundTo(@NotNull DbEditorModelController controller) {
        if (controller == null) {
            DbModelRef.$$$reportNull$$$0(7);
        }
        return this.myModel.getController() == controller;
    }

    @NotNull
    public static JBIterable<DbEditorModel<?, ?>> resolveRefs(DbEditorModelController controller, Iterable<DbModelRef<?, ?>> states) {
        JBIterable jBIterable = JBIterable.from(states).map(r -> r.resolve(controller));
        if (jBIterable == null) {
            DbModelRef.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    public static boolean isRefTo(@Nullable DbModelRef<?, ?> r, @Nullable DbEditorModel<?, ?> m) {
        return r == null ? m == null : r.isRefTo(m);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DbModelRef)) {
            return false;
        }
        DbModelRef ref2 = (DbModelRef)o;
        return Objects.equals(this.getModelIdentity(), ref2.getModelIdentity());
    }

    public int hashCode() {
        return this.getModelIdentity().hashCode();
    }

    public String toString() {
        return "ref: " + this.myModel;
    }

    public boolean register(@NotNull DbEditorModelController controller) {
        if (controller == null) {
            DbModelRef.$$$reportNull$$$0(9);
        }
        return this.resolve(controller).register();
    }

    public boolean unregister(@NotNull DbEditorModelController controller) {
        if (controller == null) {
            DbModelRef.$$$reportNull$$$0(10);
        }
        return this.resolve(controller).unregister();
    }

    @Contract(value="!null->!null;null->null")
    public static <E extends BasicElement, S extends DbModelState> DbModelRef<E, S> create(@Nullable DbEditorModel<E, S> model) {
        return model == null ? null : new DbModelRef<E, S>(model);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/model/DbModelRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/model/DbModelRef";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelIdentity";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplier";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveRefs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveOpt";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isBoundTo";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "unregister";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 6, 8 -> new IllegalStateException(string);
        };
    }
}

