/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.ui;

import com.intellij.database.dataSource.url.FieldSize;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.state.DbCompoundModelState;
import com.intellij.database.schemaEditor.model.state.DbModelState;
import com.intellij.database.schemaEditor.ui.DbEditor;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.DbVisualEditor;
import com.intellij.database.schemaEditor.ui.DbVisualEditorBase;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbCompoundEditor<E extends BasicElement, S extends DbModelState>
extends DbVisualEditorBase<E, S> {
    private final List<DbEditor<?, ?>> myEditors;

    protected DbCompoundEditor(@NotNull DbEditorController controller, @NotNull DbModelRef<E, S> modelRef, @NotNull List<DbModelRef<?, ?>> subModelRefs) {
        if (controller == null) {
            DbCompoundEditor.$$$reportNull$$$0(0);
        }
        if (modelRef == null) {
            DbCompoundEditor.$$$reportNull$$$0(1);
        }
        if (subModelRefs == null) {
            DbCompoundEditor.$$$reportNull$$$0(2);
        }
        super(controller, modelRef);
        this.myEditors = new ArrayList();
        this.createEditors(subModelRefs, this.myEditors);
    }

    private void createEditors(@NotNull Iterable<DbModelRef<?, ?>> subModels, List<DbEditor<?, ?>> editors2) {
        if (subModels == null) {
            DbCompoundEditor.$$$reportNull$$$0(3);
        }
        for (DbModelRef<?, ?> sub : subModels) {
            DbEditor<?, ?> editor2 = this.createSubEditor(sub);
            if (editor2 != null) {
                editors2.add(editor2);
                continue;
            }
            Object obj2 = sub.getState();
            if (!(obj2 instanceof DbCompoundModelState)) continue;
            DbCompoundModelState s = (DbCompoundModelState)obj2;
            ArrayList models2 = ContainerUtil.newArrayList(s.getSubStates());
            this.createEditors(models2, editors2);
        }
    }

    @Nullable
    protected DbEditor<?, ?> createSubEditor(@NotNull DbModelRef<?, ?> sub) {
        if (sub == null) {
            DbCompoundEditor.$$$reportNull$$$0(4);
        }
        return this.getController().createEditor(sub);
    }

    @Override
    public boolean register() {
        if (!super.register()) {
            return false;
        }
        this.myEditors.forEach(DbEditor::register);
        return true;
    }

    @Override
    public boolean unregister(boolean keepModel) {
        if (!super.unregister(keepModel)) {
            return false;
        }
        for (DbEditor<?, ?> myEditor : this.myEditors) {
            myEditor.unregister(keepModel);
        }
        return true;
    }

    @NotNull
    public List<DbEditor<?, ?>> getEditors() {
        List<DbEditor<?, ?>> list = this.myEditors;
        if (list == null) {
            DbCompoundEditor.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    public void applyImpl() {
    }

    @Override
    public void resetImpl() {
    }

    @Override
    @NotNull
    public FieldSize getFieldSize() {
        List sizes = JBIterable.from(this.myEditors).filter(DbVisualEditor.class).map(DbVisualEditor::getFieldSize).take(3).toList();
        if (sizes.size() == 1) {
            FieldSize fieldSize = (FieldSize)((Object)sizes.get(0));
            if (fieldSize == null) {
                DbCompoundEditor.$$$reportNull$$$0(6);
            }
            return fieldSize;
        }
        if (sizes.size() == 2 && sizes.get(0) == FieldSize.SMALL && sizes.get(1) == FieldSize.SMALL) {
            FieldSize fieldSize = FieldSize.MEDIUM;
            if (fieldSize == null) {
                DbCompoundEditor.$$$reportNull$$$0(7);
            }
            return fieldSize;
        }
        FieldSize fieldSize = FieldSize.LARGE;
        if (fieldSize == null) {
            DbCompoundEditor.$$$reportNull$$$0(8);
        }
        return fieldSize;
    }

    @Override
    public boolean isVertical() {
        return DbCompoundEditor.isVertical(this.myEditors);
    }

    protected static boolean isVertical(@NotNull List<? extends DbEditor<?, ?>> editors2) {
        if (editors2 == null) {
            DbCompoundEditor.$$$reportNull$$$0(9);
        }
        return ContainerUtil.find(editors2, e -> {
            DbVisualEditor ve;
            return e instanceof DbVisualEditor && (ve = (DbVisualEditor)e).isVertical();
        }) != null;
    }

    @Override
    public boolean isEmpty() {
        return ContainerUtil.all(this.getEditors(), DbEditor::isEmpty);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelRef";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subModelRefs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subModels";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sub";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbCompoundEditor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbCompoundEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditors";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createEditors";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createSubEditor";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isVertical";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

