/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script;

import com.intellij.database.script.MongoJSLanguage;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.sql.psi.IsExternal;
import com.intellij.sql.script.Script;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.testFramework.ReadOnlyLightVirtualFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptModelUtilCore {
    public static final Key<Long> PART_OFFSET = Key.create((String)"PART_OFFSET");
    public static final Key<Integer> PART_INDEX = Key.create((String)"PART_INDEX");
    public static final Key<Integer> PART_ERRORS = Key.create((String)"PART_ERRORS");
    public static final Key<DatabaseSettings.SplitScriptMode> SPLIT_SCRIPT_MODE = Key.create((String)"SPLIT_SCRIPT_MODE");
    public static final Function<ScriptModel.ModelIt<?>, TextRange> TO_RANGE = it -> it.range().shiftRight((int)it.rangeOffset());
    public static final Function<ScriptModel.ModelIt<?>, String> TO_TEXT = it -> it.text();
    public static final Function<ScriptModel.ModelIt<?>, IElementType> TO_TYPE = it -> it.type();
    public static final Function<ScriptModel.ModelIt<?>, Object> TO_OBJECT = it -> it.object();
    public static final Function<ScriptModel.ParamIt<?>, String> TO_NAME = it -> it.name();
    public static final Function<ScriptModel.StatementIt<?>, String> TO_QUERY = it -> it.query();

    protected ScriptModelUtilCore() {
    }

    @NotNull
    public static Condition<TextRange> INTERSECTS_RANGE(TextRange range) {
        Condition condition = r -> {
            int e;
            int s = Math.max(r.getStartOffset(), range.getStartOffset());
            if (s == (e = Math.min(r.getEndOffset(), range.getEndOffset()))) {
                return s == r.getEndOffset() || range.getLength() == 0;
            }
            return s < e;
        };
        if (condition == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(0);
        }
        return condition;
    }

    @NotNull
    public static Condition<TextRange> CONTAINS_RANGE(TextRange range) {
        Condition condition = r -> r.equals((Object)range) || r.contains(range);
        if (condition == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(1);
        }
        return condition;
    }

    @NotNull
    public static Condition<TextRange> IN_RANGE(TextRange range) {
        Condition condition = r -> range.contains(r);
        if (condition == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(2);
        }
        return condition;
    }

    @NotNull
    public static Condition<ScriptModel.ModelIt<?>> AT_OFFSET2(int offset) {
        Condition condition = o -> o.range().contains(offset);
        if (condition == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(3);
        }
        return condition;
    }

    @NotNull
    public static <V> Function<SyntaxTraverser<V>, SyntaxTraverser<V>> LIMIT_TO_RANGE(final TextRange range) {
        return new Function.Mono<SyntaxTraverser<V>>(){

            public SyntaxTraverser<V> fun(SyntaxTraverser<V> vs) {
                return ScriptModelUtilCore.inRange(vs, range);
            }
        };
    }

    @Nullable
    public static <V> DatabaseSettings.SplitScriptMode getSplitScriptMode(@NotNull Script<V> script2) {
        if (script2 == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(4);
        }
        try {
            Iterator iterator = script2.getScript().iterator();
            if (iterator.hasNext()) {
                SyntaxTraverser st = (SyntaxTraverser)iterator.next();
                return (DatabaseSettings.SplitScriptMode)((Object)st.getUserData(SPLIT_SCRIPT_MODE));
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    public static <V> SyntaxTraverser<V> inRange(@NotNull SyntaxTraverser<V> s, @NotNull TextRange range) {
        if (s == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(5);
        }
        if (range == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(6);
        }
        int partOffset = ScriptModelUtilCore.getPartOffsetAsInt(s);
        if (range.getStartOffset() < partOffset) {
            SyntaxTraverser syntaxTraverser = (SyntaxTraverser)s.expandAndFilter(Conditions.alwaysFalse());
            if (syntaxTraverser == null) {
                ScriptModelUtilCore.$$$reportNull$$$0(7);
            }
            return syntaxTraverser;
        }
        TextRange adjusted2 = range.shiftRight(-partOffset);
        SyntaxTraverser ranged = (SyntaxTraverser)s.onRange(Conditions.compose((Function)s.api.TO_RANGE, ScriptModelUtilCore.INTERSECTS_RANGE(adjusted2)));
        SyntaxTraverser syntaxTraverser = range instanceof ScriptModel.ChosenRange ? (SyntaxTraverser)ranged.filter(Conditions.compose((Function)s.api.TO_RANGE, ScriptModelUtilCore.IN_RANGE(adjusted2))) : ranged;
        if (syntaxTraverser == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(8);
        }
        return syntaxTraverser;
    }

    public static int getPartOffsetAsInt(SyntaxTraverser<?> s) {
        return (int)ScriptModelUtilCore.getPartOffset(s);
    }

    public static long getPartOffset(SyntaxTraverser<?> s) {
        Long o = (Long)s.getUserData(PART_OFFSET);
        return o == null ? 0L : o;
    }

    public static <V> String statementText(ScriptModel.StatementIt<V> st, ScriptModel.PStorage storage, Condition<? super ScriptModel.ParamIt<V>> paramCondition) {
        JBIterable params = st.parameters().filter(Conditions.not(paramCondition));
        JBIterable<ScriptModel.ExternalIt<V>> externals = st.externals();
        return ScriptModelUtilCore.statementText(storage, params, externals, st.text(), st.range().getStartOffset());
    }

    @NotNull
    public static String statementText(@NotNull ScriptModel.PStorage storage, @NotNull JBIterable<? extends ScriptModel.ParamIt<?>> params, @NotNull JBIterable<? extends ScriptModel.ExternalIt<?>> externals, @NotNull String text2, int offset) {
        if (storage == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(9);
        }
        if (params == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(10);
        }
        if (externals == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(11);
        }
        if (text2 == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(12);
        }
        int curIndex = 0;
        StringBuilder sb = null;
        ModificationIterator modificationIterator = new ModificationIterator(params.iterator(), externals.iterator());
        while (modificationIterator.hasNext()) {
            TextRange r;
            ScriptModel.ModelIt it;
            if (sb == null) {
                sb = new StringBuilder();
            }
            if ((it = (ScriptModel.ModelIt)modificationIterator.next()) instanceof ScriptModel.ParamIt) {
                r = it.range();
                if (curIndex > r.getStartOffset() - offset) continue;
                Object v = storage.getValue(((ScriptModel.ParamIt)it).name());
                if (v == null) {
                    sb.append(text2, curIndex, r.getEndOffset() - offset);
                } else {
                    sb.append(text2, curIndex, r.getStartOffset() - offset);
                    sb.append(v);
                }
                curIndex = r.getEndOffset() - offset;
                continue;
            }
            if (!(it instanceof ScriptModel.ExternalIt) || curIndex > (r = it.range()).getStartOffset() - offset) continue;
            sb.append(text2, curIndex, r.getStartOffset() - offset);
            sb.append(" ");
            curIndex = r.getEndOffset() - offset;
        }
        String string = sb == null ? text2 : sb.append(text2, curIndex, text2.length()).toString();
        if (string == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(13);
        }
        return string;
    }

    public static <V> void updateOriginVirtualFile(V current, @NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(14);
        }
        if (!(current instanceof PsiElement)) {
            return;
        }
        PsiFile file = ((PsiElement)current).getContainingFile();
        VirtualFile currentVirtualFile = file.getViewProvider().getVirtualFile();
        if (currentVirtualFile instanceof LightVirtualFile && ((LightVirtualFile)currentVirtualFile).getOriginalFile() == null) {
            VirtualFile origin = VirtualFileUtil.originalFileOrSelf((VirtualFile)virtualFile);
            ((LightVirtualFile)currentVirtualFile).setOriginalFile(origin);
        }
    }

    @NotNull
    public static <V> Iterable<String> getRelativeSnippet(V current, SyntaxTraverser.Api<V> api) {
        Object parent = api.parent(current);
        if (parent == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                ScriptModelUtilCore.$$$reportNull$$$0(15);
            }
            return jBIterable;
        }
        TextRange pr = api.rangeOf(parent);
        TextRange cr = api.rangeOf(current);
        int delta = 15;
        int a2 = cr.getStartOffset() - pr.getStartOffset();
        int b2 = cr.getEndOffset() - pr.getStartOffset();
        int s = Math.max(a2 - delta, 0);
        int e = Math.min(b2 + delta, pr.getLength());
        int a1 = s < delta ? 0 : s;
        int b1 = pr.getLength() - e < delta ? pr.getLength() : e;
        CharSequence t = api.textOf(parent);
        JBIterable jBIterable = JBIterable.of((Object[])new String[]{(a1 > 0 ? "..." : "") + t.subSequence(a1, a2), t.subSequence(a2, b2).toString(), t.subSequence(b2, b1) + (b1 < pr.getLength() ? "..." : "")});
        if (jBIterable == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(16);
        }
        return jBIterable;
    }

    @Contract(value="null -> false")
    public static boolean isJSFile(@Nullable PsiFile file) {
        return file != null && ScriptModelUtilCore.isJSFile(file.getProject(), file.getViewProvider().getVirtualFile());
    }

    @Contract(value="_,null -> false")
    public static boolean isJSFile(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(17);
        }
        return file != null && DbVFSUtils.isMongo(project, file);
    }

    @Nullable
    public static Language getHostLanguage(VirtualFile vFile) {
        VirtualFile virtualFile = vFile;
        if (virtualFile instanceof LightVirtualFile) {
            virtualFile = ((LightVirtualFile)virtualFile).getOriginalFile();
        }
        if (virtualFile instanceof VirtualFileWindow) {
            virtualFile = ((VirtualFileWindow)virtualFile).getDelegate();
        }
        return Comparing.equal((Object)virtualFile, (Object)vFile) ? null : LanguageUtil.getFileLanguage((VirtualFile)virtualFile);
    }

    public static int getSelectionOption(TextRange range) {
        return range instanceof ScriptModel.StrictRange ? 1 : (range instanceof ScriptModel.SmartRange ? 3 : 2);
    }

    @Nullable
    public static Language getJSLanguage() {
        Language lang = Language.findLanguageByID((String)"MongoJSExt");
        if (lang != null) {
            return lang;
        }
        lang = Language.findLanguageByID((String)"ECMAScript 6");
        if (lang != null) {
            return lang;
        }
        lang = Language.findLanguageByID((String)"JavaScript");
        if (lang != null) {
            return lang;
        }
        return MongoJSLanguage.INSTANCE;
    }

    @NotNull
    public static <V> Condition<V> wholeFileCondition(SyntaxTraverser<V> s, TextRange scriptRange, Condition<? super V> wsOrComment, Condition<? super V> isStatementSeparator, Condition<? super V> isStatement) {
        Condition condition = v -> {
            if (!(s.api.typeOf(v) instanceof IFileElementType)) {
                return false;
            }
            Condition isExternal = e -> s.api.typeOf(e) instanceof IsExternal;
            JBIterable it = ((SyntaxTraverser)((SyntaxTraverser)((SyntaxTraverser)s.withRoot(v)).reset()).expand(Conditions.not((Condition)isExternal))).preOrderDfsTraversal().skip(1);
            Object st = it.filter(isStatement).first();
            if (st == null) {
                return s.api.rangeOf(v).getLength() > 256 || !StringUtil.isEmptyOrSpaces((CharSequence)s.api.textOf(v));
            }
            if (!(scriptRange instanceof ScriptModel.PositionRange) && scriptRange.getLength() > 0) {
                if (scriptRange instanceof ScriptModel.StrictRange) {
                    return !Comparing.equal((Object)s.api.rangeOf(v), (Object)s.api.rangeOf(st));
                }
                return s.api.rangeOf(st).getStartOffset() > 0 && it.takeWhile(Conditions.notEqualTo((Object)st)).filter(o -> !wsOrComment.value(o) && !isStatementSeparator.value(o) && !isExternal.value(o)).isNotEmpty();
            }
            return ((SyntaxTraverser)s.withRoot(v)).preOrderDfsTraversal().take(3).size() > 2;
        };
        if (condition == null) {
            ScriptModelUtilCore.$$$reportNull$$$0(18);
        }
        return condition;
    }

    @Nullable
    public static Document getScriptDocument(VirtualFile virtualFile) {
        return virtualFile instanceof ReadOnlyLightVirtualFile || SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)virtualFile) ? null : (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(virtualFile));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5, 6, 9, 10, 11, 12, 14, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/script/ScriptModelUtilCore";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externals";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "INTERSECTS_RANGE";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "CONTAINS_RANGE";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "IN_RANGE";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "AT_OFFSET2";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/script/ScriptModelUtilCore";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "inRange";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "statementText";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativeSnippet";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "wholeFileCondition";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSplitScriptMode";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "inRange";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "statementText";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateOriginVirtualFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isJSFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5, 6, 9, 10, 11, 12, 14, 17 -> new IllegalArgumentException(string);
        };
    }

    private static class ModificationIterator
    implements Iterator<ScriptModel.ModelIt<?>> {
        private final Iterator<? extends ScriptModel.ParamIt<?>> paramIt;
        private final Iterator<? extends ScriptModel.ExternalIt<?>> externalIt;
        private ScriptModel.ModelIt<?> saved;

        ModificationIterator(@NotNull Iterator<? extends ScriptModel.ParamIt<?>> paramIt, @NotNull Iterator<? extends ScriptModel.ExternalIt<?>> externalIt) {
            if (paramIt == null) {
                ModificationIterator.$$$reportNull$$$0(0);
            }
            if (externalIt == null) {
                ModificationIterator.$$$reportNull$$$0(1);
            }
            this.paramIt = paramIt;
            this.externalIt = externalIt;
        }

        @Override
        public boolean hasNext() {
            return this.saved != null || this.paramIt.hasNext() || this.externalIt.hasNext();
        }

        @Override
        public ScriptModel.ModelIt<?> next() {
            ScriptModel.ParamIt<?> nextParam;
            ScriptModel.ParamIt<Object> paramIt = this.saved instanceof ScriptModel.ParamIt ? (ScriptModel.ParamIt<?>)this.saved : (nextParam = this.paramIt.hasNext() ? this.paramIt.next() : null);
            ScriptModel.ExternalIt nextExternal = this.saved instanceof ScriptModel.ExternalIt ? (ScriptModel.ExternalIt)this.saved : (this.externalIt.hasNext() ? (ScriptModel.ModelIt)this.externalIt.next() : null);
            this.saved = null;
            if (nextParam == null && nextExternal == null) {
                throw new NoSuchElementException();
            }
            if (nextParam == null) {
                return nextExternal;
            }
            if (nextExternal == null) {
                return nextParam;
            }
            if (nextParam.range().getStartOffset() < nextExternal.range().getStartOffset()) {
                this.saved = nextExternal;
                return nextParam;
            }
            this.saved = nextParam;
            return nextExternal;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "paramIt";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "externalIt";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/script/ScriptModelUtilCore$ModificationIterator";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class ParamHelper
    implements DocumentListener {
        private static final Key<ParamHelper> PARAM_NAMES = Key.create((String)"PARAM_NAMES");
        private final AtomicInteger counter = new AtomicInteger();
        private final ConcurrentMap<Segment, String> map = new ConcurrentHashMap<Segment, String>();

        private ParamHelper() {
        }

        public void beforeDocumentChange(@NotNull DocumentEvent e) {
            if (e == null) {
                ParamHelper.$$$reportNull$$$0(0);
            }
            if (this.map.size() < 100) {
                return;
            }
            Iterator it = this.map.keySet().iterator();
            while (it.hasNext()) {
                if (((RangeMarker)it.next()).isValid()) continue;
                it.remove();
            }
        }

        @NotNull
        public static String getAndCacheParameterId(@NotNull ScriptModel.ParamIt<?> it, @NotNull UserDataHolder userDataHolder) {
            TextRange segment;
            ParamHelper names;
            if (it == null) {
                ParamHelper.$$$reportNull$$$0(1);
            }
            if (userDataHolder == null) {
                ParamHelper.$$$reportNull$$$0(2);
            }
            if ((names = (ParamHelper)PARAM_NAMES.get(userDataHolder)) == null) {
                names = new ParamHelper();
                PARAM_NAMES.set(userDataHolder, (Object)names);
                if (userDataHolder instanceof Document) {
                    ((Document)userDataHolder).addDocumentListener((DocumentListener)names);
                }
            }
            TextRange r = it.range().shiftRight((int)it.rangeOffset());
            if (userDataHolder instanceof DocumentEx) {
                DocumentEx document = (DocumentEx)userDataHolder;
                Ref found = Ref.create();
                document.processRangeMarkersOverlappingWith(r.getStartOffset(), r.getEndOffset(), marker -> {
                    if (!r.equalsToRange(marker.getStartOffset(), marker.getEndOffset())) {
                        return true;
                    }
                    if (marker.isGreedyToRight()) {
                        return true;
                    }
                    found.set(marker);
                    return false;
                });
                RangeMarker marker2 = (RangeMarker)found.get();
                if (marker2 == null || !marker2.isValid()) {
                    marker2 = document.createRangeMarker(r);
                }
                segment = marker2;
            } else {
                segment = r;
            }
            String name2 = (String)names.map.get(segment);
            String string = name2 != null ? name2 : (String)ConcurrencyUtil.cacheOrGet(names.map, (Object)segment, (Object)("#" + names.counter.incrementAndGet()));
            if (string == null) {
                ParamHelper.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "it";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "userDataHolder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/script/ScriptModelUtilCore$ParamHelper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/script/ScriptModelUtilCore$ParamHelper";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAndCacheParameterId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "beforeDocumentChange";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getAndCacheParameterId";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

