/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.util.Case;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPart;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.view.DatabaseCoreUiService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class QNameUtil {
    private QNameUtil() {
    }

    @NlsSafe
    @NotNull
    public static String getQualifiedName(@Nullable DbElement element) {
        if (element instanceof DasDataSource) {
            String string = element.getName();
            if (string == null) {
                QNameUtil.$$$reportNull$$$0(0);
            }
            return string;
        }
        return QNameUtil.getQualifiedName((DasObject)element);
    }

    @NlsSafe
    @NotNull
    public static String getQualifiedName(@Nullable DasObject element) {
        return QNameUtil.getQualifiedName(element, DasUtil.TO_NAME);
    }

    @NlsSafe
    @NotNull
    public static String getQualifiedName(@Nullable ObjectPath element) {
        String string = element == null ? "" : element.getDisplayName();
        if (string == null) {
            QNameUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String getQualifiedName(@Nullable DasObject element, @NotNull NamingService namingService) {
        if (namingService == null) {
            QNameUtil.$$$reportNull$$$0(2);
        }
        return QNameUtil.getQualifiedName(element, (Function<? super DasObject, String>)((Function)object -> namingService.catToScript(object.getName(), object.getKind(), true)));
    }

    @NlsSafe
    @NotNull
    public static String getQualifiedName(@Nullable DasObject element, @NotNull Function<? super DasObject, String> namer) {
        if (namer == null) {
            QNameUtil.$$$reportNull$$$0(3);
        }
        List parents = DasUtil.dasParents(element).toList();
        StringBuilder sb = new StringBuilder();
        for (DasObject o : ContainerUtil.reverse((List)parents)) {
            if (sb.length() != 0) {
                sb.append(".");
            }
            sb.append((String)namer.fun((Object)o));
        }
        String string = sb.toString();
        if (string == null) {
            QNameUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static boolean fqnStartsWith(@NotNull String fqn, @NotNull DasObject object, @NotNull Function<? super DasObject, String> namer, @NotNull CasingProvider provider) {
        int to;
        if (fqn == null) {
            QNameUtil.$$$reportNull$$$0(5);
        }
        if (object == null) {
            QNameUtil.$$$reportNull$$$0(6);
        }
        if (namer == null) {
            QNameUtil.$$$reportNull$$$0(7);
        }
        if (provider == null) {
            QNameUtil.$$$reportNull$$$0(8);
        }
        return (to = QNameUtil.fqnMatch(fqn, object, namer, provider)) == 0 || QNameUtil.isDot(fqn, to);
    }

    public static boolean fqnEquals(@NotNull String fqn, @NotNull DasObject object, @NotNull Function<? super DasObject, String> namer, @NotNull CasingProvider provider) {
        if (fqn == null) {
            QNameUtil.$$$reportNull$$$0(9);
        }
        if (object == null) {
            QNameUtil.$$$reportNull$$$0(10);
        }
        if (namer == null) {
            QNameUtil.$$$reportNull$$$0(11);
        }
        if (provider == null) {
            QNameUtil.$$$reportNull$$$0(12);
        }
        return QNameUtil.fqnMatch(fqn, object, namer, provider) == fqn.length();
    }

    private static int fqnMatch(@NotNull String fqn, @NotNull DasObject object, @NotNull Function<? super DasObject, String> namer, @NotNull CasingProvider provider) {
        if (fqn == null) {
            QNameUtil.$$$reportNull$$$0(13);
        }
        if (object == null) {
            QNameUtil.$$$reportNull$$$0(14);
        }
        if (namer == null) {
            QNameUtil.$$$reportNull$$$0(15);
        }
        if (provider == null) {
            QNameUtil.$$$reportNull$$$0(16);
        }
        ArrayList parents = ContainerUtil.newArrayList(DasUtil.dasParents(object));
        Collections.reverse(parents);
        int from = 0;
        for (DasObject parent : parents) {
            int to = QNameUtil.fqnCmpStep(from, fqn, parent, namer, provider);
            if (parent == object) {
                return to;
            }
            if (from == to) continue;
            if (!QNameUtil.isDot(fqn, to)) {
                return -1;
            }
            from = to + 1;
        }
        return -1;
    }

    private static boolean isDot(@NotNull String fqn, int from) {
        if (fqn == null) {
            QNameUtil.$$$reportNull$$$0(17);
        }
        return from != -1 && from < fqn.length() && fqn.charAt(from) == '.';
    }

    public static int fqnCmpStep(int from, @NotNull String fqn, @NotNull DasObject object, @NotNull Function<? super DasObject, String> namer, @NotNull CasingProvider provider) {
        String name2;
        int end;
        if (fqn == null) {
            QNameUtil.$$$reportNull$$$0(18);
        }
        if (object == null) {
            QNameUtil.$$$reportNull$$$0(19);
        }
        if (namer == null) {
            QNameUtil.$$$reportNull$$$0(20);
        }
        if (provider == null) {
            QNameUtil.$$$reportNull$$$0(21);
        }
        if ((end = from + (name2 = (String)namer.fun((Object)object)).length()) > fqn.length()) {
            return -1;
        }
        Case c2 = provider.getCasing((ObjectKind)object.getKind(), (DasObject)object).quoted;
        boolean m = fqn.regionMatches(!c2.sensitive, from, name2, 0, name2.length());
        return m ? end : -1;
    }

    @NotNull
    public static JBIterable<DasObject> findByQName(@NotNull DasModel model, @NotNull String fqn, @NotNull Function<? super DasObject, String> namer) {
        if (model == null) {
            QNameUtil.$$$reportNull$$$0(22);
        }
        if (fqn == null) {
            QNameUtil.$$$reportNull$$$0(23);
        }
        if (namer == null) {
            QNameUtil.$$$reportNull$$$0(24);
        }
        JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)model.traverser().expand(object -> QNameUtil.fqnStartsWith(fqn, object, namer, model))).filter(object -> QNameUtil.fqnEquals(fqn, object, namer, model))).traverse();
        if (jBIterable == null) {
            QNameUtil.$$$reportNull$$$0(25);
        }
        return jBIterable;
    }

    @NotNull
    private static Condition<DasObject> getNameCondition(@NotNull DasModel model, @NotNull ObjectPath path) {
        if (model == null) {
            QNameUtil.$$$reportNull$$$0(26);
        }
        if (path == null) {
            QNameUtil.$$$reportNull$$$0(27);
        }
        Condition condition = DbSqlUtilCore.byName(path.name, path.isQuoted(), path.getIdentity(), model);
        if (condition == null) {
            QNameUtil.$$$reportNull$$$0(28);
        }
        return condition;
    }

    @NotNull
    public static JBIterable<DasObject> findByPath(@NotNull DasModel model, @Nullable ObjectPath path) {
        if (model == null) {
            QNameUtil.$$$reportNull$$$0(29);
        }
        return QNameUtil.findByPath(null, model, path, null);
    }

    @NotNull
    public static JBIterable<DasObject> findByPath(@Nullable Project project, @NotNull DasModel model, @Nullable ObjectPath path) {
        if (model == null) {
            QNameUtil.$$$reportNull$$$0(30);
        }
        return QNameUtil.findByPath(project, model, path, null);
    }

    @NotNull
    public static JBIterable<DasObject> findByRelPath(@Nullable Project project, @NotNull DasModel model, @NotNull DasObject base, @Nullable ObjectPath path) {
        if (model == null) {
            QNameUtil.$$$reportNull$$$0(31);
        }
        if (base == null) {
            QNameUtil.$$$reportNull$$$0(32);
        }
        if (path == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                QNameUtil.$$$reportNull$$$0(33);
            }
            return jBIterable;
        }
        JBIterable<DasObject> jBIterable = QNameUtil.findBySinglePath(project, model, path, (Function<? super ObjectPath, ? extends JBIterable<DasObject>>)((Function)p2 -> p2 == ObjectPath.CURRENT ? JBIterable.of((Object)base) : null));
        if (jBIterable == null) {
            QNameUtil.$$$reportNull$$$0(34);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DasObject> findByPath(@Nullable Project project, @NotNull DasModel model, @Nullable ObjectPath path, @Nullable Function<? super ObjectPath, ? extends JBIterable<DasObject>> cacheAccessor) {
        if (model == null) {
            QNameUtil.$$$reportNull$$$0(35);
        }
        if (path == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                QNameUtil.$$$reportNull$$$0(36);
            }
            return jBIterable;
        }
        MetaModel metaModel = model.getMetaModel();
        if (QNameUtil.isValid(path, metaModel)) {
            JBIterable<DasObject> jBIterable = QNameUtil.findBySinglePath(project, model, path, cacheAccessor);
            if (jBIterable == null) {
                QNameUtil.$$$reportNull$$$0(37);
            }
            return jBIterable;
        }
        Set<ObjectPath> paths = QNameUtil.possiblePaths(path, metaModel);
        if (paths.contains(path)) {
            throw new AssertionError((Object)"Invalid path transformed to itself");
        }
        if (cacheAccessor != null) {
            JBIterable jBIterable = JBIterable.from(paths).flatten(cacheAccessor);
            if (jBIterable == null) {
                QNameUtil.$$$reportNull$$$0(38);
            }
            return jBIterable;
        }
        return QNameUtil.findByPaths(project, model, paths);
    }

    @NotNull
    private static Set<ObjectPath> possiblePaths(@NotNull ObjectPath path, @NotNull MetaModel metaModel) {
        if (path == null) {
            QNameUtil.$$$reportNull$$$0(39);
        }
        if (metaModel == null) {
            QNameUtil.$$$reportNull$$$0(40);
        }
        ObjectPath known = QNameUtil.findLastKnownSegment(path);
        if (known.kind == ObjectKind.NONE) {
            Set<ObjectPath> set = Collections.emptySet();
            if (set == null) {
                QNameUtil.$$$reportNull$$$0(41);
            }
            return set;
        }
        ArrayList<ObjectPart> unknown2 = new ArrayList<ObjectPart>();
        ObjectPath tmp = known;
        while (tmp != null) {
            unknown2.add(tmp);
            tmp = tmp.parent;
        }
        LinkedHashSet<ObjectPath> res2 = new LinkedHashSet<ObjectPath>();
        for (List kinds : metaModel.getPathsToRoot(known.kind)) {
            ObjectPath uSeg = QNameUtil.recreateUnknownSegment(unknown2, kinds);
            ObjectPath complete = path.rebase(uSeg);
            res2.add(complete);
        }
        LinkedHashSet<ObjectPath> linkedHashSet = res2;
        if (linkedHashSet == null) {
            QNameUtil.$$$reportNull$$$0(42);
        }
        return linkedHashSet;
    }

    @Nullable
    private static ObjectPath recreateUnknownSegment(List<ObjectPart> unknown2, List<ObjectKind> kinds) {
        ObjectPath res2 = null;
        for (int i2 = kinds.size() - 2; i2 >= 0; --i2) {
            ObjectKind kind = kinds.get(i2);
            ObjectPart up = i2 < unknown2.size() ? unknown2.get(i2) : null;
            res2 = up == null ? ObjectPath.create("", kind, true, null, res2) : ObjectPath.create(up.name, kind, up.isQuoted(), up.getIdentity(), res2);
        }
        return res2;
    }

    @NotNull
    private static ObjectPath findLastKnownSegment(@NotNull ObjectPath path) {
        if (path == null) {
            QNameUtil.$$$reportNull$$$0(43);
        }
        ObjectPath known = path;
        if (known.kind != ObjectKind.NONE) {
            while (known.parent != null && known.parent.kind != ObjectKind.NONE) {
                known = known.parent;
            }
        }
        ObjectPath objectPath = known;
        if (objectPath == null) {
            QNameUtil.$$$reportNull$$$0(44);
        }
        return objectPath;
    }

    private static boolean isValid(@NotNull ObjectPath path, MetaModel metaModel) {
        if (path == null) {
            QNameUtil.$$$reportNull$$$0(45);
        }
        if (path.kind == ObjectKind.NONE) {
            return false;
        }
        if (path.parent == null) {
            JBIterable<ObjectKind> pks = metaModel.getParentKinds(path.kind);
            return pks.isEmpty() || pks.contains((Object)ObjectKind.ROOT);
        }
        return QNameUtil.isValid(path.parent, metaModel);
    }

    private static JBIterable<DasObject> findBySinglePath(@Nullable Project project, @NotNull DasModel model, @NotNull ObjectPath path, @Nullable Function<? super ObjectPath, ? extends JBIterable<DasObject>> cacheAccessor) {
        if (model == null) {
            QNameUtil.$$$reportNull$$$0(46);
        }
        if (path == null) {
            QNameUtil.$$$reportNull$$$0(47);
        }
        if (path.parent == null || path.parent.kind == ObjectKind.ROOT) {
            return QNameUtil.getModelRoots(project, model, path.kind).filter(QNameUtil.getNameCondition(model, path));
        }
        JBIterable<DasObject> parents = null;
        if (cacheAccessor != null) {
            parents = (JBIterable<DasObject>)cacheAccessor.fun((Object)path.parent);
        }
        if (parents == null) {
            parents = QNameUtil.findBySinglePath(project, model, path.parent, cacheAccessor);
        }
        if (path.isStepUp()) {
            return parents.filterMap(DasObject::getDasParent).unique();
        }
        return parents.flatten(o -> QNameUtil.getChildrenImpl(project, o, path.kind)).filter(QNameUtil.getNameCondition(model, path));
    }

    @NotNull
    private static JBIterable<DasObject> getChildrenImpl(@Nullable Project project, DasObject o, ObjectKind kind) {
        BasicMetaObject<?> meta = DbImplUtilCore.getMetaObject(o);
        JBIterable children2 = project == null || BasicMetaUtils.findChild(meta, kind) != null ? o.getDasChildren(kind).filter(DasObject.class) : DatabaseCoreUiService.getInstance().treeChildren(project, o, kind).filter(DasObject.class);
        JBIterable jBIterable = children2;
        if (jBIterable == null) {
            QNameUtil.$$$reportNull$$$0(48);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<DasObject> findByPaths(@Nullable Project project, @NotNull DasModel model, @NotNull Set<ObjectPath> paths) {
        ObjectPath anyPath;
        if (model == null) {
            QNameUtil.$$$reportNull$$$0(49);
        }
        if (paths == null) {
            QNameUtil.$$$reportNull$$$0(50);
        }
        if ((anyPath = (ObjectPath)ContainerUtil.getFirstItem(paths)) == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                QNameUtil.$$$reportNull$$$0(51);
            }
            return jBIterable;
        }
        Set kinds = ContainerUtil.map2Set(paths, p2 -> p2.kind);
        Condition<DasObject> byName2 = QNameUtil.getNameCondition(model, anyPath);
        if (anyPath.parent == null || anyPath.parent.kind == ObjectKind.ROOT) {
            JBIterable jBIterable = QNameUtil.getModelRoots(project, model, kinds).filter(byName2);
            if (jBIterable == null) {
                QNameUtil.$$$reportNull$$$0(52);
            }
            return jBIterable;
        }
        JBIterable jBIterable = QNameUtil.findByPaths(project, model, ContainerUtil.map2Set(paths, p2 -> p2.parent)).flatten(o -> JBIterable.from((Iterable)kinds).flatten(k -> o.getDasChildren((ObjectKind)k))).filter(byName2);
        if (jBIterable == null) {
            QNameUtil.$$$reportNull$$$0(53);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<DasObject> getModelRoots(@Nullable Project project, @NotNull DasModel model, ObjectKind kind) {
        if (model == null) {
            QNameUtil.$$$reportNull$$$0(54);
        }
        if (model instanceof BasicModel && kind != ObjectKind.NONE) {
            BasicRoot root = ((BasicModel)model).getRoot();
            return QNameUtil.getChildrenImpl(project, root, kind);
        }
        JBIterable jBIterable = model.getModelRoots().filter(DasUtil.byKind(kind));
        if (jBIterable == null) {
            QNameUtil.$$$reportNull$$$0(55);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<DasObject> getModelRoots(@Nullable Project project, @NotNull DasModel model, Set<ObjectKind> kinds) {
        if (model == null) {
            QNameUtil.$$$reportNull$$$0(56);
        }
        if (model instanceof BasicModel) {
            BasicRoot root = ((BasicModel)model).getRoot();
            JBIterable jBIterable = JBIterable.from(kinds).flatten(k -> QNameUtil.getChildrenImpl(project, root, k));
            if (jBIterable == null) {
                QNameUtil.$$$reportNull$$$0(57);
            }
            return jBIterable;
        }
        JBIterable jBIterable = model.getModelRoots().filter(o -> kinds.contains(o.getKind()));
        if (jBIterable == null) {
            QNameUtil.$$$reportNull$$$0(58);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 26, 27, 29, 30, 31, 32, 35, 39, 40, 43, 45, 46, 47, 49, 50, 54, 56 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/QNameUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namingService";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 15: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namer";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 17: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 8: 
            case 12: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 22: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 35: 
            case 46: 
            case 49: 
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 27: 
            case 39: 
            case 43: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaModel";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 39: 
            case 40: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 54: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/QNameUtil";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "findByQName";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameCondition";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "findByRelPath";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "findByPath";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "possiblePaths";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "findLastKnownSegment";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenImpl";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "findByPaths";
                break;
            }
            case 55: 
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelRoots";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fqnStartsWith";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fqnEquals";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "fqnMatch";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isDot";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "fqnCmpStep";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findByQName";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getNameCondition";
                break;
            }
            case 29: 
            case 30: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findByPath";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findByRelPath";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "possiblePaths";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "findLastKnownSegment";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "findBySinglePath";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "findByPaths";
                break;
            }
            case 54: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getModelRoots";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 26, 27, 29, 30, 31, 32, 35, 39, 40, 43, 45, 46, 47, 49, 50, 54, 56 -> new IllegalArgumentException(string);
        };
    }
}

