/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.editors.DatabaseEditorUtil;
import com.intellij.database.view.editors.ShutSplitter;
import com.intellij.database.view.ui.SqlPreviewComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ErrorLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PerformRoutineScriptDialog
extends DialogWrapper {
    private final Project myProject;
    private final DbDataSource mySource;
    private final SearchPath mySearchPath;
    private final String myQuery;
    private SqlPreviewComponent myPreviewPanel;
    private final @NlsContexts.Label String myLabelText;
    @NotNull
    private final List<String> myMessages;
    @NotNull
    private final List<JdbcConsole> myOwners;
    private ComboBox<JdbcConsole> myOwnersComboBox;

    public PerformRoutineScriptDialog(@NotNull Project project, @NotNull DbDataSource dataSource, @Nullable SearchPath searchPath, @NotNull @NlsContexts.DialogTitle String title, @NotNull @NlsContexts.Label String labelText, @NotNull String query, @NotNull List<String> messages, @NotNull List<JdbcConsole> owners) {
        if (project == null) {
            PerformRoutineScriptDialog.$$$reportNull$$$0(0);
        }
        if (dataSource == null) {
            PerformRoutineScriptDialog.$$$reportNull$$$0(1);
        }
        if (title == null) {
            PerformRoutineScriptDialog.$$$reportNull$$$0(2);
        }
        if (labelText == null) {
            PerformRoutineScriptDialog.$$$reportNull$$$0(3);
        }
        if (query == null) {
            PerformRoutineScriptDialog.$$$reportNull$$$0(4);
        }
        if (messages == null) {
            PerformRoutineScriptDialog.$$$reportNull$$$0(5);
        }
        if (owners == null) {
            PerformRoutineScriptDialog.$$$reportNull$$$0(6);
        }
        super(project);
        this.myProject = project;
        this.mySource = dataSource;
        this.mySearchPath = searchPath;
        this.myQuery = query;
        this.myLabelText = labelText;
        this.myMessages = messages;
        this.myOwners = owners;
        this.setTitle(title);
        this.init();
    }

    @NotNull
    protected String getDimensionServiceKey() {
        String string = ((Object)((Object)this)).getClass().getName();
        if (string == null) {
            PerformRoutineScriptDialog.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 1));
        JComponent previewComponent = this.createPreviewComponent();
        panel2.add(previewComponent);
        JComponent ownersComponent = this.createOwnersComponent();
        if (ownersComponent != null) {
            panel2.add(ownersComponent);
        }
        return panel2;
    }

    @NotNull
    private JComponent createPreviewComponent() {
        this.myPreviewPanel = new SqlPreviewComponent(this.myProject, this.mySource, this.mySearchPath, this.myQuery, false, () -> this.close(1));
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)new JLabel(this.myLabelText), "Center");
        if (!this.myMessages.isEmpty()) {
            String title = this.myMessages.size() == 1 ? this.myMessages.get(0) : DatabaseBundle.message("label.there.are.errors", new Object[0]);
            ErrorLabel error = new ErrorLabel(title, UIUtil.getBalloonErrorIcon());
            error.setErrorText(StringUtil.join(this.myMessages, (String)"\n"), (Color)JBColor.RED);
            northPanel.add((Component)error, "East");
        }
        ShutSplitter splitter = DatabaseEditorUtil.createHideableSplitter(DatabaseBundle.message("ObjectEditorWithPreview.label.sql.script", new Object[0]), northPanel, (JComponent)this.myPreviewPanel.getEditor(), this.getDimensionServiceKey(), 0.7f);
        splitter.setProportion(0.0f);
        splitter.setResizeEnabled(false);
        splitter.setTrailWidget(this.myPreviewPanel.createToolbar());
        ShutSplitter shutSplitter = splitter;
        if (shutSplitter == null) {
            PerformRoutineScriptDialog.$$$reportNull$$$0(8);
        }
        return shutSplitter;
    }

    @Nullable
    private JComponent createOwnersComponent() {
        if (this.myOwners.isEmpty()) {
            this.myOwnersComboBox = null;
            return null;
        }
        this.myOwnersComboBox = new ComboBox((Object[])this.myOwners.toArray(new JdbcConsole[0]));
        this.myOwnersComboBox.setRenderer((ListCellRenderer)new OwnerListCellRenderer());
        this.myOwnersComboBox.setSelectedItem(null);
        this.myOwnersComboBox.setEnabled(false);
        final JBCheckBox ownersCheckBox = new JBCheckBox(DatabaseBundle.message("run.from", new Object[0]));
        ownersCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PerformRoutineScriptDialog.this.myOwnersComboBox.setEnabled(ownersCheckBox.isSelected());
            }
        });
        JPanel ownersPanel = new JPanel(new FlowLayout(0));
        ownersPanel.add((Component)ownersCheckBox);
        ownersPanel.add((Component)this.myOwnersComboBox);
        return ownersPanel;
    }

    @NotNull
    public String getStatement() {
        String string = this.myPreviewPanel.getQuery();
        if (string == null) {
            PerformRoutineScriptDialog.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    public JdbcConsole getForcedOwner() {
        return this.myOwnersComboBox != null && this.myOwnersComboBox.isEnabled() ? (JdbcConsole)this.myOwnersComboBox.getItem() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owners";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/PerformRoutineScriptDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/PerformRoutineScriptDialog";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDimensionServiceKey";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createPreviewComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9 -> new IllegalStateException(string);
        };
    }

    private static class OwnerListCellRenderer
    extends DefaultListCellRenderer {
        private OwnerListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof JdbcConsole) {
                JdbcConsole owner = (JdbcConsole)value;
                this.setText(owner.getTitle());
                this.setIcon(owner.getIcon());
            }
            return component;
        }
    }
}

