/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.database.symbols.DasSymbol;
import com.intellij.lang.Language;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.model.search.CodeReferenceSearcher;
import com.intellij.model.search.LeafOccurrence;
import com.intellij.model.search.SearchRequest;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.symbols.DasSymbolUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/sql/SqlCodeReferenceSearcher;", "Lcom/intellij/model/search/CodeReferenceSearcher;", "<init>", "()V", "getReferencingLanguage", "Lcom/intellij/lang/Language;", "target", "Lcom/intellij/model/Symbol;", "getSearchRequest", "Lcom/intellij/model/search/SearchRequest;", "project", "Lcom/intellij/openapi/project/Project;", "getReferences", "", "Lcom/intellij/model/psi/PsiSymbolReference;", "occurrence", "Lcom/intellij/model/search/LeafOccurrence;", "intellij.database.sql.impl"})
public final class SqlCodeReferenceSearcher
implements CodeReferenceSearcher {
    @NotNull
    public Language getReferencingLanguage(@NotNull Symbol target2) {
        Language language;
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        if (target2 instanceof DasSymbol) {
            SqlLanguageDialectEx sqlLanguageDialectEx = DasSymbolUtil.getSqlDialect((DasSymbol)target2);
            Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialect(...)");
            language = (Language)sqlLanguageDialectEx;
        } else {
            SqlLanguage sqlLanguage = SqlLanguage.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlLanguage, (String)"INSTANCE");
            language = (Language)sqlLanguage;
        }
        return language;
    }

    @Nullable
    public SearchRequest getSearchRequest(@NotNull Project project, @NotNull Symbol target2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        DasSymbol dasSymbol = target2 instanceof DasSymbol ? (DasSymbol)target2 : null;
        if (dasSymbol == null) {
            return null;
        }
        DasSymbol dasSymbol2 = dasSymbol;
        return SearchRequest.of((String)dasSymbol2.getName());
    }

    @NotNull
    public Collection<PsiSymbolReference> getReferences(@NotNull Symbol target2, @NotNull LeafOccurrence occurrence) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)occurrence, (String)"occurrence");
        PsiElement psiElement = occurrence.getStart().getParent();
        SqlIdentifier sqlIdentifier = psiElement instanceof SqlIdentifier ? (SqlIdentifier)psiElement : null;
        PsiElement psiElement2 = sqlIdentifier != null ? sqlIdentifier.getParent() : null;
        SqlReferenceExpression refExpression = psiElement2 instanceof SqlReferenceExpression ? (SqlReferenceExpression)psiElement2 : null;
        return refExpression != null && Intrinsics.areEqual((Object)refExpression.resolveSymbol(), (Object)target2) ? (Collection)CollectionsKt.listOf((Object)refExpression.getReference()) : (Collection)CollectionsKt.emptyList();
    }
}

