/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.util.SqlDialects;
import com.intellij.lang.Language;
import com.intellij.lang.LanguagePerFileMappings;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.FilePropertyKey;
import com.intellij.psi.FilePropertyKeyImpl;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlDialectPusher;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@State(name="SqlDialectMappings", storages={@Storage(value="sqldialects.xml")})
public final class SqlDialectMappings
extends LanguagePerFileMappings<SqlLanguageDialect> {
    public static final FilePropertyKey<SqlLanguageDialect> SQL_DIALECT_KEY = FilePropertyKeyImpl.createPersistentStringKey((String)"SQL_LANGUAGE_DIALECT", (FileAttribute)new FileAttribute("sql_dialect", 4, true), Language::getID, id -> (SqlLanguageDialect)Language.findLanguageByID((String)id));
    private final SqlDialectPusher myPusherInstance;

    public static SqlDialectMappings getInstance(@NotNull Project project) {
        if (project == null) {
            SqlDialectMappings.$$$reportNull$$$0(0);
        }
        return (SqlDialectMappings)((Object)project.getService(SqlDialectMappings.class));
    }

    protected FilePropertyPusher<SqlLanguageDialect> getFilePropertyPusher() {
        return this.myPusherInstance;
    }

    @NotNull
    public static SqlLanguageDialect getDefaultSqlDialect() {
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlDialectImplUtilCore.getDefaultSqlDialect();
        if (sqlLanguageDialectEx == null) {
            SqlDialectMappings.$$$reportNull$$$0(1);
        }
        return sqlLanguageDialectEx;
    }

    @Nullable
    public static SqlLanguageDialect getConfiguredDefaultSqlDialect() {
        return SqlDialectImplUtilCore.getConfiguredDefaultSqlDialect();
    }

    public static void setDefaultSqlDialect(@Nullable SqlLanguageDialect dialect) {
        SqlDialectImplUtilCore.setDefaultSqlDialect(dialect);
    }

    @NotNull
    public static SqlLanguageDialect getMapping(@Nullable Project project, @Nullable VirtualFile file) {
        if (project != null) {
            SqlLanguageDialect sqlLanguageDialect = SqlDialectMappings.getInstance(project).getMapping(file);
            if (sqlLanguageDialect == null) {
                SqlDialectMappings.$$$reportNull$$$0(2);
            }
            return sqlLanguageDialect;
        }
        if (file != null) {
            for (Project p2 : ProjectManager.getInstance().getOpenProjects()) {
                if (!ProjectFileIndex.getInstance((Project)p2).isInContent(file)) continue;
                SqlLanguageDialect sqlLanguageDialect = SqlDialectMappings.getInstance(p2).getMapping(file);
                if (sqlLanguageDialect == null) {
                    SqlDialectMappings.$$$reportNull$$$0(3);
                }
                return sqlLanguageDialect;
            }
        }
        return SqlDialectMappings.getDefaultSqlDialect();
    }

    public SqlDialectMappings(@NotNull Project project) {
        if (project == null) {
            SqlDialectMappings.$$$reportNull$$$0(4);
        }
        super(project);
        this.myPusherInstance = new SqlDialectPusher();
    }

    @NotNull
    public SqlLanguageDialect getMapping(@Nullable VirtualFile file) {
        SqlLanguageDialect sqlLanguageDialect = Objects.requireNonNull((SqlLanguageDialect)super.getMapping(file));
        if (sqlLanguageDialect == null) {
            SqlDialectMappings.$$$reportNull$$$0(5);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public SqlLanguageDialect getDefaultMapping(@Nullable VirtualFile file) {
        return SqlDialectMappings.getDefaultSqlDialect();
    }

    protected String serialize(@NotNull SqlLanguageDialect dialect) {
        if (dialect == null) {
            SqlDialectMappings.$$$reportNull$$$0(6);
        }
        return dialect.getID();
    }

    @NotNull
    public List<SqlLanguageDialect> getAvailableValues() {
        List<SqlLanguageDialect> list = SqlDialects.getTopLevelSqlDialects();
        if (list == null) {
            SqlDialectMappings.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/SqlDialectMappings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/SqlDialectMappings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSqlDialect";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMapping";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5, 7 -> new IllegalStateException(string);
        };
    }
}

