/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.hive;

import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.base.SqlLanguageDialectBase;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.hive.HiveOptionalKeywords;
import com.intellij.sql.dialects.hive.HiveReservedKeywords;
import com.intellij.sql.psi.SqlTokens;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HiveLexerBase
extends SqlLexer {
    private static final int BEGINNING_OF_STATEMENT_STATE = 1;
    private static final int SHELL_COMMAND_STATE = 2;
    private int myCommandState;

    public HiveLexerBase(@NotNull SqlLanguageDialectBase dialect, @NotNull FlexLexer flexLexer) {
        if (dialect == null) {
            HiveLexerBase.$$$reportNull$$$0(0);
        }
        if (flexLexer == null) {
            HiveLexerBase.$$$reportNull$$$0(1);
        }
        super(dialect, flexLexer);
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            HiveLexerBase.$$$reportNull$$$0(2);
        }
        if (initialState == 0 && startOffset == 0) {
            this.myCommandState = 1;
            super.start(buffer, startOffset, endOffset, 0);
        } else {
            this.myCommandState = initialState >>> 30;
            super.start(buffer, startOffset, endOffset, 0x3FFFFFFF & initialState);
        }
    }

    public int getState() {
        return this.myCommandState << 30 | 0x3FFFFFFF & super.getState();
    }

    @Override
    protected void lookAhead(@NotNull Lexer baseLexer) {
        if (baseLexer == null) {
            HiveLexerBase.$$$reportNull$$$0(3);
        }
        if (HiveLexerBase.isStmtEnd(baseLexer)) {
            this.myCommandState = 1;
            super.lookAhead(baseLexer);
            return;
        }
        if (this.myCommandState == 1 && (HiveLexerBase.isWhitespace(baseLexer) || HiveLexerBase.isComment(baseLexer))) {
            super.lookAhead(baseLexer);
            return;
        }
        if (this.myCommandState == 2 && HiveLexerBase.isWhitespace(baseLexer)) {
            super.lookAhead(baseLexer);
            return;
        }
        if (!(this.lookAheadShellCommand(baseLexer) || this.lookAheadFunctionSourceCode(baseLexer) || this.lookAheadSetCommand(baseLexer))) {
            this.myCommandState = 0;
            super.lookAhead(baseLexer);
        }
    }

    private boolean lookAheadSetCommand(Lexer baseLexer) {
        if (this.myCommandState != 1) {
            return false;
        }
        if (!StringUtil.equalsIgnoreCase((CharSequence)HiveReservedKeywords.HIVE_SET.toString(), (CharSequence)baseLexer.getTokenText())) {
            return false;
        }
        this.advanceAs(baseLexer, (IElementType)HiveReservedKeywords.HIVE_SET);
        this.skipWhitespaces(baseLexer);
        if (StringUtil.equalsIgnoreCase((CharSequence)HiveOptionalKeywords.HIVE_ROLE.toString(), (CharSequence)baseLexer.getTokenText())) {
            this.advanceAs(baseLexer, (IElementType)HiveOptionalKeywords.HIVE_ROLE);
        } else if (StringUtil.equalsIgnoreCase((CharSequence)HiveOptionalKeywords.HIVE_AUTOCOMMIT.toString(), (CharSequence)baseLexer.getTokenText())) {
            this.advanceAs(baseLexer, (IElementType)HiveOptionalKeywords.HIVE_AUTOCOMMIT);
        } else if (StringUtil.equalsIgnoreCase((CharSequence)HiveReservedKeywords.HIVE_TIME.toString(), (CharSequence)baseLexer.getTokenText())) {
            this.advanceAs(baseLexer, (IElementType)HiveReservedKeywords.HIVE_TIME);
            this.skipWhitespaces(baseLexer);
            if (StringUtil.equalsIgnoreCase((CharSequence)HiveOptionalKeywords.HIVE_ZONE.toString(), (CharSequence)baseLexer.getTokenText())) {
                this.advanceAs(baseLexer, (IElementType)HiveOptionalKeywords.HIVE_ZONE);
                this.skipWhitespaces(baseLexer);
                this.advanceUntilStmtEnd(baseLexer, (IElementType)SqlTokens.SQL_RAW_INPUT);
            }
        }
        while (baseLexer.getTokenType() == SqlTokens.SQL_IDENT || baseLexer.getTokenType() == SqlTokens.SQL_PERIOD || baseLexer.getTokenType() == SqlTokens.SQL_COLON || baseLexer.getTokenType() == SqlTokens.SQL_OP_MINUS) {
            this.advanceLexer(baseLexer);
        }
        this.skipWhitespaces(baseLexer);
        if (baseLexer.getTokenType() != SqlTokens.SQL_OP_EQ) {
            return true;
        }
        this.advanceLexer(baseLexer);
        this.skipWhitespaces(baseLexer);
        this.advanceUntilStmtEnd(baseLexer, (IElementType)SqlTokens.SQL_RAW_INPUT);
        return true;
    }

    private boolean lookAheadFunctionSourceCode(Lexer baseLexer) {
        if (!StringUtil.equalsIgnoreCase((CharSequence)HiveOptionalKeywords.HIVE_COMPILE.toString(), (CharSequence)baseLexer.getTokenText())) {
            return false;
        }
        this.advanceAs(baseLexer, (IElementType)HiveOptionalKeywords.HIVE_COMPILE);
        this.skipWhitespaces(baseLexer);
        if (baseLexer.getTokenType() != SqlTokens.SQL_IDENT_DELIMITED || !baseLexer.getTokenText().startsWith("`")) {
            return true;
        }
        this.addToken(baseLexer.getTokenStart() + 1, (IElementType)SqlTokens.SQL_CUSTOM_LQUOTE);
        this.addToken(baseLexer.getTokenEnd() - 1, (IElementType)SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN);
        this.addToken(baseLexer.getTokenEnd(), (IElementType)SqlTokens.SQL_CUSTOM_RQUOTE);
        baseLexer.advance();
        return true;
    }

    private boolean lookAheadShellCommand(Lexer baseLexer) {
        switch (this.myCommandState) {
            case 1: {
                if (this.lookAheadDfsCommand(baseLexer)) {
                    return true;
                }
                IElementType type = HiveLexerBase.getShellCommandType(baseLexer.getTokenText());
                return this.possiblyAdvanceAndInc(baseLexer, type);
            }
            case 2: {
                IElementType type = HiveLexerBase.getFileTypeToken(baseLexer.getTokenText());
                if (!this.possiblyAdvanceAndInc(baseLexer, type)) {
                    return false;
                }
                this.skipWhitespaces(baseLexer);
                this.advanceUntilStmtEnd(baseLexer, (IElementType)SqlTokens.SQL_RAW_INPUT);
                return true;
            }
        }
        return false;
    }

    private boolean lookAheadDfsCommand(Lexer baseLexer) {
        if (!StringUtil.equalsIgnoreCase((CharSequence)"dfs", (CharSequence)baseLexer.getTokenText())) {
            return false;
        }
        this.advanceAs(baseLexer, (IElementType)HiveOptionalKeywords.HIVE_DFS);
        this.skipWhitespaces(baseLexer);
        this.advanceUntilStmtEnd(baseLexer, (IElementType)SqlTokens.SQL_RAW_INPUT);
        return true;
    }

    @Nullable
    private static IElementType getFileTypeToken(String tokenText) {
        return switch (StringUtil.toUpperCase((String)tokenText)) {
            case "FILE" -> HiveOptionalKeywords.HIVE_FILE;
            case "FILES" -> HiveOptionalKeywords.HIVE_FILES;
            case "ARCHIVE" -> HiveOptionalKeywords.HIVE_ARCHIVE;
            case "ARCHIVES" -> HiveOptionalKeywords.HIVE_ARCHIVES;
            case "JAR" -> HiveOptionalKeywords.HIVE_JAR;
            case "JARS" -> HiveOptionalKeywords.HIVE_JARS;
            default -> null;
        };
    }

    @Nullable
    private static IElementType getShellCommandType(String tokenText) {
        return switch (StringUtil.toUpperCase((String)tokenText)) {
            case "ADD" -> HiveOptionalKeywords.HIVE_ADD;
            case "DELETE" -> HiveReservedKeywords.HIVE_DELETE;
            case "LIST" -> HiveOptionalKeywords.HIVE_LIST;
            default -> null;
        };
    }

    private static boolean isComment(Lexer baseLexer) {
        return SqlTokens.COMMENT_TOKENS.contains(baseLexer.getTokenType());
    }

    private static boolean isWhitespace(Lexer baseLexer) {
        return SqlTokens.WS_TOKENS.contains(baseLexer.getTokenType());
    }

    private boolean possiblyAdvanceAndInc(Lexer baseLexer, IElementType type) {
        if (type != null) {
            this.advanceAs(baseLexer, type);
            ++this.myCommandState;
            return true;
        }
        return false;
    }

    private void advanceUntilStmtEnd(Lexer baseLexer, IElementType type) {
        int commandEnd;
        if (HiveLexerBase.isStmtEnd(baseLexer)) {
            return;
        }
        while (true) {
            commandEnd = baseLexer.getTokenEnd();
            baseLexer.advance();
            if (SqlTokens.COMMENT_TOKENS.contains(baseLexer.getTokenType())) {
                String commentText = baseLexer.getTokenText();
                int pos = commentText.indexOf(";");
                if (pos == -1) continue;
                this.addTokenAndRestartLexer(baseLexer, type, commandEnd + pos);
                return;
            }
            if (HiveLexerBase.isStmtEnd(baseLexer)) break;
        }
        this.addTokenAndRestartLexer(baseLexer, type, commandEnd);
    }

    private void skipWhitespaces(Lexer baseLexer) {
        while (SqlTokens.WS_TOKENS.contains(baseLexer.getTokenType())) {
            this.advanceAs(baseLexer, baseLexer.getTokenType());
        }
    }

    private static boolean isStmtEnd(Lexer baseLexer) {
        return baseLexer.getTokenType() == SqlTokens.SQL_SEMICOLON || baseLexer.getTokenType() == null;
    }

    private void addTokenAndRestartLexer(Lexer baseLexer, IElementType type, int commandEnd) {
        this.addToken(commandEnd, type);
        baseLexer.start(baseLexer.getBufferSequence(), commandEnd, baseLexer.getBufferEnd(), 0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flexLexer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseLexer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/dialects/hive/HiveLexerBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "start";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lookAhead";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

