/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.injection;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.injection.SqlTypeBasedInjection;
import com.intellij.sql.injection.SqlTypeBasedInjector;
import com.intellij.sql.injection.SqlTypePanel;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.patterns.SqlPatterns;
import com.intellij.util.Consumer;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.AbstractLanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.config.InjectionPlace;
import org.intellij.plugins.intelliLang.inject.config.ui.AbstractInjectionPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlTypeBasedInjectionSupport
extends AbstractLanguageInjectionSupport {
    public static final String SUPPORT_ID = "sql";

    @NotNull
    public String getId() {
        return SUPPORT_ID;
    }

    public Class<?> @NotNull [] getPatternClasses() {
        Class[] classArray = new Class[]{SqlPatterns.class};
        if (classArray == null) {
            SqlTypeBasedInjectionSupport.$$$reportNull$$$0(0);
        }
        return classArray;
    }

    public boolean useDefaultInjector(PsiLanguageInjectionHost host) {
        return true;
    }

    public AnAction[] createAddActions(final Project project, final Consumer<? super BaseInjection> consumer) {
        return new AnAction[]{new AnAction(SqlBundle.message((String)"SqlTypeBasedInjectionSupport.action.sql.injection.text", (Object[])new Object[0]), null, DatabaseIcons.Sql){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                BaseInjection injection = new BaseInjection(SqlTypeBasedInjectionSupport.SUPPORT_ID);
                injection.setDisplayName(SqlBundle.message((String)"SqlTypeBasedInjectionSupport.new.sql.injection", (Object[])new Object[0]));
                BaseInjection newInjection = SqlTypeBasedInjectionSupport.showDefaultInjectionUI((Project)project, (BaseInjection)injection);
                if (newInjection != null) {
                    consumer.consume((Object)injection);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/sql/injection/SqlTypeBasedInjectionSupport$1", "actionPerformed"));
            }
        }, new AnAction(SqlBundle.message((String)"SqlTypeBasedInjectionSupport.action.sql.type.injection.text", (Object[])new Object[0]), null, DatabaseIcons.Sql){

            public void actionPerformed(@NotNull AnActionEvent e) {
                SqlTypeBasedInjection newInjection;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((newInjection = SqlTypeBasedInjectionSupport.showTypeInjectionUI(project, new SqlTypeBasedInjection())) != null) {
                    consumer.consume((Object)newInjection);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/sql/injection/SqlTypeBasedInjectionSupport$2", "actionPerformed"));
            }
        }};
    }

    public boolean isApplicableTo(PsiLanguageInjectionHost host) {
        return host instanceof SqlElement;
    }

    public boolean configureInjectionForTypes(@NotNull Project project, @NotNull Language lang, @NotNull Set<String> types) {
        Pattern pattern;
        if (project == null) {
            SqlTypeBasedInjectionSupport.$$$reportNull$$$0(1);
        }
        if (lang == null) {
            SqlTypeBasedInjectionSupport.$$$reportNull$$$0(2);
        }
        if (types == null) {
            SqlTypeBasedInjectionSupport.$$$reportNull$$$0(3);
        }
        if (types.isEmpty()) {
            return false;
        }
        SqlTypeBasedInjection injection = new SqlTypeBasedInjection();
        injection.generatePlaces();
        injection.setInjectedLanguageId(lang.getID());
        injection.setPlaceEnabled(null, true);
        String patternStr = StringUtil.join(types, (String)"|");
        try {
            pattern = Pattern.compile(patternStr);
        }
        catch (PatternSyntaxException e) {
            patternStr = StringUtil.join(types, Pattern::quote, (String)"|");
            pattern = Pattern.compile(patternStr);
        }
        injection.setDisplayName(patternStr);
        injection.setPattern(pattern);
        SqlTypeBasedInjection res2 = SqlTypeBasedInjectionSupport.showTypeInjectionUI(project, injection);
        if (res2 != null) {
            SqlTypeBasedInjectionSupport.doAddInjection(project, res2);
            return true;
        }
        return false;
    }

    public boolean editInjectionInPlace(PsiLanguageInjectionHost psiElement) {
        Project project = psiElement.getProject();
        Configuration configuration = InjectorUtils.getEditableInstance((Project)project);
        BaseInjection injection = SqlTypeBasedInjectionSupport.findUsedInjection(psiElement);
        if (injection == null) {
            return false;
        }
        BaseInjection result2 = SqlTypeBasedInjectionSupport.showInjectionUI(project, injection.copy());
        if (result2 != null) {
            configuration.replaceInjectionsWithUndo(project, psiElement.getContainingFile(), Collections.singletonList(result2), Collections.singletonList(injection), Collections.emptyList());
        }
        return true;
    }

    @Nullable
    private static BaseInjection findUsedInjection(PsiLanguageInjectionHost psiElement) {
        if (SqlTypeBasedInjector.isInjectedByComment(psiElement)) {
            return null;
        }
        SqlTypeBasedInjection injection = SqlTypeBasedInjectionSupport.findUsedTypeInjection(psiElement);
        return injection != null ? injection : SqlTypeBasedInjectionSupport.findUsedBaseInjection(psiElement);
    }

    @Nullable
    private static BaseInjection findUsedBaseInjection(PsiLanguageInjectionHost psiElement) {
        Project project = psiElement.getProject();
        Configuration configuration = InjectorUtils.getEditableInstance((Project)project);
        return (BaseInjection)JBIterable.from((Iterable)configuration.getInjections(SUPPORT_ID)).filter(i2 -> i2.acceptsPsiElement((PsiElement)psiElement)).first();
    }

    @Nullable
    private static SqlTypeBasedInjection findUsedTypeInjection(PsiLanguageInjectionHost psiElement) {
        Set<String> types = SqlTypeBasedInjector.getTypesFor(psiElement);
        if (types.size() != 1) {
            return null;
        }
        String type = types.iterator().next();
        Project project = psiElement.getProject();
        Configuration configuration = InjectorUtils.getEditableInstance((Project)project);
        return (SqlTypeBasedInjection)((Object)JBIterable.from((Iterable)configuration.getInjections(SUPPORT_ID)).filter(SqlTypeBasedInjection.class).filter(i2 -> i2.getPattern().matcher(type).matches()).first());
    }

    public boolean removeInjectionInPlace(PsiLanguageInjectionHost psiElement) {
        Project project = psiElement.getProject();
        Configuration configuration = InjectorUtils.getEditableInstance((Project)project);
        BaseInjection injection = SqlTypeBasedInjectionSupport.findUsedInjection(psiElement);
        if (injection == null) {
            return false;
        }
        BaseInjection copy = injection.copy();
        SqlTypeBasedInjectionSupport.disableInjection(copy, psiElement);
        configuration.replaceInjectionsWithUndo(project, psiElement.getContainingFile(), Collections.singletonList(copy), Collections.singletonList(injection), Collections.emptyList());
        return true;
    }

    private static void disableInjection(BaseInjection copy, PsiLanguageInjectionHost element) {
        if (copy instanceof SqlTypeBasedInjection) {
            copy.setPlaceEnabled(null, false);
        } else {
            for (InjectionPlace place : copy.getInjectionPlaces()) {
                if (!place.isEnabled() || !place.getElementPattern().accepts((Object)element)) continue;
                copy.setPlaceEnabled(place.getText(), false);
            }
        }
    }

    public BaseInjection createInjection(Element element) {
        if (element.getAttributeValue("pattern") != null || element.getAttributeValue("fragment") != null || element.getAttributeValue("hosts") != null) {
            return new SqlTypeBasedInjection();
        }
        return super.createInjection(element);
    }

    public AnAction createEditAction(final Project project, final Factory<? extends BaseInjection> producer) {
        return new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                BaseInjection copy;
                BaseInjection newInjection;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((newInjection = SqlTypeBasedInjectionSupport.showInjectionUI(project, copy = ((BaseInjection)producer.create()).copy())) != null) {
                    ((BaseInjection)producer.create()).copyFrom(newInjection);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/sql/injection/SqlTypeBasedInjectionSupport$3", "actionPerformed"));
            }
        };
    }

    @Nullable
    public String getHelpId() {
        return "reference.settings.injection.language.injection.settings.sql";
    }

    @Nullable
    private static BaseInjection showInjectionUI(Project project, BaseInjection injection) {
        return injection instanceof SqlTypeBasedInjection ? SqlTypeBasedInjectionSupport.showTypeInjectionUI(project, (SqlTypeBasedInjection)injection) : SqlTypeBasedInjectionSupport.showDefaultInjectionUI((Project)project, (BaseInjection)injection);
    }

    @Nullable
    private static SqlTypeBasedInjection showTypeInjectionUI(Project project, SqlTypeBasedInjection injection) {
        SqlTypePanel panel2 = new SqlTypePanel(injection, project);
        panel2.reset();
        if (SqlTypeBasedInjectionSupport.showEditInjectionDialog((Project)project, (AbstractInjectionPanel)panel2, (String)SqlTypeBasedInjectionSupport.class.getName(), (String)"reference.settings.injection.language.injection.settings.sql.type")) {
            return injection.copy();
        }
        return null;
    }

    private static void doAddInjection(Project project, SqlTypeBasedInjection template) {
        Configuration configuration = InjectorUtils.getEditableInstance((Project)project);
        SqlTypeBasedInjection originalInjection = (SqlTypeBasedInjection)configuration.findExistingInjection((BaseInjection)template);
        SqlTypeBasedInjection newInjection = originalInjection == null || !originalInjection.equals((Object)template) ? template : originalInjection.copy();
        configuration.replaceInjectionsWithUndo(project, null, Collections.singletonList(newInjection), Collections.emptyList(), Collections.emptyList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/injection/SqlTypeBasedInjectionSupport";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternClasses";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/injection/SqlTypeBasedInjectionSupport";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "configureInjectionForTypes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

