/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCallStatement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.stubs.SqlCallStatementStubElementType;
import com.intellij.sql.psi.stubs.SqlNamedElementStub;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.StringRef;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCallStatementElementStub
extends SqlNamedElementStub<SqlCallStatement> {
    protected final List<String> myArguments;
    protected List<SqlExpression> myArgumentExpressions;

    public SqlCallStatementElementStub(StubElement<?> parent, @NotNull SqlCallStatementStubElementType elementType, @Nullable StringRef name2, @NotNull List<String> arguments) {
        if (elementType == null) {
            SqlCallStatementElementStub.$$$reportNull$$$0(0);
        }
        if (arguments == null) {
            SqlCallStatementElementStub.$$$reportNull$$$0(1);
        }
        super(parent, elementType, name2);
        this.myArguments = arguments;
    }

    @NotNull
    public List<String> getArguments() {
        List<String> list = this.myArguments;
        if (list == null) {
            SqlCallStatementElementStub.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public List<SqlExpression> getArgumentExpressions() {
        if (this.myArgumentExpressions == null) {
            this.myArgumentExpressions = this.parseArguments();
        }
        List<SqlExpression> list = this.myArgumentExpressions;
        if (list == null) {
            SqlCallStatementElementStub.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private List<SqlExpression> parseArguments() {
        if (this.myArguments.isEmpty()) {
            List<SqlExpression> list = Collections.emptyList();
            if (list == null) {
                SqlCallStatementElementStub.$$$reportNull$$$0(4);
            }
            return list;
        }
        SqlCallStatement psi = (SqlCallStatement)this.getPsi();
        SqlLanguageDialectEx language = SqlImplUtil.getSqlDialectSafe((PsiElement)psi);
        List list = ContainerUtil.map(this.myArguments, a -> SqlPsiElementFactory.createExpressionFromText(a, language, (PsiElement)psi));
        if (list == null) {
            SqlCallStatementElementStub.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/stubs/SqlCallStatementElementStub";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/stubs/SqlCallStatementElementStub";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentExpressions";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

