/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.maven.model.InputLocationTracker;
import org.apache.maven.model.InputSource;

public final class InputLocation
implements Serializable,
Cloneable,
InputLocationTracker {
    private int lineNumber = -1;
    private int columnNumber = -1;
    private InputSource source;
    private Map<Object, InputLocation> locations;
    private InputLocation location;

    public InputLocation(int lineNumber, int columnNumber) {
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public InputLocation(int lineNumber, int columnNumber, InputSource source) {
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.source = source;
    }

    public InputLocation clone() {
        try {
            InputLocation copy = (InputLocation)super.clone();
            if (copy.locations != null) {
                copy.locations = new LinkedHashMap<Object, InputLocation>(copy.locations);
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public InputLocation getLocation(Object key2) {
        if (key2 instanceof String) {
            switch ((String)key2) {
                case "": {
                    return this.location;
                }
            }
            return this.getOtherLocation(key2);
        }
        return this.getOtherLocation(key2);
    }

    public Map<Object, InputLocation> getLocations() {
        return this.locations;
    }

    @Override
    public void setLocation(Object key2, InputLocation location) {
        if (key2 instanceof String) {
            switch ((String)key2) {
                case "": {
                    this.location = location;
                    return;
                }
            }
            this.setOtherLocation(key2, location);
            return;
        }
        this.setOtherLocation(key2, location);
    }

    public void setOtherLocation(Object key2, InputLocation location) {
        if (location != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key2, location);
        }
    }

    private InputLocation getOtherLocation(Object key2) {
        return this.locations != null ? this.locations.get(key2) : null;
    }

    public InputSource getSource() {
        return this.source;
    }

    public static InputLocation merge(InputLocation target2, InputLocation source, boolean sourceDominant) {
        Map<Object, InputLocation> locations;
        if (source == null) {
            return target2;
        }
        if (target2 == null) {
            return source;
        }
        InputLocation result2 = new InputLocation(target2.getLineNumber(), target2.getColumnNumber(), target2.getSource());
        Map<Object, InputLocation> sourceLocations = source.getLocations();
        Map<Object, InputLocation> targetLocations = target2.getLocations();
        if (sourceLocations == null) {
            locations = targetLocations;
        } else if (targetLocations == null) {
            locations = sourceLocations;
        } else {
            locations = new LinkedHashMap<Object, InputLocation>();
            locations.putAll(sourceDominant ? targetLocations : sourceLocations);
            locations.putAll(sourceDominant ? sourceLocations : targetLocations);
        }
        result2.setLocations(locations);
        return result2;
    }

    public static InputLocation merge(InputLocation target2, InputLocation source, Collection<Integer> indices) {
        Map<Object, InputLocation> locations;
        if (source == null) {
            return target2;
        }
        if (target2 == null) {
            return source;
        }
        InputLocation result2 = new InputLocation(target2.getLineNumber(), target2.getColumnNumber(), target2.getSource());
        Map<Object, InputLocation> sourceLocations = source.getLocations();
        Map<Object, InputLocation> targetLocations = target2.getLocations();
        if (sourceLocations == null) {
            locations = targetLocations;
        } else if (targetLocations == null) {
            locations = sourceLocations;
        } else {
            locations = new LinkedHashMap<Object, InputLocation>();
            for (Integer index : indices) {
                InputLocation location = index < 0 ? sourceLocations.get(~index.intValue()) : targetLocations.get(index);
                locations.put(locations.size(), location);
            }
        }
        result2.setLocations(locations);
        return result2;
    }

    public void setLocations(Map<Object, InputLocation> locations) {
        this.locations = locations;
    }

    public String toString() {
        return this.getLineNumber() + " : " + this.getColumnNumber() + ", " + this.getSource();
    }

    public static abstract class StringFormatter {
        public abstract String toString(InputLocation var1);
    }
}

