/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.merge;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.Developer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Extension;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryBase;
import org.apache.maven.model.Scm;
import org.apache.maven.model.Site;
import org.apache.maven.model.merge.ModelMerger;
import org.codehaus.plexus.util.StringUtils;

public class MavenModelMerger
extends ModelMerger {
    public static final String CHILD_PATH_ADJUSTMENT = "child-path-adjustment";
    public static final String ARTIFACT_ID = "artifact-id";

    @Override
    protected void mergeModel(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
        context.put(ARTIFACT_ID, target2.getArtifactId());
        super.mergeModel(target2, source, sourceDominant, context);
    }

    @Override
    protected void mergeModel_Name(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getName();
        if (src != null && sourceDominant) {
            target2.setName(src);
            target2.setLocation("name", source.getLocation("name"));
        }
    }

    @Override
    protected void mergeModel_Url(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getUrl();
        if (src != null) {
            if (sourceDominant) {
                target2.setUrl(src);
                target2.setLocation("url", source.getLocation("url"));
            } else if (target2.getUrl() == null) {
                target2.setUrl(this.extrapolateChildUrl(src, source.isChildProjectUrlInheritAppendPath(), context));
                target2.setLocation("url", source.getLocation("url"));
            }
        }
    }

    @Override
    protected void mergeModel_Organization(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
        Organization tgt;
        Organization src = source.getOrganization();
        if (src != null && (tgt = target2.getOrganization()) == null) {
            tgt = new Organization();
            tgt.setLocation("", src.getLocation(""));
            target2.setOrganization(tgt);
            this.mergeOrganization(tgt, src, sourceDominant, context);
        }
    }

    @Override
    protected void mergeModel_IssueManagement(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
        IssueManagement tgt;
        IssueManagement src = source.getIssueManagement();
        if (src != null && (tgt = target2.getIssueManagement()) == null) {
            tgt = new IssueManagement();
            tgt.setLocation("", src.getLocation(""));
            target2.setIssueManagement(tgt);
            this.mergeIssueManagement(tgt, src, sourceDominant, context);
        }
    }

    @Override
    protected void mergeModel_CiManagement(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
        CiManagement tgt;
        CiManagement src = source.getCiManagement();
        if (src != null && (tgt = target2.getCiManagement()) == null) {
            tgt = new CiManagement();
            tgt.setLocation("", src.getLocation(""));
            target2.setCiManagement(tgt);
            this.mergeCiManagement(tgt, src, sourceDominant, context);
        }
    }

    @Override
    protected void mergeModel_ModelVersion(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
    }

    @Override
    protected void mergeModel_ArtifactId(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
    }

    @Override
    protected void mergeModel_Profiles(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
    }

    @Override
    protected void mergeModel_Prerequisites(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
    }

    @Override
    protected void mergeModel_Licenses(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
        if (target2.getLicenses().isEmpty()) {
            target2.setLicenses(new ArrayList<License>(source.getLicenses()));
        }
    }

    @Override
    protected void mergeModel_Developers(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
        if (target2.getDevelopers().isEmpty()) {
            target2.setDevelopers(new ArrayList<Developer>(source.getDevelopers()));
        }
    }

    @Override
    protected void mergeModel_Contributors(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
        if (target2.getContributors().isEmpty()) {
            target2.setContributors(new ArrayList<Contributor>(source.getContributors()));
        }
    }

    @Override
    protected void mergeModel_MailingLists(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
        if (target2.getMailingLists().isEmpty()) {
            target2.setMailingLists(new ArrayList<MailingList>(source.getMailingLists()));
        }
    }

    @Override
    protected void mergeModelBase_Modules(ModelBase target2, ModelBase source, boolean sourceDominant, Map<Object, Object> context) {
        List<String> src = source.getModules();
        if (!src.isEmpty() && sourceDominant) {
            int i2;
            ArrayList<Integer> indices = new ArrayList<Integer>();
            List<String> tgt = target2.getModules();
            LinkedHashSet<String> excludes = new LinkedHashSet<String>(tgt);
            ArrayList<String> merged = new ArrayList<String>(tgt.size() + src.size());
            merged.addAll(tgt);
            int n = tgt.size();
            for (i2 = 0; i2 < n; ++i2) {
                indices.add(i2);
            }
            n = src.size();
            for (i2 = 0; i2 < n; ++i2) {
                String s = src.get(i2);
                if (excludes.contains(s)) continue;
                merged.add(s);
                indices.add(~i2);
            }
            target2.setModules(merged);
            target2.setLocation("modules", InputLocation.merge(target2.getLocation("modules"), source.getLocation("modules"), indices));
        }
    }

    @Override
    protected void mergeModelBase_Repositories(ModelBase target2, ModelBase source, boolean sourceDominant, Map<Object, Object> context) {
        List<Repository> src = source.getRepositories();
        if (!src.isEmpty()) {
            Object key2;
            List<Repository> recessive;
            List<Repository> dominant;
            List<Repository> tgt = target2.getRepositories();
            LinkedHashMap<Object, Repository> merged = new LinkedHashMap<Object, Repository>((src.size() + tgt.size()) * 2);
            if (sourceDominant) {
                dominant = src;
                recessive = tgt;
            } else {
                dominant = tgt;
                recessive = src;
            }
            for (Repository element : dominant) {
                key2 = this.getRepositoryKey(element);
                merged.put(key2, element);
            }
            for (Repository element : recessive) {
                key2 = this.getRepositoryKey(element);
                if (merged.containsKey(key2)) continue;
                merged.put(key2, element);
            }
            target2.setRepositories(new ArrayList<Repository>(merged.values()));
        }
    }

    @Override
    protected void mergeModelBase_PluginRepositories(ModelBase target2, ModelBase source, boolean sourceDominant, Map<Object, Object> context) {
        List<Repository> src = source.getPluginRepositories();
        if (!src.isEmpty()) {
            Object key2;
            List<Repository> recessive;
            List<Repository> dominant;
            List<Repository> tgt = target2.getPluginRepositories();
            LinkedHashMap<Object, Repository> merged = new LinkedHashMap<Object, Repository>((src.size() + tgt.size()) * 2);
            if (sourceDominant) {
                dominant = src;
                recessive = tgt;
            } else {
                dominant = tgt;
                recessive = src;
            }
            for (Repository element : dominant) {
                key2 = this.getRepositoryKey(element);
                merged.put(key2, element);
            }
            for (Repository element : recessive) {
                key2 = this.getRepositoryKey(element);
                if (merged.containsKey(key2)) continue;
                merged.put(key2, element);
            }
            target2.setPluginRepositories(new ArrayList<Repository>(merged.values()));
        }
    }

    @Override
    protected void mergeBuildBase_Filters(BuildBase target2, BuildBase source, boolean sourceDominant, Map<Object, Object> context) {
        List<String> src = source.getFilters();
        if (!src.isEmpty()) {
            List<String> tgt = target2.getFilters();
            LinkedHashSet<String> excludes = new LinkedHashSet<String>(tgt);
            ArrayList<String> merged = new ArrayList<String>(tgt.size() + src.size());
            merged.addAll(tgt);
            for (String s : src) {
                if (excludes.contains(s)) continue;
                merged.add(s);
            }
            target2.setFilters(merged);
        }
    }

    @Override
    protected void mergeBuildBase_Resources(BuildBase target2, BuildBase source, boolean sourceDominant, Map<Object, Object> context) {
        if (sourceDominant || target2.getResources().isEmpty()) {
            super.mergeBuildBase_Resources(target2, source, sourceDominant, context);
        }
    }

    @Override
    protected void mergeBuildBase_TestResources(BuildBase target2, BuildBase source, boolean sourceDominant, Map<Object, Object> context) {
        if (sourceDominant || target2.getTestResources().isEmpty()) {
            super.mergeBuildBase_TestResources(target2, source, sourceDominant, context);
        }
    }

    @Override
    protected void mergeDistributionManagement_Repository(DistributionManagement target2, DistributionManagement source, boolean sourceDominant, Map<Object, Object> context) {
        DeploymentRepository src = source.getRepository();
        if (src != null) {
            DeploymentRepository tgt = target2.getRepository();
            if (sourceDominant || tgt == null) {
                tgt = new DeploymentRepository();
                tgt.setLocation("", src.getLocation(""));
                target2.setRepository(tgt);
                this.mergeDeploymentRepository(tgt, src, sourceDominant, context);
            }
        }
    }

    @Override
    protected void mergeDistributionManagement_SnapshotRepository(DistributionManagement target2, DistributionManagement source, boolean sourceDominant, Map<Object, Object> context) {
        DeploymentRepository src = source.getSnapshotRepository();
        if (src != null) {
            DeploymentRepository tgt = target2.getSnapshotRepository();
            if (sourceDominant || tgt == null) {
                tgt = new DeploymentRepository();
                tgt.setLocation("", src.getLocation(""));
                target2.setSnapshotRepository(tgt);
                this.mergeDeploymentRepository(tgt, src, sourceDominant, context);
            }
        }
    }

    @Override
    protected void mergeDistributionManagement_Site(DistributionManagement target2, DistributionManagement source, boolean sourceDominant, Map<Object, Object> context) {
        Site src = source.getSite();
        if (src != null) {
            Site tgt = target2.getSite();
            if (sourceDominant || tgt == null || this.isSiteEmpty(tgt)) {
                if (tgt == null) {
                    tgt = new Site();
                }
                tgt.setLocation("", src.getLocation(""));
                target2.setSite(tgt);
                this.mergeSite(tgt, src, sourceDominant, context);
            }
            this.mergeSite_ChildSiteUrlInheritAppendPath(tgt, src, sourceDominant, context);
        }
    }

    @Override
    protected void mergeSite(Site target2, Site source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeSite_Id(target2, source, sourceDominant, context);
        this.mergeSite_Name(target2, source, sourceDominant, context);
        this.mergeSite_Url(target2, source, sourceDominant, context);
    }

    protected boolean isSiteEmpty(Site site) {
        return StringUtils.isEmpty(site.getId()) && StringUtils.isEmpty(site.getName()) && StringUtils.isEmpty(site.getUrl());
    }

    @Override
    protected void mergeSite_Url(Site target2, Site source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getUrl();
        if (src != null) {
            if (sourceDominant) {
                target2.setUrl(src);
                target2.setLocation("url", source.getLocation("url"));
            } else if (target2.getUrl() == null) {
                target2.setUrl(this.extrapolateChildUrl(src, source.isChildSiteUrlInheritAppendPath(), context));
                target2.setLocation("url", source.getLocation("url"));
            }
        }
    }

    @Override
    protected void mergeScm_Url(Scm target2, Scm source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getUrl();
        if (src != null) {
            if (sourceDominant) {
                target2.setUrl(src);
                target2.setLocation("url", source.getLocation("url"));
            } else if (target2.getUrl() == null) {
                target2.setUrl(this.extrapolateChildUrl(src, source.isChildScmUrlInheritAppendPath(), context));
                target2.setLocation("url", source.getLocation("url"));
            }
        }
    }

    @Override
    protected void mergeScm_Connection(Scm target2, Scm source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getConnection();
        if (src != null) {
            if (sourceDominant) {
                target2.setConnection(src);
                target2.setLocation("connection", source.getLocation("connection"));
            } else if (target2.getConnection() == null) {
                target2.setConnection(this.extrapolateChildUrl(src, source.isChildScmConnectionInheritAppendPath(), context));
                target2.setLocation("connection", source.getLocation("connection"));
            }
        }
    }

    @Override
    protected void mergeScm_DeveloperConnection(Scm target2, Scm source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getDeveloperConnection();
        if (src != null) {
            if (sourceDominant) {
                target2.setDeveloperConnection(src);
                target2.setLocation("developerConnection", source.getLocation("developerConnection"));
            } else if (target2.getDeveloperConnection() == null) {
                String e = this.extrapolateChildUrl(src, source.isChildScmDeveloperConnectionInheritAppendPath(), context);
                target2.setDeveloperConnection(e);
                target2.setLocation("developerConnection", source.getLocation("developerConnection"));
            }
        }
    }

    @Override
    protected void mergePlugin_Executions(Plugin target2, Plugin source, boolean sourceDominant, Map<Object, Object> context) {
        List<PluginExecution> src = source.getExecutions();
        if (!src.isEmpty()) {
            Object key2;
            List<PluginExecution> tgt = target2.getExecutions();
            LinkedHashMap<Object, PluginExecution> merged = new LinkedHashMap<Object, PluginExecution>((src.size() + tgt.size()) * 2);
            for (PluginExecution element : src) {
                if (!sourceDominant && !(element.getInherited() != null ? element.isInherited() : source.isInherited())) continue;
                key2 = this.getPluginExecutionKey(element);
                merged.put(key2, element);
            }
            for (PluginExecution element : tgt) {
                key2 = this.getPluginExecutionKey(element);
                PluginExecution existing2 = (PluginExecution)merged.get(key2);
                if (existing2 != null) {
                    this.mergePluginExecution(element, existing2, sourceDominant, context);
                }
                merged.put(key2, element);
            }
            target2.setExecutions(new ArrayList<PluginExecution>(merged.values()));
        }
    }

    @Override
    protected void mergePluginExecution_Goals(PluginExecution target2, PluginExecution source, boolean sourceDominant, Map<Object, Object> context) {
        List<String> src = source.getGoals();
        if (!src.isEmpty()) {
            List<String> tgt = target2.getGoals();
            LinkedHashSet<String> excludes = new LinkedHashSet<String>(tgt);
            ArrayList<String> merged = new ArrayList<String>(tgt.size() + src.size());
            merged.addAll(tgt);
            for (String s : src) {
                if (excludes.contains(s)) continue;
                merged.add(s);
            }
            target2.setGoals(merged);
        }
    }

    @Override
    protected void mergeReportPlugin_ReportSets(ReportPlugin target2, ReportPlugin source, boolean sourceDominant, Map<Object, Object> context) {
        List<ReportSet> src = source.getReportSets();
        if (!src.isEmpty()) {
            Object key2;
            List<ReportSet> tgt = target2.getReportSets();
            LinkedHashMap<Object, ReportSet> merged = new LinkedHashMap<Object, ReportSet>((src.size() + tgt.size()) * 2);
            for (ReportSet rset : src) {
                if (!sourceDominant && !(rset.getInherited() != null ? rset.isInherited() : source.isInherited())) continue;
                key2 = this.getReportSetKey(rset);
                merged.put(key2, rset);
            }
            for (ReportSet element : tgt) {
                key2 = this.getReportSetKey(element);
                ReportSet existing2 = (ReportSet)merged.get(key2);
                if (existing2 != null) {
                    this.mergeReportSet(element, existing2, sourceDominant, context);
                }
                merged.put(key2, element);
            }
            target2.setReportSets(new ArrayList<ReportSet>(merged.values()));
        }
    }

    @Override
    protected Object getDependencyKey(Dependency dependency) {
        return dependency.getManagementKey();
    }

    @Override
    protected Object getPluginKey(Plugin plugin) {
        return plugin.getKey();
    }

    @Override
    protected Object getPluginExecutionKey(PluginExecution pluginExecution) {
        return pluginExecution.getId();
    }

    @Override
    protected Object getReportPluginKey(ReportPlugin reportPlugin) {
        return reportPlugin.getKey();
    }

    @Override
    protected Object getReportSetKey(ReportSet reportSet) {
        return reportSet.getId();
    }

    @Override
    protected Object getRepositoryBaseKey(RepositoryBase repositoryBase) {
        return repositoryBase.getId();
    }

    @Override
    protected Object getExtensionKey(Extension extension) {
        return extension.getGroupId() + ':' + extension.getArtifactId();
    }

    @Override
    protected Object getExclusionKey(Exclusion exclusion) {
        return exclusion.getGroupId() + ':' + exclusion.getArtifactId();
    }

    protected String extrapolateChildUrl(String parentUrl, boolean appendPath, Map<Object, Object> context) {
        return parentUrl;
    }
}

