/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class DefaultRepositoryEventDispatcher
implements RepositoryEventDispatcher,
Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRepositoryEventDispatcher.class);
    private Collection<RepositoryListener> listeners = new ArrayList<RepositoryListener>();

    @Deprecated
    public DefaultRepositoryEventDispatcher() {
    }

    @Inject
    public DefaultRepositoryEventDispatcher(Set<RepositoryListener> listeners) {
        this.setRepositoryListeners(listeners);
    }

    public DefaultRepositoryEventDispatcher addRepositoryListener(RepositoryListener listener2) {
        this.listeners.add(Objects.requireNonNull(listener2, "repository listener cannot be null"));
        return this;
    }

    public DefaultRepositoryEventDispatcher setRepositoryListeners(Collection<RepositoryListener> listeners) {
        this.listeners = listeners == null ? new ArrayList<RepositoryListener>() : listeners;
        return this;
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setRepositoryListeners(locator.getServices(RepositoryListener.class));
    }

    @Override
    public void dispatch(RepositoryEvent event) {
        RepositoryListener listener2;
        Objects.requireNonNull(event, "event cannot be null");
        if (!this.listeners.isEmpty()) {
            for (RepositoryListener listener3 : this.listeners) {
                this.dispatch(event, listener3);
            }
        }
        if ((listener2 = event.getSession().getRepositoryListener()) != null) {
            this.dispatch(event, listener2);
        }
    }

    private void dispatch(RepositoryEvent event, RepositoryListener listener2) {
        try {
            switch (event.getType()) {
                case ARTIFACT_DEPLOYED: {
                    listener2.artifactDeployed(event);
                    break;
                }
                case ARTIFACT_DEPLOYING: {
                    listener2.artifactDeploying(event);
                    break;
                }
                case ARTIFACT_DESCRIPTOR_INVALID: {
                    listener2.artifactDescriptorInvalid(event);
                    break;
                }
                case ARTIFACT_DESCRIPTOR_MISSING: {
                    listener2.artifactDescriptorMissing(event);
                    break;
                }
                case ARTIFACT_DOWNLOADED: {
                    listener2.artifactDownloaded(event);
                    break;
                }
                case ARTIFACT_DOWNLOADING: {
                    listener2.artifactDownloading(event);
                    break;
                }
                case ARTIFACT_INSTALLED: {
                    listener2.artifactInstalled(event);
                    break;
                }
                case ARTIFACT_INSTALLING: {
                    listener2.artifactInstalling(event);
                    break;
                }
                case ARTIFACT_RESOLVED: {
                    listener2.artifactResolved(event);
                    break;
                }
                case ARTIFACT_RESOLVING: {
                    listener2.artifactResolving(event);
                    break;
                }
                case METADATA_DEPLOYED: {
                    listener2.metadataDeployed(event);
                    break;
                }
                case METADATA_DEPLOYING: {
                    listener2.metadataDeploying(event);
                    break;
                }
                case METADATA_DOWNLOADED: {
                    listener2.metadataDownloaded(event);
                    break;
                }
                case METADATA_DOWNLOADING: {
                    listener2.metadataDownloading(event);
                    break;
                }
                case METADATA_INSTALLED: {
                    listener2.metadataInstalled(event);
                    break;
                }
                case METADATA_INSTALLING: {
                    listener2.metadataInstalling(event);
                    break;
                }
                case METADATA_INVALID: {
                    listener2.metadataInvalid(event);
                    break;
                }
                case METADATA_RESOLVED: {
                    listener2.metadataResolved(event);
                    break;
                }
                case METADATA_RESOLVING: {
                    listener2.metadataResolving(event);
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown repository event type " + (Object)((Object)event.getType()));
                }
            }
        }
        catch (Exception | LinkageError e) {
            this.logError(e, listener2);
        }
    }

    private void logError(Throwable e, Object listener2) {
        LOGGER.warn("Failed to dispatch repository event to {}", (Object)listener2.getClass().getCanonicalName(), (Object)e);
    }
}

