/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.filter;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;

public final class AndDependencyFilter
implements DependencyFilter {
    private final Set<DependencyFilter> filters = new LinkedHashSet<DependencyFilter>();

    public AndDependencyFilter(DependencyFilter ... filters) {
        if (filters != null) {
            Collections.addAll(this.filters, filters);
        }
    }

    public AndDependencyFilter(Collection<DependencyFilter> filters) {
        if (filters != null) {
            this.filters.addAll(filters);
        }
    }

    public static DependencyFilter newInstance(DependencyFilter filter1, DependencyFilter filter2) {
        if (filter1 == null) {
            return filter2;
        }
        if (filter2 == null) {
            return filter1;
        }
        return new AndDependencyFilter(filter1, filter2);
    }

    @Override
    public boolean accept(DependencyNode node, List<DependencyNode> parents) {
        Objects.requireNonNull(node, "node cannot be null");
        Objects.requireNonNull(parents, "parents cannot be null");
        for (DependencyFilter filter : this.filters) {
            if (filter.accept(node, parents)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj2) {
        if (this == obj2) {
            return true;
        }
        if (obj2 == null || !this.getClass().equals(obj2.getClass())) {
            return false;
        }
        AndDependencyFilter that = (AndDependencyFilter)obj2;
        return this.filters.equals(that.filters);
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + this.filters.hashCode();
        return hash;
    }
}

