/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.repository;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.LocalArtifactRegistration;
import org.eclipse.aether.repository.LocalArtifactRequest;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.repository.LocalMetadataRegistration;
import org.eclipse.aether.repository.LocalMetadataRequest;
import org.eclipse.aether.repository.LocalMetadataResult;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;

public final class ChainedLocalRepositoryManager
implements LocalRepositoryManager {
    private final LocalRepositoryManager head;
    private final List<LocalRepositoryManager> tail;
    private final boolean ignoreTailAvailability;

    public ChainedLocalRepositoryManager(LocalRepositoryManager head, List<LocalRepositoryManager> tail, boolean ignoreTailAvailability) {
        this.head = Objects.requireNonNull(head, "head cannot be null");
        this.tail = Objects.requireNonNull(tail, "tail cannot be null");
        this.ignoreTailAvailability = ignoreTailAvailability;
    }

    @Override
    public LocalRepository getRepository() {
        return this.head.getRepository();
    }

    @Override
    public String getPathForLocalArtifact(Artifact artifact) {
        return this.head.getPathForLocalArtifact(artifact);
    }

    @Override
    public String getPathForRemoteArtifact(Artifact artifact, RemoteRepository repository, String context) {
        return this.head.getPathForRemoteArtifact(artifact, repository, context);
    }

    @Override
    public String getPathForLocalMetadata(Metadata metadata) {
        return this.head.getPathForLocalMetadata(metadata);
    }

    @Override
    public String getPathForRemoteMetadata(Metadata metadata, RemoteRepository repository, String context) {
        return this.head.getPathForRemoteMetadata(metadata, repository, context);
    }

    @Override
    public LocalArtifactResult find(RepositorySystemSession session, LocalArtifactRequest request2) {
        LocalArtifactResult result2 = this.head.find(session, request2);
        if (result2.isAvailable()) {
            return result2;
        }
        for (LocalRepositoryManager lrm : this.tail) {
            result2 = lrm.find(session, request2);
            if (result2.getFile() == null) continue;
            if (this.ignoreTailAvailability) {
                result2.setAvailable(true);
                return result2;
            }
            if (!result2.isAvailable()) continue;
            return result2;
        }
        return new LocalArtifactResult(request2);
    }

    @Override
    public void add(RepositorySystemSession session, LocalArtifactRegistration request2) {
        String artifactPath = request2.getRepository() != null ? this.getPathForRemoteArtifact(request2.getArtifact(), request2.getRepository(), "check") : this.getPathForLocalArtifact(request2.getArtifact());
        Path file = new File(this.head.getRepository().getBasedir(), artifactPath).toPath();
        if (Files.isRegularFile(file, new LinkOption[0])) {
            this.head.add(session, request2);
        }
    }

    @Override
    public LocalMetadataResult find(RepositorySystemSession session, LocalMetadataRequest request2) {
        LocalMetadataResult result2 = this.head.find(session, request2);
        if (result2.getFile() != null) {
            return result2;
        }
        for (LocalRepositoryManager lrm : this.tail) {
            result2 = lrm.find(session, request2);
            if (result2.getFile() == null) continue;
            return result2;
        }
        return new LocalMetadataResult(request2);
    }

    @Override
    public void add(RepositorySystemSession session, LocalMetadataRegistration request2) {
        String metadataPath = request2.getRepository() != null ? this.getPathForRemoteMetadata(request2.getMetadata(), request2.getRepository(), "check") : this.getPathForLocalMetadata(request2.getMetadata());
        Path file = new File(this.head.getRepository().getBasedir(), metadataPath).toPath();
        if (Files.isRegularFile(file, new LinkOption[0])) {
            this.head.add(session, request2);
        }
    }

    public String toString() {
        return this.head.getRepository().toString() + this.tail.stream().map(LocalRepositoryManager::getRepository).collect(Collectors.toList());
    }
}

