/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.version;

import java.util.ArrayList;
import java.util.Objects;
import org.eclipse.aether.util.version.GenericVersion;
import org.eclipse.aether.util.version.GenericVersionConstraint;
import org.eclipse.aether.util.version.GenericVersionRange;
import org.eclipse.aether.util.version.UnionVersionRange;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.VersionScheme;

public final class GenericVersionScheme
implements VersionScheme {
    @Override
    public GenericVersion parseVersion(String version) throws InvalidVersionSpecificationException {
        return new GenericVersion(version);
    }

    @Override
    public GenericVersionRange parseVersionRange(String range) throws InvalidVersionSpecificationException {
        return new GenericVersionRange(range);
    }

    @Override
    public GenericVersionConstraint parseVersionConstraint(String constraint) throws InvalidVersionSpecificationException {
        String process2 = Objects.requireNonNull(constraint, "constraint cannot be null");
        ArrayList<GenericVersionRange> ranges = new ArrayList<GenericVersionRange>();
        while (process2.startsWith("[") || process2.startsWith("(")) {
            int index2;
            int index1 = process2.indexOf(41);
            int index = index2 = process2.indexOf(93);
            if (index2 < 0 || index1 >= 0 && index1 < index2) {
                index = index1;
            }
            if (index < 0) {
                throw new InvalidVersionSpecificationException(constraint, "Unbounded version range " + constraint);
            }
            GenericVersionRange range = this.parseVersionRange(process2.substring(0, index + 1));
            ranges.add(range);
            if (!(process2 = process2.substring(index + 1).trim()).startsWith(",")) continue;
            process2 = process2.substring(1).trim();
        }
        if (process2.length() > 0 && !ranges.isEmpty()) {
            throw new InvalidVersionSpecificationException(constraint, "Invalid version range " + constraint + ", expected [ or ( but got " + process2);
        }
        GenericVersionConstraint result2 = ranges.isEmpty() ? new GenericVersionConstraint(this.parseVersion(constraint)) : new GenericVersionConstraint(UnionVersionRange.from(ranges));
        return result2;
    }

    public boolean equals(Object obj2) {
        if (this == obj2) {
            return true;
        }
        return obj2 != null && this.getClass().equals(obj2.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static void main(String ... args2) {
        System.out.println("Display parameters as parsed by Maven Resolver (in canonical form and as a list of tokens) and comparison result:");
        if (args2.length == 0) {
            return;
        }
        GenericVersion prev2 = null;
        int i2 = 1;
        for (String version : args2) {
            GenericVersion c2 = new GenericVersion(version);
            if (prev2 != null) {
                int compare = prev2.compareTo(c2);
                System.out.println("   " + prev2 + ' ' + (compare == 0 ? "==" : (compare < 0 ? "<" : ">")) + ' ' + version);
            }
            System.out.println(i2++ + ". " + version + " -> " + c2.asString() + "; tokens: " + c2.asItems());
            prev2 = c2;
        }
    }
}

