/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlay.snap;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.operation.overlay.OverlayOp;
import org.locationtech.jts.operation.overlay.snap.GeometrySnapper;
import org.locationtech.jts.precision.CommonBitsRemover;

public class SnapOverlayOp {
    private Geometry[] geom = new Geometry[2];
    private double snapTolerance;
    private CommonBitsRemover cbr;

    public static Geometry overlayOp(Geometry g0, Geometry g1, int opCode) {
        SnapOverlayOp op = new SnapOverlayOp(g0, g1);
        return op.getResultGeometry(opCode);
    }

    public static Geometry intersection(Geometry g0, Geometry g1) {
        return SnapOverlayOp.overlayOp(g0, g1, 1);
    }

    public static Geometry union(Geometry g0, Geometry g1) {
        return SnapOverlayOp.overlayOp(g0, g1, 2);
    }

    public static Geometry difference(Geometry g0, Geometry g1) {
        return SnapOverlayOp.overlayOp(g0, g1, 3);
    }

    public static Geometry symDifference(Geometry g0, Geometry g1) {
        return SnapOverlayOp.overlayOp(g0, g1, 4);
    }

    public SnapOverlayOp(Geometry g1, Geometry g2) {
        this.geom[0] = g1;
        this.geom[1] = g2;
        this.computeSnapTolerance();
    }

    private void computeSnapTolerance() {
        this.snapTolerance = GeometrySnapper.computeOverlaySnapTolerance(this.geom[0], this.geom[1]);
    }

    public Geometry getResultGeometry(int opCode) {
        Geometry[] prepGeom = this.snap(this.geom);
        Geometry result2 = OverlayOp.overlayOp(prepGeom[0], prepGeom[1], opCode);
        return this.prepareResult(result2);
    }

    private Geometry selfSnap(Geometry geom) {
        GeometrySnapper snapper0 = new GeometrySnapper(geom);
        Geometry snapGeom = snapper0.snapTo(geom, this.snapTolerance);
        return snapGeom;
    }

    private Geometry[] snap(Geometry[] geom) {
        Geometry[] remGeom = this.removeCommonBits(geom);
        Geometry[] snapGeom = GeometrySnapper.snap(remGeom[0], remGeom[1], this.snapTolerance);
        return snapGeom;
    }

    private Geometry prepareResult(Geometry geom) {
        this.cbr.addCommonBits(geom);
        return geom;
    }

    private Geometry[] removeCommonBits(Geometry[] geom) {
        this.cbr = new CommonBitsRemover();
        this.cbr.add(geom[0]);
        this.cbr.add(geom[1]);
        Geometry[] remGeom = new Geometry[]{this.cbr.removeCommonBits(geom[0].copy()), this.cbr.removeCommonBits(geom[1].copy())};
        return remGeom;
    }
}

