/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.lang.ASTNode;
import com.intellij.lang.puppet.PuppetTokenTypes;
import com.intellij.lang.puppet.psi.PsiPuppetBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PuppetAlignmentProcessor {
    private static final TokenSet ARROWS_NON_BLOCK_GRANDPARENTS = TokenSet.create((IElementType[])new IElementType[]{PuppetTokenTypes.HASH_VALUE, PuppetTokenTypes.RESOURCE_ARGUMENTS_LIST});
    private static final TokenSet ARROWS_PARENTS = TokenSet.create((IElementType[])new IElementType[]{PuppetTokenTypes.ARGUMENT, PuppetTokenTypes.HASH_ARGUMENT, PuppetTokenTypes.SELECTOR_VALUE, PuppetTokenTypes.DEFAULT_SELECTOR_VALUE, PuppetTokenTypes.HASH_PAIR});
    private static final TokenSet ARROWS_TOKENS = TokenSet.create((IElementType[])new IElementType[]{PuppetTokenTypes.FARROW, PuppetTokenTypes.PARROW});
    private final Map<ASTNode, Alignment> myAlignmentMap = new HashMap<ASTNode, Alignment>();

    PuppetAlignmentProcessor() {
    }

    @Nullable
    public Alignment getNodeAlignment(@NotNull ASTNode node) {
        ASTNode parentNode;
        if (node == null) {
            PuppetAlignmentProcessor.$$$reportNull$$$0(0);
        }
        if ((parentNode = node.getTreeParent()) == null) {
            return null;
        }
        ASTNode grandParentNode = parentNode.getTreeParent();
        PsiElement grandParentElement = grandParentNode == null ? null : grandParentNode.getPsi();
        IElementType grandParentElementType = PsiUtilCore.getElementType((ASTNode)grandParentNode);
        IElementType parentElementType = PsiUtilCore.getElementType((ASTNode)parentNode);
        IElementType elementType = PsiUtilCore.getElementType((ASTNode)node);
        if (grandParentNode == null) {
            return null;
        }
        if (ARROWS_TOKENS.contains(elementType) && ARROWS_PARENTS.contains(parentElementType) && (grandParentElement instanceof PsiPuppetBlock || ARROWS_NON_BLOCK_GRANDPARENTS.contains(grandParentElementType))) {
            return this.getAlignmentBase(grandParentNode);
        }
        if (elementType == PuppetTokenTypes.EQUALS && parentElementType == PuppetTokenTypes.PARAMETER && grandParentElementType == PuppetTokenTypes.PARENTHESIZED_PARAMETERS_LIST_BLOCK) {
            return this.getAlignmentBase(grandParentNode);
        }
        return null;
    }

    @Nullable
    public Alignment getNewChildAlignment(ASTNode parent, ASTNode prevChild) {
        return null;
    }

    @NotNull
    private Alignment getAlignmentBase(@NotNull ASTNode node) {
        Alignment result;
        if (node == null) {
            PuppetAlignmentProcessor.$$$reportNull$$$0(1);
        }
        if ((result = this.myAlignmentMap.get(node)) == null) {
            result = Alignment.createAlignment((boolean)true, (Alignment.Anchor)Alignment.Anchor.LEFT);
            this.myAlignmentMap.put(node, result);
        }
        Alignment alignment = result;
        if (alignment == null) {
            PuppetAlignmentProcessor.$$$reportNull$$$0(2);
        }
        return alignment;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/formatter/PuppetAlignmentProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/formatter/PuppetAlignmentProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAlignmentBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNodeAlignment";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAlignmentBase";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

