/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.highlighter;

import com.intellij.lang.puppet.highlighter.PuppetHighlightingLexer;
import com.intellij.lang.puppet.highlighter.PuppetSyntaxHighlighterColors;
import com.intellij.lang.puppet.lexer.PuppetTokenTypeSets;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PuppetHighlighter
extends SyntaxHighlighterBase {
    @Nullable
    protected final Project myProject;
    @NotNull
    private static final Map<IElementType, TextAttributesKey> ourMap = new HashMap<IElementType, TextAttributesKey>();

    public PuppetHighlighter(@Nullable Project project) {
        this.myProject = project;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        return new PuppetHighlightingLexer(this.myProject);
    }

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = PuppetHighlighter.pack((TextAttributesKey)ourMap.get(tokenType));
        if (textAttributesKeyArray == null) {
            PuppetHighlighter.$$$reportNull$$$0(0);
        }
        return textAttributesKeyArray;
    }

    static {
        PuppetHighlighter.safeMap(ourMap, (TokenSet)PuppetTokenTypeSets.KEYWORDS, (TextAttributesKey)PuppetSyntaxHighlighterColors.KEYWORD);
        PuppetHighlighter.safeMap(ourMap, (IElementType)PuppetTokenTypeSets.NAME, (TextAttributesKey)PuppetSyntaxHighlighterColors.NAME);
        PuppetHighlighter.safeMap(ourMap, (TokenSet)PuppetTokenTypeSets.DQ_STRINGS, (TextAttributesKey)PuppetSyntaxHighlighterColors.DQ_STRING);
        PuppetHighlighter.safeMap(ourMap, (TokenSet)PuppetTokenTypeSets.DIGITS, (TextAttributesKey)PuppetSyntaxHighlighterColors.DIGIT);
        PuppetHighlighter.safeMap(ourMap, (IElementType)PuppetTokenTypeSets.REGEX, (TextAttributesKey)PuppetSyntaxHighlighterColors.REGEX);
        PuppetHighlighter.safeMap(ourMap, (TokenSet)PuppetTokenTypeSets.VARIABLE_INTERPOLATION_TAGS, (TextAttributesKey)PuppetSyntaxHighlighterColors.VARIABLE_INTERPOLATION_TAGS);
        PuppetHighlighter.safeMap(ourMap, (TokenSet)PuppetTokenTypeSets.OPERATORS, (TextAttributesKey)PuppetSyntaxHighlighterColors.OPERATION_SIGN);
        PuppetHighlighter.safeMap(ourMap, (IElementType)PuppetTokenTypeSets.DOLLAR, (TextAttributesKey)PuppetSyntaxHighlighterColors.VARIABLE);
        PuppetHighlighter.safeMap(ourMap, (IElementType)PuppetTokenTypeSets.VARIABLE_LBRACE, (TextAttributesKey)PuppetSyntaxHighlighterColors.VARIABLE);
        PuppetHighlighter.safeMap(ourMap, (IElementType)PuppetTokenTypeSets.VARIABLE_NAME, (TextAttributesKey)PuppetSyntaxHighlighterColors.VARIABLE);
        PuppetHighlighter.safeMap(ourMap, (IElementType)PuppetTokenTypeSets.VARIABLE_RBRACE, (TextAttributesKey)PuppetSyntaxHighlighterColors.VARIABLE);
        PuppetHighlighter.safeMap(ourMap, (IElementType)PuppetTokenTypeSets.SINGLE_QUOTED_STRING, (TextAttributesKey)PuppetSyntaxHighlighterColors.SQ_STRING);
        PuppetHighlighter.safeMap(ourMap, (IElementType)PuppetTokenTypeSets.LPAREN, (TextAttributesKey)PuppetSyntaxHighlighterColors.PARENTHS);
        PuppetHighlighter.safeMap(ourMap, (IElementType)PuppetTokenTypeSets.RPAREN, (TextAttributesKey)PuppetSyntaxHighlighterColors.PARENTHS);
        PuppetHighlighter.safeMap(ourMap, (IElementType)PuppetTokenTypeSets.LBRACE, (TextAttributesKey)PuppetSyntaxHighlighterColors.BRACES);
        PuppetHighlighter.safeMap(ourMap, (IElementType)PuppetTokenTypeSets.RBRACE, (TextAttributesKey)PuppetSyntaxHighlighterColors.BRACES);
        PuppetHighlighter.safeMap(ourMap, (IElementType)PuppetTokenTypeSets.LBRACK, (TextAttributesKey)PuppetSyntaxHighlighterColors.BRACKETS);
        PuppetHighlighter.safeMap(ourMap, (IElementType)PuppetTokenTypeSets.RBRACK, (TextAttributesKey)PuppetSyntaxHighlighterColors.BRACKETS);
        PuppetHighlighter.safeMap(ourMap, (IElementType)PuppetTokenTypeSets.COMMA, (TextAttributesKey)PuppetSyntaxHighlighterColors.COMMA);
        PuppetHighlighter.safeMap(ourMap, (IElementType)PuppetTokenTypeSets.DOT, (TextAttributesKey)PuppetSyntaxHighlighterColors.DOT);
        PuppetHighlighter.safeMap(ourMap, (IElementType)PuppetTokenTypeSets.SEMIC, (TextAttributesKey)PuppetSyntaxHighlighterColors.SEMIC);
        PuppetHighlighter.safeMap(ourMap, (IElementType)PuppetTokenTypeSets.COMMENT, (TextAttributesKey)PuppetSyntaxHighlighterColors.BLOCK_COMMENT);
        PuppetHighlighter.safeMap(ourMap, (IElementType)PuppetTokenTypeSets.BAD_CHARACTER, (TextAttributesKey)PuppetSyntaxHighlighterColors.BAD_CHARACTER);
        PuppetHighlighter.safeMap(ourMap, (IElementType)PuppetTokenTypeSets.ESCAPE_SEQUENCE, (TextAttributesKey)PuppetSyntaxHighlighterColors.ESCAPE_SEQUENCE);
        PuppetHighlighter.safeMap(ourMap, (TokenSet)PuppetTokenTypeSets.HEREDOC_TAGS, (TextAttributesKey)PuppetSyntaxHighlighterColors.HEREDOC_TAGS);
        PuppetHighlighter.safeMap(ourMap, (IElementType)PuppetTokenTypeSets.HEREDOC_BODY, (TextAttributesKey)PuppetSyntaxHighlighterColors.SQ_STRING);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/puppet/highlighter/PuppetHighlighter", "getTokenHighlights"));
    }
}

