/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.project;

import com.intellij.lang.puppet.adapters.PuppetDependencyManagerAdapter;
import com.intellij.lang.puppet.ide.libraries.PuppetLibraryUtil;
import com.intellij.lang.puppet.project.PuppetModule;
import com.intellij.lang.puppet.project.PuppetScopeManager;
import com.intellij.lang.puppet.project.meta.PuppetMetadata;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PuppetEntity<T extends PuppetMetadata> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myRoot;
    @NotNull
    private final T myMetadata;
    private final NullableLazyValue<Module> myModuleProvider;

    public PuppetEntity(@NotNull Project project, @NotNull VirtualFile root, @NotNull T metadata) {
        if (project == null) {
            PuppetEntity.$$$reportNull$$$0(0);
        }
        if (root == null) {
            PuppetEntity.$$$reportNull$$$0(1);
        }
        if (metadata == null) {
            PuppetEntity.$$$reportNull$$$0(2);
        }
        this.myModuleProvider = NullableLazyValue.atomicLazyNullable(() -> ModuleUtilCore.findModuleForFile((VirtualFile)this.getRoot(), (Project)this.getProject()));
        this.myProject = project;
        this.myRoot = root;
        this.myMetadata = metadata;
    }

    @NotNull
    public String getName() {
        String name = this.getMetadata().getName();
        String string = name == null ? this.getRoot().getName() : name;
        if (string == null) {
            PuppetEntity.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public Module getIdeaModule() {
        return (Module)this.myModuleProvider.getValue();
    }

    @NotNull
    public abstract String getLibrarianDependenciesRootName();

    public boolean isUnderDependenciesRoot(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            PuppetEntity.$$$reportNull$$$0(4);
        }
        return this.isValid() && PuppetEntity.isUnderRoot(virtualFile, this.getAllDependenciesRoots());
    }

    protected static boolean isUnderRoot(@NotNull VirtualFile target, @NotNull List<? extends VirtualFile> roots) {
        if (target == null) {
            PuppetEntity.$$$reportNull$$$0(5);
        }
        if (roots == null) {
            PuppetEntity.$$$reportNull$$$0(6);
        }
        return VfsUtilCore.isUnder((VirtualFile)target, new HashSet<VirtualFile>(roots));
    }

    @NotNull
    public abstract List<VirtualFile> getAllDependenciesRoots();

    @Nullable
    protected VirtualFile getLibrarianDependenciesRoot() {
        if (!this.isValid()) {
            return null;
        }
        return this.myRoot.findChild(this.getLibrarianDependenciesRootName());
    }

    @RequiresReadLock
    public boolean isValid() {
        ThreadingAssertions.softAssertReadAccess();
        return this.myRoot.isValid() && !this.myProject.isDisposed();
    }

    @NotNull
    public abstract String getDescriptiveName();

    @NotNull
    public abstract List<PuppetModule> getDependencies();

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            PuppetEntity.$$$reportNull$$$0(7);
        }
        return project;
    }

    @NotNull
    public VirtualFile getRoot() {
        VirtualFile virtualFile = this.myRoot;
        if (virtualFile == null) {
            PuppetEntity.$$$reportNull$$$0(8);
        }
        return virtualFile;
    }

    @NotNull
    public T getMetadata() {
        T t = this.myMetadata;
        if (t == null) {
            PuppetEntity.$$$reportNull$$$0(9);
        }
        return t;
    }

    public GlobalSearchScope getResolveScope() {
        return PuppetScopeManager.getInstance(this.myProject).getResolveScope(this);
    }

    @NotNull
    protected abstract List<String> getMeaningfulSubDirectoryNames();

    @Nullable
    public VirtualFile getPuppetFile() {
        return this.isValid() ? this.getRoot().findChild("Puppetfile") : null;
    }

    @Nullable
    public PuppetDependencyManagerAdapter getDependencyManager() {
        for (PuppetDependencyManagerAdapter adapter : PuppetDependencyManagerAdapter.getExtensions()) {
            if (!adapter.isApplicable(this)) continue;
            return adapter;
        }
        return null;
    }

    @RequiresReadLock
    @Nullable
    GlobalSearchScope calcResolveScope() {
        VirtualFile stubsRoot;
        ThreadingAssertions.softAssertReadAccess();
        GlobalSearchScope baseScope = this.getResolveScopeWithoutDependencies();
        List<PuppetModule> dependencies = this.getDependencies();
        if (!dependencies.isEmpty()) {
            Object[] scopes = (GlobalSearchScope[])dependencies.stream().map(dependency -> dependency.getResolveScopeWithoutDependencies()).filter(scope -> scope != GlobalSearchScope.EMPTY_SCOPE).toArray(GlobalSearchScope[]::new);
            baseScope = GlobalSearchScope.union((GlobalSearchScope[])((GlobalSearchScope[])ArrayUtil.append((Object[])scopes, (Object)baseScope)));
        }
        return (stubsRoot = PuppetLibraryUtil.getStubsRoot()) == null ? baseScope : baseScope.uniteWith(GlobalSearchScopesCore.directoryScope((Project)this.myProject, (VirtualFile)stubsRoot, (boolean)true));
    }

    @RequiresReadLock
    @NotNull
    private GlobalSearchScope getResolveScopeWithoutDependencies() {
        ThreadingAssertions.softAssertReadAccess();
        if (!this.isValid()) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            if (globalSearchScope == null) {
                PuppetEntity.$$$reportNull$$$0(10);
            }
            return globalSearchScope;
        }
        ArrayList<VirtualFile> subDirs = new ArrayList<VirtualFile>();
        for (String dirName : this.getMeaningfulSubDirectoryNames()) {
            VirtualFile child = this.myRoot.findChild(dirName);
            if (child == null) continue;
            subDirs.add(child);
        }
        GlobalSearchScope globalSearchScope = subDirs.isEmpty() ? GlobalSearchScope.EMPTY_SCOPE : GlobalSearchScopesCore.directoriesScope((Project)this.myProject, (boolean)true, (VirtualFile[])subDirs.toArray(VirtualFile.EMPTY_ARRAY));
        if (globalSearchScope == null) {
            PuppetEntity.$$$reportNull$$$0(11);
        }
        return globalSearchScope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PuppetEntity entity = (PuppetEntity)o;
        if (!this.myProject.equals(entity.myProject)) {
            return false;
        }
        if (!this.myRoot.equals(entity.myRoot)) {
            return false;
        }
        return this.myMetadata.equals(entity.myMetadata);
    }

    public int hashCode() {
        int result = this.myProject.hashCode();
        result = 31 * result + this.myRoot.hashCode();
        result = 31 * result + this.myMetadata.hashCode();
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.myMetadata.getPresentableName() + "; " + this.myRoot + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadata";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/project/PuppetEntity";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/project/PuppetEntity";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetadata";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScopeWithoutDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isUnderDependenciesRoot";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isUnderRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

