/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.codeWithMe.ClientId;
import com.intellij.featureStatistics.FeatureDescriptor;
import com.intellij.featureStatistics.FeaturesRegistryListener;
import com.intellij.ide.TipsOfTheDayUsagesCollector;
import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.ide.util.TipUtils;
import com.intellij.ide.util.TipsUsageManager$State$;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.Storage;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.LongSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@com.intellij.openapi.components.State(name="ShownTips", storages={@Storage(value="other.xml")})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0001\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u001c\u001d\u001eB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0007J\u000e\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0007J\u0006\u0010\u001a\u001a\u00020\u001bR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ide/util/TipsUsageManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/ide/util/TipsUsageManager$State;", "<init>", "()V", "shownTips", "Lit/unimi/dsi/fastutil/objects/Object2LongOpenHashMap;", "", "proposedTips", "tipsOrderSeed", "", "getTipsOrderSeed", "()J", "setTipsOrderSeed", "(J)V", "getState", "loadState", "", "state", "fireTipShown", "tip", "Lcom/intellij/ide/util/TipAndTrickBean;", "fireTipProposed", "getLastTimeShown", "tipId", "getLastTimeProposed", "wereTipsShownToday", "", "Companion", "State", "TipsUsageListener", "intellij.platform.tips"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTipsUsageManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TipsUsageManager.kt\ncom/intellij/ide/util/TipsUsageManager\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n216#2,2:87\n216#2,2:89\n1#3:91\n*S KotlinDebug\n*F\n+ 1 TipsUsageManager.kt\ncom/intellij/ide/util/TipsUsageManager\n*L\n37#1:87,2\n41#1:89,2\n*E\n"})
public final class TipsUsageManager
implements PersistentStateComponent<State> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Object2LongOpenHashMap<String> shownTips = new Object2LongOpenHashMap();
    @NotNull
    private final Object2LongOpenHashMap<String> proposedTips = new Object2LongOpenHashMap();
    private long tipsOrderSeed = System.currentTimeMillis();

    public TipsUsageManager() {
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect();
        Topic topic = FeaturesRegistryListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new TipsUsageListener());
    }

    public final long getTipsOrderSeed() {
        return this.tipsOrderSeed;
    }

    public final void setTipsOrderSeed(long l) {
        this.tipsOrderSeed = l;
    }

    @NotNull
    public State getState() {
        return new State((Map)this.shownTips, (Map)this.proposedTips, this.tipsOrderSeed);
    }

    public void loadState(@NotNull State state) {
        long timestamp;
        Map.Entry<String, Long> entry;
        Map.Entry<String, Long> element$iv;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Map<String, Long> $this$forEach$iv = state.getShownTips();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Long>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            boolean bl = false;
            String filename = entry.getKey();
            timestamp = ((Number)entry.getValue()).longValue();
            this.shownTips.put((Object)TipAndTrickBean.getTipId((String)filename), timestamp);
        }
        $this$forEach$iv = state.getProposedTips();
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            boolean bl = false;
            String tipId = entry.getKey();
            timestamp = ((Number)entry.getValue()).longValue();
            this.proposedTips.put((Object)tipId, timestamp);
        }
        this.tipsOrderSeed = state.getTipsOrderSeed();
    }

    public final void fireTipShown(@NotNull TipAndTrickBean tip) {
        Intrinsics.checkNotNullParameter((Object)tip, (String)"tip");
        this.shownTips.put((Object)tip.getId(), System.currentTimeMillis());
    }

    public final void fireTipProposed(@NotNull TipAndTrickBean tip) {
        Intrinsics.checkNotNullParameter((Object)tip, (String)"tip");
        this.proposedTips.put((Object)tip.getId(), System.currentTimeMillis());
    }

    public final long getLastTimeShown(@NotNull String tipId) {
        Intrinsics.checkNotNullParameter((Object)tipId, (String)"tipId");
        return this.shownTips.getLong((Object)tipId);
    }

    public final long getLastTimeProposed(@NotNull String tipId) {
        Intrinsics.checkNotNullParameter((Object)tipId, (String)"tipId");
        return this.proposedTips.getLong((Object)tipId);
    }

    public final boolean wereTipsShownToday() {
        Comparable comparable;
        Iterator iterator = ((Iterable)((Map)this.shownTips).entrySet()).iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            Map.Entry it = (Map.Entry)iterator.next();
            boolean bl = false;
            Comparable comparable2 = (Long)it.getValue();
            while (iterator.hasNext()) {
                Map.Entry it2 = (Map.Entry)iterator.next();
                $i$a$-maxOfOrNull-TipsUsageManager$wereTipsShownToday$lastShownTimeMillis$1 = false;
                Comparable comparable3 = (Long)it2.getValue();
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Long l = (Long)comparable;
        long lastShownTimeMillis = l != null ? l : 0L;
        ZoneId currentZoneId = ZoneId.systemDefault();
        LocalDateTime curDayStartTime = LocalDate.now(currentZoneId).atStartOfDay();
        LocalDateTime lastShownTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(lastShownTimeMillis), currentZoneId);
        return lastShownTime.isAfter(curDayStartTime);
    }

    @JvmStatic
    @NotNull
    public static final TipsUsageManager getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ide/util/TipsUsageManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ide/util/TipsUsageManager;", "intellij.platform.tips"})
    @SourceDebugExtension(value={"SMAP\nTipsUsageManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TipsUsageManager.kt\ncom/intellij/ide/util/TipsUsageManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,86:1\n40#2,3:87\n*S KotlinDebug\n*F\n+ 1 TipsUsageManager.kt\ncom/intellij/ide/util/TipsUsageManager$Companion\n*L\n23#1:87,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TipsUsageManager getInstance() {
            boolean $i$f$service = false;
            Class<TipsUsageManager> serviceClass$iv = TipsUsageManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (TipsUsageManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Serializable
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 &2\u00020\u0001:\u0002%&B=\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tBO\b\u0010\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\b\u0010\u000eJ\u0015\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u0015\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J?\u0010\u0017\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u000bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0004H\u00d6\u0001J%\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0001\u00a2\u0006\u0002\b$R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006'"}, d2={"Lcom/intellij/ide/util/TipsUsageManager$State;", "", "shownTips", "", "", "", "proposedTips", "tipsOrderSeed", "<init>", "(Ljava/util/Map;Ljava/util/Map;J)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/util/Map;Ljava/util/Map;JLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getShownTips", "()Ljava/util/Map;", "getProposedTips", "getTipsOrderSeed", "()J", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_platform_tips", "$serializer", "Companion", "intellij.platform.tips"})
    public static final class State {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Map<String, Long> shownTips;
        @NotNull
        private final Map<String, Long> proposedTips;
        private final long tipsOrderSeed;
        @JvmField
        @NotNull
        private static final KSerializer<Object>[] $childSerializers;

        public State(@NotNull Map<String, Long> shownTips, @NotNull Map<String, Long> proposedTips, long tipsOrderSeed) {
            Intrinsics.checkNotNullParameter(shownTips, (String)"shownTips");
            Intrinsics.checkNotNullParameter(proposedTips, (String)"proposedTips");
            this.shownTips = shownTips;
            this.proposedTips = proposedTips;
            this.tipsOrderSeed = tipsOrderSeed;
        }

        public /* synthetic */ State(Map map, Map map2, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            if ((n & 2) != 0) {
                map2 = MapsKt.emptyMap();
            }
            if ((n & 4) != 0) {
                l = System.currentTimeMillis();
            }
            this(map, map2, l);
        }

        @NotNull
        public final Map<String, Long> getShownTips() {
            return this.shownTips;
        }

        @NotNull
        public final Map<String, Long> getProposedTips() {
            return this.proposedTips;
        }

        public final long getTipsOrderSeed() {
            return this.tipsOrderSeed;
        }

        @NotNull
        public final Map<String, Long> component1() {
            return this.shownTips;
        }

        @NotNull
        public final Map<String, Long> component2() {
            return this.proposedTips;
        }

        public final long component3() {
            return this.tipsOrderSeed;
        }

        @NotNull
        public final State copy(@NotNull Map<String, Long> shownTips, @NotNull Map<String, Long> proposedTips, long tipsOrderSeed) {
            Intrinsics.checkNotNullParameter(shownTips, (String)"shownTips");
            Intrinsics.checkNotNullParameter(proposedTips, (String)"proposedTips");
            return new State(shownTips, proposedTips, tipsOrderSeed);
        }

        public static /* synthetic */ State copy$default(State state, Map map, Map map2, long l, int n, Object object) {
            if ((n & 1) != 0) {
                map = state.shownTips;
            }
            if ((n & 2) != 0) {
                map2 = state.proposedTips;
            }
            if ((n & 4) != 0) {
                l = state.tipsOrderSeed;
            }
            return state.copy(map, map2, l);
        }

        @NotNull
        public String toString() {
            return "State(shownTips=" + this.shownTips + ", proposedTips=" + this.proposedTips + ", tipsOrderSeed=" + this.tipsOrderSeed + ")";
        }

        public int hashCode() {
            int result = ((Object)this.shownTips).hashCode();
            result = result * 31 + ((Object)this.proposedTips).hashCode();
            result = result * 31 + Long.hashCode(this.tipsOrderSeed);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            if (!Intrinsics.areEqual(this.shownTips, state.shownTips)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.proposedTips, state.proposedTips)) {
                return false;
            }
            return this.tipsOrderSeed == state.tipsOrderSeed;
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_platform_tips(State self, CompositeEncoder output, SerialDescriptor serialDesc) {
            KSerializer<Object>[] kSerializerArray = $childSerializers;
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : !Intrinsics.areEqual(self.shownTips, (Object)MapsKt.emptyMap())) {
                output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)kSerializerArray[0], self.shownTips);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : !Intrinsics.areEqual(self.proposedTips, (Object)MapsKt.emptyMap())) {
                output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)kSerializerArray[1], self.proposedTips);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : self.tipsOrderSeed != System.currentTimeMillis()) {
                output.encodeLongElement(serialDesc, 2, self.tipsOrderSeed);
            }
        }

        public /* synthetic */ State(int seen0, Map shownTips, Map proposedTips, long tipsOrderSeed, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen0) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)State$$serializer.INSTANCE.getDescriptor());
            }
            this.shownTips = (seen0 & 1) == 0 ? MapsKt.emptyMap() : shownTips;
            this.proposedTips = (seen0 & 2) == 0 ? MapsKt.emptyMap() : proposedTips;
            this.tipsOrderSeed = (seen0 & 4) == 0 ? System.currentTimeMillis() : tipsOrderSeed;
        }

        public State() {
            this(null, null, 0L, 7, null);
        }

        public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            KSerializer[] kSerializerArray = new KSerializer[]{new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)LongSerializer.INSTANCE), new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)LongSerializer.INSTANCE), null};
            $childSerializers = kSerializerArray;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ide/util/TipsUsageManager$State$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/ide/util/TipsUsageManager$State;", "intellij.platform.tips"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<State> serializer() {
                return (KSerializer)State$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/util/TipsUsageManager$TipsUsageListener;", "Lcom/intellij/featureStatistics/FeaturesRegistryListener;", "<init>", "()V", "featureUsed", "", "feature", "Lcom/intellij/featureStatistics/FeatureDescriptor;", "intellij.platform.tips"})
    private static final class TipsUsageListener
    implements FeaturesRegistryListener {
        public void featureUsed(@NotNull FeatureDescriptor feature) {
            Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
            TipAndTrickBean tipAndTrickBean = TipUtils.INSTANCE.getTip(feature);
            if (tipAndTrickBean == null) {
                return;
            }
            TipAndTrickBean tip = tipAndTrickBean;
            TipsUsageManager tipsUsageManager = Companion.getInstance();
            String string = tip.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            long timestamp = tipsUsageManager.getLastTimeShown(string);
            if (timestamp != 0L) {
                TipsOfTheDayUsagesCollector.triggerTipUsed(tip.getId(), System.currentTimeMillis() - timestamp);
            }
        }
    }
}

