/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.ssh;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remote.RemoteCredentials;
import com.jetbrains.gateway.internal.GatewayCoreRegistry;
import com.jetbrains.gateway.ssh.HostTunnelConnector;
import com.jetbrains.gateway.ssh.RemoteCredentialsExKt;
import com.jetbrains.gateway.ssh.SshPortForwarder;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.net.InetAddress;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J.\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/gateway/ssh/SshHostTunnelConnector;", "Lcom/jetbrains/gateway/ssh/HostTunnelConnector;", "remoteCredentials", "Lcom/intellij/remote/RemoteCredentials;", "<init>", "(Lcom/intellij/remote/RemoteCredentials;)V", "host", "", "getHost", "()Ljava/lang/String;", "type", "getType", "connect", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "localAddress", "Ljava/net/InetAddress;", "remoteLocalAddress", "port", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/net/InetAddress;Ljava/lang/String;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.gateway.core"})
@SourceDebugExtension(value={"SMAP\nSshHostTunnelConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshHostTunnelConnector.kt\ncom/jetbrains/gateway/ssh/SshHostTunnelConnector\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,34:1\n14#2:35\n*S KotlinDebug\n*F\n+ 1 SshHostTunnelConnector.kt\ncom/jetbrains/gateway/ssh/SshHostTunnelConnector\n*L\n32#1:35\n*E\n"})
public final class SshHostTunnelConnector
implements HostTunnelConnector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RemoteCredentials remoteCredentials;
    @NotNull
    private static final Logger logger;

    public SshHostTunnelConnector(@NotNull RemoteCredentials remoteCredentials) {
        Intrinsics.checkNotNullParameter((Object)remoteCredentials, (String)"remoteCredentials");
        this.remoteCredentials = remoteCredentials;
    }

    @Override
    @NotNull
    public String getHost() {
        String string = this.remoteCredentials.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
        return string;
    }

    @Override
    @Nullable
    public String getType() {
        return "ssh";
    }

    @Override
    @Nullable
    public Object connect(@NotNull Lifetime lifetime, @NotNull InetAddress localAddress, @NotNull String remoteLocalAddress, int port, @NotNull Continuation<? super Integer> $completion) {
        boolean isReconnectionEnabled = GatewayCoreRegistry.INSTANCE.isSshReconnectionEnabled();
        logger.info("isReconnectionEnabled=" + isReconnectionEnabled);
        if (isReconnectionEnabled) {
            logger.info("Using reconnecting port forwarder");
            SshPortForwarder forwarder = new SshPortForwarder(lifetime, this.remoteCredentials, port, remoteLocalAddress);
            return forwarder.beginForwarding(localAddress, $completion);
        }
        logger.info("Using non-reconnecting port forwarder");
        return Boxing.boxInt((int)RemoteCredentialsExKt.forwardPort(this.remoteCredentials, lifetime, localAddress, port, port, remoteLocalAddress));
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SshHostTunnelConnector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        SshHostTunnelConnector.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/gateway/ssh/SshHostTunnelConnector$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.gateway.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

