/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.welcomeScreen;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenUIManager;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ApplicationKt;
import com.intellij.util.PlatformUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.gateway.GatewayBundle;
import com.jetbrains.gateway.api.GatewayConnector;
import com.jetbrains.gateway.api.GatewayConnectorAction;
import com.jetbrains.gateway.api.GatewayConnectorView;
import com.jetbrains.gateway.api.GatewayCustomViewConnector;
import com.jetbrains.gateway.api.GatewayCustomViewConnectorContextKind;
import com.jetbrains.gateway.api.GatewayUI;
import com.jetbrains.gateway.impl.GatewayUIService;
import com.jetbrains.gateway.welcomeScreen.GatewayPanelComponentsKt;
import com.jetbrains.gateway.welcomeScreen.GatewayWelcomeScreenSelectTabTopicKt;
import com.jetbrains.gateway.welcomeScreen.GatewayWelcomeScreenTiles;
import com.jetbrains.gateway.welcomeScreen.WelcomeScreenTabSelectionListener;
import com.jetbrains.gateway.welcomeScreen.promotion.GatewayPluginPromotionPanel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0012\u001a\u00020\u000fH\u0002J\u0006\u0010\u0013\u001a\u00020\u0007J\u000e\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u000fH\u0002R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/gateway/welcomeScreen/GatewayWelcomeScreenPanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "parentLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "tabsVisibilityCallback", "Lkotlin/Function1;", "", "", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lkotlin/jvm/functions/Function1;)V", "getTabsVisibilityCallback", "()Lkotlin/jvm/functions/Function1;", "lifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "mainPanel", "Ljavax/swing/JComponent;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "createMainPanel", "reset", "createConnectorView", "connector", "Lcom/jetbrains/gateway/api/GatewayConnector;", "setContent", "content", "intellij.gateway.core"})
@SourceDebugExtension(value={"SMAP\nGatewayWelcomeScreenPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GatewayWelcomeScreenPanel.kt\ncom/jetbrains/gateway/welcomeScreen/GatewayWelcomeScreenPanel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n24#2:128\n83#2,3:129\n83#2,3:137\n774#3:132\n865#3,2:133\n1863#3,2:135\n808#3,11:140\n*S KotlinDebug\n*F\n+ 1 GatewayWelcomeScreenPanel.kt\ncom/jetbrains/gateway/welcomeScreen/GatewayWelcomeScreenPanel\n*L\n28#1:128\n38#1:129,3\n86#1:137,3\n59#1:132\n59#1:133,2\n68#1:135,2\n83#1:140,11\n*E\n"})
public final class GatewayWelcomeScreenPanel
extends BorderLayoutPanel {
    @NotNull
    private final Function1<Boolean, Unit> tabsVisibilityCallback;
    @NotNull
    private final SequentialLifetimes lifetimes;
    @NotNull
    private JComponent mainPanel;
    @NotNull
    private final Logger logger;

    public GatewayWelcomeScreenPanel(@NotNull Lifetime parentLifetime, @NotNull Function1<? super Boolean, Unit> tabsVisibilityCallback) {
        Intrinsics.checkNotNullParameter((Object)parentLifetime, (String)"parentLifetime");
        Intrinsics.checkNotNullParameter(tabsVisibilityCallback, (String)"tabsVisibilityCallback");
        this.tabsVisibilityCallback = tabsVisibilityCallback;
        this.lifetimes = new SequentialLifetimes(parentLifetime);
        GatewayWelcomeScreenPanel $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(GatewayWelcomeScreenPanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        GatewayUIService.Companion.getServiceInstance().setupGatewayPanel(parentLifetime, this);
        this.setBackground(WelcomeScreenUIManager.getMainAssociatedComponentBackground());
        this.mainPanel = this.createMainPanel();
        this.setContent(this.mainPanel);
        for (GatewayConnector connector : GatewayConnector.Companion.getConnectors()) {
            Object object;
            Logger $this$runAndLogException$iv = this.logger;
            boolean $i$f$runAndLogException = false;
            Logger logger2 = $this$runAndLogException$iv;
            try {
                Logger $this$runAndLogException_u24lambda_u240$iv = logger2;
                boolean bl = false;
                boolean bl2 = false;
                connector.initProcedure();
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
        }
        GatewayConnector.Companion.getEP().addChangeListener(() -> GatewayWelcomeScreenPanel._init_$lambda$1(this), LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)parentLifetime, null, (int)1, null));
        String lastVisited = GatewayUI.Companion.getInstance().getLastConnectorId();
        if (lastVisited != null) {
            ((WelcomeScreenTabSelectionListener)ApplicationKt.getApplication().getMessageBus().syncPublisher(GatewayWelcomeScreenSelectTabTopicKt.getWELCOME_SCREEN_SELECT_TAB_TOPIC())).selectRecentConnectionsTab(lastVisited);
            GatewayUI.Companion.getInstance().reset();
        }
    }

    @NotNull
    public final Function1<Boolean, Unit> getTabsVisibilityCallback() {
        return this.tabsVisibilityCallback;
    }

    /*
     * WARNING - void declaration
     */
    private final JComponent createMainPanel() {
        JBScrollPane jBScrollPane;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = GatewayConnector.Companion.getConnectors();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GatewayConnector it = (GatewayConnector)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof GatewayCustomViewConnector))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List connectors = (List)destination$iv$iv;
        DialogPanel it = BuilderKt.panel(arg_0 -> GatewayWelcomeScreenPanel.createMainPanel$lambda$11(connectors, this, arg_0));
        boolean bl = false;
        it.setBackground(WelcomeScreenUIManager.getMainAssociatedComponentBackground());
        it.setBorder(BorderFactory.createEmptyBorder(20, 24, 5, 0));
        JBScrollPane $this$createMainPanel_u24lambda_u2413_u24lambda_u2412 = jBScrollPane = new JBScrollPane((Component)it);
        boolean bl2 = false;
        $this$createMainPanel_u24lambda_u2413_u24lambda_u2412.setOpaque(false);
        return (JComponent)jBScrollPane;
    }

    public final void reset() {
        ThreadingAssertions.assertEventDispatchThread();
        this.lifetimes.terminateCurrent();
        this.setContent(this.mainPanel);
        this.tabsVisibilityCallback.invoke((Object)true);
    }

    public final void createConnectorView(@NotNull GatewayConnector connector) {
        Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
        Lifetime lifetime = this.lifetimes.next().getLifetime();
        GatewayConnectorView view = connector.createView(lifetime);
        if (view instanceof GatewayConnectorAction) {
            ((GatewayConnectorAction)view).invoke();
        } else {
            this.setContent(view.getComponent());
            this.tabsVisibilityCallback.invoke((Object)false);
        }
    }

    private final void setContent(JComponent content) {
        ThreadingAssertions.assertEventDispatchThread();
        this.removeAll();
        this.addToCenter(content);
        this.revalidate();
        this.repaint();
    }

    private static final void _init_$lambda$1(GatewayWelcomeScreenPanel this$0) {
        this$0.mainPanel = this$0.createMainPanel();
        this$0.setContent(this$0.mainPanel);
    }

    private static final Unit createMainPanel$lambda$11$lambda$4$lambda$3(JLabel $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setFont((Font)JBFont.h3().asBold());
        return Unit.INSTANCE;
    }

    private static final Unit createMainPanel$lambda$11$lambda$4(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(GatewayBundle.INSTANCE.message("welcome.tab.run.ide.remotely", new Object[0])).applyToComponent(GatewayWelcomeScreenPanel::createMainPanel$lambda$11$lambda$4$lambda$3);
        return Unit.INSTANCE;
    }

    private static final Unit createMainPanel$lambda$11$lambda$7$lambda$6$lambda$5(GatewayWelcomeScreenPanel this$0, GatewayConnector $it) {
        this$0.createConnectorView($it);
        return Unit.INSTANCE;
    }

    private static final Unit createMainPanel$lambda$11$lambda$7(List $connectors, GatewayWelcomeScreenPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        GatewayWelcomeScreenTiles tap = new GatewayWelcomeScreenTiles();
        Iterable $this$forEach$iv = $connectors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GatewayConnector it = (GatewayConnector)element$iv;
            boolean bl = false;
            DialogPanel connector = GatewayPanelComponentsKt.installedConnector(it, (Function0<Unit>)((Function0)() -> GatewayWelcomeScreenPanel.createMainPanel$lambda$11$lambda$7$lambda$6$lambda$5(this$0, it)));
            if (connector == null) continue;
            tap.add((JBPanel)connector);
        }
        $this$row.cell((JComponent)tap).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createMainPanel$lambda$11$lambda$8(GatewayWelcomeScreenPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)((Object)new GatewayPluginPromotionPanel((Lifetime)this$0.lifetimes.next()))).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createMainPanel$lambda$11$lambda$10(GatewayWelcomeScreenPanel this$0, GatewayCustomViewConnector $conn, Row $this$row) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Logger $this$runAndLogException$iv = this$0.logger;
        boolean $i$f$runAndLogException = false;
        Logger logger = $this$runAndLogException$iv;
        try {
            Logger $this$runAndLogException_u24lambda_u240$iv = logger;
            boolean bl = false;
            boolean bl2 = false;
            object = Result.constructor-impl((Object)$this$row.cell($conn.getCustomView(GatewayCustomViewConnectorContextKind.WELCOME_SCREEN)));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createMainPanel$lambda$11(List $connectors, GatewayWelcomeScreenPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, GatewayWelcomeScreenPanel::createMainPanel$lambda$11$lambda$4, (int)1, null).bottomGap(BottomGap.SMALL);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> GatewayWelcomeScreenPanel.createMainPanel$lambda$11$lambda$7($connectors, this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> GatewayWelcomeScreenPanel.createMainPanel$lambda$11$lambda$8(this$0, arg_0), (int)1, null);
        if (!PlatformUtils.isGateway()) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = GatewayConnector.Companion.getConnectors();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof GatewayCustomViewConnector)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List customConnectors = (List)destination$iv$iv;
            for (GatewayCustomViewConnector conn : customConnectors) {
                Panel.row$default((Panel)$this$panel, null, arg_0 -> GatewayWelcomeScreenPanel.createMainPanel$lambda$11$lambda$10(this$0, conn, arg_0), (int)1, null);
            }
        }
        return Unit.INSTANCE;
    }
}

