/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.runtime.repository.impl;

import com.intellij.platform.runtime.repository.MalformedRepositoryException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

final class ResourcePathMacros {
    private static final String DEFAULT_MAVEN_REPOSITORY_PATH = ".m2/repository";
    private static final String PROJECT_DIR_MACRO = "$PROJECT_DIR$";
    private static final String MAVEN_REPO_MACRO = "$MAVEN_REPOSITORY$";
    private static Path ourProjectDirPath;
    private static Path ourMavenRepositoryPath;

    ResourcePathMacros() {
    }

    private static Path getProjectDirPath(@NotNull Path baseDir) {
        if (baseDir == null) {
            ResourcePathMacros.$$$reportNull$$$0(0);
        }
        if (ourProjectDirPath == null) {
            ourProjectDirPath = ResourcePathMacros.locateProjectHome(baseDir);
        }
        return ourProjectDirPath;
    }

    @NotNull
    private static Path locateProjectHome(@NotNull Path baseDir) {
        Path currentPath;
        String explicitHomePath;
        if (baseDir == null) {
            ResourcePathMacros.$$$reportNull$$$0(1);
        }
        if ((explicitHomePath = System.getProperty("idea.home.path")) != null) {
            Path path = Path.of(explicitHomePath, new String[0]);
            if (path == null) {
                ResourcePathMacros.$$$reportNull$$$0(2);
            }
            return path;
        }
        for (currentPath = baseDir; currentPath != null && !ResourcePathMacros.isProjectHome(currentPath); currentPath = currentPath.getParent()) {
        }
        if (currentPath == null) {
            throw new MalformedRepositoryException("Cannot find project home to resolve $PROJECT_DIR$ macro, starting from " + baseDir);
        }
        Path path = currentPath.toAbsolutePath();
        if (path == null) {
            ResourcePathMacros.$$$reportNull$$$0(3);
        }
        return path;
    }

    private static boolean isProjectHome(@NotNull Path path) {
        if (path == null) {
            ResourcePathMacros.$$$reportNull$$$0(4);
        }
        return Files.isDirectory(path.resolve(".idea"), new LinkOption[0]) && (Files.exists(path.resolve("intellij.idea.ultimate.main.iml"), new LinkOption[0]) || Files.exists(path.resolve("intellij.idea.community.main.iml"), new LinkOption[0]) || Files.exists(path.resolve(".ultimate.root.marker"), new LinkOption[0]));
    }

    private static Path getMavenRepositoryPath() {
        if (ourMavenRepositoryPath == null) {
            String userHome = System.getProperty("user.home", null);
            Path path = userHome != null ? Path.of(userHome, DEFAULT_MAVEN_REPOSITORY_PATH) : Path.of(DEFAULT_MAVEN_REPOSITORY_PATH, new String[0]);
            ourMavenRepositoryPath = path.toAbsolutePath();
        }
        return ourMavenRepositoryPath;
    }

    @NotNull
    static Path resolve(@NotNull String path, @NotNull Path baseDir) {
        int startIndex;
        Path root;
        if (path == null) {
            ResourcePathMacros.$$$reportNull$$$0(5);
        }
        if (baseDir == null) {
            ResourcePathMacros.$$$reportNull$$$0(6);
        }
        if (path.startsWith(PROJECT_DIR_MACRO)) {
            root = ResourcePathMacros.getProjectDirPath(baseDir);
            startIndex = PROJECT_DIR_MACRO.length();
        } else if (path.startsWith(MAVEN_REPO_MACRO)) {
            root = ResourcePathMacros.getMavenRepositoryPath();
            startIndex = MAVEN_REPO_MACRO.length();
        } else {
            throw new MalformedRepositoryException("Unknown macro in " + path);
        }
        if (path.length() <= startIndex + 1 || path.charAt(startIndex) != '/') {
            throw new MalformedRepositoryException("Incorrect macro usage in " + path);
        }
        if (path.contains("/../") || path.endsWith("/..")) {
            throw new MalformedRepositoryException("Path '" + path + "' points to a file outside macro directory");
        }
        Path path2 = root.resolve(path.substring(startIndex + 1));
        if (path2 == null) {
            ResourcePathMacros.$$$reportNull$$$0(7);
        }
        return path2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/runtime/repository/impl/ResourcePathMacros";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/runtime/repository/impl/ResourcePathMacros";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "locateProjectHome";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProjectDirPath";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "locateProjectHome";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isProjectHome";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

