/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeImpl;
import com.intellij.openapi.vcs.changes.VcsIgnoreManager;
import com.intellij.openapi.vcs.impl.VcsRootIterator;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.idea.perforce.application.FileGrouper;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.P4HaveParser;
import org.jetbrains.idea.perforce.perforce.PathsHelper;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public abstract class UnversionedScopeScanner {
    private static final Logger LOG = Logger.getInstance(UnversionedScopeScanner.class);
    private final Project myProject;
    private final PerforceRunner myRunner;

    public UnversionedScopeScanner(Project project) {
        this.myProject = project;
        this.myRunner = PerforceRunner.getInstance(this.myProject);
    }

    protected abstract void checkCanceled();

    public ScanResult doRescan(Collection<FilePath> dirtyFiles, boolean force) throws VcsException {
        final ScanResult result = new ScanResult();
        if (dirtyFiles.isEmpty()) {
            return result;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("scope=" + dirtyFiles);
        }
        MultiMap<P4Connection, FilePath> map = FileGrouper.distributePathsByConnection(dirtyFiles, this.myProject);
        for (P4Connection connection : map.keySet()) {
            Collection files = map.get((Object)connection);
            final Set<VirtualFile> localFiles = this.enumerateLocalFiles(files);
            result.allLocalFiles.addAll(localFiles);
            this.checkCanceled();
            final LocalFileSystem fs = LocalFileSystem.getInstance();
            this.myRunner.haveMultiple(this.collectPaths(files), connection, new P4HaveParser(PerforceManager.getInstance(this.myProject)){

                @Override
                public void consumeRevision(String path, long revision) {
                    UnversionedScopeScanner.this.checkCanceled();
                    VirtualFile vFile = this.findVirtualFile(path);
                    if (vFile != null) {
                        localFiles.remove(vFile);
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("locally missing file reported: " + path);
                        }
                        result.missingFiles.add(path);
                    }
                }

                private VirtualFile findVirtualFile(String path) {
                    VirtualFile vFile = fs.findFileByPathIfCached(FileUtil.toSystemIndependentName((String)path));
                    if (vFile != null) {
                        return vFile;
                    }
                    File ioFile = new File(path);
                    String appleForkPath = FileUtil.toSystemIndependentName((String)ioFile.getParent()) + "/%" + ioFile.getName();
                    return fs.findFileByPathIfCached(FileUtil.toSystemIndependentName((String)appleForkPath));
                }
            });
            this.checkCanceled();
            if (force) {
                result.localOnly.addAll(localFiles);
                continue;
            }
            ChangeListManager clm = ChangeListManager.getInstance((Project)this.myProject);
            for (VirtualFile file : localFiles) {
                boolean ignored = clm.isIgnoredFile(file);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("localOnly reported: " + file + (ignored ? ", ignored" : ""));
                }
                if (ignored) continue;
                result.localOnly.add(file);
            }
        }
        return result;
    }

    private PathsHelper collectPaths(Collection<FilePath> value) {
        PathsHelper helper = new PathsHelper(PerforceManager.getInstance(this.myProject));
        for (FilePath dir : value) {
            if (dir.isDirectory()) {
                helper.addRecursively(dir);
                continue;
            }
            helper.add(dir);
        }
        return helper;
    }

    static List<FilePath> createEverythingDirtyScope(Project project) throws VcsException {
        ArrayList<FilePath> scope = new ArrayList<FilePath>();
        for (Pair<P4Connection, Collection<VirtualFile>> pair : PerforceVcs.getInstance(project).getRootsByConnections()) {
            for (VirtualFile file : (Collection)pair.second) {
                scope.add(VcsUtil.getFilePath((VirtualFile)file));
            }
        }
        return scope;
    }

    private Set<VirtualFile> enumerateLocalFiles(Collection<FilePath> roots) {
        VcsDirtyScopeImpl scope = new VcsDirtyScopeImpl((AbstractVcs)PerforceVcs.getInstance(this.myProject));
        for (FilePath root : roots) {
            scope.addDirtyDirRecursively(root);
        }
        HashSet<VirtualFile> localFiles = new HashSet<VirtualFile>();
        VcsRootIterator.iterateExistingInsideScope((VcsDirtyScope)scope, file -> {
            if (!file.isDirectory() && !this.skipPotentiallyIgnored((VirtualFile)file)) {
                localFiles.add((VirtualFile)file);
            } else {
                this.checkCanceled();
            }
            return true;
        });
        return localFiles;
    }

    private boolean skipPotentiallyIgnored(VirtualFile file) {
        return Registry.is((String)"p4.ignore.all.potentially.ignored") && VcsIgnoreManager.getInstance((Project)this.myProject).isPotentiallyIgnoredFile(file);
    }

    static class ScanResult {
        final Set<String> missingFiles = new HashSet<String>();
        final List<VirtualFile> localOnly = new ArrayList<VirtualFile>();
        final Set<VirtualFile> allLocalFiles = new HashSet<VirtualFile>();

        ScanResult() {
        }
    }
}

