/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.jobs;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.checkin.CheckinChangeListSpecificComponent;
import com.intellij.openapi.vcs.ui.TextFieldAction;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.TableView;
import com.intellij.util.Consumer;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.application.PerforceCheckinEnvironment;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.jobs.AdderRemover;
import org.jetbrains.idea.perforce.perforce.jobs.ConnectionSelector;
import org.jetbrains.idea.perforce.perforce.jobs.DefaultGb;
import org.jetbrains.idea.perforce.perforce.jobs.EditChangelistJobsDialog;
import org.jetbrains.idea.perforce.perforce.jobs.ErrorReporter;
import org.jetbrains.idea.perforce.perforce.jobs.JobDetailsLoader;
import org.jetbrains.idea.perforce.perforce.jobs.JobViewSearchSpecificator;
import org.jetbrains.idea.perforce.perforce.jobs.JobsMasterDetails;
import org.jetbrains.idea.perforce.perforce.jobs.JobsSearchSpecificator;
import org.jetbrains.idea.perforce.perforce.jobs.JobsTablePresentation;
import org.jetbrains.idea.perforce.perforce.jobs.JobsWorker;
import org.jetbrains.idea.perforce.perforce.jobs.P4JobsLogicConn;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJob;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJobFieldValue;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJobSpecification;
import org.jetbrains.idea.perforce.perforce.jobs.SelfLoadingJobDetailsPanel;
import org.jetbrains.idea.perforce.perforce.jobs.StandardJobFields;
import org.jetbrains.idea.perforce.perforce.jobs.WiseAdderRemover;

public class PerforceCheckinComponent
implements CheckinChangeListSpecificComponent,
JobsTablePresentation {
    @NotNull
    private final Project myProject;
    @NotNull
    private final CommitContext myCommitContext;
    private JPanel myPanel;
    private LocalChangeList myCurrent;
    private final Map<LocalChangeList, Map<ConnectionKey, List<PerforceJob>>> myCache;
    private final PerforceVcs myVcs;
    private final Map<ConnectionKey, P4JobsLogicConn> myConnMap;
    private final AdderRemover myAdderRemover;
    private final JobsMasterDetails myDetails;
    private static final ColumnInfo<PerforceJob, String> JOB = new ColumnInfo<PerforceJob, String>(PerforceBundle.message("job", new Object[0])){

        public String valueOf(PerforceJob perforceJob) {
            return perforceJob.getName();
        }
    };
    private static final ColumnInfo<PerforceJob, String> STATUS = new ColumnInfo<PerforceJob, String>(PerforceBundle.message("job.status", new Object[0])){

        public String valueOf(PerforceJob perforceJob) {
            PerforceJobFieldValue field = perforceJob.getValueForStandardField(StandardJobFields.status);
            return field == null ? null : field.getValue();
        }
    };
    private static final ColumnInfo<PerforceJob, String> USER = new ColumnInfo<PerforceJob, String>(PerforceBundle.message("job.user", new Object[0])){

        public String valueOf(PerforceJob perforceJob) {
            PerforceJobFieldValue field = perforceJob.getValueForStandardField(StandardJobFields.user);
            return field == null ? null : field.getValue();
        }
    };
    private static final ColumnInfo<PerforceJob, String> DATE = new ColumnInfo<PerforceJob, String>(PerforceBundle.message("job.date", new Object[0])){

        public String valueOf(PerforceJob perforceJob) {
            PerforceJobFieldValue field = perforceJob.getValueForStandardField(StandardJobFields.date);
            return field == null ? null : field.getValue();
        }
    };
    private static final ColumnInfo<PerforceJob, String> DESCRIPTION = new ColumnInfo<PerforceJob, String>(PerforceBundle.message("job.description", new Object[0])){

        public String valueOf(PerforceJob perforceJob) {
            PerforceJobFieldValue field = perforceJob.getValueForStandardField(StandardJobFields.description);
            return field == null ? null : field.getValue();
        }
    };
    private static final ColumnInfo[] columns = new ColumnInfo[]{JOB, STATUS, USER, DATE, DESCRIPTION};

    public PerforceCheckinComponent(@NotNull Project project, @NotNull CommitContext commitContext) {
        if (project == null) {
            PerforceCheckinComponent.$$$reportNull$$$0(0);
        }
        if (commitContext == null) {
            PerforceCheckinComponent.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myCommitContext = commitContext;
        this.myVcs = PerforceVcs.getInstance(this.myProject);
        this.myConnMap = new HashMap<ConnectionKey, P4JobsLogicConn>();
        this.myCache = new HashMap<LocalChangeList, Map<ConnectionKey, List<PerforceJob>>>();
        this.myDetails = new JobsMasterDetails(this.myProject){

            @Override
            protected Dimension getPanelPreferredSize() {
                return JBUI.size((int)200, (int)70);
            }
        };
        this.myDetails.onlyMain();
        this.initUI();
        this.myAdderRemover = new WiseAdderRemover(this.myProject, this);
    }

    @Override
    public void refreshJobs(PerforceJob job) {
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (!this.myCurrent.hasDefaultName()) {
            Map<ConnectionKey, List<PerforceJob>> data = this.loadOnSelect(this.myCurrent);
            this.myCache.put(this.myCurrent, data);
            ApplicationManager.getApplication().invokeLater(() -> this.setItems(ContainerUtil.flatten(data.values())));
        }
    }

    @Override
    public void addJob(PerforceJob job) {
        Map<ConnectionKey, List<PerforceJob>> data = this.getCurrentListJobs();
        if (data != null) {
            List<PerforceJob> jobs = data.get(job.getConnectionKey());
            if (jobs == null) {
                jobs = new ArrayList<PerforceJob>();
                data.put(job.getConnectionKey(), jobs);
            }
            jobs.add(job);
            this.saveJobsInCache(data);
            this.setItems(ContainerUtil.flatten(data.values()));
        }
    }

    private Map<ConnectionKey, List<PerforceJob>> getCurrentListJobs() {
        Map<ConnectionKey, List<PerforceJob>> data = this.myCurrent.hasDefaultName() ? this.myVcs.getDefaultAssociated() : this.myCache.get(this.myCurrent);
        return data;
    }

    @Override
    public void removeSelectedJobs() {
        List<PerforceJob> jobs = this.myDetails.getSelectedJobs();
        if (jobs.isEmpty()) {
            return;
        }
        this.myDetails.removeSelectedJobs();
        Map<ConnectionKey, List<PerforceJob>> data = this.getCurrentListJobs();
        if (data != null) {
            for (PerforceJob job : jobs) {
                data.get(job.getConnectionKey()).remove(job);
            }
            this.setItems(ContainerUtil.flatten(data.values()));
        }
    }

    private JComponent createToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(new AnAction(PerforceBundle.message("job.unlink.selected.title", new Object[0]), PerforceBundle.message("job.unlink.selected", new Object[0]), PlatformIcons.DELETE_ICON){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                for (PerforceJob job : PerforceCheckinComponent.this.myDetails.getSelectedJobs()) {
                    VcsException vcsException = PerforceCheckinComponent.this.myAdderRemover.remove(job, PerforceCheckinComponent.this.myCurrent, PerforceCheckinComponent.this.myProject);
                    if (vcsException == null) continue;
                    new ErrorReporter(PerforceBundle.message("job.removing.from.changelist", new Object[0])).report(PerforceCheckinComponent.this.myProject, vcsException);
                }
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    2.$$$reportNull$$$0(1);
                }
                return actionUpdateThread;
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(2);
                }
                e.getPresentation().setEnabled(!PerforceCheckinComponent.this.myDetails.getSelectedJobs().isEmpty());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/idea/perforce/perforce/jobs/PerforceCheckinComponent$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/idea/perforce/perforce/jobs/PerforceCheckinComponent$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        });
        group.add(new AnAction(PerforceBundle.message("job.edit.associated.title", new Object[0]), PerforceBundle.message("job.edit.associated", new Object[0]), AllIcons.Actions.EditSource){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Map<ConnectionKey, List<PerforceJob>> data;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((data = PerforceCheckinComponent.this.getCurrentListJobs()) == null) {
                    return;
                }
                PerforceCheckinComponent.this.ensureDefaultConnections();
                EditChangelistJobsDialog dialog2 = new EditChangelistJobsDialog(PerforceCheckinComponent.this.myProject, PerforceCheckinComponent.this.myCurrent, PerforceCheckinComponent.this.myCurrent.hasDefaultName(), PerforceCheckinComponent.this.myConnMap, data);
                dialog2.show();
                Map<ConnectionKey, List<PerforceJob>> jobs = dialog2.getJobs();
                PerforceCheckinComponent.this.saveJobsInCache(jobs);
                PerforceCheckinComponent.this.setItems(ContainerUtil.flatten(jobs.values()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/perforce/perforce/jobs/PerforceCheckinComponent$3", "actionPerformed"));
            }
        });
        group.add((AnAction)new MyTextFieldAction(PerforceBundle.message("job.search.in.view.title", new Object[0]), PerforceBundle.message("job.search.in.view", new Object[0]), IconUtil.getAddIcon()));
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("PerforceCheckIn", (ActionGroup)group, true);
        return actionToolbar.getComponent();
    }

    @Nullable(value="if canceled")
    public static @Nullable(value="if canceled") List<PerforceJob> getJobsUnderProgress(JobsWorker worker, JobsSearchSpecificator searchSpecificator, P4Connection connection, ConnectionKey key, PerforceJobSpecification spec) {
        try {
            return (List)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> worker.getJobs(spec, searchSpecificator, connection, key), PerforceBundle.message("job.searching.jobs", new Object[0]), true, worker.getProject());
        }
        catch (VcsException e1) {
            new ErrorReporter(PerforceBundle.message("job.searching.jobs.to.add", new Object[0])).report(worker.getProject(), e1);
            return null;
        }
    }

    private void initUI() {
        this.myPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gb = DefaultGb.create();
        gb.insets = new Insets(0, 0, 0, 0);
        gb.anchor = 17;
        JLabel jobsPrompt = new JLabel(PerforceBundle.message("job.jobs", new Object[0]));
        gb.gridwidth = 3;
        this.myPanel.add((Component)jobsPrompt, gb);
        ++gb.gridy;
        gb.fill = 2;
        this.myPanel.add((Component)this.createToolbar(), gb);
        ++gb.gridy;
        gb.fill = 1;
        JComponent comp = this.myDetails.createComponent();
        this.myPanel.add((Component)comp, gb);
    }

    private void saveJobsInCache(Map<ConnectionKey, List<PerforceJob>> jobs) {
        if (this.myCurrent.hasDefaultName()) {
            this.myVcs.setDefaultAssociated(jobs);
        } else {
            this.myCache.put(this.myCurrent, jobs);
        }
    }

    private JPanel createSouthPanel(final TableView<PerforceJob> table, @Nls String warningText) {
        final JPanel southPanel = new JPanel(new BorderLayout());
        final JPanel stuffPanel = new JPanel(new BorderLayout());
        if (warningText != null) {
            stuffPanel.setPreferredSize((Dimension)JBUI.size((int)300, (int)120));
            southPanel.add((Component)stuffPanel, "North");
            JLabel warningLabel = new JLabel(warningText);
            warningLabel.setFont(warningLabel.getFont().deriveFont(1));
            southPanel.add((Component)warningLabel, "South");
        } else {
            southPanel.add(stuffPanel);
        }
        southPanel.setPreferredSize((Dimension)JBUI.size((int)300, (int)140));
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PerforceJob job = (PerforceJob)table.getSelectedObject();
                if (job == null) {
                    stuffPanel.removeAll();
                } else {
                    SelfLoadingJobDetailsPanel panel = new SelfLoadingJobDetailsPanel(PerforceCheckinComponent.this.myProject, job);
                    stuffPanel.removeAll();
                    JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)panel.getPanel());
                    stuffPanel.add(scrollPane);
                }
                southPanel.revalidate();
                southPanel.repaint();
            }
        });
        return southPanel;
    }

    private void showListPopup(List<PerforceJob> jobs, Component component, Consumer<PerforceJob> consumer, int maxCount) {
        List jobsNarrowed = ContainerUtil.getFirstItems(jobs, (int)maxCount);
        TableView table = new TableView(new ListTableModel(columns, jobsNarrowed, 0));
        table.setShowHorizontalLines(false);
        table.setTableHeader(null);
        Runnable runnable = () -> {
            PerforceJob job = (PerforceJob)table.getSelectedObject();
            if (job != null) {
                consumer.consume((Object)job);
            }
        };
        if (table.getModel().getRowCount() == 0) {
            table.clearSelection();
        }
        table.setMinimumSize((Dimension)JBUI.size((int)300, (int)50));
        PopupChooserBuilder builder = new PopupChooserBuilder((JTable)table);
        builder.setSouthComponent((JComponent)this.createSouthPanel((TableView<PerforceJob>)table, jobs.size() > maxCount ? PerforceBundle.message("perforce.jobs.search.limit.exceeded.warning", maxCount) : null));
        builder.setTitle(PerforceBundle.message("perforce.jobs.select.one", new Object[0])).setItemChosenCallback(runnable).setResizable(true).setDimensionServiceKey("org.jetbrains.idea.perforce.perforce.jobs.PerforceCheckinComponent.SelectOneJob").setMinSize((Dimension)JBUI.size((int)300, (int)300));
        JBPopup popup2 = builder.createPopup();
        popup2.showUnderneathOf(component);
    }

    private void ensureDefaultConnections() {
        if (this.myCurrent.hasDefaultName()) {
            JobDetailsLoader loader = new JobDetailsLoader(this.myProject);
            loader.fillConnections(this.myCurrent, this.myConnMap);
        }
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void saveState() {
        if (this.myCurrent != null && this.myCurrent.hasDefaultName()) {
            this.keepDefaultListJobs();
        }
        this.saveJobsToContext(this.getCurrentListJobs());
    }

    public void restoreState() {
    }

    public void onChangeListSelected(@NotNull LocalChangeList list) {
        Map<ConnectionKey, List<PerforceJob>> data;
        if (list == null) {
            PerforceCheckinComponent.$$$reportNull$$$0(2);
        }
        if (Comparing.equal((Object)list, (Object)this.myCurrent)) {
            return;
        }
        if (!list.hasDefaultName() && this.myCurrent != null && this.myCurrent.hasDefaultName()) {
            this.keepDefaultListJobs();
        }
        this.myCurrent = list;
        if (this.myCurrent.hasDefaultName()) {
            this.correctDefaultAssociated(list);
            data = this.myVcs.getDefaultAssociated();
            ArrayList<PerforceJob> filtered = new ArrayList<PerforceJob>();
            for (Map.Entry<ConnectionKey, List<PerforceJob>> entry : data.entrySet()) {
                filtered.addAll((Collection<PerforceJob>)entry.getValue());
            }
            this.setItems(filtered);
        } else {
            data = this.myCache.get(this.myCurrent);
            if (data == null) {
                data = this.loadOnSelect(this.myCurrent);
                this.myCache.put(list, data);
            }
            this.setItems(ContainerUtil.flatten(data.values()));
        }
        this.saveJobsToContext(data);
    }

    private void saveJobsToContext(@Nullable Map<ConnectionKey, List<PerforceJob>> data) {
        this.myCommitContext.putUserData(PerforceCheckinEnvironment.LINKED_JOBS_KEY, data == null ? null : ContainerUtil.flatten(data.values()));
    }

    private void correctDefaultAssociated(LocalChangeList defaultList) {
        Map<ConnectionKey, List<PerforceJob>> data = this.myVcs.getDefaultAssociated();
        Map<ConnectionKey, P4Connection> map = ConnectionSelector.getConnections(this.myProject, defaultList);
        HashMap<ConnectionKey, List<PerforceJob>> filtered = new HashMap<ConnectionKey, List<PerforceJob>>();
        for (Map.Entry<ConnectionKey, List<PerforceJob>> entry : data.entrySet()) {
            if (!map.containsKey(entry.getKey())) continue;
            filtered.put(entry.getKey(), entry.getValue());
        }
        this.myVcs.setDefaultAssociated(filtered);
    }

    private void keepDefaultListJobs() {
        List<PerforceJob> perforceJobs = this.myDetails.getJobs();
        HashMap<ConnectionKey, List<PerforceJob>> jobs = new HashMap<ConnectionKey, List<PerforceJob>>();
        for (PerforceJob job : perforceJobs) {
            ArrayList<PerforceJob> oldList = (ArrayList<PerforceJob>)jobs.get(job.getConnectionKey());
            if (oldList == null) {
                oldList = new ArrayList<PerforceJob>();
                jobs.put(job.getConnectionKey(), oldList);
            }
            oldList.add(job);
        }
        this.myVcs.setDefaultAssociated(jobs);
    }

    private Map<ConnectionKey, List<PerforceJob>> loadOnSelect(LocalChangeList list) {
        JobDetailsLoader loader = new JobDetailsLoader(this.myProject);
        HashMap<ConnectionKey, List<PerforceJob>> perforceJobs = new HashMap<ConnectionKey, List<PerforceJob>>();
        loader.loadJobsForList(list, this.myConnMap, perforceJobs);
        return perforceJobs;
    }

    private void setItems(List<PerforceJob> items) {
        this.myDetails.fillTree(items, items.isEmpty() ? null : items.get(0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/perforce/perforce/jobs/PerforceCheckinComponent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "onChangeListSelected";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class MyTextFieldAction
    extends TextFieldAction {
        private MyTextFieldAction(@NlsActions.ActionDescription String text, String description, Icon icon) {
            super(text, description, icon, 20);
        }

        public void perform() {
            this.searchByJobviewAndFilter();
        }

        private void searchByJobviewAndFilter() {
            String text = this.myField.getText().trim();
            if (text.length() > 0) {
                PerforceCheckinComponent.this.ensureDefaultConnections();
                if (PerforceCheckinComponent.this.myCurrent != null) {
                    Map<ConnectionKey, P4Connection> p4ConnectionMap = ConnectionSelector.getConnections(PerforceCheckinComponent.this.myProject, PerforceCheckinComponent.this.myCurrent);
                    if (p4ConnectionMap.isEmpty()) {
                        return;
                    }
                    if (p4ConnectionMap.size() == 1) {
                        ConnectionKey key = p4ConnectionMap.keySet().iterator().next();
                        Pair pair = Pair.create((Object)key, (Object)p4ConnectionMap.get(key));
                        this.addImpl(text, (Pair<ConnectionKey, P4Connection>)pair);
                    } else {
                        ConnectionSelector.selectConnection(p4ConnectionMap, (Consumer<ConnectionKey>)((Consumer)connectionKey -> {
                            if (connectionKey != null) {
                                this.addImpl(text, (Pair<ConnectionKey, P4Connection>)Pair.create((Object)connectionKey, (Object)((P4Connection)p4ConnectionMap.get(connectionKey))));
                            }
                        }));
                    }
                }
            }
        }

        private void addImpl(String text, Pair<ConnectionKey, P4Connection> pair) {
            P4JobsLogicConn connMap;
            if (pair != null && (connMap = PerforceCheckinComponent.this.myConnMap.get(pair.getFirst())) != null) {
                PerforceJobSpecification spec;
                ConnectionKey key;
                P4Connection connection;
                JobsWorker worker = new JobsWorker(PerforceCheckinComponent.this.myProject);
                JobViewSearchSpecificator searchSpecificator = new JobViewSearchSpecificator(connMap.getJobView(), text);
                List<PerforceJob> jobs = PerforceCheckinComponent.getJobsUnderProgress(worker, searchSpecificator, connection = (P4Connection)pair.getSecond(), key = (ConnectionKey)pair.getFirst(), spec = connMap.getSpec());
                if (jobs == null) {
                    return;
                }
                if (jobs.isEmpty()) {
                    Messages.showMessageDialog((Project)PerforceCheckinComponent.this.myProject, (String)PerforceBundle.message("job.no.matching.pattern", new Object[0]), (String)PerforceBundle.message("job.add", new Object[0]), (Icon)Messages.getInformationIcon());
                    return;
                }
                Consumer consumer = perforceJob -> {
                    PerforceCheckinComponent.this.myAdderRemover.add((PerforceJob)perforceJob, PerforceCheckinComponent.this.myCurrent, PerforceCheckinComponent.this.myProject);
                    this.myField.setText("");
                };
                if (jobs.size() > 1) {
                    PerforceCheckinComponent.this.showListPopup(jobs, this.myField, (Consumer<PerforceJob>)consumer, searchSpecificator.getMaxCount());
                } else {
                    consumer.consume((Object)jobs.get(0));
                }
            }
        }
    }
}

