/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.attach;

import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.MouseButton;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.codeInsight.hints.presentation.RoundWithBackgroundPresentation;
import com.intellij.codeInsight.hints.presentation.ScaleAwarePresentationFactory;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.InlayProvider;
import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.attach.InlayHelpTooltip;
import com.intellij.javascript.debugger.attach.JSDebuggerUrlFilterKt;
import com.intellij.javascript.debugger.attach.StartDebuggingInBrowserFilterKt;
import com.intellij.javascript.debugger.attach.statistics.JavaScriptDebuggerEntrypointUsageCounter;
import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.util.io.URLUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.regex.Matcher;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/javascript/debugger/attach/StartDebuggingInBrowserFilter;", "Lcom/intellij/execution/filters/Filter;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "StartDebuggingResult", "intellij.javascript.chrome.connector"})
public final class StartDebuggingInBrowserFilter
implements Filter {
    @NotNull
    private final Project project;

    public StartDebuggingInBrowserFilter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        List list;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Matcher urlMatcher = URLUtil.URL_PATTERN.matcher(line);
        int textStartOffset = entireLength - line.length();
        List $this$applyFilter_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        while (urlMatcher.find()) {
            String url = urlMatcher.group();
            Intrinsics.checkNotNull((Object)url);
            if (!JSDebuggerUrlFilterKt.isLocalHostUrl(url)) continue;
            $this$applyFilter_u24lambda_u240.add(new StartDebuggingResult(this.project, url.toString(), textStartOffset + urlMatcher.start(), textStartOffset + urlMatcher.end()));
        }
        List resultList = CollectionsKt.build((List)list);
        return resultList.size() == 1 ? (Filter.Result)CollectionsKt.first((List)resultList) : (resultList.size() > 1 ? new Filter.Result(resultList) : null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0014\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/javascript/debugger/attach/StartDebuggingInBrowserFilter$StartDebuggingResult;", "Lcom/intellij/execution/filters/Filter$Result;", "Lcom/intellij/execution/impl/InlayProvider;", "project", "Lcom/intellij/openapi/project/Project;", "url", "", "highlightStartOffset", "", "highlightEndOffset", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;II)V", "createInlayRenderer", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.javascript.chrome.connector"})
    public static final class StartDebuggingResult
    extends Filter.Result
    implements InlayProvider {
        @NotNull
        private final Project project;
        @NotNull
        private final String url;

        public StartDebuggingResult(@NotNull Project project, @NotNull String url, int highlightStartOffset, int highlightEndOffset) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            super(highlightStartOffset, highlightEndOffset, null);
            this.project = project;
            this.url = url;
        }

        @Nullable
        public EditorCustomElementRenderer createInlayRenderer(@Nullable Editor editor) {
            if (editor == null) {
                return null;
            }
            JavaScriptDebuggerEntrypointUsageCounter.INSTANCE.logStartDebuggingButtonShown();
            PresentationFactory factory = new PresentationFactory(editor);
            ScaleAwarePresentationFactory scaledFactory = new ScaleAwarePresentationFactory(editor, factory);
            Object[] objectArray = new Object[]{ClientSystemInfo.Companion.isMac() ? "Cmd" : "Ctrl"};
            HelpTooltip helpTooltip = new InlayHelpTooltip().setTitle(JSDebuggerBundle.message((String)"start.debug.in.browser.tooltip.title", (Object[])new Object[0])).setDescription(JSDebuggerBundle.message((String)"start.debug.in.browser.tooltip.description", (Object[])objectArray));
            Intrinsics.checkNotNull((Object)helpTooltip, (String)"null cannot be cast to non-null type com.intellij.javascript.debugger.attach.InlayHelpTooltip");
            InlayHelpTooltip tooltip = (InlayHelpTooltip)helpTooltip;
            PresentationFactory $this$createInlayRenderer_u24lambda_u243 = factory;
            boolean bl = false;
            ScaleAwarePresentationFactory $this$createInlayRenderer_u24lambda_u243_u24lambda_u242 = scaledFactory;
            boolean bl2 = false;
            InlayPresentation[] inlayPresentationArray = new InlayPresentation[2];
            Icon icon = AllIcons.Actions.StartDebugger;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"StartDebugger");
            inlayPresentationArray[0] = $this$createInlayRenderer_u24lambda_u243_u24lambda_u242.lineCentered($this$createInlayRenderer_u24lambda_u243_u24lambda_u242.icon(icon));
            String string = JSDebuggerBundle.message((String)"start.debug.in.browser.text", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            inlayPresentationArray[1] = ScaleAwarePresentationFactory.inset$default((ScaleAwarePresentationFactory)$this$createInlayRenderer_u24lambda_u243_u24lambda_u242, (InlayPresentation)ScaleAwarePresentationFactory.inset$default((ScaleAwarePresentationFactory)$this$createInlayRenderer_u24lambda_u243_u24lambda_u242, (InlayPresentation)$this$createInlayRenderer_u24lambda_u243_u24lambda_u242.smallText(string), (int)0, (int)0, (int)4, (int)0, (int)22, null), (int)4, (int)0, (int)0, (int)0, (int)28, null);
            InlayPresentation baseButton = ScaleAwarePresentationFactory.inset$default((ScaleAwarePresentationFactory)$this$createInlayRenderer_u24lambda_u243_u24lambda_u242, (InlayPresentation)$this$createInlayRenderer_u24lambda_u243_u24lambda_u242.seq(inlayPresentationArray), (int)4, (int)4, (int)0, (int)0, (int)24, null);
            InlayPresentation inlayPresentation = StartDebuggingInBrowserFilterKt.access$withHelpTooltip($this$createInlayRenderer_u24lambda_u243, PresentationFactory.changeOnHover$default((PresentationFactory)$this$createInlayRenderer_u24lambda_u243, (InlayPresentation)((InlayPresentation)new RoundWithBackgroundPresentation(baseButton, 6, 6, null, 0.0f, 24, null)), () -> StartDebuggingResult.createInlayRenderer$lambda$3$lambda$2$lambda$0(baseButton), null, (int)4, null), tooltip);
            Cursor cursor = Cursor.getPredefinedCursor(12);
            Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"getPredefinedCursor(...)");
            InlayPresentation buttonWithTooltip = $this$createInlayRenderer_u24lambda_u243.withCursorOnHover(inlayPresentation, cursor);
            InlayPresentation buttonWithCallback = $this$createInlayRenderer_u24lambda_u243.onClick(buttonWithTooltip, MouseButton.Left, (arg_0, arg_1) -> StartDebuggingResult.createInlayRenderer$lambda$3$lambda$2$lambda$1(this, arg_0, arg_1));
            InlayPresentation presentation = ScaleAwarePresentationFactory.inset$default((ScaleAwarePresentationFactory)$this$createInlayRenderer_u24lambda_u243_u24lambda_u242, (InlayPresentation)buttonWithCallback, (int)4, (int)4, (int)0, (int)0, (int)24, null);
            return (EditorCustomElementRenderer)new PresentationRenderer(presentation);
        }

        private static final InlayPresentation createInlayRenderer$lambda$3$lambda$2$lambda$0(InlayPresentation $baseButton) {
            return (InlayPresentation)new RoundWithBackgroundPresentation($baseButton, 6, 6, (Color)StartDebuggingInBrowserFilterKt.access$getSTART_DEBUGGING_HOVER_COLOR$p(), 0.0f, 16, null);
        }

        private static final Unit createInlayRenderer$lambda$3$lambda$2$lambda$1(StartDebuggingResult this$0, MouseEvent event, Point translated) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
            JavaScriptDebuggerEntrypointUsageCounter.INSTANCE.logStartDebuggingButtonClicked();
            JSDebuggerUrlFilterKt.startJavaScriptDebugRunConfiguration(this$0.project, this$0.url);
            return Unit.INSTANCE;
        }
    }
}

