/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.abbreviation.internal;

import com.vladsch.flexmark.ext.abbreviation.Abbreviation;
import com.vladsch.flexmark.ext.abbreviation.AbbreviationBlock;
import com.vladsch.flexmark.ext.abbreviation.AbbreviationExtension;
import com.vladsch.flexmark.util.ast.KeepType;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeRepository;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AbbreviationRepository
extends NodeRepository<AbbreviationBlock> {
    public AbbreviationRepository(DataHolder options) {
        super(AbbreviationExtension.ABBREVIATIONS_KEEP.get(options));
    }

    @Override
    @NotNull
    public DataKey<AbbreviationRepository> getDataKey() {
        return AbbreviationExtension.ABBREVIATIONS;
    }

    @Override
    @NotNull
    public DataKey<KeepType> getKeepDataKey() {
        return AbbreviationExtension.ABBREVIATIONS_KEEP;
    }

    @Override
    @NotNull
    public Set<AbbreviationBlock> getReferencedElements(Node parent) {
        HashSet<AbbreviationBlock> references = new HashSet<AbbreviationBlock>();
        this.visitNodes(parent, value2 -> {
            AbbreviationBlock reference;
            if (value2 instanceof Abbreviation && (reference = ((Abbreviation)value2).getReferenceNode(this)) != null) {
                references.add(reference);
            }
        }, Abbreviation.class);
        return references;
    }
}

