/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.stats;

import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.cloud.project.LinkedCloudReportDescriptor;
import org.jetbrains.qodana.cloud.project.LinkedLatestCloudReportDescriptor;
import org.jetbrains.qodana.highlight.HighlightedReportState;
import org.jetbrains.qodana.highlight.HighlightedReportStateKt;
import org.jetbrains.qodana.highlight.QodanaHighlightedReportService;
import org.jetbrains.qodana.protocol.OpenInIdeCloudReportDescriptor;
import org.jetbrains.qodana.protocol.SingleMarkerReportDescriptor;
import org.jetbrains.qodana.registry.QodanaRegistry;
import org.jetbrains.qodana.report.FileReportDescriptor;
import org.jetbrains.qodana.report.ReportDescriptor;
import org.jetbrains.qodana.run.LocalRunNotPublishedReportDescriptor;
import org.jetbrains.qodana.run.LocalRunPublishedReportDescriptor;
import org.jetbrains.qodana.stats.QodanaPluginStatsCounterCollector;
import org.jetbrains.qodana.stats.SelectedNodeType;
import org.jetbrains.qodana.stats.StatsReportType;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreeDirectoryNode;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreeFileNode;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreeInspectionCategoryNode;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreeInspectionNode;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreeModuleNode;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreeNode;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreeProblemNode;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreeRoot;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreeSeverityNode;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u0018\u0010\u0003\u001a\u00020\u0004*\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a$\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a8\u0006\u0010"}, d2={"toStatsReportType", "Lorg/jetbrains/qodana/stats/StatsReportType;", "Lorg/jetbrains/qodana/report/ReportDescriptor;", "toSelectedNodeType", "Lorg/jetbrains/qodana/stats/SelectedNodeType;", "Lorg/jetbrains/qodana/ui/problemsView/tree/model/QodanaTreeNode;", "currentlyHighlightedReportStatsType", "project", "Lcom/intellij/openapi/project/Project;", "logCoverageReceivedStats", "", "isReceived", "", "languages", "", "", "intellij.qodana"})
public final class QodanaPluginStatsCounterCollectorKt {
    @NotNull
    public static final StatsReportType toStatsReportType(@NotNull ReportDescriptor $this$toStatsReportType) {
        Intrinsics.checkNotNullParameter((Object)$this$toStatsReportType, (String)"<this>");
        ReportDescriptor reportDescriptor = $this$toStatsReportType;
        return reportDescriptor instanceof FileReportDescriptor ? StatsReportType.FILE : (reportDescriptor instanceof SingleMarkerReportDescriptor ? StatsReportType.OPEN_IN_IDE : (reportDescriptor instanceof OpenInIdeCloudReportDescriptor ? StatsReportType.OPEN_IN_IDE_CLOUD_REPORT : (reportDescriptor instanceof LocalRunNotPublishedReportDescriptor ? StatsReportType.LOCAL_RUN_NOT_PUBLISHED : (reportDescriptor instanceof LocalRunPublishedReportDescriptor ? StatsReportType.LOCAL_RUN_PUBLISHED : (reportDescriptor instanceof LinkedLatestCloudReportDescriptor ? StatsReportType.CLOUD : (reportDescriptor instanceof LinkedCloudReportDescriptor ? StatsReportType.CLOUD : StatsReportType.UNKNOWN))))));
    }

    @NotNull
    public static final SelectedNodeType toSelectedNodeType(@NotNull QodanaTreeNode<?, ?, ?> $this$toSelectedNodeType) {
        Intrinsics.checkNotNullParameter($this$toSelectedNodeType, (String)"<this>");
        QodanaTreeNode<?, ?, ?> qodanaTreeNode = $this$toSelectedNodeType;
        return qodanaTreeNode instanceof QodanaTreeSeverityNode ? SelectedNodeType.SEVERITY : (qodanaTreeNode instanceof QodanaTreeInspectionCategoryNode ? SelectedNodeType.INSPECTION_CATEGORY : (qodanaTreeNode instanceof QodanaTreeInspectionNode ? SelectedNodeType.INSPECTION : (qodanaTreeNode instanceof QodanaTreeModuleNode ? SelectedNodeType.MODULE : (qodanaTreeNode instanceof QodanaTreeDirectoryNode ? SelectedNodeType.DIRECTORY : (qodanaTreeNode instanceof QodanaTreeFileNode ? SelectedNodeType.FILE : (qodanaTreeNode instanceof QodanaTreeProblemNode ? SelectedNodeType.PROBLEM : (qodanaTreeNode instanceof QodanaTreeRoot ? SelectedNodeType.ROOT : SelectedNodeType.OTHER)))))));
    }

    @NotNull
    public static final StatsReportType currentlyHighlightedReportStatsType(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        HighlightedReportState highlightedReportState = (HighlightedReportState)QodanaHighlightedReportService.Companion.getInstance(project).getHighlightedReportState().getValue();
        ReportDescriptor reportDescriptor = HighlightedReportStateKt.getReportDescriptorIfSelectedOrLoading(highlightedReportState);
        Object object = reportDescriptor;
        if (object == null || (object = QodanaPluginStatsCounterCollectorKt.toStatsReportType(object)) == null) {
            object = StatsReportType.NONE;
        }
        return object;
    }

    public static final void logCoverageReceivedStats(@NotNull Project project, boolean isReceived, @NotNull List<String> languages) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(languages, (String)"languages");
        QodanaPluginStatsCounterCollector.REPORT_WITH_COVERAGE_RECEIVED.log(project, (Object)isReceived, languages, (Object)QodanaRegistry.INSTANCE.getOpenCoverageReportEnabled());
    }
}

