/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.parser;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.flavours.gfm.StrikeThroughDelimiterParser;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.html.SimpleInlineTagProvider;
import org.intellij.markdown.html.TransparentInlineHolderProvider;
import org.intellij.markdown.lexer.MarkdownLexer;
import org.intellij.markdown.parser.LinkMap;
import org.intellij.markdown.parser.MarkerProcessorFactory;
import org.intellij.markdown.parser.sequentialparsers.DelimiterParser;
import org.intellij.markdown.parser.sequentialparsers.EmphasisLikeParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParserManager;
import org.intellij.markdown.parser.sequentialparsers.impl.AutolinkParser;
import org.intellij.markdown.parser.sequentialparsers.impl.BacktickParser;
import org.intellij.markdown.parser.sequentialparsers.impl.EmphStrongDelimiterParser;
import org.intellij.markdown.parser.sequentialparsers.impl.ImageParser;
import org.intellij.markdown.parser.sequentialparsers.impl.InlineLinkParser;
import org.intellij.markdown.parser.sequentialparsers.impl.MathParser;
import org.intellij.markdown.parser.sequentialparsers.impl.ReferenceLinkParser;
import org.intellij.plugins.markdown.lang.parser.FrontMatterGeneratingProvider;
import org.intellij.plugins.markdown.lang.parser.MarkdownDefaultMarkerProcessor;
import org.intellij.plugins.markdown.lang.parser.blocks.DefinitionListMarkerProvider;
import org.intellij.plugins.markdown.lang.parser.blocks.frontmatter.FrontMatterHeaderMarkerProvider;
import org.intellij.plugins.markdown.ui.preview.html.HeaderGeneratingProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000e\u001a\u00020\u000fH\u0016J&\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u001c\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u001bH\u0002J\u001c\u0010\u001c\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u001bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001f"}, d2={"Lorg/intellij/plugins/markdown/lang/parser/MarkdownDefaultFlavour;", "Lorg/intellij/markdown/flavours/MarkdownFlavourDescriptor;", "<init>", "()V", "delegate", "Lorg/intellij/markdown/flavours/gfm/GFMFlavourDescriptor;", "markerProcessorFactory", "Lorg/intellij/markdown/parser/MarkerProcessorFactory;", "getMarkerProcessorFactory", "()Lorg/intellij/markdown/parser/MarkerProcessorFactory;", "sequentialParserManager", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParserManager;", "getSequentialParserManager", "()Lorg/intellij/markdown/parser/sequentialparsers/SequentialParserManager;", "createInlinesLexer", "Lorg/intellij/markdown/lexer/MarkdownLexer;", "createHtmlGeneratingProviders", "", "Lorg/intellij/markdown/IElementType;", "Lorg/intellij/markdown/html/GeneratingProvider;", "linkMap", "Lorg/intellij/markdown/parser/LinkMap;", "baseURI", "Ljava/net/URI;", "addCustomProviders", "", "providers", "", "addCustomHeaderProviders", "DefaultSequentialParserManager", "ExcludedElementProvider", "intellij.markdown"})
public class MarkdownDefaultFlavour
implements MarkdownFlavourDescriptor {
    @NotNull
    private final GFMFlavourDescriptor delegate = new GFMFlavourDescriptor(false, false, false, 7, null);
    @NotNull
    private final SequentialParserManager sequentialParserManager = new DefaultSequentialParserManager();

    @NotNull
    public MarkerProcessorFactory getMarkerProcessorFactory() {
        return MarkdownDefaultMarkerProcessor.Factory.INSTANCE;
    }

    @NotNull
    public SequentialParserManager getSequentialParserManager() {
        return this.sequentialParserManager;
    }

    @NotNull
    public MarkdownLexer createInlinesLexer() {
        return this.delegate.createInlinesLexer();
    }

    @NotNull
    public Map<IElementType, GeneratingProvider> createHtmlGeneratingProviders(@NotNull LinkMap linkMap, @Nullable URI baseURI) {
        Intrinsics.checkNotNullParameter((Object)linkMap, (String)"linkMap");
        Map base = this.delegate.createHtmlGeneratingProviders(linkMap, baseURI);
        HashMap result = new HashMap(base);
        this.addCustomProviders(result);
        return result;
    }

    private final void addCustomProviders(Map<IElementType, GeneratingProvider> providers) {
        this.addCustomHeaderProviders(providers);
        providers.put(DefinitionListMarkerProvider.DEFINITION_LIST, (GeneratingProvider)new SimpleInlineTagProvider("dl", 0, 0, 6, null));
        providers.put(DefinitionListMarkerProvider.DEFINITION, (GeneratingProvider)new SimpleInlineTagProvider("dd", 0, 0, 6, null));
        providers.put(DefinitionListMarkerProvider.TERM, (GeneratingProvider)new SimpleInlineTagProvider("dt", 0, 0, 6, null));
        providers.put(DefinitionListMarkerProvider.DEFINITION_MARKER, (GeneratingProvider)new TransparentInlineHolderProvider(0, 0, 3, null));
        providers.put((IElementType)FrontMatterHeaderMarkerProvider.FRONT_MATTER_HEADER, new FrontMatterGeneratingProvider());
    }

    private final void addCustomHeaderProviders(Map<IElementType, GeneratingProvider> providers) {
        providers.put(MarkdownElementTypes.ATX_1, (GeneratingProvider)new HeaderGeneratingProvider("h1"));
        providers.put(MarkdownElementTypes.ATX_2, (GeneratingProvider)new HeaderGeneratingProvider("h2"));
        providers.put(MarkdownElementTypes.ATX_3, (GeneratingProvider)new HeaderGeneratingProvider("h3"));
        providers.put(MarkdownElementTypes.ATX_4, (GeneratingProvider)new HeaderGeneratingProvider("h4"));
        providers.put(MarkdownElementTypes.ATX_5, (GeneratingProvider)new HeaderGeneratingProvider("h5"));
        providers.put(MarkdownElementTypes.ATX_6, (GeneratingProvider)new HeaderGeneratingProvider("h6"));
        providers.put(MarkdownElementTypes.SETEXT_1, (GeneratingProvider)new HeaderGeneratingProvider("h1"));
        providers.put(MarkdownElementTypes.SETEXT_2, (GeneratingProvider)new HeaderGeneratingProvider("h2"));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/intellij/plugins/markdown/lang/parser/MarkdownDefaultFlavour$DefaultSequentialParserManager;", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParserManager;", "<init>", "()V", "getParserSequence", "", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser;", "intellij.markdown"})
    protected static final class DefaultSequentialParserManager
    extends SequentialParserManager {
        @NotNull
        public List<SequentialParser> getParserSequence() {
            Object[] objectArray = new SequentialParser[7];
            Object[] objectArray2 = new IElementType[]{MarkdownTokenTypes.AUTOLINK, GFMTokenTypes.GFM_AUTOLINK};
            objectArray[0] = new AutolinkParser(CollectionsKt.listOf((Object[])objectArray2));
            objectArray[1] = new BacktickParser();
            objectArray[2] = new MathParser();
            objectArray[3] = new ImageParser();
            objectArray[4] = new InlineLinkParser();
            objectArray[5] = new ReferenceLinkParser();
            objectArray2 = new DelimiterParser[]{new EmphStrongDelimiterParser(), new StrikeThroughDelimiterParser()};
            objectArray[6] = new EmphasisLikeParser((DelimiterParser[])objectArray2);
            return CollectionsKt.listOf((Object[])objectArray);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007R\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/intellij/plugins/markdown/lang/parser/MarkdownDefaultFlavour$ExcludedElementProvider;", "Lorg/intellij/markdown/html/GeneratingProvider;", "<init>", "()V", "processNode", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "intellij.markdown"})
    private static final class ExcludedElementProvider
    implements GeneratingProvider {
        public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor2, @NotNull String text2, @NotNull ASTNode node) {
            Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        }
    }
}

