/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.target.ssh.target;

import com.intellij.execution.Platform;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.RSyncUtil;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.SftpProgressTracker;
import com.intellij.ssh.channels.SftpChannel;
import com.intellij.util.PathUtilRt;
import com.jetbrains.plugins.remotesdk.target.ssh.target.SshEnvironment;
import com.jetbrains.plugins.remotesdk.target.ssh.target.SshTargetUtilKt;
import com.jetbrains.plugins.remotesdk.target.ssh.target.SshVolumeBase;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003Ba\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\nH\u0016J\u0018\u0010(\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020*H\u0016J\u0014\u0010+\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000f\u0018\u00010,J\u000e\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000fJ\b\u0010/\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001b\u0010\u001e\u001a\u00020\u001f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b \u0010!\u00a8\u00060"}, d2={"Lcom/jetbrains/plugins/remotesdk/target/ssh/target/NewSshVolume;", "Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshVolumeBase;", "Lcom/intellij/execution/target/TargetEnvironment$UploadableVolume;", "Lcom/intellij/execution/target/TargetEnvironment$DownloadableVolume;", "credentials", "Lcom/intellij/remote/RemoteCredentials;", "platform", "Lcom/intellij/execution/Platform;", "sftpProgressTrackerFactory", "Lkotlin/Function1;", "Lcom/intellij/execution/target/TargetProgressIndicator;", "Lcom/intellij/ssh/SftpProgressTracker;", "localRoot", "Ljava/nio/file/Path;", "targetRoot", "", "useRsync", "", "project", "Lcom/intellij/openapi/project/Project;", "sharedLocalPath", "sharedTargetPath", "<init>", "(Lcom/intellij/remote/RemoteCredentials;Lcom/intellij/execution/Platform;Lkotlin/jvm/functions/Function1;Ljava/nio/file/Path;Ljava/lang/String;ZLcom/intellij/openapi/project/Project;Ljava/nio/file/Path;Ljava/lang/String;)V", "getUseRsync", "()Z", "getSharedLocalPath", "()Ljava/nio/file/Path;", "getSharedTargetPath", "()Ljava/lang/String;", "connectionBuilder", "Lcom/intellij/ssh/ConnectionBuilder;", "getConnectionBuilder", "()Lcom/intellij/ssh/ConnectionBuilder;", "connectionBuilder$delegate", "Lkotlin/Lazy;", "upload", "", "relativePath", "targetProgressIndicator", "download", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getBatchPaths", "Lkotlin/Pair;", "getRelativePath", "path", "toString", "intellij.remoteRun"})
@SourceDebugExtension(value={"SMAP\nSshEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshEnvironment.kt\ncom/jetbrains/plugins/remotesdk/target/ssh/target/NewSshVolume\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,725:1\n1#2:726\n*E\n"})
final class NewSshVolume
extends SshVolumeBase
implements TargetEnvironment.UploadableVolume,
TargetEnvironment.DownloadableVolume {
    @NotNull
    private final RemoteCredentials credentials;
    @NotNull
    private final Function1<TargetProgressIndicator, SftpProgressTracker> sftpProgressTrackerFactory;
    private final boolean useRsync;
    @Nullable
    private final Project project;
    @Nullable
    private final Path sharedLocalPath;
    @Nullable
    private final String sharedTargetPath;
    @NotNull
    private final Lazy connectionBuilder$delegate;

    public NewSshVolume(@NotNull RemoteCredentials credentials, @NotNull Platform platform, @NotNull Function1<? super TargetProgressIndicator, ? extends SftpProgressTracker> sftpProgressTrackerFactory, @NotNull Path localRoot, @NotNull String targetRoot, boolean useRsync, @Nullable Project project, @Nullable Path sharedLocalPath, @Nullable String sharedTargetPath) {
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter(sftpProgressTrackerFactory, (String)"sftpProgressTrackerFactory");
        Intrinsics.checkNotNullParameter((Object)localRoot, (String)"localRoot");
        Intrinsics.checkNotNullParameter((Object)targetRoot, (String)"targetRoot");
        super(platform, localRoot, targetRoot);
        this.credentials = credentials;
        this.sftpProgressTrackerFactory = sftpProgressTrackerFactory;
        this.useRsync = useRsync;
        this.project = project;
        this.sharedLocalPath = sharedLocalPath;
        this.sharedTargetPath = sharedTargetPath;
        this.connectionBuilder$delegate = LazyKt.lazy(() -> NewSshVolume.connectionBuilder_delegate$lambda$0(this));
    }

    public final boolean getUseRsync() {
        return this.useRsync;
    }

    @Nullable
    public final Path getSharedLocalPath() {
        return this.sharedLocalPath;
    }

    @Nullable
    public final String getSharedTargetPath() {
        return this.sharedTargetPath;
    }

    private final ConnectionBuilder getConnectionBuilder() {
        Lazy lazy = this.connectionBuilder$delegate;
        return (ConnectionBuilder)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(@NotNull String relativePath, @NotNull TargetProgressIndicator targetProgressIndicator) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)targetProgressIndicator, (String)"targetProgressIndicator");
        String resultPath = this.resolveTargetPath(relativePath);
        Path resolvedPath = this.getLocalRoot().resolve(FileUtil.toSystemDependentName((String)relativePath));
        File file = resolvedPath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        File file2 = FilesKt.normalize((File)file);
        if (this.useRsync) {
            String string;
            Object localPath = ((Object)resolvedPath.normalize()).toString();
            Intrinsics.checkNotNull((Object)resolvedPath);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            boolean isDirectory = Files.isDirectory(resolvedPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
            if (isDirectory && !StringsKt.endsWith$default((CharSequence)((CharSequence)localPath), (char)this.getPlatform().fileSeparator, (boolean)false, (int)2, null)) {
                localPath = (String)localPath + this.getPlatform().fileSeparator;
            }
            if (isDirectory) {
                string = resultPath;
            } else {
                String string2 = resultPath.substring(0, resultPath.length() - PathUtilRt.getFileName((String)resultPath).length());
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            }
            String targetDirectory = string;
            Closeable closeable = (Closeable)ConnectionBuilder.openFailSafeSftpChannel$default((ConnectionBuilder)this.getConnectionBuilder(), (int)0, null, (int)3, null);
            Throwable throwable = null;
            try {
                SftpChannel it = (SftpChannel)closeable;
                boolean bl = false;
                SshTargetUtilKt.createTargetDirIfNotExists(targetDirectory, it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            RSyncUtil.uploadWithRSync((String)localPath, (String)resultPath, (RemoteCredentials)this.credentials, (List)SshEnvironment.Companion.getRsyncExclusions$intellij_remoteRun$default(SshEnvironment.Companion, file2, true, this.project, null, 8, null), (boolean)false, (boolean)true, (RSyncUtil.IndicatorWrapper)SshEnvironment.Companion.createIndicatorWrapper(targetProgressIndicator), (boolean)true);
        } else {
            Closeable closeable = (Closeable)ConnectionBuilder.openFailSafeSftpChannel$default((ConnectionBuilder)this.getConnectionBuilder(), (int)0, null, (int)3, null);
            Throwable throwable = null;
            try {
                SftpChannel it = (SftpChannel)closeable;
                boolean bl = false;
                it.uploadFileOrDir(file2, resultPath, "", (SftpProgressTracker)this.sftpProgressTrackerFactory.invoke((Object)targetProgressIndicator), SshEnvironment.Companion.getSshUploadFileFilter$intellij_remoteRun(file2, this.project), true);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(@NotNull String relativePath, @NotNull ProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        String resultPath = this.resolveTargetPath(relativePath);
        Path resolvedPath = this.getLocalRoot().resolve(FileUtil.toSystemDependentName((String)relativePath));
        if (this.useRsync) {
            RSyncUtil.downloadFileOrFolderWithRSync((String)((Object)resolvedPath.normalize()).toString(), (String)resultPath, (RemoteCredentials)this.credentials, (ProgressIndicator)progressIndicator);
        } else {
            Closeable closeable = (Closeable)ConnectionBuilder.openFailSafeSftpChannel$default((ConnectionBuilder)this.getConnectionBuilder(), (int)0, null, (int)3, null);
            Throwable throwable = null;
            try {
                SftpChannel sftpChannel = (SftpChannel)closeable;
                boolean bl = false;
                sftpChannel.downloadFileOrDir(resultPath, ((Object)resolvedPath).toString());
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    @Nullable
    public final Pair<Path, String> getBatchPaths() {
        if (this.sharedLocalPath == null || this.sharedTargetPath == null) {
            return null;
        }
        return new Pair((Object)this.sharedLocalPath, (Object)this.sharedTargetPath);
    }

    @NotNull
    public final String getRelativePath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (this.sharedLocalPath == null) {
            throw new IllegalStateException("shared local path should be provided".toString());
        }
        return ((Object)this.getLocalRoot().relativize(this.sharedLocalPath).resolve(path)).toString();
    }

    @NotNull
    public String toString() {
        return "NewSshVolume(localRoot=" + this.getLocalRoot() + ",\ntargetRoot='" + this.getTargetRoot() + "')";
    }

    private static final ConnectionBuilder connectionBuilder_delegate$lambda$0(NewSshVolume this$0) {
        return RemoteCredentialsUtil.connectionBuilder$default((RemoteCredentials)this$0.credentials, (Project)this$0.project, null, (boolean)false, null, (int)14, null);
    }
}

