/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.debugger;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.helper.JupyterFileExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterHelper;
import com.intellij.jupyter.py.debugger.CellSourcePosition;
import com.intellij.jupyter.py.debugger.JupyterDebugCellIdManager;
import com.intellij.jupyter.py.debugger.JupyterEditorSourcePosition;
import com.intellij.jupyter.py.debugger.JupyterSourcePosition;
import com.intellij.jupyter.py.editor.JupyterFileUtilKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyLocalPositionConverter;
import com.jetbrains.python.debugger.PySourcePosition;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000eH\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lcom/intellij/jupyter/py/debugger/JupyterPositionConverter;", "Lcom/jetbrains/python/debugger/PyLocalPositionConverter;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getCellStart", "Lcom/intellij/jupyter/py/debugger/CellSourcePosition;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "getCellStartPosition", "convertPythonToFrame", "Lcom/jetbrains/python/debugger/PySourcePosition;", "filePath", "", "line", "", "convertFrameToPython", "convertToPython", "convertFromPython", "frameName", "Companion", "intellij.jupyter.py"})
public final class JupyterPositionConverter
extends PyLocalPositionConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;

    public JupyterPositionConverter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final CellSourcePosition getCellStart(XSourcePosition position) {
        VirtualFile virtualFile = position.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        VirtualFile virtualFile2 = JupyterFileExtensionsKt.getOriginalVirtualFile((VirtualFile)virtualFile);
        Integer n = Companion.getJupyterLineStartOffset(virtualFile2, position.getLine());
        if (n == null) {
            return null;
        }
        int lineStartOffset = n;
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterHelper.INSTANCE.getJupyterVirtualFileByOriginalVirtualFile(virtualFile2);
        if (backedNotebookVirtualFile == null) {
            return null;
        }
        BackedNotebookVirtualFile jupyterVirtualFile = backedNotebookVirtualFile;
        JupyterPsiCell jupyterPsiCell = JupyterHelper.INSTANCE.getPsiCellByOffset(this.project, jupyterVirtualFile, lineStartOffset);
        if (jupyterPsiCell == null) {
            return null;
        }
        JupyterPsiCell jupyterCell = jupyterPsiCell;
        return JupyterFileUtilKt.getCellPositionForJupyterCell(virtualFile2, jupyterCell);
    }

    @TestOnly
    @Nullable
    public final CellSourcePosition getCellStartPosition(@NotNull XSourcePosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return this.getCellStart(position);
    }

    @NotNull
    public PySourcePosition convertPythonToFrame(@NotNull String filePath, int line) {
        int n;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        try {
            n = Integer.parseInt(filePath);
        }
        catch (NumberFormatException e) {
            PySourcePosition pySourcePosition = super.convertPythonToFrame(filePath, line);
            Intrinsics.checkNotNullExpressionValue((Object)pySourcePosition, (String)"convertPythonToFrame(...)");
            return pySourcePosition;
        }
        int cellId = n;
        CellSourcePosition cellPosition = JupyterDebugCellIdManager.Companion.getInstance(this.project).getCellPositionById(this.project, cellId);
        if (cellPosition == null) {
            LOG.warn("Failed to find cell for id " + cellId);
            PySourcePosition pySourcePosition = super.convertPythonToFrame(filePath, line);
            Intrinsics.checkNotNullExpressionValue((Object)pySourcePosition, (String)"convertPythonToFrame(...)");
            return pySourcePosition;
        }
        PySourcePosition pySourcePosition = super.convertPythonToFrame(cellPosition.getStart().getFile().getPath(), cellPosition.getStart().getLine() + line + 1);
        Intrinsics.checkNotNullExpressionValue((Object)pySourcePosition, (String)"convertPythonToFrame(...)");
        return pySourcePosition;
    }

    @NotNull
    public PySourcePosition convertFrameToPython(@NotNull PySourcePosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        XSourcePosition xSourcePosition = this.convertFromPython(position, "");
        if (xSourcePosition == null) {
            return position;
        }
        XSourcePosition sourcePosition = xSourcePosition;
        Object object = ReadAction.compute(() -> JupyterPositionConverter.convertFrameToPython$lambda$0(this, sourcePosition));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (PySourcePosition)object;
    }

    @NotNull
    public PySourcePosition convertToPython(@NotNull XSourcePosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        CellSourcePosition cellPosition = this.getCellStart(position);
        if (cellPosition == null) {
            JupyterDebugCellIdManager jupyterDebugCellIdManager = JupyterDebugCellIdManager.Companion.getInstance(this.project);
            String string = position.getFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            boolean isIndexed = jupyterDebugCellIdManager.isFileIndexed(string);
            if (isIndexed) {
                LOG.warn((Throwable)new PyDebuggerException("Failed to find cell position for " + position));
            }
            PySourcePosition pySourcePosition = super.convertToPython(position);
            Intrinsics.checkNotNullExpressionValue((Object)pySourcePosition, (String)"convertToPython(...)");
            return pySourcePosition;
        }
        int cellId = JupyterDebugCellIdManager.Companion.getInstance(this.project).getIdByPosition(this.project, cellPosition);
        return new JupyterSourcePosition(cellId, position.getLine() - cellPosition.getStart().getLine());
    }

    @Nullable
    public XSourcePosition convertFromPython(@NotNull PySourcePosition position, @NotNull String frameName) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)frameName, (String)"frameName");
        XSourcePosition xSourcePosition = super.convertFromPython(position, frameName);
        if (xSourcePosition == null) {
            return null;
        }
        XSourcePosition xSourcePosition2 = xSourcePosition;
        return new JupyterEditorSourcePosition(xSourcePosition2);
    }

    private static final PySourcePosition convertFrameToPython$lambda$0(JupyterPositionConverter this$0, XSourcePosition $sourcePosition) {
        return this$0.convertToPython($sourcePosition);
    }

    static {
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000eR\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/intellij/jupyter/py/debugger/JupyterPositionConverter$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "getJupyterLineStartOffset", "", "originalFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "(Lcom/intellij/openapi/vfs/VirtualFile;I)Ljava/lang/Integer;", "intellij.jupyter.py"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        @Nullable
        public final Integer getJupyterLineStartOffset(@NotNull VirtualFile originalFile, int line) {
            Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
            Editor editor = JupyterHelper.INSTANCE.getJupyterEditorByOriginalVirtualFile(originalFile);
            if (editor == null) {
                return null;
            }
            Editor editor2 = editor;
            return editor2.logicalPositionToOffset(new LogicalPosition(line, 0));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

