/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.remote.modules;

import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParametersSettings;
import com.intellij.jupyter.core.jupyter.connections.JupyterRemoteServersSettingsListener;
import com.intellij.jupyter.core.jupyter.connections.settings.ConfiguredServerJupyterModuleConnectionSettings;
import com.intellij.jupyter.core.jupyter.connections.settings.JupyterModuleConnectionSettings;
import com.intellij.jupyter.py.remote.JupyterRemoteLocalRootManager;
import com.intellij.notebooks.core.jupyter.JupyterRemotePath;
import com.intellij.notebooks.core.jupyter.remote.vfs.JupyterRemoteFileSystem;
import com.intellij.notebooks.core.jupyter.remote.vfs.JupyterRemoteVirtualFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0007J\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016J.\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\n2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010\u001b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0002J\u0018\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\nH\u0002J\b\u0010!\u001a\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/jupyter/py/remote/modules/JupyterRemoteEphemeralModuleManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "registeredModulesByAuthority", "", "", "", "Lcom/intellij/openapi/module/Module;", "knownRemoteServerListener", "Lcom/intellij/jupyter/core/jupyter/connections/JupyterRemoteServersSettingsListener;", "dispose", "", "isModuleRegistered", "", "module", "ensureModuleInitialized", "file", "Lcom/intellij/notebooks/core/jupyter/remote/vfs/JupyterRemoteVirtualFile;", "authority", "moduleList", "connectionSettings", "Lcom/intellij/jupyter/core/jupyter/connections/settings/ConfiguredServerJupyterModuleConnectionSettings;", "createModule", "moduleName", "initializeNewModule", "moduleModifiableModel", "Lcom/intellij/openapi/roots/ModifiableRootModel;", "rootName", "disposeRegisteredModules", "Companion", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterRemoteEphemeralModuleManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterRemoteEphemeralModuleManager.kt\ncom/intellij/jupyter/py/remote/modules/JupyterRemoteEphemeralModuleManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n1755#2,3:162\n1863#2,2:185\n24#3:165\n24#3:166\n61#3,5:167\n24#3:172\n61#3,5:173\n24#3:178\n61#3,5:179\n1#4:184\n*S KotlinDebug\n*F\n+ 1 JupyterRemoteEphemeralModuleManager.kt\ncom/intellij/jupyter/py/remote/modules/JupyterRemoteEphemeralModuleManager\n*L\n75#1:162,3\n46#1:185,2\n87#1:165\n99#1:166\n99#1:167,5\n124#1:172\n124#1:173,5\n131#1:178\n131#1:179,5\n*E\n"})
public final class JupyterRemoteEphemeralModuleManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Map<String, List<Module>> registeredModulesByAuthority;
    @NotNull
    private final JupyterRemoteServersSettingsListener knownRemoteServerListener;

    public JupyterRemoteEphemeralModuleManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.registeredModulesByAuthority = new HashMap();
        this.knownRemoteServerListener = (arg_0, arg_1) -> JupyterRemoteEphemeralModuleManager.knownRemoteServerListener$lambda$4(this, arg_0, arg_1);
        JupyterRemoteLocalRootManager.INSTANCE.onLocalRootChange((Function1<? super Path, Unit>)((Function1)arg_0 -> JupyterRemoteEphemeralModuleManager._init_$lambda$6(this, arg_0)));
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(JupyterConnectionParametersSettings.Companion.getREMOTE_SERVERS_TOPIC(), (Object)this.knownRemoteServerListener);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void dispose() {
    }

    @RequiresEdt
    public final boolean isModuleRegistered(@NotNull Module module) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Iterable $this$any$iv = this.registeredModulesByAuthority.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    List it = (List)element$iv;
                    boolean bl2 = false;
                    if (!it.contains(module)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void ensureModuleInitialized(@NotNull JupyterRemoteVirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ApplicationManager.getApplication().assertWriteIntentLockAcquired();
        List newList = new ArrayList(0);
        String authority = file.getRemotePath().getAuthority();
        if (this.registeredModulesByAuthority.putIfAbsent(authority, newList) == null) {
            ConfiguredServerJupyterModuleConnectionSettings configuredServerJupyterModuleConnectionSettings = JupyterConnectionParametersSettings.Companion.getInstance(this.project).getConnectionSettingsForAuthority(authority);
            if (configuredServerJupyterModuleConnectionSettings == null) {
                throw new IllegalStateException(("Bug. Tried to get connection settings for file " + file + " and found nothing.").toString());
            }
            ConfiguredServerJupyterModuleConnectionSettings connectionSettings = configuredServerJupyterModuleConnectionSettings;
            this.ensureModuleInitialized(this.project, authority, newList, connectionSettings);
            if (ProjectFileIndex.getInstance((Project)this.project).getModuleForFile((VirtualFile)file) == null) {
                JupyterRemoteEphemeralModuleManager $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(JupyterRemoteEphemeralModuleManager.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Module for the " + file + " wasn't initialized correctly in the project " + this.project + ". Absence of this message is required for the code insight.");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void ensureModuleInitialized(Project project, String authority, List<Module> moduleList, ConfiguredServerJupyterModuleConnectionSettings connectionSettings) {
        String moduleName = JupyterRemoteEphemeralModuleManager.Companion.moduleName(authority);
        if (ModuleManager.Companion.getInstance(project).findModuleByName(moduleName) == null) {
            void $this$debug_u24default$iv;
            JupyterRemoteEphemeralModuleManager $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterRemoteEphemeralModuleManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            $this$thisLogger$iv = logger;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                void var10_10 = $this$debug_u24default$iv;
                boolean bl = false;
                var10_10.debug("Creating a non-persistent module for authority " + authority, e$iv);
            }
            Module module = (Module)ActionsKt.runWriteAction(() -> JupyterRemoteEphemeralModuleManager.ensureModuleInitialized$lambda$9(this, project, moduleName, authority));
            Disposer.register((Disposable)((Disposable)module), () -> JupyterRemoteEphemeralModuleManager.ensureModuleInitialized$lambda$10(moduleList, module));
            moduleList.add(module);
            Project project2 = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            JupyterConnectionParametersSettings.Companion.getInstance(project2).setConnectionParametersForModule(module, (JupyterModuleConnectionSettings)connectionSettings);
        }
    }

    private final Module createModule(Project project, String moduleName, String authority) {
        Module module;
        ModuleManager moduleManager = ModuleManager.Companion.getInstance(project);
        String string = ModuleTypeManager.getInstance().getDefaultModuleType().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        Module it = module = moduleManager.newNonPersistentModule(moduleName, string);
        boolean bl = false;
        ModifiableRootModel modifiableRootModel = ProjectUtil.getRootManager((Module)it).getModifiableModel();
        Intrinsics.checkNotNullExpressionValue((Object)modifiableRootModel, (String)"getModifiableModel(...)");
        this.initializeNewModule(modifiableRootModel, authority);
        return module;
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeNewModule(ModifiableRootModel moduleModifiableModel, String rootName) {
        void $this$debug_u24default$iv;
        void $this$debug_u24default$iv2;
        String rootUrl = "jupyter-remote://" + rootName;
        moduleModifiableModel.addContentEntry(rootUrl).addSourceFolder(rootUrl, false);
        JupyterRemoteEphemeralModuleManager $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(JupyterRemoteEphemeralModuleManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        $this$thisLogger$iv = logger;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv2.isDebugEnabled()) {
            void var13_8 = $this$debug_u24default$iv2;
            boolean bl = false;
            var13_8.debug("Non-persistent module: add contents entry and source folder " + rootUrl, e$iv);
        }
        Library.ModifiableModel $this$initializeNewModule_u24lambda_u2414 = LibraryUtil.createLibrary((LibraryTable)moduleModifiableModel.getModuleLibraryTable(), (String)"LocalCache").getModifiableModel();
        boolean bl = false;
        Path path = JupyterRemoteFileSystem.Companion.getInstance().remotePathToLocalFilePath(JupyterRemotePath.Companion.get(rootName, new String[0])).toAbsolutePath();
        Library.ModifiableModel $this$thisLogger$iv2 = $this$initializeNewModule_u24lambda_u2414;
        boolean $i$f$thisLogger2 = false;
        Logger logger2 = Logger.getInstance(Library.ModifiableModel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        $this$thisLogger$iv2 = logger2;
        Throwable e$iv2 = null;
        boolean $i$f$debug2 = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            void var11_15 = $this$debug_u24default$iv;
            boolean bl2 = false;
            var11_15.debug("Non-persistent module: add library \"LocalCache\" with root file://" + path + " type sources", e$iv2);
        }
        $this$initializeNewModule_u24lambda_u2414.addRoot("file://" + path, OrderRootType.SOURCES);
        $this$initializeNewModule_u24lambda_u2414.commit();
        moduleModifiableModel.inheritSdk();
        moduleModifiableModel.commit();
    }

    private final void disposeRegisteredModules() {
        for (List<Module> moduleList : this.registeredModulesByAuthority.values()) {
            for (Module module : CollectionsKt.toList((Iterable)moduleList)) {
                Project project = module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                ModuleManager.Companion.getInstance(project).disposeModule(module);
            }
        }
        this.registeredModulesByAuthority.clear();
    }

    private static final Unit knownRemoteServerListener$lambda$4$lambda$3$lambda$2(Module $module) {
        block0: {
            Project project;
            Project it = project = $module.getProject();
            boolean bl = false;
            Object object = !it.isDisposed() ? project : null;
            if (object == null) break block0;
            it = object;
            boolean bl2 = false;
            ModuleManager.Companion.getInstance(it).disposeModule($module);
        }
        return Unit.INSTANCE;
    }

    private static final void knownRemoteServerListener$lambda$4(JupyterRemoteEphemeralModuleManager this$0, Map oldSettings, Map newSettings) {
        Intrinsics.checkNotNullParameter((Object)oldSettings, (String)"oldSettings");
        Intrinsics.checkNotNullParameter((Object)newSettings, (String)"newSettings");
        for (String authority : oldSettings.keySet()) {
            if (newSettings.containsKey(authority)) continue;
            List<Module> list = this$0.registeredModulesByAuthority.remove(authority);
            if (list == null) continue;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Module module = (Module)element$iv;
                boolean bl = false;
                ActionsKt.invokeLater$default(null, () -> JupyterRemoteEphemeralModuleManager.knownRemoteServerListener$lambda$4$lambda$3$lambda$2(module), (int)1, null);
            }
        }
    }

    private static final Unit lambda$6$lambda$5(JupyterRemoteEphemeralModuleManager this$0) {
        this$0.disposeRegisteredModules();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$6(JupyterRemoteEphemeralModuleManager this$0, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ActionsKt.invokeLater$default(null, () -> JupyterRemoteEphemeralModuleManager.lambda$6$lambda$5(this$0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Module ensureModuleInitialized$lambda$9(JupyterRemoteEphemeralModuleManager this$0, Project $project, String $moduleName, String $authority) {
        return this$0.createModule($project, $moduleName, $authority);
    }

    private static final void ensureModuleInitialized$lambda$10(List $moduleList, Module $module) {
        $moduleList.remove($module);
    }

    @JvmStatic
    @NotNull
    public static final JupyterRemoteEphemeralModuleManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/jupyter/py/remote/modules/JupyterRemoteEphemeralModuleManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/jupyter/py/remote/modules/JupyterRemoteEphemeralModuleManager;", "project", "Lcom/intellij/openapi/project/Project;", "moduleName", "", "authority", "intellij.jupyter.py"})
    @SourceDebugExtension(value={"SMAP\nJupyterRemoteEphemeralModuleManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterRemoteEphemeralModuleManager.kt\ncom/intellij/jupyter/py/remote/modules/JupyterRemoteEphemeralModuleManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,161:1\n31#2,2:162\n*S KotlinDebug\n*F\n+ 1 JupyterRemoteEphemeralModuleManager.kt\ncom/intellij/jupyter/py/remote/modules/JupyterRemoteEphemeralModuleManager$Companion\n*L\n154#1:162,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JupyterRemoteEphemeralModuleManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<JupyterRemoteEphemeralModuleManager> serviceClass$iv = JupyterRemoteEphemeralModuleManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (JupyterRemoteEphemeralModuleManager)object;
        }

        private final String moduleName(String authority) {
            return "jupyter-remote-" + authority;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

